/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.XAConnection;
import org.teiid.jdbc.AbstractQueryTest;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.TeiidStatement;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.TransactionQueryTestCase;
import org.teiid.test.framework.connection.ConnectionStrategy;
import org.teiid.test.framework.connection.ConnectionStrategyFactory;
import org.teiid.test.framework.datasource.DataStore;
import org.teiid.test.framework.exception.QueryTestFailedException;

public abstract class AbstractQueryTransactionTest
extends AbstractQueryTest
implements TransactionQueryTestCase {
    private static String initialized = null;
    protected String testname = "NA";
    protected int fetchSize = -1;
    protected int queryTimeout = -1;
    protected ConnectionStrategy connStrategy = ConnectionStrategyFactory.createConnectionStrategy();
    private Throwable applicationException = null;

    public AbstractQueryTransactionTest() {
    }

    public AbstractQueryTransactionTest(String testname) {
        this();
        this.testname = testname;
    }

    @Override
    public String getTestName() {
        return this.testname;
    }

    @Override
    public ConnectionStrategy getConnectionStrategy() {
        return this.connStrategy;
    }

    protected void assignExecutionProperties(Statement stmt) {
        if (stmt instanceof TeiidStatement) {
            TeiidStatement statement = (TeiidStatement)stmt;
            Properties executionProperties = this.connStrategy.getEnvironment();
            if (executionProperties != null) {
                String fetchSizeStr;
                String txnautowrap = executionProperties.getProperty("autoCommitTxn");
                if (txnautowrap != null) {
                    statement.setExecutionProperty("autoCommitTxn", txnautowrap);
                }
                if ((fetchSizeStr = executionProperties.getProperty("fetchSize")) != null) {
                    try {
                        this.fetchSize = Integer.parseInt(fetchSizeStr);
                        TestLogger.log("FetchSize = " + this.fetchSize);
                    }
                    catch (NumberFormatException e) {
                        this.fetchSize = -1;
                    }
                }
            }
            if (this.fetchSize > 0) {
                try {
                    statement.setFetchSize(this.fetchSize);
                }
                catch (SQLException e) {
                    TestLogger.log(e.getMessage());
                }
            }
            if (this.queryTimeout > 0) {
                try {
                    statement.setQueryTimeout(this.queryTimeout);
                }
                catch (SQLException e) {
                    TestLogger.log(e.getMessage());
                }
            }
        }
    }

    @Override
    public void setup() throws QueryTestFailedException {
        this.applicationException = null;
        this.setConnection(this.connStrategy.getConnection());
        this.setupDataStore();
    }

    protected void setupDataStore() {
        if (!this.getConnectionStrategy().isDataStoreDisabled()) {
            TestLogger.logDebug("Perform DataStore setup for test: " + this.testname);
            if (initialized == null || !initialized.equalsIgnoreCase(this.getClass().getSimpleName())) {
                initialized = this.getClass().getSimpleName();
                DataStore.initialize(this.connStrategy);
            }
            DataStore.setup(this.connStrategy);
        } else {
            TestLogger.logDebug("DataStore setup is disabled for test: " + this.testname);
        }
    }

    public Connection getSource(String identifier) throws QueryTestFailedException {
        Connection conn = this.connStrategy.createDriverConnection(identifier);
        try {
            conn.setAutoCommit(true);
        }
        catch (Exception sqle) {
            throw new QueryTestFailedException(sqle);
        }
        return conn;
    }

    public XAConnection getXASource(String identifier) throws QueryTestFailedException {
        return this.connStrategy.createDataSourceConnection(identifier);
    }

    @Override
    public abstract void testCase() throws Exception;

    @Override
    public boolean rollbackAllways() {
        return false;
    }

    @Override
    public void before() {
    }

    @Override
    public void after() {
    }

    @Override
    public void cleanup() {
        ConfigPropertyLoader.reset();
    }

    @Override
    public XAConnection getXAConnection() {
        return null;
    }

    @Override
    public void setApplicationException(Throwable t) {
        this.applicationException = t;
    }

    @Override
    public boolean exceptionOccurred() {
        return super.exceptionOccurred() ? super.exceptionOccurred() : this.applicationException != null;
    }

    public SQLException getLastException() {
        if (super.getLastException() != null) {
            return super.getLastException();
        }
        if (this.applicationException != null) {
            if (this.applicationException instanceof SQLException) {
                return (SQLException)this.applicationException;
            }
            TeiidSQLException mm = new TeiidSQLException(this.applicationException.getMessage());
            return mm;
        }
        return null;
    }

    @Override
    public Throwable getApplicationException() {
        return this.applicationException;
    }
}

