/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidException;
import org.teiid.core.util.ExceptionUtil;

public class TeiidRuntimeException
extends RuntimeException {
    public static final long serialVersionUID = -4035276728007979320L;
    private static final String EMPTY_STRING = "";
    public static final String CAUSED_BY_STRING = CorePlugin.Util.getString("RuntimeException.Caused_by");
    private String code;

    public static String getClassShortName(Class cls) {
        if (cls == null) {
            return EMPTY_STRING;
        }
        String className = cls.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public TeiidRuntimeException() {
    }

    public TeiidRuntimeException(String message) {
        super(message);
    }

    public TeiidRuntimeException(int code, String message) {
        super(message);
        this.setCode(code);
    }

    public TeiidRuntimeException(String code, String message) {
        super(message);
        this.setCode(code);
    }

    public TeiidRuntimeException(Throwable e) {
        this(e, e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().getMessage() : (e == null ? null : e.getMessage()));
    }

    public TeiidRuntimeException(Throwable e, String message) {
        super(message, e);
        this.setCode(e);
    }

    public TeiidRuntimeException(Throwable e, int code, String message) {
        super(message, e);
        this.setCode(code);
    }

    public TeiidRuntimeException(Throwable e, String code, String message) {
        super(message, e);
        this.setCode(code);
    }

    public Throwable getChild() {
        return this.getCause();
    }

    public String getCode() {
        if (this.code == null) {
            return "0";
        }
        return this.code;
    }

    public int getIntCode() {
        if (this.code == null) {
            return 0;
        }
        try {
            return Integer.parseInt(this.code);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void setCode(int code) {
        this.code = Integer.toString(code);
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setCode(Throwable e) {
        if (e instanceof TeiidException) {
            this.code = ((TeiidException)e).getCode();
        } else if (e instanceof TeiidRuntimeException) {
            this.code = ((TeiidRuntimeException)e).getCode();
        } else if (e instanceof SQLException) {
            this.code = Integer.toString(((SQLException)e).getErrorCode());
        }
    }

    @Override
    public String toString() {
        return ExceptionUtil.getLinkedMessages(this);
    }

    public void superPrintStackTrace(PrintStream output) {
        super.printStackTrace(output);
    }

    public void superPrintStackTrace(PrintWriter output) {
        super.printStackTrace(output);
    }
}

