/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidRuntimeException;

public final class StringUtil {
    public static final String SINGLE_QUOTE = "'";
    public static final String LINE_SEPARATOR_PROPERTY_NAME = "line.separator";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", Constants.NEW_LINE);
    public static final Comparator CASE_INSENSITIVE_ORDER = String.CASE_INSENSITIVE_ORDER;
    public static final Comparator CASE_SENSITIVE_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            return ((String)o1).compareTo((String)o2);
        }
    };

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static String enclosedInSingleQuotes(String aString) {
        StringBuffer sb = new StringBuffer();
        sb.append(SINGLE_QUOTE);
        sb.append(aString);
        sb.append(SINGLE_QUOTE);
        return sb.toString();
    }

    public static String join(List strings, String delimiter) {
        if (strings == null || delimiter == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        int most = strings.size() - 1;
        if (strings.size() > 1) {
            Iterator iter = strings.iterator();
            for (int i = 0; i < most; ++i) {
                str.append(iter.next());
                str.append(delimiter);
            }
        }
        if (strings.size() > 0) {
            str.append(strings.get(most));
        }
        return str.toString();
    }

    public static String toString(Object[] array, String delim) {
        if (array == null) {
            return "";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delim);
            }
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(Object[] array) {
        return StringUtil.toString(array, ",");
    }

    public static List split(String str, String splitter) {
        StringTokenizer tokens = new StringTokenizer(str, splitter);
        ArrayList<String> l = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static List splitOnEntireString(String target, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.length() > 0) {
            int index = 0;
            int indexOfNextMatch = target.indexOf(delimiter);
            while (indexOfNextMatch > -1) {
                result.add(target.substring(index, indexOfNextMatch));
                index = indexOfNextMatch + delimiter.length();
                indexOfNextMatch = target.indexOf(delimiter, index);
            }
            if (index <= target.length()) {
                result.add(target.substring(index));
            }
        } else {
            result.add(target);
        }
        return result;
    }

    public static List splitPreservingQuotedSubstring(String str, String splitter) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(str, splitter);
        StringBuffer token = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            token.setLength(0);
            token.append(tokens.nextToken());
            if (token.charAt(0) == '\"') {
                token.deleteCharAt(0);
                while (tokens.hasMoreTokens()) {
                    token.append(Constants.SPACE + tokens.nextToken());
                    if (token.charAt(token.length() - 1) != '\"') continue;
                    token.deleteCharAt(token.length() - 1);
                    break;
                }
            }
            l.add(token.toString().trim());
        }
        return l;
    }

    public static String replace(String source, String search, String replace) {
        int start;
        if (source != null && search != null && search.length() > 0 && replace != null && (start = source.indexOf(search)) > -1) {
            return new StringBuffer(source).replace(start, start + search.length(), replace).toString();
        }
        return source;
    }

    public static String replaceAll(String source, String search, String replace) {
        int start;
        if (source != null && search != null && search.length() > 0 && replace != null && (start = source.indexOf(search)) > -1) {
            StringBuffer newString = new StringBuffer(source);
            StringUtil.replaceAll(newString, search, replace);
            return newString.toString();
        }
        return source;
    }

    public static void replaceAll(StringBuffer source, String search, String replace) {
        if (source != null && search != null && search.length() > 0 && replace != null) {
            int start = source.toString().indexOf(search);
            while (start > -1) {
                int end = start + search.length();
                source.replace(start, end, replace);
                start = source.toString().indexOf(search, start + replace.length());
            }
        }
    }

    public static String truncString(String in, int len) {
        String out = in;
        if (in != null && len > 0 && in.length() > len) {
            out = in.substring(0, len);
        }
        return out;
    }

    public static String wrap(String str, int maxCharPerLine) {
        int strLength = str.length();
        if (strLength > maxCharPerLine) {
            StringBuffer sb = new StringBuffer(str.length() + strLength / maxCharPerLine + 1);
            strLength = 0;
            List tokens = StringUtil.split(str, Constants.SPACE);
            for (String token : tokens) {
                if (strLength + token.length() > maxCharPerLine) {
                    sb.append(Constants.NEW_LINE);
                    strLength = 0;
                }
                sb.append(token);
                sb.append(Constants.SPACE);
                strLength += token.length() + 1;
            }
            return sb.toString();
        }
        return str;
    }

    public static List getTokens(String str, String delimiter) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(str, delimiter);
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static int getTokenCount(String str, String delimiter) {
        StringTokenizer tokens = new StringTokenizer(str, delimiter);
        return tokens.countTokens();
    }

    public static int occurrences(String input, String token) {
        int num = 0;
        int index = input.indexOf(token);
        while (index >= 0) {
            ++num;
            index = input.indexOf(token, index + 1);
        }
        return num;
    }

    public static String getLastToken(String str, String delimiter) {
        if (str == null) {
            return "";
        }
        int beginIndex = 0;
        if (str.lastIndexOf(delimiter) > 0) {
            beginIndex = str.lastIndexOf(delimiter) + 1;
        }
        return str.substring(beginIndex, str.length());
    }

    public static String getFirstToken(String str, String delimiter) {
        if (str == null) {
            return "";
        }
        int endIndex = str.indexOf(delimiter);
        if (endIndex < 0) {
            endIndex = str.length();
        }
        return str.substring(0, endIndex);
    }

    public static String computeDisplayableForm(String str) {
        return StringUtil.computeDisplayableForm(str, "");
    }

    public static String computeDisplayableForm(String str, String defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        StringBuffer newName = new StringBuffer(str);
        boolean previousCharUppercase = false;
        char prevChar = newName.charAt(0);
        if (Character.isLowerCase(prevChar)) {
            newName.setCharAt(0, Character.toUpperCase(prevChar));
            previousCharUppercase = true;
        }
        if (newName.length() > 1) {
            for (int i = 1; i != newName.length(); ++i) {
                boolean nextCharUppercase;
                char nextChar;
                prevChar = newName.charAt(i - 1);
                char currentChar = newName.charAt(i);
                previousCharUppercase = Character.isUpperCase(prevChar);
                boolean currentCharUppercase = Character.isUpperCase(currentChar);
                if (i != newName.length() - 1) {
                    nextChar = newName.charAt(i + 1);
                    nextCharUppercase = Character.isUpperCase(nextChar);
                } else {
                    nextCharUppercase = false;
                    nextChar = ' ';
                }
                if (prevChar == ' ') {
                    newName.setCharAt(i, Character.toUpperCase(currentChar));
                    continue;
                }
                if (!currentCharUppercase) continue;
                if (!previousCharUppercase) {
                    if (currentChar == 'M' && i >= 4 && newName.substring(i - 4).startsWith(CorePlugin.Util.getString("StringUtil.Displayable"))) continue;
                    newName.insert(i, ' ');
                    ++i;
                    continue;
                }
                if (nextCharUppercase || nextChar == 32) continue;
                newName.insert(i, ' ');
                ++i;
            }
        }
        return newName.toString();
    }

    public static String computeDisplayableFormOfConstant(String text) {
        return StringUtil.computeDisplayableFormOfConstant(text, "");
    }

    public static String computeDisplayableFormOfConstant(String text, String defaultValue) {
        if (text == null || text.length() == 0) {
            return defaultValue;
        }
        StringBuffer buf = new StringBuffer();
        StringTokenizer iter = new StringTokenizer(text, "_");
        while (iter.hasMoreTokens()) {
            String token = iter.nextToken().toLowerCase();
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(Character.toUpperCase(token.charAt(0)));
            buf.append(token.substring(1));
        }
        return buf.toString();
    }

    public static String computePluralForm(String str) {
        return StringUtil.computePluralForm(str, "");
    }

    public static String computePluralForm(String str, String defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        String result = str;
        if (!result.endsWith("es")) {
            result = result.endsWith("ss") || result.endsWith("x") || result.endsWith("ch") || result.endsWith("sh") ? result + "es" : (result.endsWith("y") && !result.endsWith("ay") && !result.endsWith("ey") && !result.endsWith("iy") && !result.endsWith("oy") && !result.endsWith("uy") && !result.equalsIgnoreCase("any") ? result.substring(0, result.length() - 1) + "ies" : result + "s");
        }
        return result;
    }

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bas);
        t.printStackTrace(pw);
        pw.close();
        return bas.toString();
    }

    public static boolean isBoolean(String text) {
        return Boolean.TRUE.toString().equalsIgnoreCase(text) || Boolean.FALSE.toString().equalsIgnoreCase(text);
    }

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static int indexOfIgnoreCase(String text, String str) {
        if (StringUtil.isEmpty(text)) {
            return -1;
        }
        if (StringUtil.isEmpty(str)) {
            return -1;
        }
        String lowerText = text.toLowerCase();
        String lowerStr = str.toLowerCase();
        return lowerText.indexOf(lowerStr);
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        if (text == null || prefix == null) {
            return false;
        }
        return text.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String text, String suffix) {
        if (text == null || suffix == null) {
            return false;
        }
        return text.regionMatches(true, text.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean isDigits(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtil.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private StringUtil() {
    }

    static String asRegEx(String pattern) {
        String result1 = Constants.PATTERN_BACK_SLASH.matcher(pattern).replaceAll("\\\\E\\\\\\\\\\\\Q");
        String result2 = Constants.PATTERN_STAR.matcher(result1).replaceAll("\\\\E.*\\\\Q");
        String result3 = Constants.PATTERN_QUESTION.matcher(result2).replaceAll("\\\\E.\\\\Q");
        return "\\Q" + result3 + "\\E";
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return Pattern.compile(StringUtil.asRegEx(pattern));
        }
        return Pattern.compile(StringUtil.asRegEx(pattern), 66);
    }

    public static String collapseWhitespace(String raw) {
        StringBuffer rv = new StringBuffer(raw.length());
        StringTokenizer izer = new StringTokenizer(raw, " ");
        while (izer.hasMoreTokens()) {
            String tok = izer.nextToken();
            rv.append(tok);
            if (!izer.hasMoreTokens()) continue;
            rv.append(' ');
        }
        return rv.toString();
    }

    public static String toFixedLength(String input, int desiredLength) {
        if (input == null) {
            input = "";
        }
        if (input.length() == desiredLength) {
            return input;
        }
        if (input.length() < desiredLength) {
            StringBuffer str = new StringBuffer(input);
            int needSpaces = desiredLength - input.length();
            for (int i = 0; i < needSpaces; ++i) {
                str.append(' ');
            }
            return str.toString();
        }
        return input.substring(0, desiredLength);
    }

    public static boolean isLetter(char c) {
        return StringUtil.isBasicLatinLetter(c) || Character.isLetter(c);
    }

    public static boolean isDigit(char c) {
        return StringUtil.isBasicLatinDigit(c) || Character.isDigit(c);
    }

    public static boolean isLetterOrDigit(char c) {
        return StringUtil.isBasicLatinLetter(c) || StringUtil.isBasicLatinDigit(c) || Character.isLetterOrDigit(c);
    }

    public static boolean isValid(String str) {
        return str != null && str.trim().length() != 0;
    }

    public static String toUpperCase(String str) {
        String newStr = StringUtil.convertBasicLatinToUpper(str);
        if (newStr == null) {
            return str.toUpperCase();
        }
        return newStr;
    }

    public static String toLowerCase(String str) {
        String newStr = StringUtil.convertBasicLatinToLower(str);
        if (newStr == null) {
            return str.toLowerCase();
        }
        return newStr;
    }

    public static String createFileName(String str) {
        str = str.replaceAll(" \\| ", "_");
        str = str.replaceAll(">", "_");
        str = str.replaceAll(": ", "_");
        str = str.replaceAll(" ", "_");
        str = str.replaceAll("\\?", "_");
        if ((str = str.replaceAll("/", "_")).matches("[_]+")) {
            str = "file";
        }
        return str;
    }

    public static String firstLetterUppercase(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static String convertBasicLatinToUpper(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (StringUtil.isBasicLatinLowerCase(chars[i])) {
                chars[i] = (char)(65 + (chars[i] - 97));
                continue;
            }
            if (StringUtil.isBasicLatinChar(chars[i])) continue;
            return null;
        }
        return new String(chars);
    }

    private static String convertBasicLatinToLower(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (StringUtil.isBasicLatinUpperCase(chars[i])) {
                chars[i] = (char)(97 + (chars[i] - 65));
                continue;
            }
            if (StringUtil.isBasicLatinChar(chars[i])) continue;
            return null;
        }
        return new String(chars);
    }

    private static boolean isBasicLatinUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isBasicLatinLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isBasicLatinLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isBasicLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isBasicLatinChar(char c) {
        return c <= '\u007f';
    }

    public static <T> T valueOf(String value, Class type) {
        if (type == String.class) {
            return (T)value;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.decode(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.decode(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.decode(value);
        }
        if (type.isAssignableFrom(List.class)) {
            return (T)new ArrayList<String>(Arrays.asList(value.split(",")));
        }
        if (type.isArray()) {
            String[] values = value.split(",");
            Object array = Array.newInstance(type.getComponentType(), values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(array, i, StringUtil.valueOf(values[i], type.getComponentType()));
            }
            return (T)array;
        }
        if (type == Void.class) {
            return null;
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value);
        }
        if (type == URL.class) {
            try {
                return (T)new URL(value);
            }
            catch (MalformedURLException e) {
            }
        } else if (type.isAssignableFrom(Map.class)) {
            List<String> l = Arrays.asList(value.split(","));
            HashMap<String, String> m = new HashMap<String, String>();
            for (String key : l) {
                int index = key.indexOf(61);
                if (index == -1) continue;
                m.put(key.substring(0, index), key.substring(index + 1));
            }
            return (T)m;
        }
        throw new IllegalArgumentException("Conversion from String to " + type.getName() + " is not supported");
    }

    public static String[] getLines(String value) {
        StringReader stringReader = new StringReader(value);
        BufferedReader reader = new BufferedReader(stringReader);
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                result.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new TeiidRuntimeException(e);
        }
        return result.toArray(new String[result.size()]);
    }

    public static interface Constants {
        public static final char CARRIAGE_RETURN_CHAR = '\r';
        public static final char LINE_FEED_CHAR = '\n';
        public static final char NEW_LINE_CHAR = '\n';
        public static final char SPACE_CHAR = ' ';
        public static final char DOT_CHAR = '.';
        public static final char TAB_CHAR = '\t';
        public static final String CARRIAGE_RETURN = String.valueOf('\r');
        public static final String EMPTY_STRING = "";
        public static final String DBL_SPACE = "  ";
        public static final String LINE_FEED = String.valueOf('\n');
        public static final String NEW_LINE = String.valueOf('\n');
        public static final String SPACE = String.valueOf(' ');
        public static final String DOT = String.valueOf('.');
        public static final String TAB = String.valueOf('\t');
        public static final String[] EMPTY_STRING_ARRAY = new String[0];
        public static final Pattern PATTERN_BACK_SLASH = Pattern.compile("\\\\");
        public static final Pattern PATTERN_QUESTION = Pattern.compile("\\?");
        public static final Pattern PATTERN_STAR = Pattern.compile("\\*");
    }
}

