/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestDependentJoins;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.validator.TestValidator;

public class TestAccessPatterns {
    @Test
    public void testVirtualAccessPatternPassing() {
        String sql = "SELECT e0, e2 FROM vTest.vGroup2 where e0=1 and e1='2'";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), new String[]{"SELECT test.\"group\".e0, test.\"group\".e2 FROM test.\"group\" WHERE (test.\"group\".e0 = 1) AND (test.\"group\".e1 = '2')"});
    }

    @Test
    public void testVirtualAccessPatternPassing1() {
        String sql = "delete from vm1.g37 where e1 = 1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[0]);
    }

    @Test
    public void testVirtualAccessPatternFailing() {
        String sql = "SELECT e0, e2 FROM vTest.vGroup2 where e0=1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), null, null, null, false);
    }

    @Test
    public void testVirtualAccessPatternFailing1() {
        String sql = "delete from vm1.g37";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, null, null, false);
    }

    @Test
    public void testAccessPattern1() throws Exception {
        String sql = "SELECT e0, e2 FROM vTest.vGroup where e0=1 and e1='2'";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), new String[]{"SELECT g_0.e0, g_0.e2 FROM test.\"group\" AS g_0 WHERE (g_0.e0 = 1) AND (g_0.e1 = '2')"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testAccessPattern2() {
        String sql = "SELECT e0, e2 FROM vTest.vGroup where e0=1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), null, null, null, false);
    }

    @Test
    public void testAccessPattern3() {
        String sql = "SELECT e0, e2 FROM vTest.vGroup where e0=1 and e2='2'";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), null, null, null, false);
    }

    @Test
    public void testAccessPattern4() throws Exception {
        String sql = "(SELECT e0, e2 FROM vTest.vGroup where e0=1 and e1='2') union all (SELECT e0, e2 FROM vTest.vGroup where e0=1 and e1='2')";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), new String[]{"SELECT g_0.e0, g_0.e2 FROM test.\"group\" AS g_0 WHERE (g_0.e0 = 1) AND (g_0.e1 = '2')"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testAccessPattern5() {
        String sql = "(SELECT e0, e2 FROM vTest.vGroup where e0=1 and e1='2') union all (SELECT e0, e2 FROM vTest.vGroup where e0=1)";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), null, null, null, false);
    }

    @Test
    public void testAccessPattern6() {
        String sql = "SELECT e0, e2 FROM test.group where e1 IN (SELECT e2 FROM vTest.vGroup where e0=1 and e1='2')";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), new String[]{"SELECT e1, e0, e2 FROM test.\"group\""});
    }

    @Test
    public void testAccessPattern7() {
        String sql = "SELECT e0, e2 FROM test.group where e1 IN (SELECT e2 FROM vTest.vGroup where e0=1)";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), null, null, null, false);
    }

    @Test
    public void testAccessPattern8() {
        String sql = "SELECT e0, e2 FROM vTest.vGroup";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), null, null, null, false);
    }

    @Test
    public void testNodesBothHaveAccessPatterns1() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm4.g1.e1 from pm4.g1, pm4.g2 where pm4.g2.e5 = 'abc' and pm4.g1.e1 = pm4.g2.e1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1 FROM pm4.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm4.g2 AS g_0 WHERE g_0.e5 = 'abc'"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm4.g1"});
    }

    @Test
    public void testNodesBothHaveAccessPatterns1a() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm4.g1.e1 from pm4.g2, pm4.g1 where pm4.g2.e1 = pm4.g1.e1 and pm4.g2.e5 = 'abc'", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1 FROM pm4.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm4.g2 AS g_0 WHERE g_0.e5 = 'abc'"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm4.g1"});
    }

    @Test
    public void testSelfJoinAccessPatterns() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm4.g1.e1 from pm4.g1, pm4.g1 as g1A where pm4.g1.e1 = 'abc' and g1A.e1 = 'abc' and pm4.g1.e2 = g1A.e2", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[]{"SELECT g1A.e2 FROM pm4.g1 AS g1A WHERE g1A.e1 = 'abc'", "SELECT pm4.g1.e2, pm4.g1.e1 FROM pm4.g1 WHERE pm4.g1.e1 = 'abc'"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.CORRECTED_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testAccessPatternsFails() {
        TestOptimizer.helpPlan("select pm4.g2.e1 from pm4.g2, pm4.g2 as g2A where pm4.g2.e2 = 123 and pm4.g2.e1 = g2A.e5", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, null, null, false);
    }

    @Test
    public void testAccessPatternsFails2() {
        TestOptimizer.helpPlan("select pm4.g2.e1 from pm4.g2", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, null, null, false);
    }

    @Test
    public void testUnionWithAccessPatternFails() {
        TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1 UNION select pm4.g1.e1 from pm4.g1 where pm4.g1.e2 = 1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, null, null, false);
    }

    @Test
    public void testUnionWithAccessPatternFails2() {
        TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1 UNION select pm4.g1.e1 from pm4.g1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, null, null, false);
    }

    @Test
    public void testUnionWithAccessPattern() {
        TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1 UNION ALL select pm4.g1.e1 from pm4.g1 where pm4.g1.e1 = 'abc'", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm4.g1.e1 FROM pm4.g1 WHERE pm4.g1.e1 = 'abc'"});
    }

    @Test
    public void testUnionWithAccessPattern2() {
        TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1 UNION ALL select pm4.g1.e1 from pm4.g1 where pm4.g1.e1 = 'abc' and pm4.g1.e2 = 1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm4.g1.e1 FROM pm4.g1 WHERE (pm4.g1.e1 = 'abc') AND (pm4.g1.e2 = 1)"});
    }

    @Test
    public void testAccessPatternPartialMatch() throws Exception {
        TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1, pm4.g2 where pm1.g1.e1 = pm4.g2.e1 and pm4.g2.e2 = 123", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1 FROM pm4.g2 AS g_0 WHERE (g_0.e2 = 123) AND (g_0.e1 IN (<dependent values>))", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testAccessPatternFails3() {
        TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1, pm4.g2 where pm1.g1.e1 = pm4.g2.e1 or pm4.g2.e2 = 123", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, null, null, false);
    }

    @Test
    public void testAccessPatternsGroupsInSameModelFails() {
        TestOptimizer.helpPlan("select pm5.g1.e1 from pm5.g1, pm5.g2 where pm5.g1.e1 = pm5.g2.e1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, null, null, false);
    }

    @Test
    public void testPushingCriteriaThroughFrameAccessPattern0() {
        TestOptimizer.helpPlan("select * from vm1.g9 where vm1.g9.e1='abc'", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[]{"SELECT pm4.g1.e1 FROM pm4.g1 WHERE pm4.g1.e1 = 'abc'", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'"});
    }

    @Test
    public void testPushingCriteriaThroughFrameAccessPattern1() {
        TestOptimizer.helpPlan("select * from vm1.g1, vm1.g10 where vm1.g1.e1='abc' and vm1.g1.e1=vm1.g10.e1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), null, false);
    }

    @Test
    public void testPushingCriteriaThroughFrameAccessPattern2() {
        TestOptimizer.helpPlan("select e1 from vm1.g11 where vm1.g11.e1='abc' and vm1.g11.e2=123", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[]{"SELECT pm4.g2.e1 FROM pm4.g2 WHERE (pm4.g2.e1 = 'abc') AND (pm4.g2.e2 = 123)"});
    }

    @Test
    public void testPushingCriteriaThroughFrameAccessPattern3() {
        TestOptimizer.helpPlan("select * from vm1.g1, vm1.g9 where vm1.g1.e1='abc' and vm1.g1.e1=vm1.g9.e1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), new String[]{"SELECT pm4.g1.e1 FROM pm4.g1 WHERE pm4.g1.e1 = 'abc'", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'", "SELECT g1__1.e1, g1__1.e2, g1__1.e3, g1__1.e4 FROM pm1.g1 AS g1__1 WHERE g1__1.e1 = 'abc'"});
    }

    @Test
    public void testPushingCriteriaThroughFrameAccessPattern4() {
        TestOptimizer.helpPlan("select * from vm1.g10 where vm1.g10.e1='abc'", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), null, false);
    }

    @Test
    public void testCase6425() {
        String sql = "SELECT e1 FROM pm4.g1 WHERE e1 = '1' OR e1 = '2'";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, new String[]{"SELECT e1 FROM pm4.g1 WHERE (e1 = '1') OR (e1 = '2')"});
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testCase6425_2() {
        String sql = "SELECT e1 FROM pm4.g1 WHERE e1 = '1' OR (e1 = '2' AND e2 = 3)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, new String[]{"SELECT e1 FROM pm4.g1 WHERE (e1 = '1') OR ((e1 = '2') AND (e2 = 3))"});
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testCase6425_4() throws Exception {
        String sql = "SELECT e1 FROM pm4.g1 WHERE e1 = '1' OR e2 = '2'";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, TestOptimizer.ComparisonMode.FAILED_PLANNING);
    }

    @Test
    public void testMultiAccessPatternWithCriteria() throws Exception {
        String sql = "SELECT pm1.g1.* FROM pm4.g1, pm5.g1, pm1.g1 where pm4.g1.e1 = pm1.g1.e1 and pm5.g1.e1 = pm1.g1.e1 and pm5.g1.e2 like '%x' ";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, new String[]{"SELECT g_0.e2, g_0.e1 FROM pm5.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1, g_0.e2, g_0.e3, g_0.e4 FROM pm1.g1 AS g_0", "SELECT g_0.e1 FROM pm4.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>)"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }
}

