/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.proc;

import java.util.Collections;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;

public class TestProcedurePlanner {
    private static boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessorPlan helpPlanProcedure(String userQuery, String procedure, String procedureType) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        Command userCommand;
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc(procedureType, procedure);
        QueryParser parser = QueryParser.getQueryParser();
        Command command = userCommand = userQuery != null ? parser.parseCommand(userQuery) : parser.parseCommand(procedure);
        if (userCommand instanceof CreateUpdateProcedureCommand) {
            GroupSymbol gs = new GroupSymbol("proc");
            gs.setMetadataID((Object)new TempMetadataID("proc", Collections.EMPTY_LIST));
            ((CreateUpdateProcedureCommand)userCommand).setVirtualGroup(gs);
        }
        QueryResolver.resolveCommand((Command)userCommand, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)userCommand, (QueryMetadataInterface)metadata);
        if (report.hasItems()) {
            ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
            throw new QueryValidatorException(firstFailure.getMessage());
        }
        userCommand = QueryRewriter.rewrite((Command)userCommand, (QueryMetadataInterface)metadata, null);
        AnalysisRecord analysisRecord = new AnalysisRecord(false, DEBUG);
        try {
            ProcessorPlan processorPlan = QueryOptimizer.optimizePlan((Command)userCommand, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (AnalysisRecord)analysisRecord, null);
            return processorPlan;
        }
        finally {
            if (DEBUG) {
                System.out.println(analysisRecord.getDebugLog());
            }
        }
    }

    @Test
    public void testCreateUpdateProcedure1() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Declare String var1;\n";
        procedure = procedure + "if(var1 = 'x' or var1 = 'y')\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, Input.e2, CHANGING.e2, CHANGING.e1 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ROWS_UPDATED = 1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "INSERT into vm1.g1 (e1) values('x')";
        this.helpPlanProcedure(userUpdateStr, procedure, "insertProcedure");
    }

    @Test
    public void testCreateUpdateProcedure2() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(CHANGING.e1 = 'true')\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, Input.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUT.e1, pm1.g1.e2 = INPUT.e2;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ROWS_UPDATED = 1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpPlanProcedure(userUpdateStr, procedure, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure3() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(CHANGING.e1='false' and INPUT.e1=1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, Input.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUT.e1, pm1.g1.e2 = INPUT.e2;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ROWS_UPDATED = 1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpPlanProcedure(userUpdateStr, procedure, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure4() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(CHANGING.e4 ='true' and INPUT.e2=1 or var1 < 30)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, Input.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUT.e1, pm1.g1.e2 = INPUT.e2;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ROWS_UPDATED = 1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpPlanProcedure(userUpdateStr, procedure, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure5() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1 where HAS CRITERIA ON (vm1.g1.e1, vm1.g1.e1);\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = 'x', pm1.g1.e2 = var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpPlanProcedure(userUpdateStr, procedure, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure6() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(HAS CRITERIA ON (vm1.g1.e1, vm1.g1.e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1 where HAS CRITERIA ON (vm1.g1.e1, vm1.g1.e1);\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = 'x', pm1.g1.e2 = var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpPlanProcedure(userUpdateStr, procedure, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure7() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUT.e1, pm1.g1.e2 = INPUT.e2;\n";
        procedure = procedure + "ROWS_UPDATED = 1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e2=40";
        this.helpPlanProcedure(userUpdateStr, procedure, "updateProcedure");
    }

    @Test
    public void testCreateVirtualProcedure1() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1 INTO #temptable FROM vm1.g1;\n";
        procedure = procedure + "SELECT e1 FROM #temptable;\n";
        procedure = procedure + "END\n";
        this.helpPlanProcedure(null, procedure, "updateProcedure");
    }

    @Test
    public void testCreateVirtualProcedure2() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, convert(e2, string) INTO #temptable FROM vm1.g1;\n";
        procedure = procedure + "SELECT e1 FROM #temptable;\n";
        procedure = procedure + "END\n";
        this.helpPlanProcedure(null, procedure, "updateProcedure");
    }

    @Test
    public void testCreateVirtualProcedure3() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, convert(e2, string) as a1 INTO #temptable FROM vm1.g1;\n";
        procedure = procedure + "SELECT e1 FROM #temptable;\n";
        procedure = procedure + "END\n";
        this.helpPlanProcedure(null, procedure, "updateProcedure");
    }

    @Test
    public void testCase4504() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT y INTO #temptable FROM (select x.e1 as y from (select convert(pm1.g1.e1, date) e1 from pm1.g1) x) z;\n";
        procedure = procedure + "loop on (SELECT y FROM #temptable) as mycursor\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "select * from #temptable;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        this.helpPlanProcedure(null, procedure, "updateProcedure");
    }
}

