/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.rewriter.TestQueryRewriter;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.TestUpdateValidator;

public class TestInherintlyUpdatableViews {
    @Test
    public void testUpdatePassThrough() throws Exception {
        String userSql = "update vm1.gx set e1 = e2";
        String viewSql = "select * from pm1.g1 where e3 < 5";
        String expectedSql = "UPDATE pm1.g1 SET e1 = pm1.g1.e2 WHERE e3 < 5";
        this.helpTest(userSql, viewSql, expectedSql, null);
    }

    private Command helpTest(String userSql, String viewSql, String expectedSql, ProcessorDataManager dm) throws Exception {
        TransformationMetadata metadata = TestUpdateValidator.example1();
        TestUpdateValidator.createView(viewSql, metadata, "gx");
        Command command = TestQueryRewriter.helpTestRewriteCommand(userSql, expectedSql, (QueryMetadataInterface)metadata);
        if (dm != null) {
            CommandContext context = TestProcessor.createCommandContext();
            BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
            caps.setFunctionSupport("convert", true);
            ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
            List[] expected = new List[]{Arrays.asList(1)};
            TestProcessor.helpProcess(plan, context, dm, expected);
        }
        return command;
    }

    @Test
    public void testUpdatePassThroughWithAlias() throws Exception {
        String userSql = "update vm1.gx set e1 = e2";
        String viewSql = "select * from pm1.g1 as x where e3 < 5";
        String expectedSql = "UPDATE pm1.g1 SET e1 = pm1.g1.e2 WHERE e3 < 5";
        this.helpTest(userSql, viewSql, expectedSql, null);
    }

    @Test
    public void testDeletePassThrough() throws Exception {
        String userSql = "delete from vm1.gx where e1 = e2";
        String viewSql = "select * from pm1.g1 where e3 < 5";
        String expectedSql = "DELETE FROM pm1.g1 WHERE (pm1.g1.e1 = pm1.g1.e2) AND (e3 < 5)";
        this.helpTest(userSql, viewSql, expectedSql, null);
    }

    @Test
    public void testInsertPassThrough() throws Exception {
        String userSql = "insert into vm1.gx (e1) values (1)";
        String viewSql = "select * from pm1.g1 where e3 < 5";
        String expectedSql = "INSERT INTO pm1.g1 (pm1.g1.e1) VALUES ('1')";
        this.helpTest(userSql, viewSql, expectedSql, null);
    }

    @Test
    public void testDeleteUnion() throws Exception {
        String userSql = "delete from vm1.gx where e4 is null";
        String viewSql = "select * from pm1.g1 where e3 < 5 union all select * from pm1.g2 where e1 > 1";
        String expectedSql = "BatchedUpdate{D,D}";
        BatchedUpdateCommand buc = (BatchedUpdateCommand)this.helpTest(userSql, viewSql, expectedSql, null);
        Assert.assertEquals((Object)"DELETE FROM pm1.g2 WHERE (pm1.g2.e4 IS NULL) AND (e1 > '1')", (Object)buc.getUpdateCommands().get(1).toString());
    }

    @Test
    public void testInsertPassThrough1() throws Exception {
        String userSql = "insert into vm1.gx (e1) values (1)";
        String viewSql = "select g2.* from pm1.g1 inner join pm1.g2 on g1.e1 = g2.e1";
        String expectedSql = "INSERT INTO pm1.g2 (pm1.g2.e1) VALUES ('1')";
        this.helpTest(userSql, viewSql, expectedSql, null);
    }

    @Test
    public void testUpdateComplex() throws Exception {
        String userSql = "update vm1.gx set e1 = e2 where e3 is null";
        String viewSql = "select g2.* from pm1.g1 inner join pm1.g2 on g1.e1 = g2.e1";
        HardcodedDataManager dm = new HardcodedDataManager();
        dm.addData("SELECT g_1.e2, g_1.e2 FROM pm1.g1 AS g_0, pm1.g2 AS g_1 WHERE (g_0.e1 = g_1.e1) AND (g_1.e3 IS NULL)", new List[]{Arrays.asList(1, 1)});
        dm.addData("UPDATE pm1.g2 SET e1 = pm1.g2.e2 WHERE pm1.g2.e2 = 1", new List[]{Arrays.asList(1)});
        this.helpTest(userSql, viewSql, "CREATE PROCEDURE\nBEGIN\nLOOP ON (SELECT pm1.g2.e2 AS s_0, pm1.g2.e2 AS s_1 FROM pm1.g1 INNER JOIN pm1.g2 ON g1.e1 = g2.e1 WHERE pm1.g2.e3 IS NULL) AS X\nBEGIN\nUPDATE pm1.g2 SET e1 = pm1.g2.e2 WHERE pm1.g2.e2 = X.s_1;\nVARIABLES.ROWS_UPDATED = (VARIABLES.ROWS_UPDATED + 1);\nEND\nEND", dm);
    }

    @Test
    public void testDeleteComplex() throws Exception {
        String userSql = "delete from vm1.gx where e2 < 10";
        String viewSql = "select g2.* from pm1.g1 inner join pm1.g2 on g1.e1 = g2.e1";
        HardcodedDataManager dm = new HardcodedDataManager();
        dm.addData("SELECT g_1.e2 FROM pm1.g1 AS g_0, pm1.g2 AS g_1 WHERE (g_0.e1 = g_1.e1) AND (g_1.e2 < 10)", new List[]{Arrays.asList(2)});
        dm.addData("DELETE FROM pm1.g2 WHERE pm1.g2.e2 = 2", new List[]{Arrays.asList(1)});
        this.helpTest(userSql, viewSql, "CREATE PROCEDURE\nBEGIN\nLOOP ON (SELECT pm1.g2.e2 AS s_0 FROM pm1.g1 INNER JOIN pm1.g2 ON g1.e1 = g2.e1 WHERE pm1.g2.e2 < 10) AS X\nBEGIN\nDELETE FROM pm1.g2 WHERE pm1.g2.e2 = X.s_0;\nVARIABLES.ROWS_UPDATED = (VARIABLES.ROWS_UPDATED + 1);\nEND\nEND", dm);
    }

    @Test
    public void testInsertPartitionedUnion() throws Exception {
        String userSql = "insert into vm1.gx (e1, e2) values (1, 2)";
        String viewSql = "select 1 as e1, e2 from pm1.g1 union all select 2 as e1, e2 from pm1.g2";
        String expectedSql = "INSERT INTO pm1.g1 (e2) VALUES (2)";
        this.helpTest(userSql, viewSql, expectedSql, null);
    }
}

