/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.FakeDataStore;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.xml.TestXMLProcessor;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;

public class TestProcedureProcessor {
    private static final boolean DEBUG = false;

    public static ProcessorPlan getProcedurePlan(String userQuery, QueryMetadataInterface metadata) throws Exception {
        return TestProcedureProcessor.getProcedurePlan(userQuery, metadata, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessorPlan getProcedurePlan(String userQuery, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder) throws Exception {
        ProcessorPlan plan;
        Command userCommand = QueryParser.getQueryParser().parseCommand(userQuery);
        QueryResolver.resolveCommand((Command)userCommand, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)userCommand, (QueryMetadataInterface)metadata);
        if (report.hasItems()) {
            ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
            throw new QueryValidatorException(firstFailure.getMessage());
        }
        QueryRewriter.rewrite((Command)userCommand, (QueryMetadataInterface)metadata, (CommandContext)new CommandContext());
        AnalysisRecord analysisRecord = new AnalysisRecord(false, false);
        if (capabilitiesFinder == null) {
            capabilitiesFinder = new DefaultCapabilitiesFinder();
        }
        ProcessorPlan processorPlan = plan = QueryOptimizer.optimizePlan((Command)userCommand, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capabilitiesFinder, (AnalysisRecord)analysisRecord, null);
        return processorPlan;
    }

    public static void helpTestProcess(ProcessorPlan procPlan, List[] expectedResults, ProcessorDataManager dataMgr, QueryMetadataInterface metadata) throws Exception {
        CommandContext context = new CommandContext((Object)"pID", null, null, null, 1);
        if (!(metadata instanceof TempMetadataAdapter)) {
            metadata = new TempMetadataAdapter(metadata, new TempMetadataStore());
        }
        context.setMetadata(metadata);
        TestProcessor.helpProcess(procPlan, context, dataMgr, expectedResults);
        Assert.assertNotNull((String)"Expected processing to fail", (Object)expectedResults);
    }

    private void helpTestProcessFailure(ProcessorPlan procPlan, FakeDataManager dataMgr, String failMessage, QueryMetadataInterface metadata) throws Exception {
        try {
            TestProcedureProcessor.helpTestProcess(procPlan, null, dataMgr, metadata);
        }
        catch (TeiidException ex) {
            Assert.assertEquals((Object)failMessage, (Object)ex.getMessage());
        }
    }

    private void helpTestProcess(ProcessorPlan procPlan, int expectedRows, FakeDataManager dataMgr, QueryMetadataInterface metadata) throws Exception {
        TestProcedureProcessor.helpTestProcess(procPlan, new List[]{Arrays.asList(expectedRows)}, dataMgr, metadata);
    }

    private static List createElements(List elementIDs) {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        for (int i = 0; i < elementIDs.size(); ++i) {
            FakeMetadataObject elementID = (FakeMetadataObject)elementIDs.get(i);
            ElementSymbol element = new ElementSymbol(elementID.getName());
            elements.add(element);
        }
        return elements;
    }

    private FakeDataManager exampleDataManager(FakeMetadataFacade metadata) throws QueryMetadataException, TeiidComponentException {
        FakeDataManager dataMgr = new FakeDataManager();
        FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g1");
        List elementIDs = metadata.getElementIDsInGroupID(groupID);
        List elementSymbols = TestProcedureProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("First", new Integer(5), new Boolean(true), new Double(1.003)), Arrays.asList("Second", new Integer(15), new Boolean(true), new Double(2.003)), Arrays.asList("Third", new Integer(51), new Boolean(true), new Double(3.003))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g2");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = TestProcedureProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("First", new Integer(5), new Boolean(true), new Double(1.003)), Arrays.asList("Second", new Integer(15), new Boolean(true), new Double(2.003)), Arrays.asList("Third", new Integer(51), new Boolean(true), new Double(3.003))});
        return dataMgr;
    }

    private FakeDataManager exampleDataManager2(FakeMetadataFacade metadata) throws QueryMetadataException, TeiidComponentException {
        FakeDataManager dataMgr = new FakeDataManager();
        FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g1");
        List elementIDs = metadata.getElementIDsInGroupID(groupID);
        List elementSymbols = TestProcedureProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("First", new Integer(5), new Boolean(true), new Double(1.003)), Arrays.asList("Second", new Integer(15), new Boolean(true), new Double(2.003)), Arrays.asList("Third", new Integer(51), new Boolean(true), new Double(3.003))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g2");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = TestProcedureProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("First", new Integer(5), new Boolean(true), new Double(1.003)), Arrays.asList("Second", new Integer(15), new Boolean(true), new Double(2.003)), Arrays.asList("Third", new Integer(51), new Boolean(true), new Double(3.003))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm2.g1");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = TestProcedureProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("First", new Integer(5), new Boolean(true), new Double(1.003)), Arrays.asList("Second", new Integer(15), new Boolean(true), new Double(2.003)), Arrays.asList("Third", new Integer(51), new Boolean(true), new Double(3.003))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm2.g2");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = TestProcedureProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("First", new Integer(5), new Boolean(true), new Double(1.003)), Arrays.asList("Second", new Integer(15), new Boolean(true), new Double(2.003)), Arrays.asList("Third", new Integer(51), new Boolean(true), new Double(3.003))});
        return dataMgr;
    }

    private FakeDataManager exampleDataManagerPm5(FakeMetadataFacade metadata) throws QueryMetadataException, TeiidComponentException {
        FakeDataManager dataMgr = new FakeDataManager();
        FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("pm5.g3");
        List elementIDs = metadata.getElementIDsInGroupID(groupID);
        List elementSymbols = TestProcedureProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("First", new Short(5), new Boolean(true), new Double(1.003)), Arrays.asList("Second", new Short(15), new Boolean(true), new Double(2.003)), Arrays.asList("Third", new Short(51), new Boolean(true), new Double(3.003))});
        return dataMgr;
    }

    @Test
    public void testProcedureProcessor1() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1 = 0;\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 0, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testProcedureProcessor2() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1 where e2=5;\n";
        procedure = procedure + "if(var1 = 5)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 5, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testProcedureProcessor2WithBlockedException() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1 where e2=5;\n";
        procedure = procedure + "if(var1 = 5)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        dataMgr.setBlockOnce();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 5, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testProcedureProcessor3() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1 where e2=5;\n";
        procedure = procedure + "var1 = INPUT.e2;\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e2=40";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 45, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testProcedureProcessor4() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1 where e2=5;\n";
        procedure = procedure + "if(var1 = 5)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ELSE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1 where e2=5;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUT.e1, pm1.g1.e2 = var1;\n";
        procedure = procedure + "var1 = INPUT.e2;\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e2=45";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 5, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testProcedureProcessor4WithBlockedException() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1 where e2=5;\n";
        procedure = procedure + "if(var1 = 5)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ELSE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1 where e2=5;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUT.e1, pm1.g1.e2 = var1;\n";
        procedure = procedure + "var1 = INPUT.e2;\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e2=45";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        dataMgr.setBlockOnce();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 5, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testProcedureProcessor5() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1 where e2=15;\n";
        procedure = procedure + "if(var1 = 5)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ELSE\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1 where e2=5;\n";
        procedure = procedure + "var1 = INPUT.e2;\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e2=45";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 50, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testProcedureProcessor6() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcessFailure(plan, dataMgr, "Error Code:ERR.015.006.0058 Message:Unable to evaluate (SELECT pm1.g1.e2 FROM pm1.g1): Error Code:ERR.015.006.0058 Message:The command of this scalar subquery returned more than one value: SELECT pm1.g1.e2 FROM pm1.g1", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testProcedureProcessor7() throws Exception {
        String errorValue = "'MY ERROR'";
        this.helpTestErrorStatment(errorValue, "MY ERROR");
    }

    @Test
    public void testProcedureProcessor8() throws Exception {
        String errorValue = "var1";
        this.helpTestErrorStatment(errorValue, "5");
    }

    @Test
    public void testProcedureProcessor9() throws Exception {
        String errorValue = "var1||'MY ERROR'";
        this.helpTestErrorStatment(errorValue, "5MY ERROR");
    }

    @Test
    public void testProcedureProcessor10() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "loop on (Select pm1.g1.e2 from pm1.g1 where e2 = 5) as mycursor\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ERROR (mycursor.e2||'MY ERROR');\n";
        procedure = procedure + "ROWS_UPDATED = 0;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcessFailure(plan, dataMgr, "Procedure error:5MY ERROR", (QueryMetadataInterface)metadata);
    }

    private void helpTestErrorStatment(String errorValue, String expected) throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = 5;\n";
        procedure = procedure + "ERROR " + errorValue + ";\n";
        procedure = procedure + "ROWS_UPDATED = 0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcessFailure(plan, dataMgr, "Procedure error:" + expected, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testLookupFunction1() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var2;\n";
        procedure = procedure + "if('a' = lookup('pm1.g1','e1', 'e2', 0))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var2 = INPUT.e2;\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED +1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ELSE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var2 = 100;\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED +13;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e2=30";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = new FakeDataManager();
        FakeDataStore.sampleData2(dataMgr);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 1, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testLookupFunction2() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var2;\n";
        procedure = procedure + "if('a' = lookup('pm1.g1','e1', 'e2', 5))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var2 = INPUT.e2;\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED +1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ELSE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var2 = 100;\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED +12;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e2=30";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = new FakeDataManager();
        FakeDataStore.sampleData2(dataMgr);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 12, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp2()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureWithBlockedException() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp2()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        dataMgr.setBlockOnce();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure2() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp3()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure3() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp4()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure4() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp5()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure5() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp6()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure6() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp7(5)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure7() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp8(51)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure8() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp9(51)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure9() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp10(51)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure10() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp13()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third", new Integer(5))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure11() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp14()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure12() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp15()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g2");
        List elementIDs = metadata.getElementIDsInGroupID(groupID);
        List elementSymbols = TestProcedureProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("First", new Integer(5), new Boolean(true), new Double(1.003)), Arrays.asList("Third", new Integer(51), new Boolean(true), new Double(3.003))});
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure13() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp16()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g2");
        List elementIDs = metadata.getElementIDsInGroupID(groupID);
        List elementSymbols = TestProcedureProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("First", new Integer(5), new Boolean(true), new Double(1.003)), Arrays.asList("Third", new Integer(51), new Boolean(true), new Double(3.003))});
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure14() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp17()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure15() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp19()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third"), Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure16() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp20()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third"), Arrays.asList("Fourth")};
        CommandContext context = new CommandContext((Object)"pID", null, null, null, 1);
        context.setMetadata((QueryMetadataInterface)metadata);
        context.setProcessorBatchSize(1);
        TestProcessor.helpProcess(plan, context, dataMgr, expected);
    }

    @Test
    public void testVirtualProcedure17() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp21(7)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", new Integer(5)), Arrays.asList("Second", new Integer(15)), Arrays.asList("Third", new Integer(51)), Arrays.asList("Fourth", new Integer(7))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure18() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp22(7)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second", new Integer(15)), Arrays.asList("Third", new Integer(51))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure19() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp23(7)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second", new Integer(15))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure19WithBlockedException() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp23(7)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second", new Integer(15))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureNoDataInTempTable() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp25()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect13625() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "IF(HAS CRITERIA ON (vm1.g4.e2))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1 where TRANSLATE = CRITERIA ON (vm1.g4.e2);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "if(var1 = 5)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE g4 SET e1='x' where e2=5";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 5, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure30() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp30()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure31() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp31(51)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureDefect14282() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp24()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16193() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp35(51)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure16602() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp37()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g1");
        ArrayList<ElementSymbol> elementSymbols = new ArrayList<ElementSymbol>();
        ElementSymbol element = new ElementSymbol("Count");
        elementSymbols.add(element);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList(new Integer(1))});
        List[] expected = new List[]{Arrays.asList(new Integer(1))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16649_1() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp38()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16649_2() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp39()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16694() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp40()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16707() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp44(2)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16707_1() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp43(2)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect17451() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp45()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g2");
        List elementIDs = metadata.getElementIDsInGroupID(groupID);
        List elementSymbols = TestProcedureProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("First", new Integer(5), new Boolean(true), new Double(1.003)), Arrays.asList("Third", new Integer(51), new Boolean(true), new Double(3.003))});
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedure46() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp46()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect17650() throws Exception {
        String procedure1 = "CREATE PROCEDURE  ";
        procedure1 = procedure1 + "BEGIN\n";
        procedure1 = procedure1 + "DECLARE integer var1;\n";
        procedure1 = procedure1 + "IF(HAS CRITERIA ON (vm1.g1.e2))\n";
        procedure1 = procedure1 + "BEGIN\n";
        procedure1 = procedure1 + "ROWS_UPDATED = UPDATE vm1.g2 SET e1='x' where TRANSLATE = CRITERIA ON (vm1.g1.e2);\n";
        procedure1 = procedure1 + "END\n";
        procedure1 = procedure1 + "END";
        String procedure2 = "CREATE PROCEDURE  ";
        procedure2 = procedure2 + "BEGIN\n";
        procedure2 = procedure2 + "DECLARE integer var1;\n";
        procedure2 = procedure2 + "Select pm1.g2.e2 from pm1.g2 where TRANSLATE CRITERIA;\n";
        procedure2 = procedure2 + "ROWS_UPDATED = 5;\n";
        procedure2 = procedure2 + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x' where e2=5";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure1, procedure2);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 5, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect19982() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp55(5)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("First", new Integer(5)), Arrays.asList("Second", new Integer(5)), Arrays.asList("Third", new Integer(5))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCase3521() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp1()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("Second")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithTranslate() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "IF(HAS CRITERIA ON (vm1.g4.e2))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "execute string 'Select pm1.g1.e2 x, changing.e1 y from pm1.g1 where TRANSLATE = CRITERIA ON (vm1.g4.e2)' as x integer, y boolean into #temp;\n";
        procedure = procedure + "var1 = select x from #temp;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "if(var1 = 5)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE g4 SET e1='x' where e2=5";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 5, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithIntoExpression() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        QueryNode sq2n1 = new QueryNode("pm1.sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'SELECT e1 FROM pm1.g1 WHERE e1 = ''First''' as x string into #temp; declare string VARIABLES.RESULT = select x from #temp;select VARIABLES.RESULT; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithIntoAndLoop() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("declare integer VARIABLES.e2_total=0;\n");
        procedure.append("execute string 'SELECT e1, e2 FROM pm1.g1' as e1 string, e2 integer into #temp;\n");
        procedure.append("loop on (Select e2 from #temp where e2 > 2) as mycursor\n");
        procedure.append("BEGIN\n");
        procedure.append("IF (mycursor.e2>5) \n");
        procedure.append("VARIABLES.e2_total=VARIABLES.e2_total+mycursor.e2;\n");
        procedure.append("END\n");
        procedure.append("SELECT VARIABLES.e2_total;\n");
        procedure.append("END");
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure.toString());
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(new Integer(66))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithParameter() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq2.in' as e1 string, e2 integer; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("pm1.sq2", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq2);
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", new Integer(5))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithUsing() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'SELECT e1, e2 FROM pm1.g1 WHERE e1=using.id' using id=pm1.sq2.in; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("pm1.sq2", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq2);
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", new Integer(5))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithVariable() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq2", "CREATE VIRTUAL PROCEDURE BEGIN\ndeclare string VARIABLES.x; VARIABLES.x = pm1.sq2.in; execute string 'SELECT e1, e2 FROM pm1.g1 WHERE e1=VARIABLES.x'; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("pm1.sq2", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq2);
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", new Integer(5))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandValidationFails() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq2", "CREATE VIRTUAL PROCEDURE BEGIN\ndeclare object VARIABLES.x; execute string 'SELECT xmlelement(name elem, x)'; select 1; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("pm1.sq2", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq2);
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        try {
            TestProcedureProcessor.helpTestProcess(plan, null, dataMgr, (QueryMetadataInterface)metadata);
            Assert.fail((String)"exception expected");
        }
        catch (QueryProcessingException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof QueryValidatorException));
        }
    }

    @Test
    public void testDynamicCommandWithSingleSelect() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs1 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs1);
        QueryNode sq2n1 = new QueryNode("pm1.sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'SELECT 26'; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs1);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("26")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandTypeConversion() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq2", "CREATE VIRTUAL PROCEDURE BEGIN\ndeclare string VARIABLES.x; VARIABLES.x = 'a'; execute string 'SELECT e2 ' || ' FROM pm1.g1 ' || ' where e1=pm1.sq2.in'; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("pm1.sq2", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq2);
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("5")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandRecursion() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'EXEC pm1.sq2(''First'')' as e1 string, e2 integer; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("pm1.sq2", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq2);
        String userUpdateStr = "EXEC pm1.sq2('First')";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcessFailure(plan, dataMgr, "Couldn't execute the dynamic SQL command \"EXECUTE 'EXEC pm1.sq2(''First'')' AS e1 string, e2 integer\" with the SQL statement \"'EXEC pm1.sq2(''First'')'\" due to: There is a recursive invocation of group 'PM1.SQ2'. Please correct the SQL.", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandIncorrectProjectSymbolCount() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nSELECT pm1.g1.e1 FROM pm1.g1; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        QueryNode sq2n2 = new QueryNode("pm1.sq2", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'EXEC pm1.sq1(''First'')' as e1 string, e2 integer; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("pm1.sq2", pm1, Arrays.asList(rs2p1, rs2p2), sq2n2);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        metadata.getStore().addObject(sq2);
        String userUpdateStr = "EXEC pm1.sq2('test')";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcessFailure(plan, dataMgr, "Couldn't execute the dynamic SQL command \"EXECUTE 'EXEC pm1.sq1(''First'')' AS e1 string, e2 integer\" with the SQL statement \"'EXEC pm1.sq1(''First'')'\" due to: The dynamic sql string contains an incorrect number of elements.", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandPositional() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1", "e2"}, new String[]{"string", "string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'select e1 as x, e2 from pm1.g1'; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1('test')";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("First", "5"), Arrays.asList("Second", "15"), Arrays.asList("Third", "51")}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandIncorrectProjectSymbolDatatypes() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"integer"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        QueryNode sq2n1 = new QueryNode("pm1.sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'select e1 from pm1.g1'; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcessFailure(plan, dataMgr, "Couldn't execute the dynamic SQL command \"EXECUTE 'select e1 from pm1.g1'\" with the SQL statement \"'select e1 from pm1.g1'\" due to: The datatype 'string' for element 'E1' in the dynamic SQL cannot be implicitly converted to 'integer'.", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithTwoDynamicStatements() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1", "e2"}, new String[]{"string", "string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        QueryNode sq2n1 = new QueryNode("pm1.sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'select e1 from pm1.g1'; execute string 'select e1, e2 from pm1.g1' as e1 string, e2 integer; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", new Integer(5)), Arrays.asList("Second", new Integer(15)), Arrays.asList("Third", new Integer(51))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testAssignmentWithCase() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        String sql = new StringBuffer("declare integer caseValue = ").append("CASE").append(" WHEN pm1.sq1.param='a' THEN 0").append(" WHEN pm1.sq1.param='b' THEN 1").append(" WHEN pm1.sq1.param='c' THEN 2").append(" WHEN pm1.sq1.param='d' THEN 3").append(" ELSE 9999").append(" END").toString();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("param", 2, 1, "string", null);
        FakeMetadataObject rs1 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs1);
        QueryNode sq2n1 = new QueryNode("pm1.sq1", "CREATE VIRTUAL PROCEDURE BEGIN\n" + sql + "; SELECT caseValue; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs1);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1('d')";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(new Integer(3))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandInsertIntoTempTableWithDifferentDatatypeFromSource() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm5 = metadata.getStore().findObject("pm5", "Model");
        FakeMetadataObject rs1 = FakeMetadataFactory.createResultSet("pm5.rs1", pm5, new String[]{"e1", "e2"}, new String[]{"string", "short"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs1);
        QueryNode sq2n1 = new QueryNode("pm5.sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'select e1,e2 from pm5.g3' as e1 string, e2 integer INTO #temp; select * from #temp; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm5.sq1", pm5, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs1);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm5.sq1()";
        FakeDataManager dataMgr = this.exampleDataManagerPm5(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", new Integer(5)), Arrays.asList("Second", new Integer(15)), Arrays.asList("Third", new Integer(51))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDynamicCommandWithVariableOnly() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm5 = metadata.getStore().findObject("pm5", "Model");
        FakeMetadataObject rs1 = FakeMetadataFactory.createResultSet("pm5.rs1", pm5, new String[]{"e1", "e2"}, new String[]{"string", "short"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("param", 1, 1, "short", rs1);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("ret", 2, 5, "object", rs1);
        QueryNode sq2n1 = new QueryNode("pm5.sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nDECLARE string VARIABLES.CRIT = 'select e1, e2 from pm5.g3 where e2=using.id'; execute string VARIABLES.CRIT USING ID = pm5.sq1.param; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm5.sq1", pm5, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs1);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm5.sq1(convert(5,short))";
        FakeDataManager dataMgr = this.exampleDataManagerPm5(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", new Short(5))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureWithCreate() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp60()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureWithCreateAndDrop() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp61()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testVirtualProcedureWithCreateAndSelectInto() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp62()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDifferentlyScopedTempTables() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("declare integer VARIABLES.e2_total=0;\n");
        procedure.append("if (e2_total = 0)");
        procedure.append("BEGIN\n");
        procedure.append("select e1 into #temp from pm1.g1;\n");
        procedure.append("VARIABLES.e2_total=select count(*) from #temp;\n");
        procedure.append("END\n");
        procedure.append("if (e2_total = 3)");
        procedure.append("BEGIN\n");
        procedure.append("select e1 into #temp from pm1.g1;\n");
        procedure.append("VARIABLES.e2_total=select count(*) from #temp;\n");
        procedure.append("END\n");
        procedure.append("SELECT VARIABLES.e2_total;\n");
        procedure.append("END");
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure.toString());
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(new Integer(3))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testLoopsWithBreak() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("declare integer VARIABLES.e2_total=0;\n");
        procedure.append("loop on (select e2 as x from pm1.g1) as mycursor\n");
        procedure.append("BEGIN\n");
        procedure.append("e2_total=e2_total+mycursor.x;\n");
        procedure.append("break;\n");
        procedure.append("END\n");
        procedure.append("loop on (select e2 as x from pm1.g1) as mycursor\n");
        procedure.append("BEGIN\n");
        procedure.append("e2_total=e2_total+mycursor.x;");
        procedure.append("END\n");
        procedure.append("SELECT VARIABLES.e2_total;\n");
        procedure.append("END");
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure.toString());
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(new Integer(76))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCreateWithoutDrop() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("create local temporary table t1 (e1 integer);\n");
        procedure.append("create local temporary table t1 (e1 integer);\n");
        procedure.append("SELECT e1 from t1;\n");
        procedure.append("END");
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure.toString());
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcessFailure(plan, dataMgr, "Temporary table \"T1\" already exists.", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDoubleDrop() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("create local temporary table t1 (e1 string);\n");
        procedure.append("select e1 into t1 from pm1.g1;\n");
        procedure.append("drop table t1;\n");
        procedure.append("drop table t1;\n");
        procedure.append("SELECT 1;\n");
        procedure.append("END");
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure.toString());
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList(1)}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testFunctionInput() throws Exception {
        FakeMetadataObject v1 = FakeMetadataFactory.createVirtualModel("v1");
        FakeMetadataObject p1 = FakeMetadataFactory.createParameter("v1.vp1.in", 2, 1, "string", null);
        FakeMetadataObject rs1 = FakeMetadataFactory.createResultSet("v1.rs1", v1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs1p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs1);
        QueryNode n1 = new QueryNode("v1.vp1", "CREATE VIRTUAL PROCEDURE BEGIN declare string VARIABLES.x = '1'; exec v1.vp2(concat(x, v1.vp1.in)); END");
        FakeMetadataObject vt1 = FakeMetadataFactory.createVirtualProcedure("v1.vp1", v1, Arrays.asList(rs1p1, p1), n1);
        FakeMetadataObject p2 = FakeMetadataFactory.createParameter("v1.vp2.in", 2, 1, "string", null);
        QueryNode n2 = new QueryNode("v1.vp2", "CREATE VIRTUAL PROCEDURE BEGIN select v1.vp2.in; end");
        FakeMetadataObject vt2 = FakeMetadataFactory.createVirtualProcedure("v1.vp2", v1, Arrays.asList(rs1p1, p2), n2);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(v1);
        store.addObject(rs1);
        store.addObject(vt1);
        store.addObject(vt2);
        store.addObject(vt2);
        String sql = "exec v1.vp1('1')";
        List[] expected = new List[]{Arrays.asList("11")};
        FakeMetadataFacade metadata = new FakeMetadataFacade(store);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, expected, new FakeDataManager(), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testIfEvaluation() throws Exception {
        String procedure1 = "CREATE PROCEDURE  ";
        procedure1 = procedure1 + "BEGIN\n";
        procedure1 = procedure1 + "DECLARE string var1 = INPUT.e1;\n";
        procedure1 = procedure1 + "ROWS_UPDATED = UPDATE vm1.g2 SET e1=var1;\n";
        procedure1 = procedure1 + "END";
        String procedure2 = "CREATE PROCEDURE  ";
        procedure2 = procedure2 + "BEGIN\n";
        procedure2 = procedure2 + "DECLARE integer var1;\n";
        procedure2 = procedure2 + "IF (INPUT.e1 = 1)\n";
        procedure2 = procedure2 + "ROWS_UPDATED = 5;\n";
        procedure2 = procedure2 + "ELSE\n";
        procedure2 = procedure2 + "ROWS_UPDATED = 4;\n";
        procedure2 = procedure2 + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x' where e2=5";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure1, procedure2);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 4, new FakeDataManager(), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testReferenceForwarding() throws Exception {
        String sql = "EXEC pm1.vsp49()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataStore store = metadata.getStore();
        FakeMetadataObject pm1 = store.findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq2", "CREATE VIRTUAL PROCEDURE BEGIN if (1 = 2) begin declare integer x = 1; end SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq2.in; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("pm1.sq2", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        store.addObject(sq2);
        List[] expected = new List[]{Arrays.asList("b", new Integer(2))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, expected, dataManager, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testInsertAfterCreate() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n").append("BEGIN\n").append("\n  create local temporary table #temp (e1 string, e2 string);").append("\n  insert into #temp (e1) values ('a');").append("\n  insert into #temp (e2) values ('b');").append("SELECT e2 as e1 from #temp;\n").append("END");
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure.toString());
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("b")}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testUpdateAssignmentNotExecuted() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1 = UPDATE pm1.g1 SET pm1.g1.e1 = INPUT.e2;";
        procedure = procedure + "ROWS_UPDATED = var1 + 1;\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE g4 SET e1='x' where e2=5";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 1, dataMgr, (QueryMetadataInterface)metadata);
        Assert.assertTrue((boolean)plan.requiresTransaction(false));
    }

    @Test
    public void testUpdateAssignmentNotExecutedVirtual() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1 = UPDATE vm1.g2 SET e1 = INPUT.e2;";
        procedure = procedure + "ROWS_UPDATED = var1 + 1;\n";
        procedure = procedure + "END";
        String procedure2 = "CREATE PROCEDURE  ";
        procedure2 = procedure2 + "BEGIN\n";
        procedure2 = procedure2 + "DECLARE integer var1;\n";
        procedure2 = procedure2 + "IF (INPUT.e1 = 1)\n";
        procedure2 = procedure2 + "ROWS_UPDATED = 5;\n";
        procedure2 = procedure2 + "ELSE\n";
        procedure2 = procedure2 + "ROWS_UPDATED = 4;\n";
        procedure2 = procedure2 + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x' where e2=5";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure, procedure2);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 1, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEvaluatableSelectWithOrderBy() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("param", 2, 1, "string", null);
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n").append("BEGIN\n").append("SELECT param from pm1.g1 order by param limit 1;\n").append("END");
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure.toString());
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1(1)";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("1")}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEvaluatableSelectWithOrderBy1() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("param", 2, 1, "string", null);
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n").append("BEGIN\n").append("SELECT param from pm1.g1 union select e1 from pm1.g1 order by param limit 2;\n").append("END");
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure.toString());
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1(1)";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("1"), Arrays.asList("First")}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testNonDeterministicEvaluation() throws Exception {
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n").append("BEGIN\n").append("DECLARE integer x = 0;\n").append("CREATE LOCAL TEMPORARY TABLE #TEMP (e1 integer);\n").append("while (x < 2)\n").append("BEGIN\n").append("insert into #temp (e1) values (convert(rand() * 1000, integer));\n").append("x = x + 1;\n").append("END\n").append("SELECT * FROM #TEMP;\n").append("END");
        FakeMetadataFacade metadata = this.createProcedureMetadata(procedure.toString());
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList(new Integer(240)), Arrays.asList(new Integer(637))}, dataMgr, (QueryMetadataInterface)metadata);
    }

    private FakeMetadataFacade createProcedureMetadata(String procedure) {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"integer"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure.toString());
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        return metadata;
    }

    @Test
    public void testTempTableTypeConversion() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "CREATE local temporary table temp (x string, y integer);\n";
        procedure = procedure + "Select pm1.g1.e2 as e1, pm1.g1.e2 into temp from pm1.g1 order by pm1.g1.e2 limit 1;\n";
        procedure = procedure + "Select x from temp;\n";
        procedure = procedure + "END\n";
        FakeMetadataFacade metadata = this.createProcedureMetadata(procedure);
        String userUpdateStr = "EXEC pm1.sq1()";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, new List[]{Arrays.asList("5")}, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testXMLWithExternalCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5d.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        FakeMetadataObject pm1 = metadata.getStore().findObject("xqttest", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1"}, new String[]{"xml"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("input", 2, 1, "integer", null);
        QueryNode sq2n1 = new QueryNode("xqttest.proc", "CREATE VIRTUAL PROCEDURE BEGIN\ndeclare integer VARIABLES.x = xqttest.proc.input; SELECT * FROM xmltest.doc9 WHERE context(SupplierID, OrderID)=x OR OrderID='2'; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("xqttest.proc", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq2);
        String userUpdateStr = "EXEC xqttest.proc(5)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(expectedDoc)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testXMLWithExternalCriteria_InXMLVar() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5d.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        expectedDoc = expectedDoc.replaceAll("\\r", "");
        FakeMetadataObject pm1 = metadata.getStore().findObject("xqttest", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1"}, new String[]{"xml"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("input", 2, 1, "integer", null);
        QueryNode sq2n1 = new QueryNode("xqttest.proc", "CREATE VIRTUAL PROCEDURE BEGIN\ndeclare integer VARIABLES.x = xqttest.proc.input; declare xml y = SELECT * FROM xmltest.doc9 WHERE context(SupplierID, OrderID)=x OR OrderID='2'; select convert(y, string); END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("xqttest.proc", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq2);
        String userUpdateStr = "EXEC xqttest.proc(5)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(expectedDoc)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testXMLWithExternalCriteria1() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Catalogs>\n   <Catalog>\n      <Items>\n         <Item ItemID=\"001\">\n            <Name>Lamp</Name>\n            <Quantity>5</Quantity>\n            <Suppliers>\n               <Supplier SupplierID=\"52\">\n                  <Name>Biff's Stuff</Name>\n                  <Zip>22222</Zip>\n                  <Orders>\n                     <Order OrderID=\"2\">\n                        <OrderDate>12/31/01</OrderDate>\n                        <OrderQuantity>87</OrderQuantity>\n                        <OrderStatus>complete</OrderStatus>\n                     </Order>\n                  </Orders>\n               </Supplier>\n            </Suppliers>\n         </Item>\n         <Item ItemID=\"002\">\n            <Name>Screwdriver</Name>\n            <Quantity>100</Quantity>\n            <Suppliers/>\n         </Item>\n         <Item ItemID=\"003\">\n            <Name>Goat</Name>\n            <Quantity>4</Quantity>\n            <Suppliers/>\n         </Item>\n      </Items>\n   </Catalog>\n</Catalogs>";
        FakeMetadataObject pm1 = metadata.getStore().findObject("xmltest", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1"}, new String[]{"xml"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("input", 2, 1, "integer", null);
        QueryNode sq2n1 = new QueryNode("xmltest.proc", "CREATE VIRTUAL PROCEDURE BEGIN\ndeclare integer VARIABLES.x = xmltest.proc.input; SELECT * FROM xmltest.doc9 WHERE context(SupplierID, SupplierID)=x; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("xmltest.proc", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq2);
        String userUpdateStr = "EXEC xmltest.proc(52)";
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(expectedDoc)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCase174806() throws Exception {
        String userUpdateStr = "EXEC pm1.vsp63()";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("c")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testJoinProcAndPhysicalModel() throws Exception {
        String userUpdateStr = "select a.e1 from (EXEC pm1.vsp46()) as a, pm1.g1 where a.e1=pm1.g1.e1";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        List[] expected = new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDeclareWithQueryAssignment() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE \n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "   DECLARE integer VARIABLES.var1 = 0;\n";
        procedure = procedure + "   /* the following DECLARE with ASSIGNMENT to a query should work ";
        procedure = procedure + "      but in IT236455 it results in the assignment inside the LOOP ";
        procedure = procedure + "      to fail */ ";
        procedure = procedure + "   DECLARE integer VARIABLES.NLEVELS = SELECT COUNT(*) FROM (\n";
        procedure = procedure + "                                          SELECT 'Col1' AS ACol1, 'Col2' AS ACol2, convert(3, integer) AS ACol3\n";
        procedure = procedure + "                                       ) AS Src;\n";
        procedure = procedure + "   LOOP ON (\n";
        procedure = procedure + "      SELECT StaticTable.BCol1, StaticTable.BCol2, StaticTable.BCol3 FROM (\n";
        procedure = procedure + "         SELECT 'Col 1' AS BCol1, 'Col 2' AS BCol2, convert(3, integer) AS BCol3\n";
        procedure = procedure + "      ) AS StaticTable\n";
        procedure = procedure + "   ) AS L1\n";
        procedure = procedure + "   BEGIN\n";
        procedure = procedure + "      /* In IT236455 the following would fail as the results from ";
        procedure = procedure + "         the LOOP (L1) are not in scope when the assignment is being ";
        procedure = procedure + "         performed due to the query earlier being part of a DECLARE  ";
        procedure = procedure + "         statement. */  ";
        procedure = procedure + "      VARIABLES.var1 = L1.BCol3;\n";
        procedure = procedure + "   END\n";
        procedure = procedure + "   SELECT VARIABLES.Var1 AS e1;\n";
        procedure = procedure + "END\n";
        FakeMetadataFacade metadata = this.createProcedureMetadata(procedure);
        String userQuery = "SELECT e1 FROM (EXEC pm1.sq1()) as proc";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(new Integer(3))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect8693() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1 where e2 = 5;\n";
        procedure = procedure + "if (5 in (select 5 from pm1.g1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 5, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testWhileWithSubquery() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1 = 2;\n";
        procedure = procedure + "WHILE (5 in (select var1 from pm1.g1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 0, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect18404() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1 = 5 + (select count(e2) from pm1.g1);\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        this.helpTestProcess(plan, 8, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRemovalOfNonJoinCritWithReference() throws Exception {
        String proc = "";
        String sql = "";
        sql = sql + "SELECT \tpm1.g1.e1 AS pm1g1e1, \tpm2.g2.e1 AS pm2g2e1, \tpm1.g1.e2 AS pm1g1e2, \tpm2.g2.e2 AS pm2g2e2 FROM \tpm1.g1\tLEFT OUTER JOIN pm2.g2 \tON pm1.g1.e1 = pm2.g2.e1 \tAND pm2.g2.e2 = VARIABLES.myVar ";
        proc = proc + "CREATE VIRTUAL PROCEDURE BEGIN    declare integer myVar = 5;   " + sql + ";" + "END";
        FakeMetadataFacade metadata = this.createProcedureMetadata(proc);
        String userQuery = "SELECT * FROM (EXEC pm1.sq1()) as proc";
        FakeDataManager dataMgr = this.exampleDataManager2(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("First", "First", new Integer(5), new Integer(5)), Arrays.asList("Second", null, new Integer(15), null), Arrays.asList("Third", null, new Integer(51), null)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
        Assert.assertTrue((!plan.requiresTransaction(false) ? 1 : 0) != 0);
    }

    @Test
    public void testRemovalOfNonJoinCritWithReference2() throws Exception {
        String proc = "";
        String sql = "";
        sql = sql + "SELECT \tpm1.g1.e1 AS pm1g1e1, \tpm2.g2.e1 AS pm2g2e1, \tpm1.g1.e2 AS pm1g1e2, \tpm2.g2.e2 AS pm2g2e2 FROM \tpm1.g1\tLEFT OUTER JOIN pm2.g2 \tON pm1.g1.e1 = pm2.g2.e1 \tAND pm2.g2.e2 = VARIABLES.myVar ";
        proc = proc + "CREATE VIRTUAL PROCEDURE BEGIN    declare integer myVar = 5;   " + sql + ";" + "END";
        FakeMetadataFacade metadata = this.createProcedureMetadata(proc);
        String userQuery = "SELECT * FROM (EXEC pm1.sq1()) as proc";
        FakeDataManager dataMgr = this.exampleDataManager2(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("First", "First", new Integer(5), new Integer(5)), Arrays.asList("Second", null, new Integer(15), null), Arrays.asList("Third", null, new Integer(51), null)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testUpdateDeleteTemp() throws Exception {
        String proc = "CREATE VIRTUAL PROCEDURE BEGIN  select e1, e2, e3, e4 into #t1 from pm1.g1;\n update #t1 set e1 = 1 where e4 < 2;\n delete from #t1 where e4 > 2;\n select e1 from #t1;\nEND";
        FakeMetadataFacade metadata = this.createProcedureMetadata(proc);
        String userQuery = "SELECT * FROM (EXEC pm1.sq1()) as proc";
        FakeDataManager dataMgr = this.exampleDataManager2(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(String.valueOf(1))};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testTempSubqueryInput() throws Exception {
        String proc = "CREATE VIRTUAL PROCEDURE BEGIN  create local temporary table t1 (e1 string);\n select e1 into t1 from pm1.g1;\n select e2 from (exec pm1.sq2((select max(e1) from t1))) x;\nEND";
        FakeMetadataFacade metadata = this.createProcedureMetadata(proc);
        String userQuery = "SELECT * FROM (EXEC pm1.sq1()) as proc";
        FakeDataManager dataMgr = this.exampleDataManager2(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(51)};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testUnambiguousVirtualProc() throws Exception {
        String userQuery = "EXEC MMSP6('1')";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("1")};
        TestProcedureProcessor.helpTestProcess(plan, expected, new HardcodedDataManager(), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testParameterAssignments() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String userQuery = "EXEC TEIIDSP7(1)";
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userQuery, (QueryMetadataInterface)metadata);
        dataMgr.addData("x = EXEC spTest9(1)", new List[]{Arrays.asList(3)});
        dataMgr.addData("EXEC spTest11(3, null)", new List[]{Arrays.asList("1", 1, null), Arrays.asList(null, null, 4)});
        List[] expected = new List[]{Arrays.asList("34")};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testNonQueryPushdownValidation() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject in = FakeMetadataFactory.createParameter("pm1.sq1.in1", 2, 1, "integer", null);
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE \n");
        procedure.append("BEGIN\n");
        procedure.append("create local temporary table x (y string);\n");
        procedure.append("declare string s = 'foo';\n");
        procedure.append("update x set y = in1 || s;\n");
        procedure.append("update pm1.g1 set e1 = lookup('pm1.g1', 'e1', 'e2', in1);\n");
        procedure.append("exec pm1.sq2(in1 || 'foo');\n");
        procedure.append("END");
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure.toString());
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(in, rs2p1), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        String userUpdateStr = "EXEC pm1.sq1(1)";
        FakeDataManager dataMgr = this.exampleDataManager(metadata);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(userUpdateStr, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{};
        TestProcedureProcessor.helpTestProcess(plan, expected, dataMgr, (QueryMetadataInterface)metadata);
    }
}

