/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestBatchedUpdatePlanner;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.BatchedUpdateNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestBatchedUpdateNode {
    private BatchedUpdateNode helpGetNode(String[] sql, QueryMetadataInterface md, ProcessorDataManager pdm) throws Exception {
        List<Command> commands = TestBatchedUpdatePlanner.helpGetCommands(sql, md);
        ArrayList<Boolean> shouldEvaluate = new ArrayList<Boolean>(commands.size());
        for (Command command : commands) {
            shouldEvaluate.add(EvaluatableVisitor.needsProcessingEvaluation((LanguageObject)command));
        }
        BatchedUpdateNode node = new BatchedUpdateNode(1, commands, Collections.EMPTY_LIST, shouldEvaluate, "myModelName");
        CommandContext context = new CommandContext();
        context.setProcessorID((Object)"myProcessorID");
        context.setMetadata(md);
        node.initialize(context, (BufferManager)Mockito.mock(BufferManager.class), pdm);
        return node;
    }

    private BatchedUpdateNode helpOpen(String[] commands, ProcessorDataManager pdm) throws Exception {
        BatchedUpdateNode node = this.helpGetNode(commands, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), pdm);
        node.open();
        return node;
    }

    private void helpTestOpen(String[] commands, String[] expectedCommands) throws Exception {
        FakePDM pdm = new FakePDM(expectedCommands.length);
        this.helpOpen(commands, pdm);
        Assert.assertEquals(Arrays.asList(expectedCommands), (Object)pdm.commands);
    }

    private FakePDM helpTestNextBatch(String[] commands, int[] expectedResults) throws Exception {
        int numExecutedCommands = 0;
        for (int i = 0; i < expectedResults.length; ++i) {
            numExecutedCommands += expectedResults[i];
        }
        FakePDM fakePDM = new FakePDM(numExecutedCommands);
        BatchedUpdateNode node = this.helpOpen(commands, fakePDM);
        TupleBatch batch = null;
        try {
            batch = node.nextBatch();
        }
        catch (BlockedException e) {
            batch = node.nextBatch();
        }
        Assert.assertNotNull((Object)batch);
        Assert.assertTrue((boolean)batch.getTerminationFlag());
        Assert.assertEquals((long)expectedResults.length, (long)batch.getRowCount());
        for (int i = 0; i < expectedResults.length; ++i) {
            List tuple = batch.getTuple(i + 1);
            Assert.assertNotNull((Object)tuple);
            Object result = tuple.get(0);
            Assert.assertNotNull(result);
            Assert.assertEquals((Object)new Integer(expectedResults[i]), result);
        }
        return fakePDM;
    }

    @Test
    public void testOpen1() throws Exception {
        String[] sql = new String[]{"INSERT INTO pm1.g1 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)", "INSERT INTO pm1.g2 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)"};
        String[] expectedCommands = new String[]{"BatchedUpdate{I,I}"};
        this.helpTestOpen(sql, expectedCommands);
    }

    @Test
    public void testOpen2() throws Exception {
        String[] sql = new String[]{"INSERT INTO pm1.g1 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)", "UPDATE pm1.g1 SET e2 = 50 WHERE e1 = 'criteria'", "DELETE FROM pm1.g2 WHERE e2 = 50", "DELETE FROM pm1.g2 WHERE e2 = 100"};
        String[] expectedCommands = new String[]{"BatchedUpdate{I,U,D,D}"};
        this.helpTestOpen(sql, expectedCommands);
    }

    @Test
    public void testOpenAllCommandsExecuted() throws Exception {
        String[] sql = new String[]{"UPDATE pm1.g1 SET e2 = 50 WHERE e1 = 'criteria'", "DELETE FROM pm1.g2 WHERE e2 = 50", "UPDATE pm1.g2 set e2 = 5, e3 = {b'false'}, e4 = 3.33 WHERE e1 = 'myrow'"};
        String[] expectedCommands = new String[]{"BatchedUpdate{U,D,U}"};
        this.helpTestOpen(sql, expectedCommands);
    }

    @Test
    public void testOpenNoCommandsExecuted() throws Exception {
        String[] sql = new String[]{"UPDATE pm1.g1 SET e2 = 50 WHERE 1 = 0", "DELETE FROM pm1.g2 WHERE 1 = 0", "UPDATE pm1.g2 set e2 = 5, e3 = {b'false'}, e4 = 3.33 WHERE 1 = 0"};
        String[] expectedCommands = new String[]{};
        this.helpTestOpen(sql, expectedCommands);
    }

    @Test
    public void testOpenSomeCommandsExecuted() throws Exception {
        String[] sql = new String[]{"UPDATE pm1.g1 SET e2 = 50 WHERE e1 = 'criteria'", "DELETE FROM pm1.g2 WHERE 1 = 0", "UPDATE pm1.g2 set e2 = 5, e3 = {b'false'}, e4 = 3.33 WHERE e1 = 'myrow'"};
        String[] expectedCommands = new String[]{"BatchedUpdate{U,U}"};
        this.helpTestOpen(sql, expectedCommands);
    }

    @Test
    public void testNextBatch1() throws Exception {
        String[] commands = new String[]{"INSERT INTO pm1.g1 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)", "INSERT INTO pm1.g2 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)"};
        int[] expectedResults = new int[]{1, 1};
        this.helpTestNextBatch(commands, expectedResults);
    }

    @Test
    public void testNextBatch2() throws Exception {
        String[] commands = new String[]{"INSERT INTO pm1.g1 (e1, e2, e3, e4) values ('string1', 1, {b'true'}, 1.0)", "UPDATE pm1.g1 SET e2 = 50 WHERE e1 = 'criteria'", "DELETE FROM pm1.g2 WHERE e2 = 50", "DELETE FROM pm1.g2 WHERE e2 = 100"};
        int[] expectedResults = new int[]{1, 1, 1, 1};
        this.helpTestNextBatch(commands, expectedResults);
    }

    @Test
    public void testNextBatchAllcommandsExecuted() throws Exception {
        String[] commands = new String[]{"UPDATE pm1.g1 SET e2 = 50 WHERE e1 = 'criteria'", "DELETE FROM pm1.g2 WHERE e2 = 50", "UPDATE pm1.g2 set e2 = 5, e3 = {b'false'}, e4 = 3.33 WHERE e1 = 'myrow'"};
        int[] expectedResults = new int[]{1, 1, 1};
        this.helpTestNextBatch(commands, expectedResults);
    }

    @Test
    public void testNextBatchNoCommandsExecuted() throws Exception {
        String[] commands = new String[]{"UPDATE pm1.g1 SET e2 = 50 WHERE 1 = 0", "DELETE FROM pm1.g2 WHERE 1 = 0", "UPDATE pm1.g2 set e2 = 5, e3 = {b'false'}, e4 = 3.33 WHERE 1 = 0"};
        int[] expectedResults = new int[]{0, 0, 0};
        this.helpTestNextBatch(commands, expectedResults);
    }

    @Test
    public void testNextBatchSomeCommandsExecuted() throws Exception {
        String[] commands = new String[]{"DELETE FROM pm1.g2 WHERE 1 = 0", "UPDATE pm1.g1 SET e2 = 50 WHERE e1 = 'criteria'", "UPDATE pm1.g2 set e2 = 5, e3 = {b'false'}, e4 = 3.33 WHERE e1 = 'myrow'", "UPDATE pm1.g2 set e2 = 5, e3 = {b'false'}, e4 = 3.33 WHERE 1 = 0"};
        int[] expectedResults = new int[]{0, 1, 1, 0};
        this.helpTestNextBatch(commands, expectedResults);
    }

    @Test
    public void testNextBatchCommandNeedsEvaluated() throws Exception {
        String[] commands = new String[]{"INSERT INTO pm1.g1 (e1, e2, e3, e4) values (commandpayload(), 1, {b'true'}, 1.0)"};
        int[] expectedResults = new int[]{1};
        FakePDM fpdm = this.helpTestNextBatch(commands, expectedResults);
        Assert.assertEquals((Object)"INSERT INTO pm1.g1 (e1, e2, e3, e4) VALUES (null, 1, TRUE, 1.0)", (Object)((BatchedUpdateCommand)fpdm.actualCommands.get(0)).getUpdateCommands().get(0).toString());
    }

    private static final class FakeTupleSource
    implements TupleSource {
        private int currentTuple = 0;
        private int numCommands;
        private boolean first = true;

        private FakeTupleSource(int numCommands) {
            this.numCommands = numCommands;
        }

        public void closeSource() {
        }

        public List nextTuple() throws TeiidComponentException {
            if (this.first) {
                this.first = false;
                throw BlockedException.INSTANCE;
            }
            if (this.currentTuple++ < this.numCommands) {
                return Arrays.asList(new Integer(1));
            }
            return null;
        }
    }

    private static final class FakePDM
    implements ProcessorDataManager {
        private int numExecutedCommands;
        private List<String> commands = new ArrayList<String>();
        private List<Command> actualCommands = new ArrayList<Command>();

        private FakePDM(int numExecutedCommands) {
            this.numExecutedCommands = numExecutedCommands;
        }

        public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException {
            return null;
        }

        public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidComponentException {
            Assert.assertEquals((Object)"myProcessorID", (Object)context.getProcessorID());
            Assert.assertEquals((Object)"myModelName", (Object)modelName);
            Assert.assertEquals((long)1L, (long)nodeID);
            this.commands.add(command.toString());
            this.actualCommands.add(command);
            return new FakeTupleSource(this.numExecutedCommands);
        }
    }
}

