/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;

public class TestLimitNode
extends TestCase {
    public void testLimitInFirstBatch() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(40, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)40, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)40, (int)batch.getEndRow());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testLimitAtBatchSize() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(50, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)50, (int)batch.getEndRow());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testLimitInSecondBatch() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(55, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)50, (int)batch.getEndRow());
        TestLimitNode.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        TestLimitNode.assertEquals((int)5, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)51, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)55, (int)batch.getEndRow());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testLimitMultipleOfBatchSize() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(100, new FakeRelationalNode(2, TestLimitNode.getRows(150), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)50, (int)batch.getEndRow());
        TestLimitNode.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)51, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)100, (int)batch.getEndRow());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testLimitProducesMultipleBatches() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(130, new FakeRelationalNode(2, TestLimitNode.getRows(300), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)50, (int)batch.getEndRow());
        TestLimitNode.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)51, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)100, (int)batch.getEndRow());
        TestLimitNode.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)30, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)101, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)130, (int)batch.getEndRow());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testLimitGetsNoRows() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(100, new FakeRelationalNode(2, TestLimitNode.getRows(0), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)0, (int)batch.getRowCount());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testZeroLimit() throws Exception {
        LimitNode node = TestLimitNode.getLimitNode(0, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)0, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)0, (int)batch.getEndRow());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testOffsetInFirstBatch() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(49, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)1, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)1, (int)batch.getEndRow());
        TestLimitNode.assertEquals(Arrays.asList(new Integer(50)), (Object)batch.getTuple(1));
        TestLimitNode.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)2, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)51, (int)batch.getEndRow());
        TestLimitNode.assertEquals(Arrays.asList(new Integer(51)), (Object)batch.getTuple(2));
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testOffsetAtBatchSize() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(50, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)50, (int)batch.getEndRow());
        TestLimitNode.assertEquals(Arrays.asList(new Integer(51)), (Object)batch.getTuple(1));
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testOffsetInSecondBatch() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(55, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)45, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)45, (int)batch.getEndRow());
        TestLimitNode.assertEquals(Arrays.asList(new Integer(56)), (Object)batch.getTuple(1));
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testOffsetMultipleOfBatchSize() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(100, new FakeRelationalNode(2, TestLimitNode.getRows(300), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)50, (int)batch.getEndRow());
        TestLimitNode.assertEquals(Arrays.asList(new Integer(101)), (Object)batch.getTuple(1));
        TestLimitNode.assertFalse((boolean)batch.getTerminationFlag());
    }

    public void testOffsetGreaterThanRowCount() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(100, new FakeRelationalNode(2, TestLimitNode.getRows(10), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)0, (int)batch.getRowCount());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testOffsetNoRows() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(100, new FakeRelationalNode(2, TestLimitNode.getRows(0), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)0, (int)batch.getRowCount());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testZeroOffset() throws Exception {
        LimitNode node = TestLimitNode.getOffsetNode(0, new FakeRelationalNode(2, TestLimitNode.getRows(100), 50));
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)1, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)50, (int)batch.getEndRow());
        TestLimitNode.assertFalse((boolean)batch.getTerminationFlag());
        batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)50, (int)batch.getRowCount());
        TestLimitNode.assertEquals((int)51, (int)batch.getBeginRow());
        TestLimitNode.assertEquals((int)100, (int)batch.getEndRow());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    public void testOffsetWithoutLimit() throws Exception {
        LimitNode node = new LimitNode(1, null, (Expression)new Constant((Object)new Integer(10)));
        node.addChild((RelationalNode)new FakeRelationalNode(2, TestLimitNode.getRows(10), 50));
        node.open();
        TupleBatch batch = node.nextBatch();
        TestLimitNode.assertNotNull((Object)batch);
        TestLimitNode.assertEquals((int)0, (int)batch.getRowCount());
        TestLimitNode.assertTrue((boolean)batch.getTerminationFlag());
    }

    static List[] getRows(int rows) {
        List[] data = new List[rows];
        for (int i = 0; i < rows; ++i) {
            data[i] = Arrays.asList(new Integer(i + 1));
        }
        return data;
    }

    private static LimitNode getOffsetNode(int offset, RelationalNode child) throws Exception {
        LimitNode node = new LimitNode(1, (Expression)new Constant((Object)new Integer(-1)), (Expression)new Constant((Object)new Integer(offset)));
        node.addChild(child);
        node.open();
        return node;
    }

    private static LimitNode getLimitNode(int limit, RelationalNode child) throws Exception {
        LimitNode node = new LimitNode(1, (Expression)new Constant((Object)new Integer(limit)), (Expression)new Constant((Object)new Integer(0)));
        node.addChild(child);
        node.open();
        return node;
    }

    public void testClone() {
        LimitNode node = new LimitNode(1, (Expression)new Constant((Object)new Integer(-1)), null);
        LimitNode clone = (LimitNode)node.clone();
        TestLimitNode.assertEquals((Object)node.getLimitExpr(), (Object)clone.getLimitExpr());
        TestLimitNode.assertNull((Object)clone.getOffsetExpr());
        node = new LimitNode(1, null, (Expression)new Constant((Object)new Integer(-1)));
        clone = (LimitNode)node.clone();
        TestLimitNode.assertNull((Object)clone.getLimitExpr());
    }
}

