/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.xml.ExecSqlInstruction;
import org.teiid.query.processor.xml.ExecStagingTableInstruction;
import org.teiid.query.processor.xml.TestXMLProcessor;
import org.teiid.query.processor.xml.XMLPlan;
import org.teiid.query.processor.xml.XMLProgramUtil;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;

public class TestXMLPlanningEnhancements {
    private FakeMetadataFacade getMetadata(String query) {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata();
        FakeMetadataStore store = metadata.getStore();
        FakeMetadataObject xmltest = store.findObject("xmltest", "Model");
        QueryNode rsQueryY = new QueryNode("xmltest.suppliersY", query);
        rsQueryY.addBinding("xmltest.group.items.itemNum");
        rsQueryY.addBinding("xmltest.group.items.itemNum");
        FakeMetadataObject rsQY = FakeMetadataFactory.createVirtualGroup("xmltest.suppliersY", xmltest, rsQueryY);
        List<FakeMetadataObject> rsElementsY = FakeMetadataFactory.createElements(rsQY, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        FakeMetadataObject doc18a = FakeMetadataFactory.createVirtualGroup("xmltest.doc18a", xmltest, TestXMLProcessor.createXMLPlanNested("xmltest.suppliersY"));
        List<FakeMetadataObject> docE18a = FakeMetadataFactory.createElements(doc18a, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.suppliers", "Catalogs.Catalog.items.item.suppliers.supplier", "Catalogs.Catalog.items.item.suppliers.supplier.@SupplierID", "Catalogs.Catalog.items.item.suppliers.supplier.zip", "Catalogs.Catalog.items.item.suppliers.supplier.Name"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string"});
        store.addObject(rsQY);
        store.addObjects(rsElementsY);
        store.addObject(doc18a);
        store.addObjects(docE18a);
        return metadata;
    }

    private FakeMetadataFacade getTempTableMetadata(boolean simpleTempSelect) {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata();
        FakeMetadataStore store = metadata.getStore();
        FakeMetadataObject xmltest = store.findObject("xmltest", "Model");
        FakeMetadataObject docJoin = FakeMetadataFactory.createVirtualGroup("xmltest.docJoin", xmltest, TestXMLPlanningEnhancements.createXMLPlanNestedJoin());
        List<FakeMetadataObject> docEJoin = FakeMetadataFactory.createElements(docJoin, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.suppliers", "Catalogs.Catalog.items.item.suppliers.supplier", "Catalogs.Catalog.items.item.suppliers.supplier.@SupplierID", "Catalogs.Catalog.items.item.suppliers.supplier.zip", "Catalogs.Catalog.items.item.suppliers.supplier.Name", "Catalogs.Catalog.items.item.suppliers.supplier.orders", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.@OrderID", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.OrderDate", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.OrderQuantity", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.OrderStatus"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string"});
        QueryNode tempQueryJoin = null;
        tempQueryJoin = !simpleTempSelect ? new QueryNode("tempGroup.orders", "SELECT stock.orders.* FROM stock.orders") : new QueryNode("tempGroup.orders", "SELECT stock.orders.* FROM stock.orders join stock.suppliers on stock.orders.supplierFK=stock.suppliers.supplierNum");
        FakeMetadataObject tempJoin = FakeMetadataFactory.createVirtualGroup("tempGroup.orders", xmltest, tempQueryJoin);
        QueryNode rsQueryJoin = null;
        if (!simpleTempSelect) {
            rsQueryJoin = new QueryNode("xmltest.ordersC", "SELECT orderNum, orderDate, orderQty, orderStatus FROM tempGroup.orders join stock.suppliers on tempGroup.orders.supplierFK=stock.suppliers.supplierNum WHERE itemFK = ? AND supplierNameFK = ?");
            rsQueryJoin.addBinding("xmltest.group.items.itemNum");
            rsQueryJoin.addBinding("xmltest.suppliers.supplierName");
        } else {
            rsQueryJoin = new QueryNode("xmltest.ordersC1", "SELECT orderNum, orderDate, orderQty, orderStatus FROM tempGroup.orders WHERE supplierNameFK = ?");
            rsQueryJoin.addBinding("xmltest.suppliers.supplierName");
        }
        FakeMetadataObject rsJoin = FakeMetadataFactory.createVirtualGroup("xmltest.ordersC", xmltest, rsQueryJoin);
        List<FakeMetadataObject> tempJoinElements = FakeMetadataFactory.createElements(tempJoin, new String[]{"orderNum", "itemFK", "supplierFK", "supplierNameFK", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "string", "string", "string", "integer", "string"});
        List<FakeMetadataObject> rsElementsJoin = FakeMetadataFactory.createElements(rsJoin, new String[]{"orderNum", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "integer", "string"});
        store.addObject(docJoin);
        store.addObjects(docEJoin);
        store.addObjects(tempJoinElements);
        store.addObjects(rsElementsJoin);
        store.addObject(tempJoin);
        store.addObject(rsJoin);
        return metadata;
    }

    private static MappingNode createXMLPlanNestedJoin() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        root.setStagingTables(Arrays.asList("tempGroup.orders"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        MappingElement nestedWrapper = item.addChildElement(new MappingElement("Suppliers"));
        MappingElement supplier = nestedWrapper.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        supplier.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        supplier.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        MappingElement ordersWrapper = supplier.addChildElement(new MappingElement("Orders"));
        MappingElement order = ordersWrapper.addChildElement(new MappingElement("Order"));
        order.setSource("xmltest.ordersC");
        order.setMaxOccurrs(-1);
        order.addAttribute(new MappingAttribute("OrderID", "xmltest.ordersC.orderNum"));
        order.addChildElement(new MappingElement("OrderDate", "xmltest.ordersc.orderDate"));
        order.addChildElement(new MappingElement("OrderQuantity", "xmltest.ordersC.orderQty"));
        order.addChildElement(new MappingElement("OrderStatus", "xmltest.ordersC.orderStatus")).setMinOccurrs(0);
        return doc;
    }

    @Test
    public void testBaseballPlayersDocDefect19541() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleCase3225();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerCase3225(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<BaseballPlayers>\r\n   <Player PlayerID=\"1001\">\r\n      <FirstName>Albert</FirstName>\r\n      <LastName>Pujols</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1002\">\r\n      <FirstName>Jim</FirstName>\r\n      <LastName>Edmunds</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1003\">\r\n      <FirstName>David</FirstName>\r\n      <LastName>Eckstein</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n</BaseballPlayers>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("select * from xmltest.playersDoc where owner.@ownerid = '1009'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5c() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5c.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE NOT(SupplierID='52') AND (OrderID='5' OR OrderID='2')", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5d() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5d.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE OrderID='5' OR context(SupplierID, OrderID)='2'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5d1() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5d.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(SupplierID, OrderID)='5' OR OrderID='2'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5e() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String resultFile = "TestXMLProcessor-testNested2WithContextCriteria5e.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE OrderID='5' OR SupplierID='52'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testXQTChoice_6796() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager(metadata);
        String resultFile = "TestXMLProcessor-testXQTChoice_6796.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc4 WHERE root.key.keys.nestedkey = 4", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderByWithChoiceCriteriaElement() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n   <wrapper/>\n</root>";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc5 order by root.wrapper.key", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testXQTChoice_withContextCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager(metadata);
        String resultFile = "TestXMLProcessor-testXQTChoice_withContextCriteria.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc4 WHERE context(root.key.keys.nestedkey, root.key.keys.nestedkey) = 4", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testXQTChoice_withContextCriteria1() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager(metadata);
        String resultFile = "TestXMLProcessor-testXQTChoice_withContextCriteria1.xml";
        String expectedDoc = TestXMLProcessor.readFile(resultFile);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc4 WHERE context(root.key.keys.nestedkey, root.key.keys.nestedkey) = 4 and context(root.wrapper.key.keys.nestedkey, root.wrapper.key.keys.nestedkey) = 3", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testMappingClassWithInlineViewAndCriteria() throws Exception {
        FakeMetadataFacade metadata = this.getMetadata("SELECT upper(x.supplierNum) as supplierNum, x.supplierName, x.supplierZipCode from (select stock.suppliers.supplierNum, supplierName, supplierZipCode, itemNum FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum) x where x.itemNum = ?");
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testMappingClassWithStoredProcedureAndCriteria.xml");
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18a where supplierID<56", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testMappingClassWithUnionAndCriteria() throws Exception {
        FakeMetadataFacade metadata = this.getMetadata("SELECT concat(stock.suppliers.supplierNum, '') as supplierNum, supplierName, supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum = ? union all SELECT concat(stock.suppliers.supplierNum, '1'), supplierName, convert(12345, string) FROM stock.suppliers WHERE stock.suppliers.supplierNum = ?");
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testMappingClassWithStoredProcedureAndCriteria.xml");
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18a where supplierID<56", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testMappingClassWithInputSetElementNameConflict() throws Exception {
        FakeMetadataFacade metadata = this.getMetadata("SELECT concat(stock.suppliers.supplierNum, '') as supplierNum, supplierName, supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.supplierNum = ?");
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Catalogs>\n<Catalog>\n<Items/>\n</Catalog>\n</Catalogs>";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18a where supplierID<56", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testAutoStagingFailsForMappingClassWithProcRelational() throws Exception {
        FakeMetadataFacade metadata = this.getMetadata("SELECT supplierNum, supplierName, supplierZipCode FROM v1.supplierProc where itemnum = ?");
        FakeMetadataObject v1 = FakeMetadataFactory.createVirtualModel("v1");
        FakeMetadataObject rs1 = FakeMetadataFactory.createResultSet("v1.rs1", v1, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        FakeMetadataObject rs1p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs1);
        FakeMetadataObject rs1p2 = FakeMetadataFactory.createParameter("itemNum", 2, 1, "string", null);
        QueryNode n1 = new QueryNode("v1.supplierProc", "CREATE VIRTUAL PROCEDURE BEGIN SELECT concat(stock.suppliers.supplierNum, '') as supplierNum, supplierName, supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum = v1.supplierProc.itemNum; END");
        FakeMetadataObject vt1 = FakeMetadataFactory.createVirtualProcedure("v1.supplierProc", v1, Arrays.asList(rs1p1, rs1p2), n1);
        metadata.getStore().addObject(vt1);
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testMappingClassWithStoredProcedureAndCriteria.xml");
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18a where supplierID<56", expectedDoc, metadata, dataMgr);
        Map stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertNull(stats.get(ExecStagingTableInstruction.class));
    }

    @Test
    public void testMappingClassWitSelectDistinctAndCriteria() throws Exception {
        FakeMetadataFacade metadata = this.getMetadata("SELECT distinct '1' as supplierNum, '2' as supplierName, '3' as supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum like substring(?,1,1) || '%'");
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testMappingClassWitSelectDistinctAndCriteria.xml");
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18a", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testMappingClassWithStoredProcedureAndCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testMappingClassWithStoredProcedureAndCriteria.xml");
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18 where supplierID<56", expectedDoc, metadata, dataMgr);
    }

    public void defer_testXMLQueryWithFalseRootCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18 where 1 = 0", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testAutoStagingByCosting() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        FakeMetadataObject suppliers = metadata.getStore().findObject("stock.suppliers", "Group");
        FakeMetadataObject itemSuppliers = metadata.getStore().findObject("stock.item_supplier", "Group");
        suppliers.putProperty("cardinality", new Integer(10));
        itemSuppliers.putProperty("cardinality", new Integer(10));
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9", expectedDoc, metadata, dataMgr);
        Map stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertEquals((long)2L, (long)((List)stats.get(ExecStagingTableInstruction.class)).size());
    }

    @Test
    public void testAutoStagingFailsByCosting() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        FakeMetadataObject suppliers = metadata.getStore().findObject("stock.suppliers", "Group");
        FakeMetadataObject itemSuppliers = metadata.getStore().findObject("stock.item_supplier", "Group");
        suppliers.putProperty("cardinality", new Integer(10000));
        itemSuppliers.putProperty("cardinality", new Integer(10000));
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9", expectedDoc, metadata, dataMgr);
        Map stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertNull(stats.get(ExecStagingTableInstruction.class));
    }

    @Test
    public void testAutoStagingFailsByNoCache() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 OPTION NOCACHE", expectedDoc, metadata, dataMgr);
        Map stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertNull(stats.get(ExecStagingTableInstruction.class));
    }

    @Test
    public void testAutoStagingFailsByNoCacheByGroup() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 OPTION NOCACHE XMLTEST.SUPPLIERS", expectedDoc, metadata, dataMgr);
        Map stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertNull(stats.get(ExecStagingTableInstruction.class));
        plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 OPTION NOCACHE XMLTEST.SUPPLIERS", expectedDoc, metadata, dataMgr);
        stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertNull(stats.get(ExecStagingTableInstruction.class));
    }

    @Test
    public void testUseOfStagingCardinalityOnDependentJoinsNoCost() throws Exception {
        FakeMetadataFacade metadata = this.getTempTableMetadata(false);
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan xmlPlan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.docJoin", expectedDoc, metadata, dataMgr);
        Map stats = XMLProgramUtil.getProgramStats(xmlPlan.getOriginalProgram());
        List list = (List)stats.get(ExecSqlInstruction.class);
        ExecSqlInstruction instr = (ExecSqlInstruction)list.get(2);
        ProcessorPlan plan = instr.info.getPlan();
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkDependentJoinCount(plan, 0);
    }

    @Test
    public void testUseOfStagingCardinalityOnDependentJoinsWithCost() throws Exception {
        FakeMetadataFacade metadata = this.getTempTableMetadata(false);
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        FakeMetadataObject orders = metadata.getStore().findObject("stock.orders", "Group");
        FakeMetadataObject suppliers = metadata.getStore().findObject("stock.suppliers", "Group");
        orders.putProperty("cardinality", 511);
        suppliers.putProperty("cardinality", 10);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-FullSuppliers.xml");
        XMLPlan xmlPlan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.docJoin", expectedDoc, metadata, dataMgr);
        Map stats = XMLProgramUtil.getProgramStats(xmlPlan.getOriginalProgram());
        List list = (List)stats.get(ExecSqlInstruction.class);
        ExecSqlInstruction instr = (ExecSqlInstruction)list.get(2);
        ProcessorPlan plan = instr.info.getPlan();
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkDependentJoinCount(plan, 1);
    }

    @Test
    public void testNoRedundentStagingTables() throws Exception {
        FakeMetadataFacade metadata = this.getTempTableMetadata(true);
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        FakeMetadataObject suppliers = metadata.getStore().findObject("stock.suppliers", "Group");
        FakeMetadataObject orders = metadata.getStore().findObject("stock.orders", "Group");
        suppliers.putProperty("cardinality", new Integer(10));
        orders.putProperty("cardinality", new Integer(10));
        String expectedDoc = TestXMLProcessor.readFile("TestXMLProcessor-OnlySupplier51.xml");
        XMLPlan xmlPlan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.docJoin where context(Supplier, SupplierID) = 51", expectedDoc, metadata, dataMgr);
        Map stats = XMLProgramUtil.getProgramStats(xmlPlan.getOriginalProgram());
        Assert.assertEquals((long)4L, (long)((List)stats.get(ExecStagingTableInstruction.class)).size());
    }

    @Test
    public void testEmptyMappingClass() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        FakeMetadataObject suppliers = metadata.getStore().findObject("xmltest.suppliers", "Group");
        QueryNode node = (QueryNode)suppliers.getProperty("plan");
        node.setQuery(null);
        FakeMetadataObject docGroup = metadata.getStore().findObject("xmltest.doc9", "Group");
        MappingDocument doc = (MappingDocument)docGroup.getProperty("plan");
        MappingNode suppliersNode = MappingNode.findNode((MappingNode)doc, (String)"Catalogs.Catalog.Items.Item.Suppliers.Supplier".toUpperCase());
        suppliersNode.setExclude(true);
        String expectedDoc = TestXMLProcessor.readFile("TestXMLPlanningEnhancements-testEmptyMappingClass.xml");
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9", expectedDoc, metadata, dataMgr);
    }
}

