/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCommentNode;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.Namespace;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.xml.TestXMLPlanner;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.xml.ExecStagingTableInstruction;
import org.teiid.query.processor.xml.XMLPlan;
import org.teiid.query.processor.xml.XMLProgramUtil;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;
import org.teiid.query.util.CommandContext;

public class TestXMLProcessor {
    private static final boolean DEBUG = false;
    private static final FakeMetadataFacade EXAMPLE_CACHED = TestXMLProcessor.exampleMetadata();
    private static final String EXPECTED_DOC_NESTED_2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>12/31/01</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"3\">\r\n                                <OrderDate>02/31/02</OrderDate>\r\n                                <OrderQuantity>12</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderDate>05/31/02</OrderDate>\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
    private static final String EXPECTED_DOC_NESTED_3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>12/31/01</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
    private static final String EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_4 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
    private static final String EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_5 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>12/31/01</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
    private static final String EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_7 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
    private static final String EXPECTED_DOC_DEFECT_8917_AND_11789 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name xsi:nil=\"true\"/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n    <OptionalCatalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name xsi:nil=\"true\"/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </OptionalCatalog>\r\n    <OptionalCatalog2>\r\n        <Items>\r\n            <Item>\r\n                <Name xsi:nil=\"true\"/>\r\n            </Item>\r\n        </Items>\r\n    </OptionalCatalog2>\r\n    <Catalog4/>\r\n    <Catalog5>\r\n        <OptionalItems>\r\n            <Item>\r\n                <FixedName>Nugent</FixedName>\r\n            </Item>\r\n        </OptionalItems>\r\n    </Catalog5>\r\n    <Catalog6/>\r\n</Catalogs>\r\n\r\n";
    private static final String CASE_3225_WITH_CRITERIA_EXPECTED_DOC = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>2/13/05</OrderDate>\r\n                                <OrderQuantity>2</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                        <Employees>\r\n                            <Employee EmployeeID=\"1001\" SupervisorID=\"1004\">\r\n                                <FirstName>Albert</FirstName>\r\n                                <LastName>Pujols</LastName>\r\n                            </Employee>\r\n                            <Employee EmployeeID=\"1002\" SupervisorID=\"1004\">\r\n                                <FirstName>Jim</FirstName>\r\n                                <LastName>Edmunds</LastName>\r\n                            </Employee>\r\n                        </Employees>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>3/13/05</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                        <Employees/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                        <Employees/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                        <Employees>\r\n                            <Employee EmployeeID=\"1005\" SupervisorID=\"1007\">\r\n                                <FirstName>Derrek</FirstName>\r\n                                <LastName>Lee</LastName>\r\n                            </Employee>\r\n                        </Employees>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
    private static String EXPECTED_ORDERED_DOC9A = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"3\">\r\n                                <OrderDate>02/31/02</OrderDate>\r\n                                <OrderQuantity>12</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderDate>05/31/02</OrderDate>\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>12/31/01</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";

    public static FakeMetadataFacade exampleMetadataCached() {
        return EXAMPLE_CACHED;
    }

    public static FakeMetadataFacade exampleMetadata() {
        FakeMetadataStore store = new FakeMetadataStore();
        FakeMetadataFacade facade = new FakeMetadataFacade(store);
        FakeMetadataObject stock = FakeMetadataFactory.createPhysicalModel("stock");
        FakeMetadataObject xmltest = FakeMetadataFactory.createVirtualModel("xmltest");
        FakeMetadataObject items = FakeMetadataFactory.createPhysicalGroup("stock.items", stock);
        FakeMetadataObject item_supplier = FakeMetadataFactory.createPhysicalGroup("stock.item_supplier", stock);
        FakeMetadataObject suppliers = FakeMetadataFactory.createPhysicalGroup("stock.suppliers", stock);
        FakeMetadataObject orders = FakeMetadataFactory.createPhysicalGroup("stock.orders", stock);
        FakeMetadataObject employees = FakeMetadataFactory.createPhysicalGroup("stock.employees", stock);
        List<FakeMetadataObject> itemElements = FakeMetadataFactory.createElements(items, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        List<FakeMetadataObject> itemSupplierElements = FakeMetadataFactory.createElements(item_supplier, new String[]{"itemNum", "supplierNum"}, new String[]{"string", "string"});
        List<FakeMetadataObject> supplierElements = FakeMetadataFactory.createElements(suppliers, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        List<FakeMetadataObject> stockOrders = FakeMetadataFactory.createElements(orders, new String[]{"orderNum", "itemFK", "supplierFK", "supplierNameFK", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "string", "string", "string", "integer", "string"});
        List<FakeMetadataObject> supplierEmployees = FakeMetadataFactory.createElements(employees, new String[]{"employeeNum", "supplierNumFK", "supervisorNum", "firstName", "lastName"}, new String[]{"string", "string", "string", "string", "string"});
        QueryNode rsQuery = new QueryNode("xmltest.group.items", "SELECT itemNum, itemName, itemQuantity, itemStatus FROM stock.items");
        FakeMetadataObject rs = FakeMetadataFactory.createVirtualGroup("xmltest.group.items", xmltest, rsQuery);
        QueryNode rsQuery2 = new QueryNode("xmltest.suppliers", "SELECT concat(stock.suppliers.supplierNum, '') as supplierNum, supplierName, supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum = ?");
        rsQuery2.addBinding("xmltest.group.items.itemNum");
        FakeMetadataObject rs2 = FakeMetadataFactory.createVirtualGroup("xmltest.suppliers", xmltest, rsQuery2);
        QueryNode rsQuery3 = new QueryNode("xmltest.orders", "SELECT orderNum, orderDate, orderQty, orderStatus FROM stock.orders WHERE itemFK = ? AND supplierFK = ? AND supplierNameFK = ?");
        rsQuery3.addBinding("xmltest.group.items.itemNum");
        rsQuery3.addBinding("xmltest.suppliers.supplierNum");
        rsQuery3.addBinding("xmltest.suppliers.supplierName");
        FakeMetadataObject rs3 = FakeMetadataFactory.createVirtualGroup("xmltest.orders", xmltest, rsQuery3);
        QueryNode rsEmployees = new QueryNode("xmltest.employees", "SELECT employeeNum, firstName, lastName FROM stock.employees WHERE supervisorNum IS NULL");
        FakeMetadataObject rs4 = FakeMetadataFactory.createVirtualGroup("xmltest.employees", xmltest, rsEmployees);
        QueryNode rsEmployeesRecursive = new QueryNode("xmltest.employeesRecursive", "SELECT employeeNum, firstName, lastName FROM stock.employees WHERE supervisorNum = ?");
        rsEmployeesRecursive.addBinding("xmltest.employees.employeeNum");
        FakeMetadataObject rs4a = FakeMetadataFactory.createVirtualGroup("xmltest.employeesRecursive", xmltest, rsEmployeesRecursive);
        QueryNode rsEmployees2 = new QueryNode("xmltest.employees2", "SELECT employeeNum, firstName, lastName, supervisorNum FROM stock.employees WHERE supplierNumFK = '2' AND NOT (supervisorNum IS NULL)");
        FakeMetadataObject rs5 = FakeMetadataFactory.createVirtualGroup("xmltest.employees2", xmltest, rsEmployees2);
        QueryNode rsEmployees2Recursive = new QueryNode("xmltest.employees2Recursive", "SELECT employeeNum, firstName, lastName, supervisorNum FROM stock.employees WHERE employeeNum = ?");
        rsEmployees2Recursive.addBinding("xmltest.employees2.supervisorNum");
        FakeMetadataObject rs5a = FakeMetadataFactory.createVirtualGroup("xmltest.employees2Recursive", xmltest, rsEmployees2Recursive);
        QueryNode rsQueryX = new QueryNode("xmltest.suppliersX", "SELECT * FROM (exec xmltest.sqX(?)) as X");
        rsQueryX.addBinding("xmltest.group.items.itemNum");
        FakeMetadataObject rsQX = FakeMetadataFactory.createVirtualGroup("xmltest.suppliersX", xmltest, rsQueryX);
        QueryNode tempQuery = new QueryNode("tempGroup.orders", "SELECT * FROM stock.orders");
        FakeMetadataObject temp = FakeMetadataFactory.createVirtualGroup("tempGroup.orders", xmltest, tempQuery);
        QueryNode tempQuery2 = new QueryNode("tempGroup.orders2", "SELECT * FROM tempGroup.orders");
        FakeMetadataObject temp2 = FakeMetadataFactory.createVirtualGroup("tempGroup.orders2", xmltest, tempQuery2);
        QueryNode rsQuery3a = new QueryNode("xmltest.ordersA", "SELECT orderNum, orderDate, orderQty, orderStatus FROM tempGroup.orders2 WHERE itemFK = ? AND supplierFK = ? AND supplierNameFK = ?");
        rsQuery3a.addBinding("xmltest.group.items.itemNum");
        rsQuery3a.addBinding("xmltest.suppliers.supplierNum");
        rsQuery3a.addBinding("xmltest.suppliers.supplierName");
        FakeMetadataObject rs3a = FakeMetadataFactory.createVirtualGroup("xmltest.ordersA", xmltest, rsQuery3a);
        QueryNode tempQuery3b = new QueryNode("tempGroup.orders3B", "SELECT orderNum, orderDate, orderQty, orderStatus FROM tempGroup.orders2 WHERE itemFK = ? AND supplierFK = ? AND supplierNameFK = ?");
        tempQuery3b.addBinding("xmltest.group.items.itemNum");
        tempQuery3b.addBinding("xmltest.suppliers.supplierNum");
        tempQuery3b.addBinding("xmltest.suppliers.supplierName");
        FakeMetadataObject temp3b = FakeMetadataFactory.createVirtualGroup("tempGroup.orders3B", xmltest, tempQuery3b);
        QueryNode rsQuery3b = new QueryNode("xmltest.ordersB", "SELECT orderNum, orderDate, orderQty, orderStatus FROM tempGroup.orders3B");
        FakeMetadataObject rs3b = FakeMetadataFactory.createVirtualGroup("xmltest.ordersB", xmltest, rsQuery3b);
        QueryNode rsQuery12260 = new QueryNode("xmltest.group.itemsWithNumSuppliers", "SELECT itemNum, itemName, itemQuantity, itemStatus, convert((select count(*) from stock.item_supplier where stock.items.itemNum = stock.item_supplier.itemNum), string) as NUMSuppliers FROM stock.items");
        FakeMetadataObject rs12260 = FakeMetadataFactory.createVirtualGroup("xmltest.group.itemsWithNumSuppliers", xmltest, rsQuery12260);
        List<FakeMetadataObject> rsElements12260 = FakeMetadataFactory.createElements(rs12260, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus", "numSuppliers"}, new String[]{"string", "string", "integer", "string", "integer"});
        QueryNode rsQuery8373 = new QueryNode("xmltest.items8373", "SELECT itemNum, itemName, itemQuantity, itemStatus FROM stock.items UNION ALL SELECT itemNum, itemName, itemQuantity, itemStatus FROM stock.items");
        FakeMetadataObject rs8373 = FakeMetadataFactory.createVirtualGroup("xmltest.items8373", xmltest, rsQuery8373);
        List<FakeMetadataObject> rsElements8373 = FakeMetadataFactory.createElements(rs8373, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        QueryNode rsQuery8373a = new QueryNode("xmltest.items8373a", "SELECT * FROM xmltest.items8373");
        FakeMetadataObject rs8373a = FakeMetadataFactory.createVirtualGroup("xmltest.items8373a", xmltest, rsQuery8373a);
        List<FakeMetadataObject> rsElements8373a = FakeMetadataFactory.createElements(rs8373a, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        QueryNode rsQuery8373b = new QueryNode("xmltest.items8373b", "SELECT * FROM xmltest.group.items UNION ALL SELECT * FROM xmltest.group.items");
        FakeMetadataObject rs8373b = FakeMetadataFactory.createVirtualGroup("xmltest.items8373b", xmltest, rsQuery8373b);
        List<FakeMetadataObject> rsElements8373b = FakeMetadataFactory.createElements(rs8373b, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        QueryNode rsUpdateQuery = new QueryNode("xmltest.updateTest", "INSERT INTO stock.items (itemNum, itemName, itemQuantity, itemStatus) VALUES ('3','beer',12,'something')");
        FakeMetadataObject rsUpdate = FakeMetadataFactory.createVirtualGroup("xmltest.updateTest", xmltest, rsUpdateQuery);
        List<FakeMetadataObject> rsElements = FakeMetadataFactory.createElements(rs, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        List<FakeMetadataObject> rsElements2 = FakeMetadataFactory.createElements(rs2, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        List<FakeMetadataObject> rsElements3 = FakeMetadataFactory.createElements(rs3, new String[]{"orderNum", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "integer", "string"});
        List<FakeMetadataObject> rsElements4 = FakeMetadataFactory.createElements(rs4, new String[]{"employeeNum", "firstName", "lastName"}, new String[]{"string", "string", "string"});
        List<FakeMetadataObject> rsElements4a = FakeMetadataFactory.createElements(rs4a, new String[]{"employeeNum", "firstName", "lastName"}, new String[]{"string", "string", "string"});
        List<FakeMetadataObject> rsElements5 = FakeMetadataFactory.createElements(rs5, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum"}, new String[]{"string", "string", "string", "string"});
        List<FakeMetadataObject> rsElements5a = FakeMetadataFactory.createElements(rs5a, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum"}, new String[]{"string", "string", "string", "string"});
        List<FakeMetadataObject> tempElements = FakeMetadataFactory.createElements(temp, new String[]{"orderNum", "itemFK", "supplierFK", "supplierNameFK", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "string", "string", "string", "integer", "string"});
        List<FakeMetadataObject> tempElements2 = FakeMetadataFactory.createElements(temp2, new String[]{"orderNum", "itemFK", "supplierFK", "supplierNameFK", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "string", "string", "string", "integer", "string"});
        List<FakeMetadataObject> rsElements3a = FakeMetadataFactory.createElements(rs3a, new String[]{"orderNum", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "integer", "string"});
        List<FakeMetadataObject> tempElements3b = FakeMetadataFactory.createElements(temp3b, new String[]{"orderNum", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "integer", "string"});
        List<FakeMetadataObject> rsElements3b = FakeMetadataFactory.createElements(rs3b, new String[]{"orderNum", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "integer", "string"});
        List<FakeMetadataObject> rsUpdateElement = FakeMetadataFactory.createElements(rsUpdate, new String[]{"rowCount"}, new String[]{"integer"});
        List<FakeMetadataObject> rsElementsX = FakeMetadataFactory.createElements(rsQX, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        FakeMetadataObject doc1 = FakeMetadataFactory.createVirtualGroup("xmltest.doc1", xmltest, TestXMLProcessor.createXMLMappingNode(true));
        List<FakeMetadataObject> docE1 = FakeMetadataFactory.createElements(doc1, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity"}, new String[]{"string", "string", "string", "string", "string", "string", "integer"});
        FakeMetadataObject doc1a = FakeMetadataFactory.createVirtualGroup("xmltest.doc1Unformatted", xmltest, TestXMLProcessor.createXMLMappingNode(false));
        FakeMetadataObject doc1b = FakeMetadataFactory.createVirtualGroup("xmltest.doc1b", xmltest, TestXMLProcessor.createXMLPlan2(false, true, 0));
        List<FakeMetadataObject> docE1b = FakeMetadataFactory.createElements(doc1b, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity"}, new String[]{"string", "string", "string", "string", "string", "string", "integer"});
        FakeMetadataObject doc1c = FakeMetadataFactory.createVirtualGroup("xmltest.doc1c", xmltest, TestXMLProcessor.createXMLPlan2(false, true, 1));
        List<FakeMetadataObject> docE1c = FakeMetadataFactory.createElements(doc1c, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity"}, new String[]{"string", "string", "string", "string", "string", "string", "integer"});
        FakeMetadataObject docBounded = FakeMetadataFactory.createVirtualGroup("xmltest.docBounded", xmltest, TestXMLProcessor.createXMLMappingBoundingNode());
        List<FakeMetadataObject> docBoundedElements = FakeMetadataFactory.createElements(docBounded, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity"}, new String[]{"string", "string", "string", "string", "string", "string", "integer"});
        FakeMetadataObject doc2 = FakeMetadataFactory.createVirtualGroup("xmltest.doc2", xmltest, TestXMLProcessor.createXMLPlan2(1, -1, false));
        List<FakeMetadataObject> docE2 = FakeMetadataFactory.createElements(doc2, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items"}, new String[]{"string", "string", "string"});
        FakeMetadataObject doc2a = FakeMetadataFactory.createVirtualGroup("xmltest.doc2a", xmltest, TestXMLProcessor.createXMLPlan2(1, 1, false));
        FakeMetadataObject doc2b = FakeMetadataFactory.createVirtualGroup("xmltest.doc2b", xmltest, TestXMLProcessor.createXMLPlan2(1, -1, true));
        FakeMetadataObject doc2c = FakeMetadataFactory.createVirtualGroup("xmltest.doc2c", xmltest, TestXMLProcessor.createXMLPlan2(2, -1, false));
        FakeMetadataObject doc2d = FakeMetadataFactory.createVirtualGroup("xmltest.doc2d", xmltest, TestXMLProcessor.createXMLPlan2(2, 1, false));
        FakeMetadataObject doc2e = FakeMetadataFactory.createVirtualGroup("xmltest.doc2e", xmltest, TestXMLProcessor.createXMLPlan2(2, 3, false));
        FakeMetadataObject doc3 = FakeMetadataFactory.createVirtualGroup("xmltest.doc3", xmltest, TestXMLProcessor.createXMLPlanWithDefaults());
        List<FakeMetadataObject> docE3 = FakeMetadataFactory.createElements(doc3, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity"}, new String[]{"string", "string", "string", "string", "string", "string", "integer"});
        FakeMetadataObject doc4 = FakeMetadataFactory.createVirtualGroup("xmltest.doc4", xmltest, TestXMLProcessor.createXMLPlanAdvanced());
        List<FakeMetadataObject> docE4 = FakeMetadataFactory.createElements(doc4, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Fake", "Catalogs.Fake.FakeChild2", "Catalogs.Fake.FakeChild2.FakeChild2a", "Catalogs.Fake.FakeChild3", "Catalogs.Fake.FakeChild3.@FakeAtt"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string"});
        FakeMetadataObject doc5 = FakeMetadataFactory.createVirtualGroup("xmltest.doc5", xmltest, TestXMLProcessor.createXMLPlanUltraAdvanced());
        List<FakeMetadataObject> docE5 = FakeMetadataFactory.createElements(doc5, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.DiscontinuedItem", "Catalogs.Catalog.items.DiscontinuedItem.@ItemID", "Catalogs.Catalog.items.DiscontinuedItem.Name", "Catalogs.Catalog.items.DiscontinuedItem.Quantity", "Catalogs.Catalog.items.StatusUnknown", "Catalogs.Catalog.items.StatusUnknown.@ItemID", "Catalogs.Catalog.items.StatusUnknown.Name", "Catalogs.Catalog.items.StatusUnknown.Quantity", "Catalogs.Catalog.items.Shouldn't see", "Catalogs.Catalog.items.Shouldn't see 2"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "integer", "string", "string", "string", "integer", "string", "string"});
        FakeMetadataObject doc6 = FakeMetadataFactory.createVirtualGroup("xmltest.doc6", xmltest, TestXMLProcessor.createXMLPlanUltraAdvancedExceptionOnDefault());
        List<FakeMetadataObject> docE6 = FakeMetadataFactory.createElements(doc6, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.DiscontinuedItem", "Catalogs.Catalog.items.DiscontinuedItem.@ItemID", "Catalogs.Catalog.items.DiscontinuedItem.Name", "Catalogs.Catalog.items.DiscontinuedItem.Quantity", "Catalogs.Catalog.items.Shouldn't see"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "integer", "string"});
        FakeMetadataObject doc7 = FakeMetadataFactory.createVirtualGroup("xmltest.doc7", xmltest, TestXMLProcessor.createTestAttributePlan());
        List<FakeMetadataObject> docE7 = FakeMetadataFactory.createElements(doc7, new String[]{"FixedValueTest", "FixedValueTest.wrapper", "FixedValueTest.wrapper.@fixed", "FixedValueTest.wrapper.@key", "FixedValueTest.wrapper.@fixedAttr"}, new String[]{"string", "string", "string", "string", "string"});
        FakeMetadataObject doc8 = FakeMetadataFactory.createVirtualGroup("xmltest.doc8", xmltest, TestXMLProcessor.createXMLPlanNested());
        List<FakeMetadataObject> docE8 = FakeMetadataFactory.createElements(doc8, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.suppliers", "Catalogs.Catalog.items.item.suppliers.supplier", "Catalogs.Catalog.items.item.suppliers.supplier.@SupplierID", "Catalogs.Catalog.items.item.suppliers.supplier.zip", "Catalogs.Catalog.items.item.suppliers.supplier.Name"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string"});
        FakeMetadataObject doc9 = FakeMetadataFactory.createVirtualGroup("xmltest.doc9", xmltest, TestXMLProcessor.createXMLPlanNested2());
        List<FakeMetadataObject> docE9 = FakeMetadataFactory.createElements(doc9, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.suppliers", "Catalogs.Catalog.items.item.suppliers.supplier", "Catalogs.Catalog.items.item.suppliers.supplier.@SupplierID", "Catalogs.Catalog.items.item.suppliers.supplier.zip", "Catalogs.Catalog.items.item.suppliers.supplier.Name", "Catalogs.Catalog.items.item.suppliers.supplier.orders", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.@OrderID", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.OrderDate", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.OrderQuantity", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.OrderStatus"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string"});
        FakeMetadataObject doc9a = FakeMetadataFactory.createVirtualGroup("xmltest.doc9a", xmltest, TestXMLProcessor.createXMLPlanNested2a());
        List<FakeMetadataObject> docE9a = FakeMetadataFactory.createElements(doc9a, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.suppliers", "Catalogs.Catalog.items.item.suppliers.supplier", "Catalogs.Catalog.items.item.suppliers.supplier.@SupplierID", "Catalogs.Catalog.items.item.suppliers.supplier.zip", "Catalogs.Catalog.items.item.suppliers.supplier.Name", "Catalogs.Catalog.items.item.suppliers.supplier.orders", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.@OrderID", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.OrderDate", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.OrderQuantity", "Catalogs.Catalog.items.item.suppliers.supplier.orders.order.OrderStatus"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string"});
        FakeMetadataObject doc9b = FakeMetadataFactory.createVirtualGroup("xmltest.doc9b", xmltest, TestXMLProcessor.createXMLPlanNested2b());
        FakeMetadataObject doc10 = FakeMetadataFactory.createVirtualGroup("xmltest.doc10", xmltest, TestXMLProcessor.createXMLPlanNestedWithChoice());
        List<FakeMetadataObject> docE10 = FakeMetadataFactory.createElements(doc10, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.suppliers", "Catalogs.Catalog.items.item.suppliers.supplier", "Catalogs.Catalog.items.item.suppliers.supplier.@SupplierID", "Catalogs.Catalog.items.item.suppliers.supplier.zip", "Catalogs.Catalog.items.item.suppliers.supplier.Name", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.order", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.order.@OrderID", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.order.OrderDate", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.order.OrderQuantity", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.order.OrderStatus", "Catalogs.Catalog.items.item.suppliers.supplier.orders.ProcessingOrders", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.otherorder.@OrderID", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.otherorder"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string"});
        FakeMetadataObject doc10L = FakeMetadataFactory.createVirtualGroup("xmltest.doc10L", xmltest, TestXMLProcessor.createXMLPlanNestedWithLookupChoice());
        List<FakeMetadataObject> docE10L = FakeMetadataFactory.createElements(doc10L, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.suppliers", "Catalogs.Catalog.items.item.suppliers.supplier", "Catalogs.Catalog.items.item.suppliers.supplier.@SupplierID", "Catalogs.Catalog.items.item.suppliers.supplier.zip", "Catalogs.Catalog.items.item.suppliers.supplier.Name", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.order", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.order.@OrderID", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.order.OrderDate", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.order.OrderQuantity", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.order.OrderStatus", "Catalogs.Catalog.items.item.suppliers.supplier.orders.ProcessingOrders", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.otherorder.@OrderID", "Catalogs.Catalog.items.item.suppliers.supplier.ProcessingOrders.otherorder"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string"});
        FakeMetadataObject doc11 = FakeMetadataFactory.createVirtualGroup("xmltest.doc11", xmltest, TestXMLProcessor.createXMLPlanMultipleDocs());
        List<FakeMetadataObject> docE11 = FakeMetadataFactory.createElements(doc11, new String[]{"Item", "Item.@ItemID", "Item.Name", "Item.Quantity", "Item.Suppliers", "Item.Suppliers.Supplier", "Item.Suppliers.Supplier.@SupplierID", "Item.Suppliers.Supplier.Name", "Item.Suppliers.Supplier.Zip"}, new String[]{"string", "string", "string", "string", "string", "string", "string", "string", "string"});
        boolean useRecursiveCriteria = false;
        int recursionlimit = -1;
        boolean exceptionOnLimit = false;
        FakeMetadataObject doc12 = FakeMetadataFactory.createVirtualGroup("xmltest.doc12", xmltest, TestXMLProcessor.createXMLPlanRecursive(useRecursiveCriteria, recursionlimit, exceptionOnLimit));
        FakeMetadataObject doc12a = FakeMetadataFactory.createVirtualGroup("xmltest.doc12a", xmltest, TestXMLProcessor.createXMLPlanRecursiveA(useRecursiveCriteria, recursionlimit, exceptionOnLimit));
        useRecursiveCriteria = true;
        FakeMetadataObject doc13 = FakeMetadataFactory.createVirtualGroup("xmltest.doc13", xmltest, TestXMLProcessor.createXMLPlanRecursive(useRecursiveCriteria, recursionlimit, exceptionOnLimit));
        useRecursiveCriteria = false;
        recursionlimit = 2;
        FakeMetadataObject doc14 = FakeMetadataFactory.createVirtualGroup("xmltest.doc14", xmltest, TestXMLProcessor.createXMLPlanRecursive(useRecursiveCriteria, recursionlimit, exceptionOnLimit));
        exceptionOnLimit = true;
        FakeMetadataObject doc15 = FakeMetadataFactory.createVirtualGroup("xmltest.doc15", xmltest, TestXMLProcessor.createXMLPlanRecursive(useRecursiveCriteria, recursionlimit, exceptionOnLimit));
        useRecursiveCriteria = false;
        recursionlimit = -1;
        exceptionOnLimit = false;
        FakeMetadataObject doc16 = FakeMetadataFactory.createVirtualGroup("xmltest.doc16", xmltest, TestXMLProcessor.createXMLPlanRecursive2(useRecursiveCriteria, recursionlimit, exceptionOnLimit));
        FakeMetadataObject doc17 = FakeMetadataFactory.createVirtualGroup("xmltest.doc17", xmltest, TestXMLProcessor.createXMLPlanWithComment());
        FakeMetadataObject doc_5266a = FakeMetadataFactory.createVirtualGroup("xmltest.doc_5266a", xmltest, TestXMLProcessor.createXMLPlanNestedWithChoiceFor5266());
        List<FakeMetadataObject> doc_E5266a = FakeMetadataFactory.createElements(doc_5266a, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items"}, new String[]{"string", "string", "string"});
        FakeMetadataObject doc_8917 = FakeMetadataFactory.createVirtualGroup("xmltest.doc_8917", xmltest, TestXMLProcessor.createXMLPlan_defect8917());
        FakeMetadataObject doc_9446 = FakeMetadataFactory.createVirtualGroup("xmltest.doc_9446", xmltest, TestXMLProcessor.createXMLPlan_defect9446());
        FakeMetadataObject doc_9530 = FakeMetadataFactory.createVirtualGroup("xmltest.doc_9530", xmltest, TestXMLProcessor.createXMLPlan_defect_9530());
        List<FakeMetadataObject> docE_9446 = FakeMetadataFactory.createElements(doc_9446, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.XXXXX", "Catalogs.Catalog.items.item.XXXXX", "Catalogs.Catalog.items.item.XXXXX"}, new String[]{"string", "string", "string", "string", "string", "string", "integer"});
        FakeMetadataObject docUpdateTest = FakeMetadataFactory.createVirtualGroup("xmltest.docUpdateTest", xmltest, TestXMLProcessor.createUpdateTestDoc());
        FakeMetadataObject doc_9893 = FakeMetadataFactory.createVirtualGroup("xmltest.doc9893", xmltest, TestXMLProcessor.createXMLPlan_9893());
        List<FakeMetadataObject> docE_9893 = FakeMetadataFactory.createElements(doc_9893, new String[]{"Root", "Root.ItemName"}, new String[]{"string", "string"});
        FakeMetadataObject doc18 = FakeMetadataFactory.createVirtualGroup("xmltest.doc18", xmltest, TestXMLProcessor.createXMLPlanNested("xmltest.suppliersX"));
        List<FakeMetadataObject> docE18 = FakeMetadataFactory.createElements(doc18, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.suppliers", "Catalogs.Catalog.items.item.suppliers.supplier", "Catalogs.Catalog.items.item.suppliers.supplier.@SupplierID", "Catalogs.Catalog.items.item.suppliers.supplier.zip", "Catalogs.Catalog.items.item.suppliers.supplier.Name"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string"});
        FakeMetadataObject doc12260 = FakeMetadataFactory.createVirtualGroup("xmltest.doc12260", xmltest, TestXMLProcessor.createXMLPlanCorrelatedSubqueryTransform());
        List<FakeMetadataObject> docE12260 = FakeMetadataFactory.createElements(doc12260, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.numSuppliers"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string"});
        FakeMetadataObject doc8373 = FakeMetadataFactory.createVirtualGroup("xmltest.doc8373", xmltest, TestXMLProcessor.createXMLPlan_defect8373());
        List<FakeMetadataObject> docE8373 = FakeMetadataFactory.createElements(doc8373, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.numSuppliers"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string"});
        FakeMetadataObject doc8373a = FakeMetadataFactory.createVirtualGroup("xmltest.doc8373a", xmltest, TestXMLProcessor.createXMLPlan_defect8373a());
        List<FakeMetadataObject> docE8373a = FakeMetadataFactory.createElements(doc8373a, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.numSuppliers"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string"});
        FakeMetadataObject doc8373b = FakeMetadataFactory.createVirtualGroup("xmltest.doc8373b", xmltest, TestXMLProcessor.createXMLPlan_defect8373b());
        List<FakeMetadataObject> docE8373b = FakeMetadataFactory.createElements(doc8373b, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.numSuppliers"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string"});
        FakeMetadataObject doc13617 = FakeMetadataFactory.createVirtualGroup("xmltest.doc13617", xmltest, TestXMLProcessor.createXMLPlanDefect13617());
        List<FakeMetadataObject> docE13617 = FakeMetadataFactory.createElements(doc13617, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity"}, new String[]{"string", "string", "string", "string", "string", "string", "integer"});
        FakeMetadataObject doc19 = FakeMetadataFactory.createVirtualGroup("xmltest.doc19", xmltest, TestXMLProcessor.createXMLPlanRecursiveStaging(true, recursionlimit, exceptionOnLimit));
        QueryNode doc19TempQuery = new QueryNode("xmltest.doc19temp", "SELECT employeeNum, firstName, lastName, supervisorNum FROM stock.employees");
        FakeMetadataObject tempDoc19 = FakeMetadataFactory.createVirtualGroup("xmltest.doc19temp", xmltest, doc19TempQuery);
        List<FakeMetadataObject> doc19TempQueryE = FakeMetadataFactory.createElements(tempDoc19, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum"}, new String[]{"string", "string", "string", "string"});
        QueryNode rsEmployeesDoc19 = new QueryNode("xmltest.employeesDoc19", "SELECT employeeNum, firstName, lastName FROM xmltest.doc19temp WHERE supervisorNum IS NULL");
        FakeMetadataObject mc1Doc19 = FakeMetadataFactory.createVirtualGroup("xmltest.employeesDoc19", xmltest, rsEmployeesDoc19);
        List<FakeMetadataObject> mc1Doc19E = FakeMetadataFactory.createElements(mc1Doc19, new String[]{"employeeNum", "firstName", "lastName"}, new String[]{"string", "string", "string"});
        QueryNode rsEmployeesRecursiveDoc19 = new QueryNode("xmltest.employeesRecursiveDoc19", "SELECT employeeNum, firstName, lastName FROM xmltest.doc19temp WHERE supervisorNum = ?");
        rsEmployeesRecursiveDoc19.addBinding("xmltest.employeesDoc19.employeeNum");
        FakeMetadataObject mc2Doc19 = FakeMetadataFactory.createVirtualGroup("xmltest.employeesRecursiveDoc19", xmltest, rsEmployeesRecursiveDoc19);
        List<FakeMetadataObject> mc2Doc19E = FakeMetadataFactory.createElements(mc2Doc19, new String[]{"employeeNum", "firstName", "lastName"}, new String[]{"string", "string", "string"});
        FakeMetadataObject rsX = FakeMetadataFactory.createResultSet("xmltest.rsX", xmltest, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        FakeMetadataObject rsXp1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rsX);
        FakeMetadataObject rsXp2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sqXn1 = new QueryNode("xmltest.sqX", "CREATE VIRTUAL PROCEDURE BEGIN declare string x; SELECT concat(stock.suppliers.supplierNum, '') as supplierNum, supplierName, supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum = xmltest.sqX.in; END");
        FakeMetadataObject sqX = FakeMetadataFactory.createVirtualProcedure("xmltest.sqX", xmltest, Arrays.asList(rsXp1, rsXp2), sqXn1);
        FakeMetadataObject normDoc1 = FakeMetadataFactory.createVirtualGroup("xmltest.normDoc1", xmltest, TestXMLProcessor.createXMLPlanNormalization("collapse"));
        List<FakeMetadataObject> normDocE1 = FakeMetadataFactory.createElements(normDoc1, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.DiscontinuedItem", "Catalogs.Catalog.items.DiscontinuedItem.@ItemID", "Catalogs.Catalog.items.DiscontinuedItem.Name", "Catalogs.Catalog.items.DiscontinuedItem.Quantity", "Catalogs.Catalog.items.StatusUnknown", "Catalogs.Catalog.items.StatusUnknown.@ItemID", "Catalogs.Catalog.items.StatusUnknown.Name", "Catalogs.Catalog.items.StatusUnknown.Quantity", "Catalogs.Catalog.items.Shouldn't see", "Catalogs.Catalog.items.Shouldn't see 2"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "integer", "string", "string", "string", "integer", "string", "string"});
        FakeMetadataObject normDoc2 = FakeMetadataFactory.createVirtualGroup("xmltest.normDoc2", xmltest, TestXMLProcessor.createXMLPlanNormalization("replace"));
        List<FakeMetadataObject> normDocE2 = FakeMetadataFactory.createElements(normDoc2, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.DiscontinuedItem", "Catalogs.Catalog.items.DiscontinuedItem.@ItemID", "Catalogs.Catalog.items.DiscontinuedItem.Name", "Catalogs.Catalog.items.DiscontinuedItem.Quantity", "Catalogs.Catalog.items.StatusUnknown", "Catalogs.Catalog.items.StatusUnknown.@ItemID", "Catalogs.Catalog.items.StatusUnknown.Name", "Catalogs.Catalog.items.StatusUnknown.Quantity", "Catalogs.Catalog.items.Shouldn't see", "Catalogs.Catalog.items.Shouldn't see 2"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "integer", "string", "string", "string", "integer", "string", "string"});
        FakeMetadataObject normDoc3 = FakeMetadataFactory.createVirtualGroup("xmltest.normDoc3", xmltest, TestXMLProcessor.createXMLPlanNormalization("preserve"));
        List<FakeMetadataObject> normDocE3 = FakeMetadataFactory.createElements(normDoc3, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.DiscontinuedItem", "Catalogs.Catalog.items.DiscontinuedItem.@ItemID", "Catalogs.Catalog.items.DiscontinuedItem.Name", "Catalogs.Catalog.items.DiscontinuedItem.Quantity", "Catalogs.Catalog.items.StatusUnknown", "Catalogs.Catalog.items.StatusUnknown.@ItemID", "Catalogs.Catalog.items.StatusUnknown.Name", "Catalogs.Catalog.items.StatusUnknown.Quantity", "Catalogs.Catalog.items.Shouldn't see", "Catalogs.Catalog.items.Shouldn't see 2"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "integer", "string", "string", "string", "integer", "string", "string"});
        QueryNode vspqn1 = new QueryNode("vsp1", "CREATE VIRTUAL PROCEDURE BEGIN insert into #temp select * from stock.items; SELECT * FROM xmltest.doc1 where Item.Quantity < (select avg(itemquantity) from #temp); END");
        FakeMetadataObject vsprs1 = FakeMetadataFactory.createResultSet("pm1.vsprs1", xmltest, new String[]{"xml"}, new String[]{"xml"});
        FakeMetadataObject vspp1 = FakeMetadataFactory.createParameter("ret", 1, 5, "xml", vsprs1);
        FakeMetadataObject vsp1 = FakeMetadataFactory.createVirtualProcedure("xmltest.vsp1", xmltest, Arrays.asList(vspp1), vspqn1);
        store.addObject(stock);
        store.addObject(items);
        store.addObject(item_supplier);
        store.addObject(suppliers);
        store.addObject(orders);
        store.addObject(employees);
        store.addObjects(itemElements);
        store.addObjects(itemSupplierElements);
        store.addObjects(supplierElements);
        store.addObjects(stockOrders);
        store.addObjects(supplierEmployees);
        store.addObject(xmltest);
        store.addObject(rs);
        store.addObject(rs2);
        store.addObject(rs3);
        store.addObject(rs4);
        store.addObject(rs4a);
        store.addObject(rs5);
        store.addObject(rs5a);
        store.addObject(temp);
        store.addObject(temp2);
        store.addObject(rs3a);
        store.addObject(temp3b);
        store.addObject(rs3b);
        store.addObject(rsQX);
        store.addObject(rs12260);
        store.addObject(rs8373);
        store.addObject(rs8373a);
        store.addObject(rs8373b);
        store.addObject(rsX);
        store.addObject(sqX);
        store.addObject(rsUpdate);
        store.addObjects(rsElements);
        store.addObjects(rsElements2);
        store.addObjects(rsElements3);
        store.addObjects(rsElements4);
        store.addObjects(rsElements4a);
        store.addObjects(rsElements5);
        store.addObjects(rsElements5a);
        store.addObjects(tempElements);
        store.addObjects(tempElements2);
        store.addObjects(rsElements3a);
        store.addObjects(tempElements3b);
        store.addObjects(rsElements3b);
        store.addObjects(rsUpdateElement);
        store.addObjects(rsElementsX);
        store.addObjects(rsElements12260);
        store.addObjects(rsElements8373);
        store.addObjects(rsElements8373a);
        store.addObjects(rsElements8373b);
        store.addObject(doc1);
        store.addObject(docBounded);
        store.addObject(doc1a);
        store.addObject(doc1b);
        store.addObject(doc1c);
        store.addObject(doc2);
        store.addObject(doc2a);
        store.addObject(doc2b);
        store.addObject(doc2c);
        store.addObject(doc2d);
        store.addObject(doc2e);
        store.addObject(doc3);
        store.addObject(doc4);
        store.addObject(doc5);
        store.addObject(normDoc1);
        store.addObject(normDoc2);
        store.addObject(normDoc3);
        store.addObject(doc6);
        store.addObject(doc7);
        store.addObject(doc8);
        store.addObject(doc9);
        store.addObject(doc9a);
        store.addObject(doc9b);
        store.addObject(doc10);
        store.addObject(doc10L);
        store.addObject(doc11);
        store.addObject(doc12);
        store.addObject(doc12a);
        store.addObject(doc13);
        store.addObject(doc14);
        store.addObject(doc15);
        store.addObject(doc16);
        store.addObject(doc17);
        store.addObject(doc_8917);
        store.addObject(doc_9446);
        store.addObject(doc_9530);
        store.addObject(docUpdateTest);
        store.addObject(doc_9893);
        store.addObject(doc18);
        store.addObject(doc12260);
        store.addObject(doc8373);
        store.addObject(doc8373a);
        store.addObject(doc8373b);
        store.addObject(doc13617);
        store.addObject(doc19);
        store.addObject(tempDoc19);
        store.addObject(mc1Doc19);
        store.addObject(mc2Doc19);
        store.addObject(doc_5266a);
        store.addObjects(doc19TempQueryE);
        store.addObjects(mc1Doc19E);
        store.addObjects(mc2Doc19E);
        store.addObjects(docE1);
        store.addObjects(docE1b);
        store.addObjects(docE1c);
        store.addObjects(docBoundedElements);
        store.addObjects(docE2);
        store.addObjects(docE3);
        store.addObjects(docE4);
        store.addObjects(docE5);
        store.addObjects(normDocE1);
        store.addObjects(normDocE2);
        store.addObjects(normDocE3);
        store.addObjects(docE6);
        store.addObjects(docE7);
        store.addObjects(docE8);
        store.addObjects(docE9);
        store.addObjects(docE9a);
        store.addObjects(docE_9446);
        store.addObjects(docE_9893);
        store.addObjects(docE18);
        store.addObjects(docE12260);
        store.addObjects(docE8373);
        store.addObjects(docE8373a);
        store.addObjects(docE8373b);
        store.addObjects(docE13617);
        store.addObjects(doc_E5266a);
        store.addObjects(docE10);
        store.addObjects(docE10L);
        store.addObjects(docE11);
        store.addObject(vsp1);
        return facade;
    }

    public FakeMetadataFacade exampleMetadataNestedWithSibling() {
        FakeMetadataStore store = new FakeMetadataStore();
        FakeMetadataFacade facade = new FakeMetadataFacade(store);
        FakeMetadataObject stock = FakeMetadataFactory.createPhysicalModel("stock");
        FakeMetadataObject xmltest = FakeMetadataFactory.createVirtualModel("xmltest");
        FakeMetadataObject items = FakeMetadataFactory.createPhysicalGroup("stock.items", stock);
        FakeMetadataObject item_supplier = FakeMetadataFactory.createPhysicalGroup("stock.item_supplier", stock);
        FakeMetadataObject item_order = FakeMetadataFactory.createPhysicalGroup("stock.item_order", stock);
        FakeMetadataObject orders = FakeMetadataFactory.createPhysicalGroup("stock.orders", stock);
        FakeMetadataObject suppliers = FakeMetadataFactory.createPhysicalGroup("stock.suppliers", stock);
        List<FakeMetadataObject> itemElements = FakeMetadataFactory.createElements(items, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        List<FakeMetadataObject> itemSupplierElements = FakeMetadataFactory.createElements(item_supplier, new String[]{"itemNum", "supplierNum"}, new String[]{"string", "string"});
        List<FakeMetadataObject> supplierElements = FakeMetadataFactory.createElements(suppliers, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        List<FakeMetadataObject> itemOrderElements = FakeMetadataFactory.createElements(item_order, new String[]{"itemNum", "orderNum"}, new String[]{"string", "string"});
        List<FakeMetadataObject> stockOrders = FakeMetadataFactory.createElements(orders, new String[]{"orderNum", "orderName", "orderZipCode"}, new String[]{"string", "string", "string"});
        QueryNode rsQuery1 = new QueryNode("xmltest.group.items", "SELECT itemNum, itemName, itemQuantity, itemStatus FROM stock.items");
        FakeMetadataObject rs1 = FakeMetadataFactory.createVirtualGroup("xmltest.group.items", xmltest, rsQuery1);
        QueryNode rsQuery2 = new QueryNode("xmltest.suppliers", "SELECT concat(stock.suppliers.supplierNum, '') as supplierNum, supplierName, supplierZipCode FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum = ?");
        rsQuery2.addBinding("xmltest.group.items.itemNum");
        FakeMetadataObject rs2 = FakeMetadataFactory.createVirtualGroup("xmltest.suppliers", xmltest, rsQuery2);
        QueryNode rsQuery3 = new QueryNode("xmltest.orders", "SELECT concat(stock.orders.orderNum, '') as orderNum, orderName, orderZipCode FROM stock.orders, stock.item_order WHERE stock.orders.orderNum = stock.item_order.orderNum AND stock.item_order.itemNum = ?");
        rsQuery3.addBinding("xmltest.group.items.itemNum");
        FakeMetadataObject rs3 = FakeMetadataFactory.createVirtualGroup("xmltest.orders", xmltest, rsQuery3);
        List<FakeMetadataObject> rsElements1 = FakeMetadataFactory.createElements(rs1, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        List<FakeMetadataObject> rsElements2 = FakeMetadataFactory.createElements(rs2, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string", "string"});
        List<FakeMetadataObject> rsElements3 = FakeMetadataFactory.createElements(rs3, new String[]{"orderNum", "orderName", "orderZipCode"}, new String[]{"string", "string", "string"});
        FakeMetadataObject doc9c = FakeMetadataFactory.createVirtualGroup("xmltest.doc9c", xmltest, this.createXMLPlanNested2c());
        List<FakeMetadataObject> docE9c = FakeMetadataFactory.createElements(doc9c, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.suppliers", "Catalogs.Catalog.items.item.suppliers.supplier", "Catalogs.Catalog.items.item.suppliers.supplier.@SupplierID", "Catalogs.Catalog.items.item.suppliers.supplier.zip", "Catalogs.Catalog.items.item.suppliers.supplier.Name", "Catalogs.Catalog.items.item.orders", "Catalogs.Catalog.items.item.orders.order", "Catalogs.Catalog.items.item.orders.order.@OrderID", "Catalogs.Catalog.items.item.orders.order.zip", "Catalogs.Catalog.items.item.orders.order.Name"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string"});
        store.addObject(stock);
        store.addObject(items);
        store.addObject(item_supplier);
        store.addObject(item_order);
        store.addObject(suppliers);
        store.addObject(orders);
        store.addObjects(itemElements);
        store.addObjects(itemSupplierElements);
        store.addObjects(supplierElements);
        store.addObjects(stockOrders);
        store.addObjects(itemOrderElements);
        store.addObject(xmltest);
        store.addObject(rs1);
        store.addObject(rs2);
        store.addObject(rs3);
        store.addObjects(rsElements1);
        store.addObjects(rsElements2);
        store.addObjects(rsElements3);
        store.addObject(doc9c);
        store.addObjects(docE9c);
        return facade;
    }

    public static FakeMetadataFacade exampleMetadata2() {
        FakeMetadataStore store = new FakeMetadataStore();
        FakeMetadataFacade facade = new FakeMetadataFacade(store);
        FakeMetadataObject xqt = FakeMetadataFactory.createPhysicalModel("xqt");
        FakeMetadataObject xqttest = FakeMetadataFactory.createVirtualModel("xqttest");
        FakeMetadataObject xqtGroup = FakeMetadataFactory.createPhysicalGroup("xqt.data", xqt);
        List<FakeMetadataObject> xqtData = FakeMetadataFactory.createElements(xqtGroup, new String[]{"intKey", "intNum", "stringNum"}, new String[]{"integer", "integer", "string"});
        QueryNode xqtDataGroup = new QueryNode("xqttest.xqtData", "SELECT intKey as key, intNum as data, (intKey + 2) as nextKey FROM xqt.data");
        FakeMetadataObject objData = FakeMetadataFactory.createVirtualGroup("xqttest.xqtData", xqttest, xqtDataGroup);
        QueryNode rsGroup = new QueryNode("xqttest.group", "SELECT key as ID, data as CODE, nextKey as supervisorID FROM xqttest.xqtData");
        FakeMetadataObject objGroup = FakeMetadataFactory.createVirtualGroup("xqttest.group", xqttest, rsGroup);
        QueryNode rsSupervisor = new QueryNode("xqttest.supervisor", "SELECT key as ID, data as CODE, nextKey as groupID FROM xqttest.xqtData WHERE key = ?");
        rsSupervisor.addBinding("xqttest.group.supervisorID");
        FakeMetadataObject objSupervisor = FakeMetadataFactory.createVirtualGroup("xqttest.supervisor", xqttest, rsSupervisor);
        QueryNode rsGroup1 = new QueryNode("xqttest.group1", "SELECT key as ID, data as CODE, nextKey as supervisorID FROM xqttest.xqtData WHERE key = ?");
        rsGroup1.addBinding("xqttest.supervisor.groupID");
        FakeMetadataObject objGroup1 = FakeMetadataFactory.createVirtualGroup("xqttest.group1", xqttest, rsGroup1);
        List<FakeMetadataObject> elemXQTData = FakeMetadataFactory.createElements(objData, new String[]{"key", "data", "nextKey"}, new String[]{"integer", "integer", "integer"});
        List<FakeMetadataObject> elemGroup = FakeMetadataFactory.createElements(objGroup, new String[]{"ID", "code", "supervisorID"}, new String[]{"integer", "integer", "integer"});
        List<FakeMetadataObject> elemSupervisor = FakeMetadataFactory.createElements(objSupervisor, new String[]{"ID", "code", "groupID"}, new String[]{"integer", "integer", "integer"});
        List<FakeMetadataObject> elemGroup1 = FakeMetadataFactory.createElements(objGroup1, new String[]{"ID", "code", "supervisorID"}, new String[]{"integer", "integer", "integer"});
        QueryNode rsQuery = new QueryNode("xqttest.data", "SELECT intKey, intNum, stringNum FROM xqt.data WHERE intKey=13");
        FakeMetadataObject rs = FakeMetadataFactory.createVirtualGroup("xqttest.data", xqttest, rsQuery);
        QueryNode rsQuery2 = new QueryNode("xqttest.data2", "SELECT intKey, intNum, stringNum FROM xqt.data WHERE intKey = ?");
        rsQuery2.addBinding("xqttest.data.intNum");
        FakeMetadataObject rs2 = FakeMetadataFactory.createVirtualGroup("xqttest.data2", xqttest, rsQuery2);
        QueryNode rsQuery3 = new QueryNode("xqttest.data3", "SELECT intKey, intNum, stringNum FROM xqt.data WHERE intKey = ?");
        rsQuery3.addBinding("xqttest.data2.intNum");
        FakeMetadataObject rs3 = FakeMetadataFactory.createVirtualGroup("xqttest.data3", xqttest, rsQuery3);
        QueryNode rsQuery4 = new QueryNode("xqttest.data4", "SELECT intKey, intNum, stringNum FROM xqt.data WHERE intKey = ?");
        rsQuery4.addBinding("xqttest.data.intNum");
        FakeMetadataObject rs4 = FakeMetadataFactory.createVirtualGroup("xqttest.data4", xqttest, rsQuery4);
        QueryNode rsQuery5 = new QueryNode("xqttest.data5", "SELECT intKey, intNum, stringNum FROM xqt.data WHERE intKey = ?");
        rsQuery5.addBinding("xqttest.data4.intNum");
        FakeMetadataObject rs5 = FakeMetadataFactory.createVirtualGroup("xqttest.data5", xqttest, rsQuery5);
        QueryNode rsQuery6 = new QueryNode("xqttest.data6", "SELECT intKey, intNum, stringNum FROM xqt.data WHERE intKey = ?");
        rsQuery6.addBinding("xqttest.data5.intNum");
        FakeMetadataObject rs6 = FakeMetadataFactory.createVirtualGroup("xqttest.data6", xqttest, rsQuery6);
        QueryNode rsQuery7 = new QueryNode("xqttest.data7", "SELECT intKey, intNum, stringNum FROM xqt.data");
        FakeMetadataObject rs7 = FakeMetadataFactory.createVirtualGroup("xqttest.data7", xqttest, rsQuery7);
        QueryNode rsQuery8 = new QueryNode("xqttest.data8", "SELECT intKey, intNum, stringNum FROM xqt.data WHERE intKey < ?");
        rsQuery8.addBinding("xqttest.data7.intNum");
        FakeMetadataObject rs8 = FakeMetadataFactory.createVirtualGroup("xqttest.data8", xqttest, rsQuery8);
        List<FakeMetadataObject> rsElements = FakeMetadataFactory.createElements(rs, new String[]{"intKey", "intNum", "stringNum"}, new String[]{"integer", "integer", "string"});
        List<FakeMetadataObject> rsElements2 = FakeMetadataFactory.createElements(rs2, new String[]{"intKey", "intNum", "stringNum"}, new String[]{"integer", "integer", "string"});
        List<FakeMetadataObject> rsElements3 = FakeMetadataFactory.createElements(rs3, new String[]{"intKey", "intNum", "stringNum"}, new String[]{"integer", "integer", "string"});
        List<FakeMetadataObject> rsElements4 = FakeMetadataFactory.createElements(rs4, new String[]{"intKey", "intNum", "stringNum"}, new String[]{"integer", "integer", "string"});
        List<FakeMetadataObject> rsElements5 = FakeMetadataFactory.createElements(rs5, new String[]{"intKey", "intNum", "stringNum"}, new String[]{"integer", "integer", "string"});
        List<FakeMetadataObject> rsElements6 = FakeMetadataFactory.createElements(rs6, new String[]{"intKey", "intNum", "stringNum"}, new String[]{"integer", "integer", "string"});
        List<FakeMetadataObject> rsElements7 = FakeMetadataFactory.createElements(rs7, new String[]{"intKey", "intNum", "stringNum"}, new String[]{"integer", "integer", "string"});
        List<FakeMetadataObject> rsElements8 = FakeMetadataFactory.createElements(rs8, new String[]{"intKey", "intNum", "stringNum"}, new String[]{"integer", "integer", "string"});
        FakeMetadataObject doc1 = FakeMetadataFactory.createVirtualGroup("xqttest.doc1", xqttest, TestXMLProcessor.createXQTPlanRecursive_5988());
        FakeMetadataObject doc1a = FakeMetadataFactory.createVirtualGroup("xqttest.doc1a", xqttest, TestXMLProcessor.createXQTPlanRecursive1a_5988());
        FakeMetadataObject doc2 = FakeMetadataFactory.createVirtualGroup("xqttest.doc2", xqttest, TestXMLProcessor.createXQTPlanRecursiveSiblings());
        FakeMetadataObject doc3 = FakeMetadataFactory.createVirtualGroup("xqttest.doc3", xqttest, TestXMLProcessor.createXQTPlanRecursive3_5988());
        FakeMetadataObject doc4 = FakeMetadataFactory.createVirtualGroup("xqttest.doc4", xqttest, TestXMLProcessor.createXQTPlanChoice_6796());
        FakeMetadataObject doc5 = FakeMetadataFactory.createVirtualGroup("xqttest.doc5", xqttest, TestXMLProcessor.createChoiceDefect24651());
        FakeMetadataObject groupDoc = FakeMetadataFactory.createVirtualGroup("xqttest.groupDoc", xqttest, TestXMLProcessor.createGroupDoc());
        List<FakeMetadataObject> elemGroupDoc = FakeMetadataFactory.createElements(groupDoc, new String[]{"group", "group.pseudoID"}, new String[]{"string", "string"});
        List<FakeMetadataObject> elemGroupDoc4 = FakeMetadataFactory.createElements(doc4, new String[]{"root", "root.key", "root.key.keys", "root.key.keys.nestedkey", "root.wrapper.key", "root.wrapper.key.keys", "root.wrapper.key.keys.nestedkey"}, new String[]{"string", "string", "string", "string", "string", "string", "string"});
        List<FakeMetadataObject> elemGroupDoc5 = FakeMetadataFactory.createElements(doc5, new String[]{"root", "root.wrapper.key"}, new String[]{"string", "string"});
        store.addObject(xqt);
        store.addObject(xqtGroup);
        store.addObjects(xqtData);
        store.addObject(xqttest);
        store.addObject(objData);
        store.addObject(objGroup);
        store.addObject(objSupervisor);
        store.addObject(objGroup1);
        store.addObjects(elemXQTData);
        store.addObjects(elemGroup);
        store.addObjects(elemSupervisor);
        store.addObjects(elemGroup1);
        store.addObject(rs);
        store.addObject(rs2);
        store.addObject(rs3);
        store.addObject(rs4);
        store.addObject(rs5);
        store.addObject(rs6);
        store.addObject(rs7);
        store.addObject(rs8);
        store.addObjects(rsElements);
        store.addObjects(rsElements2);
        store.addObjects(rsElements3);
        store.addObjects(rsElements4);
        store.addObjects(rsElements5);
        store.addObjects(rsElements6);
        store.addObjects(rsElements7);
        store.addObjects(rsElements8);
        store.addObject(doc1);
        store.addObject(doc1a);
        store.addObject(doc2);
        store.addObject(doc3);
        store.addObject(doc4);
        store.addObject(doc5);
        store.addObject(groupDoc);
        store.addObjects(elemGroupDoc);
        store.addObjects(elemGroupDoc4);
        store.addObjects(elemGroupDoc5);
        return facade;
    }

    public static FakeMetadataFacade exampleMetadataSoap1() {
        FakeMetadataStore store = new FakeMetadataStore();
        FakeMetadataFacade facade = new FakeMetadataFacade(store);
        FakeMetadataObject taxReport = FakeMetadataFactory.createPhysicalModel("taxReport");
        FakeMetadataObject xmltest = FakeMetadataFactory.createVirtualModel("xmltest");
        FakeMetadataObject arrayOfItem = FakeMetadataFactory.createPhysicalGroup("taxReport.TaxIDs", taxReport);
        List<FakeMetadataObject> itemElements = FakeMetadataFactory.createElements(arrayOfItem, new String[]{"ID"}, new String[]{"string"});
        QueryNode rsQuerySoap = new QueryNode("xmltest.group.TaxIDs", "SELECT ID FROM taxReport.TaxIDs");
        FakeMetadataObject rsSoap = FakeMetadataFactory.createVirtualGroup("xmltest.group.TaxIDs", xmltest, rsQuerySoap);
        List<FakeMetadataObject> rsSoapElements = FakeMetadataFactory.createElements(rsSoap, new String[]{"ID"}, new String[]{"string"});
        FakeMetadataObject doc_SOAP = FakeMetadataFactory.createVirtualGroup("xmltest.docSoap", xmltest, TestXMLProcessor.createXMLPlanSOAP());
        List<FakeMetadataObject> doc_SOAPE1 = FakeMetadataFactory.createElements(doc_SOAP, new String[]{"TaxReports", "TaxReports.TaxReport", "TaxReports.TaxReport.ArrayOfTaxID", "TaxReports.TaxReport.ArrayOfTaxID.TaxID", "TaxReports.TaxReport.ArrayOfTaxID.TaxID.ID"}, new String[]{"string", "string", "string", "string", "string"});
        store.addObject(taxReport);
        store.addObject(arrayOfItem);
        store.addObjects(itemElements);
        store.addObject(xmltest);
        store.addObject(rsSoap);
        store.addObjects(rsSoapElements);
        store.addObject(doc_SOAP);
        store.addObjects(doc_SOAPE1);
        return facade;
    }

    private static MappingNode createXQTPlanChoice_6796() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingChoiceNode choice = root.addChoiceNode(new MappingChoiceNode(false));
        choice.setSource("xqttest.data7");
        choice.setMaxOccurrs(-1);
        MappingCriteriaNode crit = choice.addCriteriaNode(new MappingCriteriaNode("xqttest.data7.intKey < 10", false));
        MappingElement wrapper1 = crit.addChildElement(new MappingElement("wrapper"));
        MappingElement key = wrapper1.addChildElement(new MappingElement("key", "xqttest.data7.intKey"));
        MappingElement keys = key.addChildElement(new MappingElement("keys"));
        keys.setSource("xqttest.data8");
        keys.setMaxOccurrs(-1);
        keys.addChildElement(new MappingElement("nestedkey", "xqttest.data8.intKey"));
        MappingCriteriaNode wrapper2 = choice.addCriteriaNode(new MappingCriteriaNode(null, true));
        key = wrapper2.addChildElement(new MappingElement("key", "xqttest.data7.intKey"));
        keys = key.addChildElement(new MappingElement("keys"));
        keys.setSource("xqttest.data8");
        keys.setMaxOccurrs(-1);
        keys.addChildElement(new MappingElement("nestedkey", "xqttest.data8.intKey"));
        return doc;
    }

    private static MappingNode createChoiceDefect24651() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingChoiceNode choice = root.addChoiceNode(new MappingChoiceNode(false));
        choice.setSource("xqttest.data7");
        choice.setMaxOccurrs(-1);
        MappingCriteriaNode crit = choice.addCriteriaNode(new MappingCriteriaNode("xqttest.data7.intKey < 10", false));
        MappingElement wrapper1 = crit.addChildElement(new MappingElement("wrapper"));
        MappingElement key = wrapper1.addChildElement(new MappingElement("key", "xqttest.data7.intKey"));
        key.setExclude(true);
        return doc;
    }

    private static MappingNode createXQTPlanRecursive_5988() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("recursiveTest"));
        MappingElement src1 = root.addChildElement(new MappingElement("src"));
        src1.setSource("xqttest.data");
        MappingSequenceNode seq1 = new MappingSequenceNode();
        seq1.addChildElement(new MappingElement("key", "xqttest.data.intKey"));
        seq1.addChildElement(new MappingElement("data", "xqttest.data.intNum"));
        src1.addSequenceNode(seq1);
        MappingElement src2 = seq1.addChildElement(new MappingElement("srcNested"));
        src2.setSource("xqttest.data2");
        MappingSequenceNode seq2 = src2.addSequenceNode(new MappingSequenceNode());
        seq2.addChildElement(new MappingElement("key", "xqttest.data2.intKey"));
        seq2.addChildElement(new MappingElement("data", "xqttest.data2.intNum"));
        MappingElement recursive = seq2.addChildElement((MappingElement)new MappingRecursiveElement("srcNestedRecursive", "xqttest.data2"));
        recursive.setSource("xqttest.data3");
        MappingElement recursive2 = seq1.addChildElement((MappingElement)new MappingRecursiveElement("srcRecursive", "xqttest.data"));
        recursive2.setSource("xqttest.data4");
        return doc;
    }

    private static MappingNode createXQTPlanRecursive1a_5988() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("recursiveTest"));
        MappingElement src1 = root.addChildElement(new MappingElement("src"));
        src1.setSource("xqttest.data");
        MappingSequenceNode seq1 = new MappingSequenceNode();
        seq1.addChildElement(new MappingElement("key", "xqttest.data.intKey"));
        seq1.addChildElement(new MappingElement("data", "xqttest.data.intNum"));
        src1.addSequenceNode(seq1);
        MappingElement src2 = seq1.addChildElement(new MappingElement("srcNested"));
        src2.setSource("xqttest.data2");
        MappingSequenceNode seq2 = src2.addSequenceNode(new MappingSequenceNode());
        seq2.addChildElement(new MappingElement("key", "xqttest.data2.intKey"));
        seq2.addChildElement(new MappingElement("data", "xqttest.data2.intNum"));
        MappingElement recursive = seq2.addChildElement((MappingElement)new MappingRecursiveElement("srcRecursive", "xqttest.data2"));
        recursive.setSource("xqttest.data3");
        MappingElement recursive2 = seq1.addChildElement((MappingElement)new MappingRecursiveElement("srcRecursive", "xqttest.data"));
        recursive2.setSource("xqttest.data4");
        return doc;
    }

    private static MappingNode createXQTPlanRecursive3_5988() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("recursiveTest"));
        MappingElement src1 = root.addChildElement(new MappingElement("src"));
        src1.setSource("xqttest.data");
        MappingSequenceNode seq1 = src1.addSequenceNode(new MappingSequenceNode());
        seq1.addChildElement(new MappingElement("key", "xqttest.data.intKey"));
        seq1.addChildElement(new MappingElement("data", "xqttest.data.intNum"));
        MappingElement src2 = seq1.addChildElement(new MappingElement("srcNested"));
        src2.setSource("xqttest.data2");
        MappingSequenceNode seq2 = src2.addSequenceNode(new MappingSequenceNode());
        seq2.addChildElement(new MappingElement("key", "xqttest.data2.intKey"));
        seq2.addChildElement(new MappingElement("data", "xqttest.data2.intNum"));
        MappingElement nested = seq1.addChildElement((MappingElement)new MappingRecursiveElement("srcNested", "xqttest.data"));
        nested.setSource("xqttest.data4");
        return doc;
    }

    private static MappingNode createXQTPlanRecursiveSiblings() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("recursiveTest"));
        MappingElement src1 = root.addChildElement(new MappingElement("src"));
        src1.setSource("xqttest.data");
        MappingSequenceNode seq1 = src1.addSequenceNode(new MappingSequenceNode());
        seq1.addChildElement(new MappingElement("key", "xqttest.data.intKey"));
        seq1.addChildElement(new MappingElement("data", "xqttest.data.intNum"));
        MappingElement sibiling1 = seq1.addChildElement((MappingElement)new MappingRecursiveElement("srcSibling1", "xqttest.data"));
        sibiling1.setSource("xqttest.data2");
        sibiling1.setMaxOccurrs(-1);
        MappingElement sibiling2 = seq1.addChildElement((MappingElement)new MappingRecursiveElement("srcSibling2", "xqttest.data"));
        sibiling2.setSource("xqttest.data2");
        sibiling2.setMaxOccurrs(-1);
        return doc;
    }

    private static MappingNode createXMLPlanNested() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = new MappingElement("Catalogs");
        doc.addChildElement(root);
        MappingSequenceNode sequence = new MappingSequenceNode();
        MappingElement cats = sequence.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingSequenceNode sequence0 = items.addSequenceNode(new MappingSequenceNode());
        MappingElement item = sequence0.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        MappingSequenceNode sequence1 = item.addSequenceNode(new MappingSequenceNode());
        sequence1.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        sequence1.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        MappingElement nestedWrapper = new MappingElement("Suppliers");
        MappingSequenceNode sequence2 = nestedWrapper.addSequenceNode(new MappingSequenceNode());
        MappingElement supplier = sequence2.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        MappingSequenceNode sequence3 = supplier.addSequenceNode(new MappingSequenceNode());
        sequence3.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        sequence3.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        sequence1.addChildElement(nestedWrapper);
        root.addSequenceNode(sequence);
        return doc;
    }

    static MappingNode createXMLPlanNested(String queryGroup) {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = new MappingElement("Catalogs");
        doc.addChildElement(root);
        MappingSequenceNode sequence = new MappingSequenceNode();
        MappingElement cats = sequence.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingSequenceNode sequence0 = items.addSequenceNode(new MappingSequenceNode());
        MappingElement item = sequence0.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        MappingSequenceNode sequence1 = item.addSequenceNode(new MappingSequenceNode());
        sequence1.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        sequence1.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        MappingElement nestedWrapper = new MappingElement("Suppliers");
        MappingSequenceNode sequence2 = nestedWrapper.addSequenceNode(new MappingSequenceNode());
        MappingElement supplier = sequence2.addChildElement(new MappingElement("Supplier"));
        supplier.setSource(queryGroup);
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", queryGroup + ".supplierNum"));
        MappingSequenceNode sequence3 = supplier.addSequenceNode(new MappingSequenceNode());
        sequence3.addChildElement(new MappingElement("Name", queryGroup + ".supplierName"));
        sequence3.addChildElement(new MappingElement("Zip", queryGroup + ".supplierZipCode"));
        sequence1.addChildElement(nestedWrapper);
        root.addSequenceNode(sequence);
        return doc;
    }

    private static MappingNode createXMLPlanCorrelatedSubqueryTransform() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingSequenceNode sequence = new MappingSequenceNode();
        MappingElement cats = sequence.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingSequenceNode sequence0 = items.addSequenceNode(new MappingSequenceNode());
        MappingElement item = sequence0.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.itemsWithNumSuppliers");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.itemsWithNumSuppliers.itemNum"));
        MappingSequenceNode sequence1 = item.addSequenceNode(new MappingSequenceNode());
        sequence1.addChildElement(new MappingElement("Name", "xmltest.group.itemsWithNumSuppliers.itemName"));
        sequence1.addChildElement(new MappingElement("Quantity", "xmltest.group.itemsWithNumSuppliers.itemQuantity"));
        sequence1.addChildElement(new MappingElement("numSuppliers", "xmltest.group.itemsWithNumSuppliers.numSuppliers"));
        root.addSequenceNode(sequence);
        return doc;
    }

    private static MappingNode createXMLPlan_9893() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Root"));
        MappingSequenceNode seq = root.addSequenceNode(new MappingSequenceNode());
        MappingElement node = seq.addChildElement(new MappingElement("ItemName", "xmltest.group.items.itemName"));
        node.setSource("xmltest.group.items");
        node.setMaxOccurrs(-1);
        node.setMaxOccurrs(MappingNodeConstants.CARDINALITY_UNBOUNDED.intValue());
        return doc;
    }

    private static Object createXMLPlan_defect8373() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.items8373");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.items8373.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.items8373.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.items8373.itemQuantity"));
        return doc;
    }

    private static Object createXMLPlan_defect8373a() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.items8373a");
        item.setMaxOccurrs(-1);
        item.setStagingTables(Arrays.asList("xmltest.items8373"));
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.items8373a.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.items8373a.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.items8373a.itemQuantity"));
        return doc;
    }

    private static Object createXMLPlan_defect8373b() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.items8373b");
        item.setMaxOccurrs(-1);
        item.setStagingTables(Arrays.asList("xmltest.group.items"));
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.items8373b.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.items8373b.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.items8373b.itemQuantity"));
        return doc;
    }

    private static MappingNode createXMLPlanNested2() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        MappingElement nestedWrapper = item.addChildElement(new MappingElement("Suppliers"));
        MappingElement supplier = nestedWrapper.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        supplier.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        supplier.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        MappingElement ordersWrapper = supplier.addChildElement(new MappingElement("Orders"));
        MappingElement order = ordersWrapper.addChildElement(new MappingElement("Order"));
        order.setSource("xmltest.orders");
        order.setMaxOccurrs(-1);
        order.addAttribute(new MappingAttribute("OrderID", "xmltest.orders.orderNum"));
        order.addChildElement(new MappingElement("OrderDate", "xmltest.orders.orderDate"));
        order.addChildElement(new MappingElement("OrderQuantity", "xmltest.orders.orderQty"));
        order.addChildElement(new MappingElement("OrderStatus", "xmltest.orders.orderStatus")).setMinOccurrs(0);
        return doc;
    }

    private MappingNode createXMLPlanNested2c() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        MappingElement nestedWrapper = item.addChildElement(new MappingElement("Suppliers"));
        MappingElement supplier = nestedWrapper.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        supplier.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        supplier.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        MappingElement ordersWrapper = item.addChildElement(new MappingElement("Orders"));
        MappingElement order = ordersWrapper.addChildElement(new MappingElement("Order"));
        order.setSource("xmltest.orders");
        order.setMaxOccurrs(-1);
        order.addAttribute(new MappingAttribute("OrderID", "xmltest.orders.orderNum"));
        order.addChildElement(new MappingElement("Name", "xmltest.orders.orderName"));
        order.addChildElement(new MappingElement("Zip", "xmltest.orders.orderZipCode"));
        return doc;
    }

    private static MappingNode createXMLPlanNested2a() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        root.setStagingTables(Arrays.asList("tempGroup.orders", "tempGroup.orders2"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        MappingElement nestedWrapper = item.addChildElement(new MappingElement("Suppliers"));
        MappingElement supplier = nestedWrapper.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        supplier.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        supplier.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        MappingElement ordersWrapper = supplier.addChildElement(new MappingElement("Orders"));
        MappingElement order = ordersWrapper.addChildElement(new MappingElement("Order"));
        order.setSource("xmltest.ordersA");
        order.setMaxOccurrs(-1);
        order.addAttribute(new MappingAttribute("OrderID", "xmltest.ordersA.orderNum"));
        order.addChildElement(new MappingElement("OrderDate", "xmltest.ordersA.orderDate"));
        order.addChildElement(new MappingElement("OrderQuantity", "xmltest.ordersA.orderQty"));
        order.addChildElement(new MappingElement("OrderStatus", "xmltest.ordersA.orderStatus")).setMinOccurrs(0);
        return doc;
    }

    private static MappingNode createXMLPlanNested2b() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        root.setStagingTables(Arrays.asList("tempGroup.orders", "tempGroup.orders2"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        MappingElement nestedWrapper = item.addChildElement(new MappingElement("Suppliers"));
        MappingElement supplier = nestedWrapper.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        supplier.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        supplier.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        MappingElement ordersWrapper = supplier.addChildElement(new MappingElement("Orders"));
        MappingElement order = ordersWrapper.addChildElement(new MappingElement("Order"));
        order.setSource("xmltest.ordersB");
        order.setStagingTables(Arrays.asList("tempGroup.orders3B"));
        order.addAttribute(new MappingAttribute("OrderID", "xmltest.ordersB.orderNum"));
        order.addChildElement(new MappingElement("OrderDate", "xmltest.ordersB.orderDate"));
        order.addChildElement(new MappingElement("OrderQuantity", "xmltest.ordersB.orderQty"));
        order.addChildElement(new MappingElement("OrderStatus", "xmltest.ordersB.orderStatus")).setMinOccurrs(0);
        return doc;
    }

    public static MappingDocument createXMLPlanNestedWithChoice() {
        MappingCriteriaNode critNode = new MappingCriteriaNode();
        MappingElement defaltElement = critNode.addChildElement(new MappingElement("OtherOrder"));
        defaltElement.addAttribute(new MappingAttribute("OrderID", "xmltest.orders.orderNum"));
        return TestXMLProcessor.baseXMLPlanNestedWithLookupChoice("xmltest.orders.orderStatus = 'processing'", critNode);
    }

    private static MappingNode createXMLPlanNestedWithChoiceFor5266() {
        MappingCriteriaNode critNode = new MappingCriteriaNode("xmltest.orders.orderStatus = 'shipped'", true);
        return TestXMLProcessor.baseXMLPlanNestedWithLookupChoice("xmltest.orders.orderStatus = 'processing'", critNode);
    }

    private static MappingNode createXMLPlanNestedWithLookupChoice() {
        MappingCriteriaNode critNode = new MappingCriteriaNode();
        MappingElement defaltElement = critNode.addChildElement(new MappingElement("OtherOrder"));
        defaltElement.addAttribute(new MappingAttribute("OrderID", "xmltest.orders.orderNum"));
        return TestXMLProcessor.baseXMLPlanNestedWithLookupChoice("lookup('stock.items', 'itemNum', 'itemName', xmltest.orders.orderStatus) = 'processing'", critNode);
    }

    private static MappingDocument baseXMLPlanNestedWithLookupChoice(String criteria, MappingCriteriaNode defaultNode) {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingSequenceNode seq1 = root.addSequenceNode(new MappingSequenceNode());
        MappingElement cats = seq1.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cats.addChildElement(new MappingElement("Items"));
        MappingSequenceNode seq2 = items.addSequenceNode(new MappingSequenceNode());
        MappingElement item = seq2.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        MappingSequenceNode seq3 = item.addSequenceNode(new MappingSequenceNode());
        seq3.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        seq3.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        MappingElement suppliers = seq3.addChildElement(new MappingElement("Suppliers"));
        MappingSequenceNode seq4 = suppliers.addSequenceNode(new MappingSequenceNode());
        MappingElement supplier = seq4.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        MappingSequenceNode seq5 = supplier.addSequenceNode(new MappingSequenceNode());
        seq5.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        seq5.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        MappingElement ordersWrapper = seq5.addChildElement(new MappingElement("ProcessingOrders"));
        MappingChoiceNode choice = ordersWrapper.addChoiceNode(new MappingChoiceNode(false));
        choice.setSource("xmltest.orders");
        choice.setMaxOccurrs(-1);
        MappingCriteriaNode crit = choice.addCriteriaNode(new MappingCriteriaNode(criteria, false));
        MappingElement order = crit.addChildElement(new MappingElement("Order"));
        order.addAttribute(new MappingAttribute("OrderID", "xmltest.orders.orderNum"));
        MappingSequenceNode seq6 = order.addSequenceNode(new MappingSequenceNode());
        seq6.addChildElement(new MappingElement("OrderDate", "xmltest.orders.orderDate"));
        seq6.addChildElement(new MappingElement("OrderQuantity", "xmltest.orders.orderQty"));
        choice.addCriteriaNode(defaultNode);
        return doc;
    }

    private static MappingNode createTestAttributePlan() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("FixedValueTest"));
        MappingSequenceNode seq = root.addSequenceNode(new MappingSequenceNode());
        MappingElement wrapper = seq.addChildElement(new MappingElement("wrapper"));
        wrapper.setSource("xmltest.group.items");
        wrapper.setMaxOccurrs(-1);
        MappingAttribute att = new MappingAttribute("fixedAttr");
        att.setValue("fixed attribute");
        wrapper.addAttribute(att);
        MappingSequenceNode seq1 = wrapper.addSequenceNode(new MappingSequenceNode());
        seq1.addChildElement(new MappingElement("key", "xmltest.group.items.itemNum"));
        seq1.addChildElement(new MappingElement("fixed")).setValue("fixed value");
        return doc;
    }

    private static Object createUpdateTestDoc() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("UpdateTest"));
        MappingSequenceNode seq = root.addSequenceNode(new MappingSequenceNode());
        seq.setSource("xmltest.updateTest");
        seq.addChildElement(new MappingElement("data", "xmltest.updateTest.rowCount"));
        return doc;
    }

    private static MappingNode createXMLPlanWithComment() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Root"));
        root.addCommentNode(new MappingCommentNode("Comment1"));
        MappingElement node = root.addChildElement(new MappingElement("Something"));
        node.addCommentNode(new MappingCommentNode("Comment2"));
        return doc;
    }

    public static MappingDocument createXMLMappingBoundingNode() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMinOccurrs(1);
        item.setMaxOccurrs(2);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName").setNillable(true));
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        return doc;
    }

    public static MappingDocument createXMLMappingNode(boolean format) {
        MappingDocument doc = new MappingDocument(format);
        doc.addChildElement(TestXMLProcessor.createXMLPlan1Unformatted(false, 1));
        return doc;
    }

    private static MappingNode createXMLPlan2(boolean format, boolean testNillable, int cardinality) {
        MappingDocument doc = new MappingDocument(format);
        doc.addChildElement(TestXMLProcessor.createXMLPlan1Unformatted(testNillable, cardinality));
        return doc;
    }

    private static MappingNode createXMLPlanSOAP() {
        Namespace namespace = new Namespace("ORG", "http://www.mm.org/dummy");
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("TaxReports", namespace));
        root.setNamespaces(new Namespace[]{namespace});
        MappingElement report = root.addChildElement(new MappingElement("TaxReport", namespace));
        report.setNamespaces(new Namespace[]{namespace});
        Namespace xsiNamespace = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Namespace soapNamespace = new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        MappingElement taxIds = report.addChildElement(new MappingElement("ArrayOfTaxID", namespace));
        taxIds.setMinOccurrs(0);
        taxIds.setNamespaces(new Namespace[]{xsiNamespace, soapNamespace});
        MappingAttribute xsiType = new MappingAttribute("type", xsiNamespace);
        xsiType.setValue(namespace.getPrefix() + ":ArrayOfTaxIDType");
        xsiType.setOptional(true);
        taxIds.addAttribute(xsiType);
        MappingAttribute arrayType = new MappingAttribute("arrayType", soapNamespace);
        arrayType.setValue(namespace.getPrefix() + ":TaxIDType[]");
        arrayType.setOptional(true);
        taxIds.addAttribute(arrayType);
        MappingElement taxId = taxIds.addChildElement(new MappingElement("TaxID", namespace));
        taxId.setSource("xmltest.group.TaxIDs");
        taxId.setMaxOccurrs(-1);
        MappingAttribute xsiType2 = new MappingAttribute("type", xsiNamespace);
        xsiType2.setValue(namespace.getPrefix() + ":TaxIDType");
        xsiType2.setOptional(true);
        taxId.addAttribute(xsiType2);
        taxId.addChildElement(new MappingElement("ID", "xmltest.group.TaxIDs.ID"));
        return doc;
    }

    private static MappingElement createXMLPlan1Unformatted(boolean testNillable, int cardinality) {
        MappingElement root = new MappingElement("Catalogs");
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        items.setNillable(testNillable);
        items.setMinOccurrs(cardinality);
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName").setNillable(true));
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        return root;
    }

    private static MappingNode createXMLPlanDefect13617() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.setMinOccurrs(0);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setMinOccurrs(0);
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity")).setMinOccurrs(0);
        return doc;
    }

    private static MappingNode createXMLPlan2(int numChoices, int numDefaultChoice, boolean exception_on_Default) {
        MappingCriteriaNode item;
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        MappingChoiceNode choice = items.addChoiceNode(new MappingChoiceNode(exception_on_Default));
        choice.setSource("xmltest.group.items");
        choice.setMaxOccurrs(-1);
        if (numChoices >= 1) {
            item = TestXMLProcessor.getChoiceChild("Item", "xmltest.group.items.itemName='Lamp'", numDefaultChoice == 1);
            choice.addCriteriaNode(item);
        }
        if (numChoices >= 2) {
            item = TestXMLProcessor.getChoiceChild("Item2", "xmltest.group.items.itemName='Screwdriver'", numDefaultChoice == 2);
            choice.addCriteriaNode(item);
        }
        if (numChoices >= 3) {
            item = TestXMLProcessor.getChoiceChild("Item3", "xmltest.group.items.itemName='Goat'", numDefaultChoice == 3);
            choice.addCriteriaNode(item);
        }
        if (numDefaultChoice > numChoices) {
            item = TestXMLProcessor.getChoiceChild("ItemDefault", null, true);
            choice.addCriteriaNode(item);
        }
        return doc;
    }

    private static MappingCriteriaNode getChoiceChild(String name, String criteria, boolean defalt) {
        MappingCriteriaNode crit = new MappingCriteriaNode(criteria, defalt);
        MappingElement item = crit.addChildElement(new MappingElement(name));
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNillable(true);
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        return crit;
    }

    private static MappingDocument createXMLPlanWithDefaults() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNillable(true);
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity")).setDefaultValue("1");
        return doc;
    }

    private static MappingNode createXMLPlanUltraAdvanced() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        boolean exceptionOnDefault = false;
        MappingChoiceNode choice = items.addChoiceNode(new MappingChoiceNode(exceptionOnDefault));
        choice.setSource("xmltest.group.items");
        choice.setMaxOccurrs(-1);
        MappingCriteriaNode crit1 = choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'okay'", false));
        MappingElement item = crit1.addChildElement(new MappingElement("Item"));
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNillable(true);
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity")).setDefaultValue("0");
        MappingCriteriaNode crit2 = choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'discontinued'", false));
        MappingElement discontinued = crit2.addChildElement(new MappingElement("DiscontinuedItem"));
        discontinued.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        discontinued.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNillable(true);
        discontinued.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity")).setDefaultValue("0");
        MappingCriteriaNode crit3 = choice.addCriteriaNode(new MappingCriteriaNode());
        MappingElement unknown = crit3.addChildElement(new MappingElement("StatusUnknown"));
        unknown.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        unknown.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNillable(true);
        unknown.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity")).setDefaultValue("0");
        choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'something'", false)).setExclude(true);
        choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'something'", false)).setExclude(true);
        return doc;
    }

    private static MappingNode createXMLPlanUltraAdvancedExceptionOnDefault() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        boolean exceptionOnDefault = true;
        MappingChoiceNode choice = items.addChoiceNode(new MappingChoiceNode(exceptionOnDefault));
        choice.setSource("xmltest.group.items");
        choice.setMaxOccurrs(-1);
        MappingCriteriaNode crit1 = choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'okay'", false));
        MappingElement item = crit1.addChildElement(new MappingElement("Item"));
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNillable(true);
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity")).setDefaultValue("0");
        MappingCriteriaNode crit2 = choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'discontinued'", false));
        MappingElement discontinued = crit2.addChildElement(new MappingElement("DiscontinuedItem"));
        discontinued.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        discontinued.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNillable(true);
        discontinued.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity")).setDefaultValue("0");
        choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'discontinued'", false)).setExclude(true);
        return doc;
    }

    private static MappingNode createXMLPlanAdvanced() {
        MappingDocument doc = TestXMLProcessor.createXMLPlanWithDefaults();
        MappingElement root = (MappingElement)doc.getRootNode();
        Namespace nameSpaceOne = new Namespace("duh", "http://www.duh.org/duh");
        Namespace nameSpaceTwo = new Namespace("duh2", "http://www.duh2.org/duh2");
        Namespace nameSpaceThree = new Namespace("duh", "http://www.duh.org/duh/duh");
        Namespace nameSpaceFour = new Namespace("", "");
        Namespace nameSpaceFive = new Namespace("", "http://www.default.org/default");
        MappingElement fakeChildOfRoot = new MappingElement("Fake", nameSpaceOne);
        fakeChildOfRoot.setValue("fixed constant value");
        fakeChildOfRoot.addNamespace(nameSpaceOne);
        fakeChildOfRoot.addNamespace(nameSpaceTwo);
        fakeChildOfRoot.addNamespace(nameSpaceFive);
        root.addChildElement(fakeChildOfRoot);
        MappingElement fakeChild2 = fakeChildOfRoot.addChildElement(new MappingElement("FakeChild2", nameSpaceOne));
        MappingElement fakeChild2a = fakeChild2.addChildElement(new MappingElement("FakeChild2a"));
        fakeChild2a.setValue("another fixed constant value");
        MappingElement fakeChild3 = fakeChildOfRoot.addChildElement(new MappingElement("FakeChild3"));
        fakeChild3.addNamespace(nameSpaceThree);
        fakeChild3.addNamespace(nameSpaceFour);
        MappingAttribute fakeAtt = new MappingAttribute("FakeAtt", nameSpaceOne);
        fakeAtt.setValue("fixed att value");
        fakeChild3.addAttribute(fakeAtt);
        return doc;
    }

    private static MappingNode createXMLPlanMultipleDocs() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Item"));
        root.setSource("xmltest.group.items");
        root.setMaxOccurrs(-1);
        root.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        MappingSequenceNode sequence1 = root.addSequenceNode(new MappingSequenceNode());
        sequence1.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        sequence1.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        MappingElement nestedWrapper = sequence1.addChildElement(new MappingElement("Suppliers"));
        MappingSequenceNode sequence2 = nestedWrapper.addSequenceNode(new MappingSequenceNode());
        MappingElement supplier = sequence2.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        MappingSequenceNode sequence3 = supplier.addSequenceNode(new MappingSequenceNode());
        sequence3.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        sequence3.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        return doc;
    }

    private static MappingNode createXMLPlanRecursive(boolean useRecursiveCriteria, int recursionLimit, boolean exceptionOnLimit) {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("OrgHierarchy"));
        MappingElement ceo = root.addChildElement(new MappingElement("Employee"));
        ceo.setSource("xmltest.employees");
        ceo.setMinOccurrs(0);
        ceo.setMaxOccurrs(-1);
        ceo.addAttribute(new MappingAttribute("ID", "xmltest.employees.employeeNum"));
        MappingSequenceNode sequence = ceo.addSequenceNode(new MappingSequenceNode());
        sequence.addChildElement(new MappingElement("FirstName", "xmltest.employees.firstName"));
        sequence.addChildElement(new MappingElement("LastName", "xmltest.employees.lastName"));
        MappingElement subordinates = sequence.addChildElement(new MappingElement("Subordinates"));
        MappingRecursiveElement employee = (MappingRecursiveElement)subordinates.addChildElement((MappingElement)new MappingRecursiveElement("Employee", "xmltest.employees"));
        employee.setSource("xmltest.employeesRecursive");
        employee.setMinOccurrs(0);
        employee.setMaxOccurrs(-1);
        if (useRecursiveCriteria) {
            employee.setCriteria("xmltest.employees.employeeNum = '04'");
        }
        employee.setRecursionLimit(recursionLimit > 0 ? recursionLimit : 10, exceptionOnLimit);
        return doc;
    }

    private static MappingNode createXMLPlanRecursiveA(boolean useRecursiveCriteria, int recursionLimit, boolean exceptionOnLimit) {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("OrgHierarchy"));
        MappingSequenceNode seq0 = root.addSequenceNode(new MappingSequenceNode());
        seq0.setSource("xmltest.employees");
        seq0.setMinOccurrs(0);
        seq0.setMaxOccurrs(-1);
        MappingElement ceo = seq0.addChildElement(new MappingElement("Employee"));
        ceo.addAttribute(new MappingAttribute("ID", "xmltest.employees.employeeNum"));
        MappingSequenceNode seq = ceo.addSequenceNode(new MappingSequenceNode());
        seq.addChildElement(new MappingElement("FirstName", "xmltest.employees.firstName"));
        seq.addChildElement(new MappingElement("LastName", "xmltest.employees.lastName"));
        MappingElement subordinates = seq.addChildElement(new MappingElement("Subordinates"));
        MappingRecursiveElement employee = (MappingRecursiveElement)subordinates.addChildElement((MappingElement)new MappingRecursiveElement("Subordinate", "xmltest.employees"));
        employee.setSource("xmltest.employeesRecursive");
        employee.setMinOccurrs(0);
        employee.setMaxOccurrs(-1);
        if (useRecursiveCriteria) {
            employee.setCriteria("xmltest.employees.employeeNum = '04'");
        }
        employee.setRecursionLimit(recursionLimit > 0 ? recursionLimit : 10, exceptionOnLimit);
        return doc;
    }

    private static MappingNode createXMLPlanRecursiveStaging(boolean useRecursiveCriteria, int recursionLimit, boolean exceptionOnLimit) {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("OrgHierarchy"));
        root.setStagingTables(Arrays.asList("xmltest.doc19temp"));
        MappingElement ceo = root.addChildElement(new MappingElement("Employee"));
        ceo.setSource("xmltest.employeesDoc19");
        ceo.setMinOccurrs(0);
        ceo.setMaxOccurrs(-1);
        ceo.addAttribute(new MappingAttribute("ID", "xmltest.employeesDoc19.employeeNum"));
        MappingSequenceNode seq = ceo.addSequenceNode(new MappingSequenceNode());
        seq.addChildElement(new MappingElement("FirstName", "xmltest.employeesDoc19.firstName"));
        seq.addChildElement(new MappingElement("LastName", "xmltest.employeesDoc19.lastName"));
        MappingElement subordinates = seq.addChildElement(new MappingElement("Subordinates"));
        MappingRecursiveElement employee = (MappingRecursiveElement)subordinates.addChildElement((MappingElement)new MappingRecursiveElement("Employee", "xmltest.employeesDoc19"));
        employee.setSource("xmltest.employeesRecursiveDoc19");
        employee.setMinOccurrs(0);
        employee.setMaxOccurrs(-1);
        if (useRecursiveCriteria) {
            employee.setCriteria("xmltest.employeesDoc19.employeeNum = '04'");
        }
        employee.setRecursionLimit(recursionLimit > 0 ? recursionLimit : 10, exceptionOnLimit);
        return doc;
    }

    private static MappingNode createXMLPlanRecursive2(boolean useRecursiveCriteria, int recursionLimit, boolean exceptionOnLimit) {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Employees"));
        MappingElement ceo = root.addChildElement(new MappingElement("Employee"));
        ceo.setSource("xmltest.employees2");
        ceo.setMinOccurrs(0);
        ceo.setMaxOccurrs(-1);
        ceo.addAttribute(new MappingAttribute("ID", "xmltest.employees2.employeeNum"));
        MappingSequenceNode seq = ceo.addSequenceNode(new MappingSequenceNode());
        seq.addChildElement(new MappingElement("FirstName", "xmltest.employees2.firstName"));
        seq.addChildElement(new MappingElement("LastName", "xmltest.employees2.lastName"));
        MappingRecursiveElement employee = (MappingRecursiveElement)seq.addChildElement((MappingElement)new MappingRecursiveElement("Supervisor", "xmltest.employees2"));
        employee.setSource("xmltest.employees2Recursive");
        employee.setMinOccurrs(0);
        employee.setMaxOccurrs(-1);
        if (useRecursiveCriteria) {
            employee.setCriteria("xmltest.employees2.employeeNum = '04'");
        }
        employee.setRecursionLimit(recursionLimit > 0 ? recursionLimit : 10, exceptionOnLimit);
        return doc;
    }

    private static MappingNode createXMLPlan_defect8917() {
        Namespace namespace1 = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        root.addNamespace(namespace1);
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNillable(true);
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        cat = root.addChildElement(new MappingElement("OptionalCatalog"));
        cat.setMinOccurrs(0);
        items = cat.addChildElement(new MappingElement("Items"));
        item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNillable(true);
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        cat = root.addChildElement(new MappingElement("OptionalCatalog2"));
        cat.setMinOccurrs(0);
        items = cat.addChildElement(new MappingElement("Items"));
        item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNillable(true);
        cat = root.addChildElement(new MappingElement("OptionalCatalog3"));
        cat.setMinOccurrs(0);
        items = cat.addChildElement(new MappingElement("Items"));
        item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        cat = root.addChildElement(new MappingElement("Catalog4"));
        items = cat.addChildElement(new MappingElement("OptionalItems"));
        items.setMinOccurrs(0);
        item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        cat = root.addChildElement(new MappingElement("Catalog5"));
        items = cat.addChildElement(new MappingElement("OptionalItems"));
        items.setMinOccurrs(0);
        item = items.addChildElement(new MappingElement("Item"));
        item.addChildElement(new MappingElement("FixedName")).setValue("Nugent");
        cat = root.addChildElement(new MappingElement("Catalog6"));
        items = cat.addChildElement(new MappingElement("OptionalItems"));
        items.setMinOccurrs(0);
        item = items.addChildElement(new MappingElement("Item"));
        item.addChildElement(new MappingElement("EmptyName"));
        return doc;
    }

    private static MappingNode createXMLPlan_defect9446() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("XXXXX", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("XXXXX", "xmltest.group.items.itemName"));
        item.addChildElement(new MappingElement("XXXXX", "xmltest.group.items.itemQuantity"));
        return doc;
    }

    private static MappingNode createXMLPlan_defect_9530() {
        Namespace namespace = new Namespace("mm", "http://www.duh.org/duh");
        Namespace namespace2 = new Namespace("mm", "http://www.duh2.org/duh2");
        Namespace namespace3 = new Namespace("mm2", "http://www.duh3.org/duh3");
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs", namespace));
        root.addNamespace(namespace);
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        MappingElement item = items.addChildElement(new MappingElement("Item", namespace));
        item.setSource("xmltest.group.items");
        item.setMaxOccurrs(-1);
        item.addNamespace(namespace2);
        item.addNamespace(namespace3);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity"));
        return doc;
    }

    private static MappingNode createGroupDoc() {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("group"));
        root.setSource("xqttest.group");
        root.setMinOccurrs(0);
        root.setMaxOccurrs(-1);
        MappingAttribute attr = new MappingAttribute("pseudoID", "xqttest.group.ID");
        attr.setExclude(true);
        root.addAttribute(attr);
        MappingSequenceNode sequence = root.addSequenceNode(new MappingSequenceNode());
        sequence.addChildElement(new MappingElement("ID", "xqttest.group.ID"));
        sequence.addChildElement(new MappingElement("code", "xqttest.group.Code"));
        MappingElement supervisor = sequence.addChildElement(new MappingElement("supervisor"));
        supervisor.setSource("xqttest.supervisor");
        supervisor.setMinOccurrs(0);
        supervisor.setMaxOccurrs(-1);
        MappingSequenceNode sequence1 = supervisor.addSequenceNode(new MappingSequenceNode());
        sequence1.addChildElement(new MappingElement("ID", "xqttest.supervisor.ID"));
        sequence1.addChildElement(new MappingElement("code", "xqttest.supervisor.Code"));
        MappingRecursiveElement group1 = (MappingRecursiveElement)sequence1.addChildElement((MappingElement)new MappingRecursiveElement("group", "xqttest.group"));
        group1.setSource("xqttest.group1");
        group1.setMinOccurrs(0);
        group1.setMaxOccurrs(-1);
        return doc;
    }

    private static List createElements(List elementIDs) {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        for (int i = 0; i < elementIDs.size(); ++i) {
            FakeMetadataObject elementID = (FakeMetadataObject)elementIDs.get(i);
            ElementSymbol element = new ElementSymbol(elementID.getName());
            elements.add(element);
        }
        return elements;
    }

    public static FakeDataManager exampleDataManager(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", "Lamp", new Integer(5), "okay"), Arrays.asList("002", "Screwdriver", new Integer(100), "okay"), Arrays.asList("003", "Goat", new Integer(4), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    public static FakeDataManager exampleDataManager15117(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", " Lamp ", new Integer(5), "okay"), Arrays.asList("002", "  Screw  driver  ", new Integer(100), "okay"), Arrays.asList("003", " Goat ", new Integer(4), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    public static FakeDataManager exampleDataManager15117a(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", "\t \n\r", new Integer(5), "okay"), Arrays.asList("002", "  >Screw< \n driver  &", new Integer(100), "okay"), Arrays.asList("003", " >>\rGoat ", new Integer(4), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    public static FakeDataManager exampleDataManager14905(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList(" ", " ", new Integer(5), "okay"), Arrays.asList("  ", "  ", new Integer(100), "okay"), Arrays.asList(" ", " ", new Integer(4), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    public static FakeDataManager exampleDataManager13617(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", "Lamp", new Integer(5), "okay"), Arrays.asList("002", "Screwdriver", new Integer(100), "okay"), Arrays.asList("003", "Goat", new Integer(4), "okay"), Arrays.asList("004", null, new Integer(1), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    public static FakeDataManager exampleDataManagerNested(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            FakeMetadataObject groupID2 = (FakeMetadataObject)metadata.getGroupID("stock.suppliers");
            FakeMetadataObject groupID3 = (FakeMetadataObject)metadata.getGroupID("stock.orders");
            FakeMetadataObject groupID1_2join = (FakeMetadataObject)metadata.getGroupID("stock.item_supplier");
            FakeMetadataObject groupEmployees = (FakeMetadataObject)metadata.getGroupID("stock.employees");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupID2);
            List supplierElementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupID3);
            List ordersElementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupID1_2join);
            List itemSupplierElementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupEmployees);
            List employeeSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", "Lamp", new Integer(5), "okay"), Arrays.asList("002", "Screwdriver", new Integer(100), "okay"), Arrays.asList("003", "Goat", new Integer(4), "okay")});
            dataMgr.registerTuples(groupID1_2join, itemSupplierElementSymbols, new List[]{Arrays.asList("001", "51"), Arrays.asList("001", "52"), Arrays.asList("001", "53"), Arrays.asList("001", "56"), Arrays.asList("002", "54"), Arrays.asList("002", "55"), Arrays.asList("002", "56"), Arrays.asList("003", "56")});
            dataMgr.registerTuples(groupID2, supplierElementSymbols, new List[]{Arrays.asList("51", "Chucky", "11111"), Arrays.asList("52", "Biff's Stuff", "22222"), Arrays.asList("53", "AAAA", "33333"), Arrays.asList("54", "Nugent Co.", "44444"), Arrays.asList("55", "Zeta", "55555"), Arrays.asList("56", "Microsoft", "66666")});
            dataMgr.registerTuples(groupID3, ordersElementSymbols, new List[]{Arrays.asList("1", "002", "54", "Nugent Co.", "10/23/01", new Integer(5), "complete"), Arrays.asList("2", "001", "52", "Biff's Stuff", "12/31/01", new Integer(87), "complete"), Arrays.asList("3", "003", "56", "Microsoft", "02/31/02", new Integer(12), "complete"), Arrays.asList("4", "003", "56", "Microsoft", "05/31/02", new Integer(9), "processing"), Arrays.asList("5", "002", "56", "Microsoft", "06/01/02", new Integer(87), "complete"), Arrays.asList("6", "002", "56", "Microsoft", "07/01/02", new Integer(1), null), Arrays.asList("7", "002", "56", "bad data, shouldn't see", "07/01/02", new Integer(1), "complete")});
            dataMgr.registerTuples(groupEmployees, employeeSymbols, new List[]{Arrays.asList("01", "1", null, "Ted", "Nugent"), Arrays.asList("02", "1", "01", "Bill", "Squier"), Arrays.asList("03", "1", "01", "John", "Smith"), Arrays.asList("04", "1", "02", "Leland", "Sklar"), Arrays.asList("05", "1", "03", "Kevin", "Moore"), Arrays.asList("06", "1", "04", "John", "Zorn"), Arrays.asList("07", "2", null, "Geoff", "Tate"), Arrays.asList("08", "2", "07", "Les", "Claypool"), Arrays.asList("09", "2", "08", "Meat", "Loaf"), Arrays.asList("10", "2", "08", "Keith", "Sweat"), Arrays.asList("11", "1", "06", "Mike", "Patton"), Arrays.asList("12", "1", "06", "Devin", "Townsend"), Arrays.asList("13", "1", "11", "Puffy", "Bordin")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    private FakeDataManager exampleDataManagerNestedWithSibling(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID1 = (FakeMetadataObject)metadata.getGroupID("stock.items");
            FakeMetadataObject groupID2 = (FakeMetadataObject)metadata.getGroupID("stock.suppliers");
            FakeMetadataObject groupID3 = (FakeMetadataObject)metadata.getGroupID("stock.orders");
            FakeMetadataObject groupID1_2join = (FakeMetadataObject)metadata.getGroupID("stock.item_supplier");
            FakeMetadataObject groupID1_3join = (FakeMetadataObject)metadata.getGroupID("stock.item_order");
            List elementIDs = metadata.getElementIDsInGroupID(groupID1);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupID2);
            List supplierElementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupID3);
            List ordersElementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupID1_2join);
            List itemSupplierElementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupID1_3join);
            List itemOrderElementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID1, elementSymbols, new List[]{Arrays.asList("001", "Lamp", new Integer(5), "okay"), Arrays.asList("002", "Screwdriver", new Integer(100), "okay"), Arrays.asList("003", "Goat", new Integer(4), "okay")});
            dataMgr.registerTuples(groupID1_2join, itemSupplierElementSymbols, new List[]{Arrays.asList("001", "51"), Arrays.asList("001", "52"), Arrays.asList("001", "53"), Arrays.asList("001", "56"), Arrays.asList("002", "54"), Arrays.asList("002", "55"), Arrays.asList("002", "56"), Arrays.asList("003", "56")});
            dataMgr.registerTuples(groupID2, supplierElementSymbols, new List[]{Arrays.asList("51", "Chucky", "11111"), Arrays.asList("52", "Biff's Stuff", "22222"), Arrays.asList("53", "AAAA", "33333"), Arrays.asList("54", "Nugent Co.", "44444"), Arrays.asList("55", "Zeta", "55555"), Arrays.asList("56", "Microsoft", "66666")});
            dataMgr.registerTuples(groupID3, ordersElementSymbols, new List[]{Arrays.asList("1", "KMart", "12345"), Arrays.asList("2", "Sun", "94040"), Arrays.asList("3", "Cisco", "94041"), Arrays.asList("4", "Doc", "94042"), Arrays.asList("5", "Excite", "21098"), Arrays.asList("6", "Yahoo", "94043"), Arrays.asList("7", "Inktomi", "94044")});
            dataMgr.registerTuples(groupID1_3join, itemOrderElementSymbols, new List[]{Arrays.asList("001", "1"), Arrays.asList("001", "2"), Arrays.asList("001", "3"), Arrays.asList("001", "4"), Arrays.asList("002", "5"), Arrays.asList("002", "6"), Arrays.asList("003", "7")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    private FakeDataManager exampleDataManagerWithNulls(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", null, new Integer(5), "okay"), Arrays.asList("002", "Screwdriver", null, "okay"), Arrays.asList("003", "Goat", new Integer(4), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    public static FakeDataManager exampleDataManagerForSoap1(FakeMetadataFacade metadata, boolean makeEmpty) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("taxReport.TaxIDs");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            List[] tuples = null;
            tuples = makeEmpty ? new List[]{} : new List[]{Arrays.asList("1"), Arrays.asList("2"), Arrays.asList("3")};
            dataMgr.registerTuples(groupID, elementSymbols, tuples);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    private FakeDataManager exampleDataManager_8917(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", null, new Integer(5), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    private FakeDataManager exampleDataManager_8917a(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", " ", new Integer(5), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    private FakeDataManager exampleDataManager_8917b(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", "", new Integer(5), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    private FakeDataManager exampleDataManagerWithDuplicates(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", "Goat", new Integer(5), "okay"), Arrays.asList("002", "Screwdriver", new Integer(100), "okay"), Arrays.asList("003", "Goat", new Integer(4), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    private FakeDataManager exampleDataManagerWithDuplicates1(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", "Goat", new Integer(5), "okay"), Arrays.asList("003", "Screwdriver", new Integer(100), "okay"), Arrays.asList("001", "Goat", new Integer(4), "okay")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    private FakeDataManager exampleDataManagerDuJour(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", null, new Integer(5), "okay"), Arrays.asList("002", "Screwdriver", null, "okay"), Arrays.asList("003", "Goat", new Integer(4), "okay"), Arrays.asList("004", "Flux Capacitor", new Integer(2), "discontinued"), Arrays.asList("005", "Milkshake", new Integer(88), null), Arrays.asList("006", "Feta Matrix", new Integer(0), "discontinued")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    public static FakeDataManager exampleXQTDataManager(FakeMetadataFacade metadata) throws Exception {
        FakeDataManager dataMgr = new FakeDataManager();
        FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("xqt.data");
        List elementIDs = metadata.getElementIDsInGroupID(groupID);
        List xqtData = TestXMLProcessor.createElements(elementIDs);
        dataMgr.registerTuples(groupID, xqtData, new List[]{Arrays.asList(new Integer(1), new Integer(-2), "-2"), Arrays.asList(new Integer(2), new Integer(-1), null), Arrays.asList(new Integer(3), null, "0"), Arrays.asList(new Integer(4), new Integer(1), "1"), Arrays.asList(new Integer(5), new Integer(2), "2"), Arrays.asList(new Integer(6), new Integer(3), "3"), Arrays.asList(new Integer(7), new Integer(4), "4"), Arrays.asList(new Integer(8), new Integer(5), null), Arrays.asList(new Integer(9), null, "6"), Arrays.asList(new Integer(10), new Integer(7), "7"), Arrays.asList(new Integer(11), new Integer(8), "8"), Arrays.asList(new Integer(12), new Integer(9), "9"), Arrays.asList(new Integer(13), new Integer(10), "10")});
        return dataMgr;
    }

    public static Command helpGetCommand(String sql, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        QueryParser parser = new QueryParser();
        Command command = parser.parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)metadata, null);
        return command;
    }

    static ProcessorPlan helpTestProcess(String sql, String expectedDoc, FakeMetadataFacade metadata, FakeDataManager dataMgr) throws Exception {
        return TestXMLProcessor.helpTestProcess(sql, expectedDoc, metadata, dataMgr, null);
    }

    static ProcessorPlan helpTestProcess(String sql, String expectedDoc, FakeMetadataFacade metadata, FakeDataManager dataMgr, Class expectedException) throws Exception {
        return TestXMLProcessor.helpTestProcess(sql, metadata, dataMgr, expectedException, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), expectedDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProcessorPlan helpTestProcess(String sql, FakeMetadataFacade metadata, FakeDataManager dataMgr, Class expectedException, CapabilitiesFinder capFinder, String ... expectedDoc) throws Exception {
        Command command = TestXMLProcessor.helpGetCommand(sql, (QueryMetadataInterface)metadata);
        AnalysisRecord analysisRecord = new AnalysisRecord(false, false);
        try {
            CommandContext planningContext = new CommandContext();
            planningContext.setMetadata((QueryMetadataInterface)new TempMetadataAdapter((QueryMetadataInterface)metadata, new TempMetadataStore()));
            ProcessorPlan plan = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, (AnalysisRecord)analysisRecord, (CommandContext)planningContext);
            List[] expected = new List[expectedDoc.length];
            for (int i = 0; i < expectedDoc.length; ++i) {
                expected[i] = Arrays.asList(expectedDoc[i]);
            }
            TestProcessor.helpProcess(plan, planningContext, dataMgr, expected);
            Assert.assertNull((String)"Expected failure", (Object)expectedException);
            ProcessorPlan processorPlan = plan;
            return processorPlan;
        }
        catch (Exception e) {
            if (expectedException == null) {
                throw e;
            }
            Assert.assertTrue((boolean)expectedException.isInstance(e));
        }
        return null;
    }

    @Test
    public void test1() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy1() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 ORDER BY Catalogs.Catalog.Items.Item.Quantity ASC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy1a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT \"xml\" FROM xmltest.doc1 ORDER BY Catalogs.Catalog.Items.Item.Quantity ASC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy1b() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT xmltest.doc1.xml FROM xmltest.doc1 ORDER BY Catalogs.Catalog.Items.Item.Quantity ASC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 ORDER BY Catalogs.Catalog.Items.Item.Quantity DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy3() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 ORDER BY Catalogs.Catalog.Items.Item.ItemID DESC, Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID ASC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy3a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 ORDER BY Catalogs.Catalog.Items.Item.ItemID ASC, Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy4() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE ItemID='001' AND Quantity < 60 ORDER BY ItemID", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy5() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 ORDER BY ItemID", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy6() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>12/31/01</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderDate>05/31/02</OrderDate>\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"3\">\r\n                                <OrderDate>02/31/02</OrderDate>\r\n                                <OrderQuantity>12</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 ORDER BY Catalogs.Catalog.Items.Item.ItemID ASC, Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID ASC, OrderID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy7() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9a ORDER BY ItemID DESC", EXPECTED_ORDERED_DOC9A, metadata, dataMgr);
    }

    @Test
    public void testOrderBy8() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>12/31/01</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderDate>05/31/02</OrderDate>\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"3\">\r\n                                <OrderDate>02/31/02</OrderDate>\r\n                                <OrderQuantity>12</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE Catalogs.Catalog.Items.Item.Quantity < 60 ORDER BY Catalogs.Catalog.Items.Item.ItemID ASC, Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID ASC, OrderID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy10() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE Quantity < 60 ORDER BY Name DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy11() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9a WHERE ItemID='001' OR ItemID='002' OR ItemID='003' ORDER BY ItemID DESC", EXPECTED_ORDERED_DOC9A, metadata, dataMgr);
    }

    @Test
    public void testOrderBy13() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 ORDER BY Name DESC, Quantity ASC ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy14() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderDate>05/31/02</OrderDate>\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"3\">\r\n                                <OrderDate>02/31/02</OrderDate>\r\n                                <OrderQuantity>12</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>12/31/01</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 ORDER BY Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID ASC, OrderID DESC, Catalogs.Catalog.Items.Item.ItemID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy15() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 ORDER BY Name ASC, Quantity DESC ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy17() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerWithNulls(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name xsi:nil=\"true\"/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity/>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 ORDER BY Name ASC, Quantity ASC ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy18() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerWithDuplicates(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Goat</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 ORDER BY Name ASC, Quantity DESC ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy19() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerWithDuplicates1(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Goat</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 ORDER BY ItemID ASC, Name ASC, Quantity DESC ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy20() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_4;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE ItemID='002' AND Catalogs.Catalog.Items.Item.Suppliers.Supplier.Orders.Order.OrderQuantity < 1000 ORDER BY SupplierID ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testOrderBy_defect9803() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        try {
            TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE ItemID='002' AND Catalogs.Catalog.Items.Item.Suppliers.Supplier.Orders.Order.OrderQuantity < 1000 ORDER BY Suppliers", "", metadata, dataMgr);
            Assert.fail((String)"Should have failed with QueryPlannerException but didn't");
        }
        catch (QueryPlannerException e) {
            String expectedMsg = "The XML document element [element] name='Suppliers' minOccurs=1 maxOccurs=1 is not mapped to data and cannot be used in the ORDER BY clause: ORDER BY Suppliers";
            Assert.assertEquals((Object)expectedMsg, (Object)e.getMessage());
        }
    }

    @Test
    public void test1CriteriaWithUnmappedElementFails() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE Catalog = 'something'", null, metadata, dataMgr, QueryPlannerException.class);
    }

    @Test
    public void test1CriteriaWithUnmappedElementFails2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE Item = 'something'", null, metadata, dataMgr, QueryPlannerException.class);
    }

    @Test
    public void testNested() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2aTempGroup() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9a", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2aTempGroupCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9a WHERE tempGroup.orders.orderNum = 1", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2aTempGroupCompoundCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9a WHERE tempGroup.orders.orderNum = '1' AND tempGroup.orders.orderStatus = 'processing'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2aTempGroupCompoundCriteria1() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9a WHERE tempGroup.orders.orderNum = 1 AND tempGroup.orders.orderQty = 87", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2aTempGroupCompoundCriteria2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderDate>05/31/02</OrderDate>\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9a WHERE tempGroup.orders.orderNum = '1' OR tempGroup.orders.orderStatus = 'processing'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2cTempGroup() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_3;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9a WHERE ItemID = '001'", expectedDoc, metadata, dataMgr);
    }

    public void defer_testNested2bTempGroup() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9b", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_3;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE ItemID='001'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithCriteria2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>12/31/01</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        XMLPlan plan = (XMLPlan)TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(SupplierID, SupplierID)='52'", expectedDoc, metadata, dataMgr);
        Map stats = XMLProgramUtil.getProgramStats(plan.getOriginalProgram());
        Assert.assertEquals((long)2L, (long)((List)stats.get(ExecStagingTableInstruction.class)).size());
    }

    @Test
    public void testNested2WithCriteria2_defect9802() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>12/31/01</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(Supplier.SupplierID, SupplierID)='52'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithCriteria2_function() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>12/31/01</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(SupplierID, SupplierID)=convert(52, string)", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithCriteria2a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_3;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE SupplierID='52'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_3;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(Item, SupplierID)='52'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_4;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(Item, OrderID)='5'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria3() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(SupplierID, OrderID)='5'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria4() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_4;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(Item, OrderID)='5' OR context(Item, OrderID)='6'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria4a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_4;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(Item, OrderID)='5' OR OrderID='6'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria4b() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_4;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE OrderID='5' OR OrderID='6'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_5;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(Item, OrderID)='5' OR context(Item, OrderID)='2'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_5;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE OrderID='5' OR context(Item, OrderID)='2'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria5b() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_5;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE OrderID='5' OR OrderID='2'", expectedDoc, metadata, dataMgr);
    }

    public static String readFile(String fileName) throws Exception {
        FileInputStream fis = new FileInputStream(UnitTestUtil.getTestDataFile((String)fileName));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c = 0;
        while ((c = fis.read()) != -1) {
            baos.write(c);
        }
        return baos.toString();
    }

    @Test
    public void testNested2WithContextCriteria5Fail() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "";
        boolean shouldSucceed = false;
        Class<QueryPlannerException> expectedException = QueryPlannerException.class;
        String shouldFailMsg = "expected failure since two different contexts were specified in conjunct";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(Item, OrderID)='5' OR context(SupplierID, OrderID)='2'", expectedDoc, metadata, dataMgr, expectedException);
    }

    @Test
    public void testNested2WithContextCriteria6() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items/>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE context(Item, OrderID)='5' AND context(Item, OrderID)='2'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria6b() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items/>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE OrderID='5' AND OrderID='2'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria7() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_7;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE CONTEXT(SupplierID, OrderID)='5' AND context(OrderID, OrderID)='5'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria7b() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_7;
        String query = "SELECT * FROM xmltest.doc9 WHERE CONTEXT(Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID, Catalogs.Catalog.Items.Item.Suppliers.Supplier.Orders.Order.OrderID)='5' AND context(OrderID, OrderID)='5'";
        TestXMLProcessor.helpTestProcess(query, expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria7c() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_7;
        String query = "SELECT * FROM xmltest.doc9 WHERE CONTEXT(Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID, Catalogs.Catalog.Items.Item.Suppliers.Supplier.Orders.Order.OrderID)='6' AND context(OrderID, OrderID)='5'";
        TestXMLProcessor.helpTestProcess(query, expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria_7333() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"3\">\r\n                                <OrderDate>02/31/02</OrderDate>\r\n                                <OrderQuantity>12</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderDate>05/31/02</OrderDate>\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE OrderID='4' AND ItemID='003'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria_7333b() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"3\">\r\n                                <OrderDate>02/31/02</OrderDate>\r\n                                <OrderQuantity>12</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderDate>05/31/02</OrderDate>\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE ItemID='003' AND OrderID='4'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria_7333c() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items/>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE OrderID='5' AND ItemID='003'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria_7333d() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items/>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE ItemID='003' AND OrderID='5'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNested2WithContextCriteria8() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE ItemID='002' AND Context(Supplier,OrderID)='5'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNestedWithChoice() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <ProcessingOrders>\r\n                            <OtherOrder OrderID=\"2\"/>\r\n                        </ProcessingOrders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <ProcessingOrders>\r\n                            <OtherOrder OrderID=\"1\"/>\r\n                        </ProcessingOrders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <ProcessingOrders>\r\n                            <OtherOrder OrderID=\"5\"/>\r\n                            <OtherOrder OrderID=\"6\"/>\r\n                        </ProcessingOrders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <ProcessingOrders>\r\n                            <OtherOrder OrderID=\"3\"/>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderDate>05/31/02</OrderDate>\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                            </Order>\r\n                        </ProcessingOrders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc10", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNestedWithChoiceAndCriteria2_6796() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <ProcessingOrders>\r\n                            <OtherOrder OrderID=\"1\"/>\r\n                        </ProcessingOrders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <ProcessingOrders>\r\n                            <OtherOrder OrderID=\"5\"/>\r\n                            <OtherOrder OrderID=\"6\"/>\r\n                        </ProcessingOrders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc10 where Catalogs.Catalog.Items.Item.Suppliers.Supplier.ProcessingOrders.OtherOrder.OrderID='5'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNestedWithChoiceAndCriteria2a_6796() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <ProcessingOrders>\r\n                            <OtherOrder OrderID=\"5\"/>\r\n                        </ProcessingOrders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc10 where context(Catalogs.Catalog.Items.Item.Suppliers.Supplier.ProcessingOrders.OtherOrder.OrderID, Catalogs.Catalog.Items.Item.Suppliers.Supplier.ProcessingOrders.OtherOrder.OrderID)='5'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNestedWithLookupChoice() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <ProcessingOrders>\r\n                            <OtherOrder OrderID=\"1\"/>\r\n                        </ProcessingOrders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <ProcessingOrders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <ProcessingOrders>\r\n                            <OtherOrder OrderID=\"5\"/>\r\n                            <OtherOrder OrderID=\"6\"/>\r\n                        </ProcessingOrders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc10L where Catalogs.Catalog.Items.Item.Suppliers.Supplier.ProcessingOrders.OtherOrder.OrderID='5'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void test1Unformatted() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items><Item ItemID=\"001\"><Name>Lamp</Name><Quantity>5</Quantity></Item><Item ItemID=\"002\"><Name>Screwdriver</Name><Quantity>100</Quantity></Item><Item ItemID=\"003\"><Name>Goat</Name><Quantity>4</Quantity></Item></Items></Catalog></Catalogs>\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1Unformatted", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testChoice_5266a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n   <Catalog>\r\n      <Items>\r\n         <Item ItemID=\"001\">\r\n            <Name>Lamp</Name>\r\n            <Quantity>5</Quantity>\r\n            <Suppliers>\r\n               <Supplier SupplierID=\"51\">\r\n                  <Name>Chucky</Name>\r\n                  <Zip>11111</Zip>\r\n                  <ProcessingOrders/>\r\n               </Supplier>\r\n               <Supplier SupplierID=\"52\">\r\n                  <Name>Biff's Stuff</Name>\r\n                  <Zip>22222</Zip>\r\n                  <ProcessingOrders/>\r\n               </Supplier>\r\n               <Supplier SupplierID=\"53\">\r\n                  <Name>AAAA</Name>\r\n                  <Zip>33333</Zip>\r\n                  <ProcessingOrders/>\r\n               </Supplier>\r\n               <Supplier SupplierID=\"56\">\r\n                  <Name>Microsoft</Name>\r\n                  <Zip>66666</Zip>\r\n                  <ProcessingOrders/>\r\n               </Supplier>\r\n            </Suppliers>\r\n         </Item>\r\n         <Item ItemID=\"002\">\r\n            <Name>Screwdriver</Name>\r\n            <Quantity>100</Quantity>\r\n            <Suppliers>\r\n               <Supplier SupplierID=\"54\">\r\n                  <Name>Nugent Co.</Name>\r\n                  <Zip>44444</Zip>\r\n                  <ProcessingOrders/>\r\n               </Supplier>\r\n               <Supplier SupplierID=\"55\">\r\n                  <Name>Zeta</Name>\r\n                  <Zip>55555</Zip>\r\n                  <ProcessingOrders/>\r\n               </Supplier>\r\n               <Supplier SupplierID=\"56\">\r\n                  <Name>Microsoft</Name>\r\n                  <Zip>66666</Zip>\r\n                  <ProcessingOrders/>\r\n               </Supplier>\r\n            </Suppliers>\r\n         </Item>\r\n         <Item ItemID=\"003\">\r\n            <Name>Goat</Name>\r\n            <Quantity>4</Quantity>\r\n            <Suppliers>\r\n               <Supplier SupplierID=\"56\">\r\n                  <Name>Microsoft</Name>\r\n                  <Zip>66666</Zip>\r\n                  <ProcessingOrders>\r\n                     <Order OrderID=\"4\">\r\n                        <OrderDate>05/31/02</OrderDate>\r\n                        <OrderQuantity>9</OrderQuantity>\r\n                     </Order>\r\n                  </ProcessingOrders>\r\n               </Supplier>\r\n            </Suppliers>\r\n         </Item>\r\n      </Items>\r\n   </Catalog>\r\n</Catalogs>\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc_5266a", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void test1WithCriteriaShortName() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE quantity < 50", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void test1WithCriteriaLongName() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE catalogs.catalog.items.item.quantity < 50", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void test2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc2", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void test2a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc2a", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void test2b() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc2b", null, metadata, dataMgr, TeiidComponentException.class);
    }

    @Test
    public void test2c() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item2 ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item2>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc2c", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void test2d() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item2 ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item2>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc2d", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void test2e() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item2 ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item2>\r\n            <ItemDefault ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </ItemDefault>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc2e", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testWithNillableNode() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerWithNulls(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name xsi:nil=\"true\"/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testWithDefault() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerWithNulls(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name xsi:nil=\"true\"/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>1</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc3", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testWithNamespaces() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerWithNulls(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name xsi:nil=\"true\"/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>1</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n    <duh:Fake xmlns:duh=\"http://www.duh.org/duh\" xmlns:duh2=\"http://www.duh2.org/duh2\"\n              xmlns=\"http://www.default.org/default\">fixed constant value<duh:FakeChild2>\r\n            <FakeChild2a>another fixed constant value</FakeChild2a>\r\n        </duh:FakeChild2>\r\n        <FakeChild3 xmlns:duh=\"http://www.duh.org/duh/duh\" duh:FakeAtt=\"fixed att value\"/>\r\n    </duh:Fake>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc4", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testWithNewIter3Properties() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerDuJour(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name xsi:nil=\"true\"/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>0</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <DiscontinuedItem ItemID=\"004\">\r\n                <Name>Flux Capacitor</Name>\r\n                <Quantity>2</Quantity>\r\n            </DiscontinuedItem>\r\n            <StatusUnknown ItemID=\"005\">\r\n                <Name>Milkshake</Name>\r\n                <Quantity>88</Quantity>\r\n            </StatusUnknown>\r\n            <DiscontinuedItem ItemID=\"006\">\r\n                <Name>Feta Matrix</Name>\r\n                <Quantity>0</Quantity>\r\n            </DiscontinuedItem>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc5", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testWithNewIter3PropertiesException() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerDuJour(metadata);
        Command command = TestXMLProcessor.helpGetCommand("SELECT * FROM xmltest.doc6", (QueryMetadataInterface)metadata);
        XMLPlan plan = TestXMLPlanner.preparePlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), null);
        BufferManager bufferMgr = BufferManagerFactory.getStandaloneBufferManager();
        CommandContext context = new CommandContext((Object)"pID", null, null, null, 1);
        QueryProcessor processor = new QueryProcessor((ProcessorPlan)plan, context, bufferMgr, (ProcessorDataManager)dataMgr);
        processor.setNonBlocking(true);
        BatchCollector collector = processor.createBatchCollector();
        TeiidComponentException failOnDefaultException = null;
        try {
            collector.collectTuples();
        }
        catch (TeiidComponentException e) {
            failOnDefaultException = e;
        }
        Assert.assertNotNull((String)"Query processing should have failed on default of choice node.", (Object)((Object)failOnDefaultException));
    }

    @Test
    public void testAttributeBug() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<FixedValueTest>\r\n    <wrapper fixedAttr=\"fixed attribute\">\r\n        <key>001</key>\r\n        <fixed>fixed value</fixed>\r\n    </wrapper>\r\n    <wrapper fixedAttr=\"fixed attribute\">\r\n        <key>002</key>\r\n        <fixed>fixed value</fixed>\r\n    </wrapper>\r\n    <wrapper fixedAttr=\"fixed attribute\">\r\n        <key>003</key>\r\n        <fixed>fixed value</fixed>\r\n    </wrapper>\r\n</FixedValueTest>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc7", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testMultipleDocs() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Item ItemID=\"001\">\r\n    <Name>Lamp</Name>\r\n    <Quantity>5</Quantity>\r\n    <Suppliers>\r\n        <Supplier SupplierID=\"51\">\r\n            <Name>Chucky</Name>\r\n            <Zip>11111</Zip>\r\n        </Supplier>\r\n        <Supplier SupplierID=\"52\">\r\n            <Name>Biff's Stuff</Name>\r\n            <Zip>22222</Zip>\r\n        </Supplier>\r\n        <Supplier SupplierID=\"53\">\r\n            <Name>AAAA</Name>\r\n            <Zip>33333</Zip>\r\n        </Supplier>\r\n        <Supplier SupplierID=\"56\">\r\n            <Name>Microsoft</Name>\r\n            <Zip>66666</Zip>\r\n        </Supplier>\r\n    </Suppliers>\r\n</Item>\r\n\r\n";
        String expectedDoc2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Item ItemID=\"002\">\r\n    <Name>Screwdriver</Name>\r\n    <Quantity>100</Quantity>\r\n    <Suppliers>\r\n        <Supplier SupplierID=\"54\">\r\n            <Name>Nugent Co.</Name>\r\n            <Zip>44444</Zip>\r\n        </Supplier>\r\n        <Supplier SupplierID=\"55\">\r\n            <Name>Zeta</Name>\r\n            <Zip>55555</Zip>\r\n        </Supplier>\r\n        <Supplier SupplierID=\"56\">\r\n            <Name>Microsoft</Name>\r\n            <Zip>66666</Zip>\r\n        </Supplier>\r\n    </Suppliers>\r\n</Item>\r\n\r\n";
        String expectedDoc3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Item ItemID=\"003\">\r\n    <Name>Goat</Name>\r\n    <Quantity>4</Quantity>\r\n    <Suppliers>\r\n        <Supplier SupplierID=\"56\">\r\n            <Name>Microsoft</Name>\r\n            <Zip>66666</Zip>\r\n        </Supplier>\r\n    </Suppliers>\r\n</Item>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc11", metadata, dataMgr, null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), expectedDoc1, expectedDoc2, expectedDoc3);
    }

    @Test
    public void testRecursive() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<OrgHierarchy>\r\n    <Employee ID=\"01\">\r\n        <FirstName>Ted</FirstName>\r\n        <LastName>Nugent</LastName>\r\n        <Subordinates>\r\n            <Employee ID=\"02\">\r\n                <FirstName>Bill</FirstName>\r\n                <LastName>Squier</LastName>\r\n                <Subordinates>\r\n                    <Employee ID=\"04\">\r\n                        <FirstName>Leland</FirstName>\r\n                        <LastName>Sklar</LastName>\r\n                        <Subordinates>\r\n                            <Employee ID=\"06\">\r\n                                <FirstName>John</FirstName>\r\n                                <LastName>Zorn</LastName>\r\n                                <Subordinates>\r\n                                    <Employee ID=\"11\">\r\n                                        <FirstName>Mike</FirstName>\r\n                                        <LastName>Patton</LastName>\r\n                                        <Subordinates>\r\n                                            <Employee ID=\"13\">\r\n                                                <FirstName>Puffy</FirstName>\r\n                                                <LastName>Bordin</LastName>\r\n                                                <Subordinates/>\r\n                                            </Employee>\r\n                                        </Subordinates>\r\n                                    </Employee>\r\n                                    <Employee ID=\"12\">\r\n                                        <FirstName>Devin</FirstName>\r\n                                        <LastName>Townsend</LastName>\r\n                                        <Subordinates/>\r\n                                    </Employee>\r\n                                </Subordinates>\r\n                            </Employee>\r\n                        </Subordinates>\r\n                    </Employee>\r\n                </Subordinates>\r\n            </Employee>\r\n            <Employee ID=\"03\">\r\n                <FirstName>John</FirstName>\r\n                <LastName>Smith</LastName>\r\n                <Subordinates>\r\n                    <Employee ID=\"05\">\r\n                        <FirstName>Kevin</FirstName>\r\n                        <LastName>Moore</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                </Subordinates>\r\n            </Employee>\r\n        </Subordinates>\r\n    </Employee>\r\n    <Employee ID=\"07\">\r\n        <FirstName>Geoff</FirstName>\r\n        <LastName>Tate</LastName>\r\n        <Subordinates>\r\n            <Employee ID=\"08\">\r\n                <FirstName>Les</FirstName>\r\n                <LastName>Claypool</LastName>\r\n                <Subordinates>\r\n                    <Employee ID=\"09\">\r\n                        <FirstName>Meat</FirstName>\r\n                        <LastName>Loaf</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                    <Employee ID=\"10\">\r\n                        <FirstName>Keith</FirstName>\r\n                        <LastName>Sweat</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                </Subordinates>\r\n            </Employee>\r\n        </Subordinates>\r\n    </Employee>\r\n</OrgHierarchy>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc12", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testRecursiveA() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<OrgHierarchy>\r\n    <Employee ID=\"01\">\r\n        <FirstName>Ted</FirstName>\r\n        <LastName>Nugent</LastName>\r\n        <Subordinates>\r\n            <Subordinate ID=\"02\">\r\n                <FirstName>Bill</FirstName>\r\n                <LastName>Squier</LastName>\r\n                <Subordinates>\r\n                    <Subordinate ID=\"04\">\r\n                        <FirstName>Leland</FirstName>\r\n                        <LastName>Sklar</LastName>\r\n                        <Subordinates>\r\n                            <Subordinate ID=\"06\">\r\n                                <FirstName>John</FirstName>\r\n                                <LastName>Zorn</LastName>\r\n                                <Subordinates>\r\n                                    <Subordinate ID=\"11\">\r\n                                        <FirstName>Mike</FirstName>\r\n                                        <LastName>Patton</LastName>\r\n                                        <Subordinates>\r\n                                            <Subordinate ID=\"13\">\r\n                                                <FirstName>Puffy</FirstName>\r\n                                                <LastName>Bordin</LastName>\r\n                                                <Subordinates/>\r\n                                            </Subordinate>\r\n                                        </Subordinates>\r\n                                    </Subordinate>\r\n                                    <Subordinate ID=\"12\">\r\n                                        <FirstName>Devin</FirstName>\r\n                                        <LastName>Townsend</LastName>\r\n                                        <Subordinates/>\r\n                                    </Subordinate>\r\n                                </Subordinates>\r\n                            </Subordinate>\r\n                        </Subordinates>\r\n                    </Subordinate>\r\n                </Subordinates>\r\n            </Subordinate>\r\n            <Subordinate ID=\"03\">\r\n                <FirstName>John</FirstName>\r\n                <LastName>Smith</LastName>\r\n                <Subordinates>\r\n                    <Subordinate ID=\"05\">\r\n                        <FirstName>Kevin</FirstName>\r\n                        <LastName>Moore</LastName>\r\n                        <Subordinates/>\r\n                    </Subordinate>\r\n                </Subordinates>\r\n            </Subordinate>\r\n        </Subordinates>\r\n    </Employee>\r\n    <Employee ID=\"07\">\r\n        <FirstName>Geoff</FirstName>\r\n        <LastName>Tate</LastName>\r\n        <Subordinates>\r\n            <Subordinate ID=\"08\">\r\n                <FirstName>Les</FirstName>\r\n                <LastName>Claypool</LastName>\r\n                <Subordinates>\r\n                    <Subordinate ID=\"09\">\r\n                        <FirstName>Meat</FirstName>\r\n                        <LastName>Loaf</LastName>\r\n                        <Subordinates/>\r\n                    </Subordinate>\r\n                    <Subordinate ID=\"10\">\r\n                        <FirstName>Keith</FirstName>\r\n                        <LastName>Sweat</LastName>\r\n                        <Subordinates/>\r\n                    </Subordinate>\r\n                </Subordinates>\r\n            </Subordinate>\r\n        </Subordinates>\r\n    </Employee>\r\n</OrgHierarchy>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc12a", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testRecursive2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<OrgHierarchy>\r\n    <Employee ID=\"01\">\r\n        <FirstName>Ted</FirstName>\r\n        <LastName>Nugent</LastName>\r\n        <Subordinates>\r\n            <Employee ID=\"02\">\r\n                <FirstName>Bill</FirstName>\r\n                <LastName>Squier</LastName>\r\n                <Subordinates/>\r\n            </Employee>\r\n            <Employee ID=\"03\">\r\n                <FirstName>John</FirstName>\r\n                <LastName>Smith</LastName>\r\n                <Subordinates>\r\n                    <Employee ID=\"05\">\r\n                        <FirstName>Kevin</FirstName>\r\n                        <LastName>Moore</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                </Subordinates>\r\n            </Employee>\r\n        </Subordinates>\r\n    </Employee>\r\n    <Employee ID=\"07\">\r\n        <FirstName>Geoff</FirstName>\r\n        <LastName>Tate</LastName>\r\n        <Subordinates>\r\n            <Employee ID=\"08\">\r\n                <FirstName>Les</FirstName>\r\n                <LastName>Claypool</LastName>\r\n                <Subordinates>\r\n                    <Employee ID=\"09\">\r\n                        <FirstName>Meat</FirstName>\r\n                        <LastName>Loaf</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                    <Employee ID=\"10\">\r\n                        <FirstName>Keith</FirstName>\r\n                        <LastName>Sweat</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                </Subordinates>\r\n            </Employee>\r\n        </Subordinates>\r\n    </Employee>\r\n</OrgHierarchy>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc13", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testRecursive3() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<OrgHierarchy>\r\n    <Employee ID=\"01\">\r\n        <FirstName>Ted</FirstName>\r\n        <LastName>Nugent</LastName>\r\n        <Subordinates>\r\n            <Employee ID=\"02\">\r\n                <FirstName>Bill</FirstName>\r\n                <LastName>Squier</LastName>\r\n                <Subordinates>\r\n                    <Employee ID=\"04\">\r\n                        <FirstName>Leland</FirstName>\r\n                        <LastName>Sklar</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                </Subordinates>\r\n            </Employee>\r\n            <Employee ID=\"03\">\r\n                <FirstName>John</FirstName>\r\n                <LastName>Smith</LastName>\r\n                <Subordinates>\r\n                    <Employee ID=\"05\">\r\n                        <FirstName>Kevin</FirstName>\r\n                        <LastName>Moore</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                </Subordinates>\r\n            </Employee>\r\n        </Subordinates>\r\n    </Employee>\r\n    <Employee ID=\"07\">\r\n        <FirstName>Geoff</FirstName>\r\n        <LastName>Tate</LastName>\r\n        <Subordinates>\r\n            <Employee ID=\"08\">\r\n                <FirstName>Les</FirstName>\r\n                <LastName>Claypool</LastName>\r\n                <Subordinates>\r\n                    <Employee ID=\"09\">\r\n                        <FirstName>Meat</FirstName>\r\n                        <LastName>Loaf</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                    <Employee ID=\"10\">\r\n                        <FirstName>Keith</FirstName>\r\n                        <LastName>Sweat</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                </Subordinates>\r\n            </Employee>\r\n        </Subordinates>\r\n    </Employee>\r\n</OrgHierarchy>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc14", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testRecursive4Exception() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc15", null, metadata, dataMgr, TeiidComponentException.class);
    }

    @Test
    public void testRecursive5() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Employees>\r\n    <Employee ID=\"08\">\r\n        <FirstName>Les</FirstName>\r\n        <LastName>Claypool</LastName>\r\n        <Supervisor ID=\"07\">\r\n            <FirstName>Geoff</FirstName>\r\n            <LastName>Tate</LastName>\r\n        </Supervisor>\r\n    </Employee>\r\n    <Employee ID=\"09\">\r\n        <FirstName>Meat</FirstName>\r\n        <LastName>Loaf</LastName>\r\n        <Supervisor ID=\"08\">\r\n            <FirstName>Les</FirstName>\r\n            <LastName>Claypool</LastName>\r\n            <Supervisor ID=\"07\">\r\n                <FirstName>Geoff</FirstName>\r\n                <LastName>Tate</LastName>\r\n            </Supervisor>\r\n        </Supervisor>\r\n    </Employee>\r\n    <Employee ID=\"10\">\r\n        <FirstName>Keith</FirstName>\r\n        <LastName>Sweat</LastName>\r\n        <Supervisor ID=\"08\">\r\n            <FirstName>Les</FirstName>\r\n            <LastName>Claypool</LastName>\r\n            <Supervisor ID=\"07\">\r\n                <FirstName>Geoff</FirstName>\r\n                <LastName>Tate</LastName>\r\n            </Supervisor>\r\n        </Supervisor>\r\n    </Employee>\r\n</Employees>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc16", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testRecursiveWithStagingTable_defect15607() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<OrgHierarchy>\r\n    <Employee ID=\"01\">\r\n        <FirstName>Ted</FirstName>\r\n        <LastName>Nugent</LastName>\r\n        <Subordinates>\r\n            <Employee ID=\"02\">\r\n                <FirstName>Bill</FirstName>\r\n                <LastName>Squier</LastName>\r\n                <Subordinates/>\r\n            </Employee>\r\n            <Employee ID=\"03\">\r\n                <FirstName>John</FirstName>\r\n                <LastName>Smith</LastName>\r\n                <Subordinates>\r\n                    <Employee ID=\"05\">\r\n                        <FirstName>Kevin</FirstName>\r\n                        <LastName>Moore</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                </Subordinates>\r\n            </Employee>\r\n        </Subordinates>\r\n    </Employee>\r\n    <Employee ID=\"07\">\r\n        <FirstName>Geoff</FirstName>\r\n        <LastName>Tate</LastName>\r\n        <Subordinates>\r\n            <Employee ID=\"08\">\r\n                <FirstName>Les</FirstName>\r\n                <LastName>Claypool</LastName>\r\n                <Subordinates>\r\n                    <Employee ID=\"09\">\r\n                        <FirstName>Meat</FirstName>\r\n                        <LastName>Loaf</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                    <Employee ID=\"10\">\r\n                        <FirstName>Keith</FirstName>\r\n                        <LastName>Sweat</LastName>\r\n                        <Subordinates/>\r\n                    </Employee>\r\n                </Subordinates>\r\n            </Employee>\r\n        </Subordinates>\r\n    </Employee>\r\n</OrgHierarchy>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc19", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testXQTRecursive_5988() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<recursiveTest>\r\n    <src>\r\n        <key>13</key>\r\n        <data>10</data>\r\n        <srcNested>\r\n            <key>10</key>\r\n            <data>7</data>\r\n            <srcNestedRecursive>\r\n                <key>7</key>\r\n                <data>4</data>\r\n                <srcNestedRecursive>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcNestedRecursive>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcNestedRecursive>\r\n                </srcNestedRecursive>\r\n            </srcNestedRecursive>\r\n        </srcNested>\r\n        <srcRecursive>\r\n            <key>10</key>\r\n            <data>7</data>\r\n            <srcNested>\r\n                <key>7</key>\r\n                <data>4</data>\r\n                <srcNestedRecursive>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcNestedRecursive>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcNestedRecursive>\r\n                </srcNestedRecursive>\r\n            </srcNested>\r\n            <srcRecursive>\r\n                <key>7</key>\r\n                <data>4</data>\r\n                <srcNested>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcNestedRecursive>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcNestedRecursive>\r\n                </srcNested>\r\n                <srcRecursive>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcNested>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcNested>\r\n                    <srcRecursive>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcRecursive>\r\n                </srcRecursive>\r\n            </srcRecursive>\r\n        </srcRecursive>\r\n    </src>\r\n</recursiveTest>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc1", expectedDoc, metadata, dataMgr);
    }

    public void DEFER_testXQTRecursive1a_5988() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<recursiveTest>\r\n    <src>\r\n        <key>13</key>\r\n        <data>10</data>\r\n        <srcNested>\r\n            <key>10</key>\r\n            <data>7</data>\r\n        </srcNested>\r\n        <srcNested>\r\n            <key>10</key>\r\n            <data>7</data>\r\n            <srcNested>\r\n                <key>7</key>\r\n                <data>4</data>\r\n            </srcNested>\r\n            <srcNested>\r\n                <key>7</key>\r\n                <data>4</data>\r\n                <srcNested>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                </srcNested>\r\n                <srcNested>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcNested>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcNested>\r\n                    <srcNested>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcNested>\r\n                </srcNested>\r\n            </srcNested>\r\n        </srcNested>\r\n    </src>\r\n</recursiveTest>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc1a", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testXQTRecursive2_5988() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<recursiveTest>\r\n    <src>\r\n        <key>13</key>\r\n        <data>10</data>\r\n        <srcNested>\r\n            <key>10</key>\r\n            <data>7</data>\r\n        </srcNested>\r\n        <srcNested>\r\n            <key>10</key>\r\n            <data>7</data>\r\n            <srcNested>\r\n                <key>7</key>\r\n                <data>4</data>\r\n            </srcNested>\r\n            <srcNested>\r\n                <key>7</key>\r\n                <data>4</data>\r\n                <srcNested>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                </srcNested>\r\n                <srcNested>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcNested>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcNested>\r\n                    <srcNested>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcNested>\r\n                </srcNested>\r\n            </srcNested>\r\n        </srcNested>\r\n    </src>\r\n</recursiveTest>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc3", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testXQTRecursiveSiblings_5988() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<recursiveTest>\r\n    <src>\r\n        <key>13</key>\r\n        <data>10</data>\r\n        <srcSibling1>\r\n            <key>10</key>\r\n            <data>7</data>\r\n            <srcSibling1>\r\n                <key>7</key>\r\n                <data>4</data>\r\n                <srcSibling1>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcSibling1>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling1>\r\n                    <srcSibling2>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling2>\r\n                </srcSibling1>\r\n                <srcSibling2>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcSibling1>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling1>\r\n                    <srcSibling2>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling2>\r\n                </srcSibling2>\r\n            </srcSibling1>\r\n            <srcSibling2>\r\n                <key>7</key>\r\n                <data>4</data>\r\n                <srcSibling1>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcSibling1>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling1>\r\n                    <srcSibling2>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling2>\r\n                </srcSibling1>\r\n                <srcSibling2>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcSibling1>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling1>\r\n                    <srcSibling2>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling2>\r\n                </srcSibling2>\r\n            </srcSibling2>\r\n        </srcSibling1>\r\n        <srcSibling2>\r\n            <key>10</key>\r\n            <data>7</data>\r\n            <srcSibling1>\r\n                <key>7</key>\r\n                <data>4</data>\r\n                <srcSibling1>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcSibling1>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling1>\r\n                    <srcSibling2>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling2>\r\n                </srcSibling1>\r\n                <srcSibling2>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcSibling1>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling1>\r\n                    <srcSibling2>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling2>\r\n                </srcSibling2>\r\n            </srcSibling1>\r\n            <srcSibling2>\r\n                <key>7</key>\r\n                <data>4</data>\r\n                <srcSibling1>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcSibling1>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling1>\r\n                    <srcSibling2>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling2>\r\n                </srcSibling1>\r\n                <srcSibling2>\r\n                    <key>4</key>\r\n                    <data>1</data>\r\n                    <srcSibling1>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling1>\r\n                    <srcSibling2>\r\n                        <key>1</key>\r\n                        <data>-2</data>\r\n                    </srcSibling2>\r\n                </srcSibling2>\r\n            </srcSibling2>\r\n        </srcSibling2>\r\n    </src>\r\n</recursiveTest>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.doc2", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement1() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item>\r\n                <Name>Lamp</Name>\r\n            </Item>\r\n            <Item>\r\n                <Name>Screwdriver</Name>\r\n            </Item>\r\n            <Item>\r\n                <Name>Goat</Name>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Name FROM xmltest.doc1", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Orders>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                            </Order>\r\n                            <Order OrderID=\"3\">\r\n                                <OrderQuantity>12</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Orders>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT SupplierID, OrderID, ItemID, OrderQuantity FROM xmltest.doc9 ORDER BY  Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID ASC, OrderID DESC, Catalogs.Catalog.Items.Item.ItemID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement3() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Orders>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                            </Order>\r\n                            <Order OrderID=\"3\">\r\n                                <OrderQuantity>12</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Orders>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT OrderQuantity, SupplierID, ItemID, OrderID FROM xmltest.doc9 ORDER BY Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID ASC, OrderID DESC, Catalogs.Catalog.Items.Item.ItemID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement4() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemID, Name, Quantity FROM xmltest.doc1 WHERE ItemID='001' OR  ItemID='002' OR ItemID='003' ORDER BY ItemID", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement4_defect9756() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\"/>\r\n            <Item ItemID=\"002\"/>\r\n            <Item ItemID=\"003\"/>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Catalogs.Catalog.Items.Item.@ItemID FROM xmltest.doc1", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement5() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Orders>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderQuantity>9</OrderQuantity>\r\n                            </Order>\r\n                            <Order OrderID=\"3\">\r\n                                <OrderQuantity>12</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Orders>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT OrderQuantity, SupplierID, Catalogs.Catalog.Items.Item.Suppliers.Supplier.Name, OrderID, ItemID FROM xmltest.doc9 ORDER BY Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID ASC, OrderID DESC, Catalogs.Catalog.Items.Item.ItemID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement6() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Item.* FROM xmltest.doc1 ORDER BY ItemID", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement6a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item>\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item>\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item>\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Catalogs.Catalog.Items.Item.Name, Catalogs.Catalog.Items.Item.Quantity FROM xmltest.doc1", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement7() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Catalogs.Catalog.Items.Item.* FROM xmltest.doc1 ORDER BY ItemID", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement8() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT xmltest.doc1.Catalogs.Catalog.Items.Item.* FROM xmltest.doc1 ORDER BY ItemID", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement9() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Catalogs.Catalog.Items.Item.Suppliers.Supplier.* FROM xmltest.doc9 WHERE ItemID='002' AND Context(Supplier,OrderID)='5' ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement9a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Catalogs.Catalog.Items.Item.Suppliers.Supplier.* FROM xmltest.doc9 WHERE ItemID='002' AND Context(Supplier,OrderID)='5' AND Context(OrderID, OrderID)='5'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement10() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Item.* FROM xmltest.doc1 WHERE Quantity <= 100 ORDER BY ItemID", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement12() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Supplier.*, ItemID FROM xmltest.doc9  WHERE ItemID='002' ORDER BY SupplierID, OrderID DESC, ItemID", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement13() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item>\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Name, Quantity FROM xmltest.doc1 WHERE ItemID='002'ORDER BY Name ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement14() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = EXPECTED_DOC_NESTED_2_WITH_CONTEXT_CRITERIA_4;
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9 WHERE ItemID='002' AND Catalogs.Catalog.Items.Item.Suppliers.Supplier.Orders.Order.OrderQuantity < 1000 ORDER By SupplierID ASC, OrderID ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement15() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Supplier.* FROM xmltest.doc9  WHERE ItemID='002' ORDER By SupplierID ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement16() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>10/23/01</OrderDate>\r\n                                <OrderQuantity>5</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>06/01/02</OrderDate>\r\n                                <OrderQuantity>87</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                            <Order OrderID=\"6\">\r\n                                <OrderDate>07/01/02</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                            </Order>\r\n                        </Orders>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Supplier.* FROM xmltest.doc9a  WHERE ItemID='002' ORDER By SupplierID", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement17() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"1\">\r\n                        <Name>KMart</Name>\r\n                        <Zip>12345</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"2\">\r\n                        <Name>Sun</Name>\r\n                        <Zip>94040</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"3\">\r\n                        <Name>Cisco</Name>\r\n                        <Zip>94041</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"4\">\r\n                        <Name>Doc</Name>\r\n                        <Zip>94042</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"5\">\r\n                        <Name>Excite</Name>\r\n                        <Zip>21098</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"6\">\r\n                        <Name>Yahoo</Name>\r\n                        <Zip>94043</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"7\">\r\n                        <Name>Inktomi</Name>\r\n                        <Zip>94044</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9c ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement18() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"5\">\r\n                        <Name>Excite</Name>\r\n                        <Zip>21098</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"6\">\r\n                        <Name>Yahoo</Name>\r\n                        <Zip>94043</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9c WHERE ItemID='002'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement19() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"5\">\r\n                        <Name>Excite</Name>\r\n                        <Zip>21098</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"6\">\r\n                        <Name>Yahoo</Name>\r\n                        <Zip>94043</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9c WHERE Catalogs.Catalog.Items.Item.Name='Screwdriver'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement20() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemID, Catalogs.Catalog.Items.Item.Quantity, Catalogs.Catalog.Items.Item.Suppliers.Supplier.Zip FROM xmltest.doc9c  WHERE Catalogs.Catalog.Items.Item.Name='Screwdriver'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement20a() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Quantity>100</Quantity>\r\n                <Orders>\r\n                    <Order>\r\n                        <Zip>21098</Zip>\r\n                    </Order>\r\n                    <Order>\r\n                        <Zip>94043</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemID, Catalogs.Catalog.Items.Item.Quantity, Catalogs.Catalog.Items.Item.Orders.Order.Zip FROM xmltest.doc9c  WHERE Catalogs.Catalog.Items.Item.Name='Screwdriver'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement21() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"1\">\r\n                        <Name>KMart</Name>\r\n                        <Zip>12345</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"2\">\r\n                        <Name>Sun</Name>\r\n                        <Zip>94040</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"3\">\r\n                        <Name>Cisco</Name>\r\n                        <Zip>94041</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"4\">\r\n                        <Name>Doc</Name>\r\n                        <Zip>94042</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"5\">\r\n                        <Name>Excite</Name>\r\n                        <Zip>21098</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"6\">\r\n                        <Name>Yahoo</Name>\r\n                        <Zip>94043</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"7\">\r\n                        <Name>Inktomi</Name>\r\n                        <Zip>94044</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT *  FROM xmltest.doc9c  WHERE SupplierID > '54' AND context(SupplierID, SupplierID)>'54' ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement21a() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"5\">\r\n                        <Name>Excite</Name>\r\n                        <Zip>21098</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"6\">\r\n                        <Name>Yahoo</Name>\r\n                        <Zip>94043</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"7\">\r\n                        <Name>Inktomi</Name>\r\n                        <Zip>94044</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT *  FROM xmltest.doc9c  WHERE OrderID > '4' AND context(OrderID, OrderID)>'4'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement22() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Suppliers>\r\n                    <Supplier>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Suppliers>\r\n                    <Supplier>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Suppliers>\r\n                    <Supplier>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemID, Catalogs.Catalog.Items.Item.Name, Catalogs.Catalog.Items.Item.Suppliers.Supplier.Zip  FROM xmltest.doc9c  WHERE SupplierID > '4' ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement22a() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Orders>\r\n                    <Order OrderID=\"1\">\r\n                        <Name>KMart</Name>\r\n                    </Order>\r\n                    <Order OrderID=\"2\">\r\n                        <Name>Sun</Name>\r\n                    </Order>\r\n                    <Order OrderID=\"3\">\r\n                        <Name>Cisco</Name>\r\n                    </Order>\r\n                    <Order OrderID=\"4\">\r\n                        <Name>Doc</Name>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Orders>\r\n                    <Order OrderID=\"5\">\r\n                        <Name>Excite</Name>\r\n                    </Order>\r\n                    <Order OrderID=\"6\">\r\n                        <Name>Yahoo</Name>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Orders>\r\n                    <Order OrderID=\"7\">\r\n                        <Name>Inktomi</Name>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemID, Catalogs.Catalog.Items.Item.Name, Catalogs.Catalog.Items.Item.Orders.Order.Name, OrderID   FROM xmltest.doc9c  WHERE OrderID > '3' ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement23() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item>\r\n                <Name>Screwdriver</Name>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item>\r\n                <Name>Goat</Name>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Catalogs.Catalog.Items.Item.Name, Catalogs.Catalog.Items.Item.Suppliers.Supplier.Name, SupplierID  FROM xmltest.doc9c  WHERE OrderID > '4' ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement23a() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Orders>\r\n                    <Order OrderID=\"1\"/>\r\n                    <Order OrderID=\"2\"/>\r\n                    <Order OrderID=\"3\"/>\r\n                    <Order OrderID=\"4\"/>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Orders>\r\n                    <Order OrderID=\"5\"/>\r\n                    <Order OrderID=\"6\"/>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Orders>\r\n                    <Order OrderID=\"7\"/>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Catalogs.Catalog.Items.Item.ItemID, OrderID  FROM xmltest.doc9c  WHERE SupplierID > '54' ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement24() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Orders>\r\n                    <Order OrderID=\"7\"/>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Orders>\r\n                    <Order OrderID=\"6\"/>\r\n                    <Order OrderID=\"5\"/>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Orders>\r\n                    <Order OrderID=\"4\"/>\r\n                    <Order OrderID=\"3\"/>\r\n                    <Order OrderID=\"2\"/>\r\n                    <Order OrderID=\"1\"/>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Catalogs.Catalog.Items.Item.ITEMID, OrderID  FROM xmltest.doc9c  WHERE SupplierID > '54'  ORDER BY ItemID DESC, OrderID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement24a() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Orders>\r\n                    <Order OrderID=\"7\">\r\n                        <Name>Inktomi</Name>\r\n                        <Zip>94044</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Orders>\r\n                    <Order OrderID=\"6\">\r\n                        <Name>Yahoo</Name>\r\n                        <Zip>94043</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"5\">\r\n                        <Name>Excite</Name>\r\n                        <Zip>21098</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Orders>\r\n                    <Order OrderID=\"4\">\r\n                        <Name>Doc</Name>\r\n                        <Zip>94042</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"3\">\r\n                        <Name>Cisco</Name>\r\n                        <Zip>94041</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"2\">\r\n                        <Name>Sun</Name>\r\n                        <Zip>94040</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"1\">\r\n                        <Name>KMart</Name>\r\n                        <Zip>12345</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Catalogs.Catalog.Items.Item.ItemID, Order.*  FROM xmltest.doc9c  WHERE SupplierID > '54'  ORDER BY ItemID DESC, OrderID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement25() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\"/>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\"/>\r\n                    <Supplier SupplierID=\"55\"/>\r\n                    <Supplier SupplierID=\"54\"/>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\"/>\r\n                    <Supplier SupplierID=\"53\"/>\r\n                    <Supplier SupplierID=\"52\"/>\r\n                    <Supplier SupplierID=\"51\"/>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemID, SupplierID  FROM xmltest.doc9c  WHERE SupplierID > '54'  ORDER BY ItemID DESC, SupplierID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement25a() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemID, Supplier.*  FROM xmltest.doc9c  WHERE SupplierID > '54'  ORDER BY ItemID DESC, SupplierID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement25b() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemID, SUPPLIER.*  FROM xmltest.doc9c  WHERE SupplierID > '54'  ORDER BY ItemID DESC, SupplierID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement26() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemID, xmltest.doc9c.catalogs.catalog.items.item.suppliers.SUPPLIER.*  FROM xmltest.doc9c  WHERE SupplierID > '54'  ORDER BY ItemID DESC, SupplierID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement27() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier/>\r\n                    <Supplier/>\r\n                    <Supplier/>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT doc9c.catalogs.catalog.items.item.itemID, items.item.name, item.Quantity, supplier  FROM xmltest.doc9c  WHERE doc9c.catalogs.catalog.items.item.suppliers.supplier.SupplierID > '54' AND itemID='002' ORDER BY doc9c.catalogs.catalog.items.item.ITEMid ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement28() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs/>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT catalogs  FROM xmltest.doc9c  WHERE item.suppliers.supplier.SupplierID > '54' AND itemID='002'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement28a() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog/>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT catalog  FROM xmltest.doc9c  WHERE item.suppliers.supplier.SupplierID > '54' AND itemID='002'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement28b() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT xmltest.doc1.* FROM xmltest.doc1 ORDER BY ItemID ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement29() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs/>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT xmltest.doc9c.catalogs  FROM xmltest.doc9c  WHERE item.suppliers.supplier.SupplierID > '54' AND itemID='002'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSelectElement30() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT item.* FROM xmltest.doc1 WHERE ItemID='001' AND Quantity < 60 ORDER BY ItemID", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect_9496_1() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT items.item.ItemID, suppliers.supplier.*  FROM xmltest.doc9c  WHERE item.suppliers.supplier.SupplierID > '54'  ORDER BY  ITEMid DESC, items.item.suppliers.supplier.SupplierID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect_9496_2() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"003\">\r\n                <Suppliers>\r\n                    <Supplier>\r\n                        <Name>Microsoft</Name>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Suppliers>\r\n                    <Supplier>\r\n                        <Name>Nugent Co.</Name>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Name>Zeta</Name>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Name>Microsoft</Name>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Suppliers>\r\n                    <Supplier>\r\n                        <Name>Chucky</Name>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Name>Biff's Stuff</Name>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Name>AAAA</Name>\r\n                    </Supplier>\r\n                    <Supplier>\r\n                        <Name>Microsoft</Name>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT doc9c.Catalogs.catalog.items.item.ItemID, items.item.Suppliers,SuppliER.Name  FROM xmltest.doc9c  WHERE SupplierID > '54'  ORDER BY ItemID DESC", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect_9496_3() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"1\">\r\n                        <Name>KMart</Name>\r\n                        <Zip>12345</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"2\">\r\n                        <Name>Sun</Name>\r\n                        <Zip>94040</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"3\">\r\n                        <Name>Cisco</Name>\r\n                        <Zip>94041</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"4\">\r\n                        <Name>Doc</Name>\r\n                        <Zip>94042</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"5\">\r\n                        <Name>Excite</Name>\r\n                        <Zip>21098</Zip>\r\n                    </Order>\r\n                    <Order OrderID=\"6\">\r\n                        <Name>Yahoo</Name>\r\n                        <Zip>94043</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n                <Orders>\r\n                    <Order OrderID=\"7\">\r\n                        <Name>Inktomi</Name>\r\n                        <Zip>94044</Zip>\r\n                    </Order>\r\n                </Orders>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT item.itemID, items.item.*  FROM xmltest.doc9c  WHERE item.suppliers.supplier.SupplierID > '54'  ORDER BY  ITEMid, items.item.suppliers.supplier.SupplierID ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testCommentNodeInDoc() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Root><!--Comment1--><Something><!--Comment2--></Something>\r\n</Root>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc17", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect8917() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManager_8917(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc_8917", EXPECTED_DOC_DEFECT_8917_AND_11789, metadata, dataMgr);
    }

    @Test
    public void testNillableOptional() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items xsi:nil=\"true\"/></Catalog></Catalogs>";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1b WHERE ItemID='9999' ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNillableNonOptional() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items xsi:nil=\"true\"/></Catalog></Catalogs>";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1c WHERE ItemID='9999' ", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect11789() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManager_8917a(metadata);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name> </Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n    <OptionalCatalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name> </Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </OptionalCatalog>\r\n    <OptionalCatalog2>\r\n        <Items>\r\n            <Item>\r\n                <Name> </Name>\r\n            </Item>\r\n        </Items>\r\n    </OptionalCatalog2>\r\n    <OptionalCatalog3>\r\n        <Items>\r\n            <Item>\r\n                <Name> </Name>\r\n            </Item>\r\n        </Items>\r\n    </OptionalCatalog3>\r\n    <Catalog4>\r\n        <OptionalItems>\r\n            <Item>\r\n                <Name> </Name>\r\n            </Item>\r\n        </OptionalItems>\r\n    </Catalog4>\r\n    <Catalog5>\r\n        <OptionalItems>\r\n            <Item>\r\n                <FixedName>Nugent</FixedName>\r\n            </Item>\r\n        </OptionalItems>\r\n    </Catalog5>\r\n    <Catalog6/>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc_8917", expected, metadata, dataMgr);
    }

    @Test
    public void testDefect11789b() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManager_8917b(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc_8917", EXPECTED_DOC_DEFECT_8917_AND_11789, metadata, dataMgr);
    }

    @Test
    public void testDefect9446() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManager_8917(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item XXXXX=\"001\">\r\n                <XXXXX/>\r\n                <XXXXX>5</XXXXX>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc_9446", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect9446_2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManager_8917(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items/>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc_9446 WHERE Catalogs.Catalog.Items.Item.XXXXX = '001'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect_9530() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<mm:Catalogs xmlns:mm=\"http://www.duh.org/duh\">\r\n    <Catalog>\r\n        <Items>\r\n            <mm:Item xmlns:mm2=\"http://www.duh3.org/duh3\" xmlns:mm=\"http://www.duh2.org/duh2\"\r\n                     ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </mm:Item>\r\n            <mm:Item xmlns:mm2=\"http://www.duh3.org/duh3\" xmlns:mm=\"http://www.duh2.org/duh2\"\r\n                     ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </mm:Item>\r\n            <mm:Item xmlns:mm2=\"http://www.duh3.org/duh3\" xmlns:mm=\"http://www.duh2.org/duh2\"\r\n                     ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </mm:Item>\r\n        </Items>\r\n    </Catalog>\r\n</mm:Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc_9530", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSubqueryInXMLQueryCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE ItemID IN (SELECT itemNum FROM stock.items WHERE itemNum = '001')", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSubqueryInXMLQueryCriteria2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE ItemID > ANY (SELECT itemNum FROM stock.items WHERE itemNum IN ('001','002') )", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSubqueryInXMLQueryCriteria3() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE NOT (ItemID IN (SELECT itemNum FROM stock.items WHERE itemNum = '001') )", expectedDoc, metadata, dataMgr);
    }

    public void XXXtestSubqueryInXMLQueryCriteria4() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE EXISTS (SELECT itemNum FROM stock.items WHERE itemNum = '001')", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSubqueryInXMLQueryCriteriaNestedSubquery() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1 WHERE ItemID > ANY (SELECT itemNum FROM stock.items WHERE itemNum IN (SELECT itemNum FROM stock.items WHERE itemNum IN ('001','002') ) )", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSubqueryInXMLQueryCriteriaNestedMappingClass() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE ItemID > ANY (SELECT itemNum FROM stock.items WHERE itemNum IN ('001','002') )", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSubqueryInXMLQueryCriteriaNestedMappingClass2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE SupplierID > ANY (SELECT supplierNum FROM stock.suppliers WHERE supplierNum IN ('53','54') )", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSubqueryInXMLQueryCriteriaNestedMappingClass3() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE SupplierID < ALL (SELECT supplierNum FROM stock.suppliers WHERE supplierNum IN ('52','54') )", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSubqueryInXMLQueryCriteriaNestedMappingClass3a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE SupplierID IN (SELECT supplierNum FROM stock.suppliers WHERE supplierNum IN ('52') )", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testSubqueryInXMLQueryCriteriaNestedMappingClass4() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers/>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE context(SupplierID, SupplierID) < SOME (SELECT supplierNum FROM stock.suppliers WHERE supplierNum IN ('52','54') )", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testCritNestedMappingClass() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE SupplierID = '52'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect_9893() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Root>\r\n    <ItemName>Lamp</ItemName>\r\n    <ItemName>Screwdriver</ItemName>\r\n    <ItemName>Goat</ItemName>\r\n</Root>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc9893", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect_9893_2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Root>\r\n    <ItemName>Lamp</ItemName>\r\n    <ItemName>Screwdriver</ItemName>\r\n    <ItemName>Goat</ItemName>\r\n</Root>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemName FROM xmltest.doc9893", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect_9893_3() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Root>\r\n    <ItemName>Lamp</ItemName>\r\n    <ItemName>Screwdriver</ItemName>\r\n    <ItemName>Goat</ItemName>\r\n</Root>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemName.* FROM xmltest.doc9893", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect_9893_4() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadataNestedWithSibling();
        FakeDataManager dataMgr = this.exampleDataManagerNestedWithSibling(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item/>\r\n            <Item/>\r\n            <Item/>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        boolean SHOULD_SUCCEED = true;
        TestXMLProcessor.helpTestProcess("SELECT Item FROM xmltest.doc9c", expectedDoc, metadata, dataMgr, null);
    }

    @Test
    public void testNestedWithStoredQueryInMappingClass() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc18", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testWithSOAPEncoding1() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataSoap1();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerForSoap1(metadata, false);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<ORG:TaxReports xmlns:ORG=\"http://www.mm.org/dummy\">\r\n    <ORG:TaxReport>\r\n        <ORG:ArrayOfTaxID xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n                          xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"\r\n                          xsi:type=\"ORG:ArrayOfTaxIDType\"\r\n SOAP-ENC:arrayType=\"ORG:TaxIDType[]\">\r\n            <ORG:TaxID xsi:type=\"ORG:TaxIDType\">\r\n                <ID>1</ID>\r\n            </ORG:TaxID>\r\n            <ORG:TaxID xsi:type=\"ORG:TaxIDType\">\r\n                <ID>2</ID>\r\n            </ORG:TaxID>\r\n            <ORG:TaxID xsi:type=\"ORG:TaxIDType\">\r\n                <ID>3</ID>\r\n            </ORG:TaxID>\r\n        </ORG:ArrayOfTaxID>\r\n    </ORG:TaxReport>\r\n</ORG:TaxReports>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.docSoap", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testWithSOAPEncodingNoRows() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataSoap1();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerForSoap1(metadata, true);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<ORG:TaxReports xmlns:ORG=\"http://www.mm.org/dummy\">\r\n    <ORG:TaxReport/>\r\n</ORG:TaxReports>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.docSoap", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect12260() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <numSuppliers>4</numSuppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <numSuppliers>3</numSuppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <numSuppliers>1</numSuppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("convert", true);
        DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)caps);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc12260", metadata, dataMgr, null, (CapabilitiesFinder)capFinder, expectedDoc);
    }

    @Test
    public void testDefect8373() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerWithNulls(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8373", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect8373a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerWithNulls(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8373a", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect8373b() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerWithNulls(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"001\">\r\n                <Name/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity/>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8373b", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect13617() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager13617(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item>\r\n                <Name>Lamp</Name>\r\n            </Item>\r\n            <Item>\r\n                <Name>Screwdriver</Name>\r\n            </Item>\r\n            <Item>\r\n                <Name>Goat</Name>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT Item.Name FROM xmltest.doc13617", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect13617a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager13617(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n            </Item>\r\n            <Item ItemID=\"004\"/>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT ItemID, Item.Name FROM xmltest.doc13617", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect14905() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager14905(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\" \">\r\n                <Name> </Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"  \">\r\n                <Name>  </Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\" \">\r\n                <Name> </Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testTextUnnormalizedDefect15117() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager15117(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name> Lamp </Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>  Screw  driver  </Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name> Goat </Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testTextUnnormalizedDefect15117a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager15117a(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>\t \n&#xD;</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>  &gt;Screw&lt; \n driver  &amp;</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name> &gt;&gt;&#xD;Goat </Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc1", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testRecursiveGroupDoc() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata2();
        FakeDataManager dataMgr = TestXMLProcessor.exampleXQTDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<group>\r\n    <ID>2</ID>\r\n    <code>-1</code>\r\n    <supervisor>\r\n        <ID>4</ID>\r\n        <code>1</code>\r\n        <group>\r\n            <ID>6</ID>\r\n            <code>3</code>\r\n            <supervisor>\r\n                <ID>8</ID>\r\n                <code>5</code>\r\n                <group>\r\n                    <ID>10</ID>\r\n                    <code>7</code>\r\n                    <supervisor>\r\n                        <ID>12</ID>\r\n                        <code>9</code>\r\n                    </supervisor>\r\n                </group>\r\n            </supervisor>\r\n        </group>\r\n    </supervisor>\r\n</group>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xqttest.groupDoc WHERE pseudoID = 2", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testCase2951MaxRows() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect19173RowLimitException() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimitexception(supplier) = 4", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect19173RowLimitExceptionBackwardsCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE 4 = rowlimitexception(supplier)", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testCase2951MaxRows2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimit(supplier) = 2", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect19173RowLimitException2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimitexception(supplier) = 2", null, metadata, dataMgr, TeiidProcessingException.class);
    }

    @Test
    public void testCase2951MaxRows2a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimit(supplier) = 2 AND rowlimit(supplierid) = 2", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect19173RowLimitException2a() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimitexception(supplier) = 2 AND rowlimitexception(supplierid) = 2", null, metadata, dataMgr, TeiidProcessingException.class);
    }

    @Test
    public void testCase2951MaxRows3() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE ItemID='002' AND rowlimit(supplier) = 2", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testDefect19173RowLimitException3() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE ItemID='002' AND rowlimitexception(supplier) = 2", null, metadata, dataMgr, TeiidProcessingException.class);
    }

    @Test
    public void testCase2951MaxRows4() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimit(supplier) = 2 AND rowlimit(item) = 2", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testCase2951AndDefect19173MixTwoFunctions() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimit(supplier) = 2 AND rowlimitException(item) = 6", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testCase2951MaxRowsFails() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimit(catalogs) = 2", null, metadata, dataMgr, QueryPlannerException.class);
    }

    @Test
    public void testCase2951MaxRowsFails2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimit(supplier) = 2 AND rowlimit(supplierID) = 3", null, metadata, dataMgr, QueryPlannerException.class);
    }

    @Test
    public void testDefect19173RowLimitExceptionFails() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimitexception(catalogs) = 2", null, metadata, dataMgr, QueryPlannerException.class);
    }

    @Test
    public void testDefect19173RowLimitExceptionFails2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimitexception(supplier) = 2 AND rowlimitexception(supplierID) = 3", null, metadata, dataMgr, QueryPlannerException.class);
    }

    @Test
    public void testDefect19173RowLimitAndRowLimitExceptionMixFails2() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE rowlimit(supplier) = 2 AND rowlimitexception(supplierID) = 3", null, metadata, dataMgr, QueryPlannerException.class);
    }

    @Test
    public void testCase2951MaxRows5() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerNested(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.doc8 WHERE 2 = rowlimit(supplier)", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNormalizationCollapse() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerNormalization(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name xsi:nil=\"true\"/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>0</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <DiscontinuedItem ItemID=\"004\">\r\n                <Name>Flux Capacitor</Name>\r\n                <Quantity>2</Quantity>\r\n            </DiscontinuedItem>\r\n            <StatusUnknown ItemID=\"005\">\r\n                <Name>Milkshake</Name>\r\n                <Quantity>88</Quantity>\r\n            </StatusUnknown>\r\n            <DiscontinuedItem ItemID=\"006\">\r\n                <Name>Feta Matrix</Name>\r\n                <Quantity>0</Quantity>\r\n            </DiscontinuedItem>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.normDoc1", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNormalizationReplace() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerNormalization(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name xsi:nil=\"true\"/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>   Screwdriver       </Name>\r\n                <Quantity>0</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>         Goat  </Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <DiscontinuedItem ItemID=\"004\">\r\n                <Name>Flux     Capacitor</Name>\r\n                <Quantity>2</Quantity>\r\n            </DiscontinuedItem>\r\n            <StatusUnknown ItemID=\"005\">\r\n                <Name>Milkshake</Name>\r\n                <Quantity>88</Quantity>\r\n            </StatusUnknown>\r\n            <DiscontinuedItem ItemID=\"006\">\r\n                <Name> Feta               Matrix       </Name>\r\n                <Quantity>0</Quantity>\r\n            </DiscontinuedItem>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.normDoc2", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testNormalizationPreserve() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = this.exampleDataManagerNormalization2(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name xsi:nil=\"true\"/>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>My Screwdriver</Name>\r\n                <Quantity>0</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>My Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n            <DiscontinuedItem ItemID=\"004\">\r\n                <Name>My Flux Capacitor</Name>\r\n                <Quantity>2</Quantity>\r\n            </DiscontinuedItem>\r\n            <StatusUnknown ItemID=\"005\">\r\n                <Name>My Milkshake</Name>\r\n                <Quantity>88</Quantity>\r\n            </StatusUnknown>\r\n            <DiscontinuedItem ItemID=\"006\">\r\n                <Name>My Feta Matrix</Name>\r\n                <Quantity>0</Quantity>\r\n            </DiscontinuedItem>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.normDoc3", expectedDoc, metadata, dataMgr);
    }

    private FakeDataManager exampleDataManagerNormalization(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", null, new Integer(5), "okay"), Arrays.asList("002", " \n Screwdriver \t    \r", null, "okay"), Arrays.asList("003", "       \t\rGoat \n", new Integer(4), "okay"), Arrays.asList("004", "Flux \t\r\n Capacitor", new Integer(2), "discontinued"), Arrays.asList("005", "Milkshake", new Integer(88), null), Arrays.asList("006", " Feta               Matrix       ", new Integer(0), "discontinued")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    private FakeDataManager exampleDataManagerNormalization2(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("stock.items");
            List elementIDs = metadata.getElementIDsInGroupID(groupID);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("001", null, new Integer(5), "okay"), Arrays.asList("002", "My Screwdriver", null, "okay"), Arrays.asList("003", "My Goat", new Integer(4), "okay"), Arrays.asList("004", "My Flux Capacitor", new Integer(2), "discontinued"), Arrays.asList("005", "My Milkshake", new Integer(88), null), Arrays.asList("006", "My Feta Matrix", new Integer(0), "discontinued")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    private static MappingNode createXMLPlanNormalization(String normMode) {
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cat = root.addChildElement(new MappingElement("Catalog"));
        MappingElement items = cat.addChildElement(new MappingElement("Items"));
        MappingChoiceNode choice = items.addChoiceNode(new MappingChoiceNode());
        choice.setSource("xmltest.group.items");
        choice.setMaxOccurrs(-1);
        MappingCriteriaNode crit = choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'okay'", false));
        MappingElement item = crit.addChildElement(new MappingElement("Item"));
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNormalizeText(normMode).setNillable(true);
        item.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity")).setDefaultValue("0");
        MappingCriteriaNode crit2 = choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'discontinued'", false));
        MappingElement discontinuedItem = crit2.addChildElement(new MappingElement("DiscontinuedItem"));
        discontinuedItem.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        discontinuedItem.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNormalizeText(normMode).setNillable(true);
        discontinuedItem.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity")).setDefaultValue("0");
        MappingCriteriaNode crit3 = choice.addCriteriaNode(new MappingCriteriaNode());
        MappingElement unknownItem = crit3.addChildElement(new MappingElement("StatusUnknown"));
        unknownItem.addAttribute(new MappingAttribute("ItemID", "xmltest.group.items.itemNum"));
        unknownItem.addChildElement(new MappingElement("Name", "xmltest.group.items.itemName")).setNormalizeText(normMode).setNillable(true);
        unknownItem.addChildElement(new MappingElement("Quantity", "xmltest.group.items.itemQuantity")).setDefaultValue("0");
        MappingCriteriaNode notIncludedSibling = choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'something'", false));
        notIncludedSibling.setExclude(true);
        MappingCriteriaNode notIncludedSibling2 = choice.addCriteriaNode(new MappingCriteriaNode("xmltest.group.items.itemStatus = 'something'", false));
        notIncludedSibling2.setExclude(true);
        return doc;
    }

    static FakeDataManager exampleDataManagerCase3225(FakeMetadataFacade metadata) {
        FakeDataManager dataMgr = new FakeDataManager();
        try {
            FakeMetadataObject groupItems = (FakeMetadataObject)metadata.getGroupID("stock.items");
            FakeMetadataObject groupSuppliers = (FakeMetadataObject)metadata.getGroupID("stock.suppliers");
            FakeMetadataObject groupOrders = (FakeMetadataObject)metadata.getGroupID("stock.orders");
            FakeMetadataObject groupEmployees = (FakeMetadataObject)metadata.getGroupID("stock.employees");
            FakeMetadataObject groupItemSupplier = (FakeMetadataObject)metadata.getGroupID("stock.item_supplier");
            List elementIDs = metadata.getElementIDsInGroupID(groupItems);
            List elementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupSuppliers);
            List supplierElementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupOrders);
            List ordersElementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupEmployees);
            List employeesElementSymbols = TestXMLProcessor.createElements(elementIDs);
            elementIDs = metadata.getElementIDsInGroupID(groupItemSupplier);
            List itemSupplierElementSymbols = TestXMLProcessor.createElements(elementIDs);
            dataMgr.registerTuples(groupItems, elementSymbols, new List[]{Arrays.asList("001", "Lamp", new Integer(5), "okay"), Arrays.asList("002", "Screwdriver", new Integer(100), "okay"), Arrays.asList("003", "Goat", new Integer(4), "okay")});
            dataMgr.registerTuples(groupItemSupplier, itemSupplierElementSymbols, new List[]{Arrays.asList("001", "51"), Arrays.asList("001", "52"), Arrays.asList("001", "53"), Arrays.asList("001", "56"), Arrays.asList("002", "54"), Arrays.asList("002", "55"), Arrays.asList("002", "56"), Arrays.asList("003", "56")});
            dataMgr.registerTuples(groupSuppliers, supplierElementSymbols, new List[]{Arrays.asList("51", "Chucky", "11111"), Arrays.asList("52", "Biff's Stuff", "22222"), Arrays.asList("53", "AAAA", "33333"), Arrays.asList("54", "Nugent Co.", "44444"), Arrays.asList("55", "Zeta", "55555"), Arrays.asList("56", "Microsoft", "66666")});
            dataMgr.registerTuples(groupOrders, ordersElementSymbols, new List[]{Arrays.asList("1", "001", "51", "2/13/05", new Integer(2), "complete"), Arrays.asList("2", "001", "52", "3/13/05", new Integer(1), "processing"), Arrays.asList("3", "002", "53", "4/13/05", new Integer(1), "complete"), Arrays.asList("4", "002", "56", "5/13/05", new Integer(1), "cancelled"), Arrays.asList("5", "003", "56", "6/13/05", new Integer(800), "processing")});
            dataMgr.registerTuples(groupEmployees, employeesElementSymbols, new List[]{Arrays.asList("1001", "51", "001", "1004", "Albert", "Pujols"), Arrays.asList("1002", "51", "001", "1004", "Jim", "Edmunds"), Arrays.asList("1003", "54", "002", "1004", "David", "Eckstein"), Arrays.asList("1004", null, null, "1009", "Tony", "LaRussa"), Arrays.asList("1005", "56", "001", "1007", "Derrek", "Lee"), Arrays.asList("1006", "56", "003", "1007", "Corey", "Patterson"), Arrays.asList("1007", null, null, "1010", "Dusty", "Baker"), Arrays.asList("1008", "56", "002", "1007", "Carlos", "Zambrano"), Arrays.asList("1009", null, null, null, "Bill", "DeWitt"), Arrays.asList("1010", null, null, null, "Some", "Guy")});
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Exception building test data (" + e.getClass().getName() + "): " + e.getMessage()));
        }
        return dataMgr;
    }

    @Test
    public void testCase3225() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleCase3225();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerCase3225(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"51\">\r\n                        <Name>Chucky</Name>\r\n                        <Zip>11111</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"1\">\r\n                                <OrderDate>2/13/05</OrderDate>\r\n                                <OrderQuantity>2</OrderQuantity>\r\n                                <OrderStatus>complete</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                        <Employees>\r\n                            <Employee EmployeeID=\"1001\" SupervisorID=\"1004\">\r\n                                <FirstName>Albert</FirstName>\r\n                                <LastName>Pujols</LastName>\r\n                            </Employee>\r\n                            <Employee EmployeeID=\"1002\" SupervisorID=\"1004\">\r\n                                <FirstName>Jim</FirstName>\r\n                                <LastName>Edmunds</LastName>\r\n                            </Employee>\r\n                        </Employees>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"52\">\r\n                        <Name>Biff's Stuff</Name>\r\n                        <Zip>22222</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"2\">\r\n                                <OrderDate>3/13/05</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                        <Employees/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"53\">\r\n                        <Name>AAAA</Name>\r\n                        <Zip>33333</Zip>\r\n                        <Orders/>\r\n                        <Employees/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders/>\r\n                        <Employees>\r\n                            <Employee EmployeeID=\"1005\" SupervisorID=\"1007\">\r\n                                <FirstName>Derrek</FirstName>\r\n                                <LastName>Lee</LastName>\r\n                            </Employee>\r\n                        </Employees>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"54\">\r\n                        <Name>Nugent Co.</Name>\r\n                        <Zip>44444</Zip>\r\n                        <Orders/>\r\n                        <Employees>\r\n                            <Employee EmployeeID=\"1003\" SupervisorID=\"1004\">\r\n                                <FirstName>David</FirstName>\r\n                                <LastName>Eckstein</LastName>\r\n                            </Employee>\r\n                        </Employees>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"55\">\r\n                        <Name>Zeta</Name>\r\n                        <Zip>55555</Zip>\r\n                        <Orders/>\r\n                        <Employees/>\r\n                    </Supplier>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"4\">\r\n                                <OrderDate>5/13/05</OrderDate>\r\n                                <OrderQuantity>1</OrderQuantity>\r\n                                <OrderStatus>cancelled</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                        <Employees>\r\n                            <Employee EmployeeID=\"1008\" SupervisorID=\"1007\">\r\n                                <FirstName>Carlos</FirstName>\r\n                                <LastName>Zambrano</LastName>\r\n                            </Employee>\r\n                        </Employees>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n                <Suppliers>\r\n                    <Supplier SupplierID=\"56\">\r\n                        <Name>Microsoft</Name>\r\n                        <Zip>66666</Zip>\r\n                        <Orders>\r\n                            <Order OrderID=\"5\">\r\n                                <OrderDate>6/13/05</OrderDate>\r\n                                <OrderQuantity>800</OrderQuantity>\r\n                                <OrderStatus>processing</OrderStatus>\r\n                            </Order>\r\n                        </Orders>\r\n                        <Employees>\r\n                            <Employee EmployeeID=\"1006\" SupervisorID=\"1007\">\r\n                                <FirstName>Corey</FirstName>\r\n                                <LastName>Patterson</LastName>\r\n                            </Employee>\r\n                        </Employees>\r\n                    </Supplier>\r\n                </Suppliers>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("select * from xmltest.itemsdoc", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testCase3225WithCriteria() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleCase3225();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerCase3225(metadata);
        TestXMLProcessor.helpTestProcess("select * from xmltest.itemsdoc where employee.@supervisorID='1004' and order.orderquantity > 1", CASE_3225_WITH_CRITERIA_EXPECTED_DOC, metadata, dataMgr);
    }

    @Test
    public void testCase3225WithCriteriaReversed() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleCase3225();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerCase3225(metadata);
        TestXMLProcessor.helpTestProcess("select * from xmltest.itemsdoc where order.orderquantity > 1 and employee.@supervisorID='1004'", CASE_3225_WITH_CRITERIA_EXPECTED_DOC, metadata, dataMgr);
    }

    @Test
    public void testCase3225WithEmptyDocCriteria() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleCase3225();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerCase3225(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs>\r\n    <Catalog>\r\n        <Items/>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("select * from xmltest.itemsdoc where order.orderquantity > 1 and employee.@supervisorID='1004' and item.@itemid='002'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testBaseballPlayersDoc() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleCase3225();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerCase3225(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<BaseballPlayers>\r\n   <Player PlayerID=\"1001\">\r\n      <FirstName>Albert</FirstName>\r\n      <LastName>Pujols</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1002\">\r\n      <FirstName>Jim</FirstName>\r\n      <LastName>Edmunds</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1003\">\r\n      <FirstName>David</FirstName>\r\n      <LastName>Eckstein</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1005\">\r\n      <FirstName>Derrek</FirstName>\r\n      <LastName>Lee</LastName>\r\n      <Manager ManagerID=\"1007\">\r\n         <FirstName>Dusty</FirstName>\r\n         <LastName>Baker</LastName>\r\n         <Owner OwnerID=\"1010\">\r\n            <FirstName>Some</FirstName>\r\n            <LastName>Guy</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1006\">\r\n      <FirstName>Corey</FirstName>\r\n      <LastName>Patterson</LastName>\r\n      <Manager ManagerID=\"1007\">\r\n         <FirstName>Dusty</FirstName>\r\n         <LastName>Baker</LastName>\r\n         <Owner OwnerID=\"1010\">\r\n            <FirstName>Some</FirstName>\r\n            <LastName>Guy</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1008\">\r\n      <FirstName>Carlos</FirstName>\r\n      <LastName>Zambrano</LastName>\r\n      <Manager ManagerID=\"1007\">\r\n         <FirstName>Dusty</FirstName>\r\n         <LastName>Baker</LastName>\r\n         <Owner OwnerID=\"1010\">\r\n            <FirstName>Some</FirstName>\r\n            <LastName>Guy</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n</BaseballPlayers>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("select * from xmltest.playersDoc", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testBaseballPlayersDocCriteria() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleCase3225();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerCase3225(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<BaseballPlayers>\r\n   <Player PlayerID=\"1001\">\r\n      <FirstName>Albert</FirstName>\r\n      <LastName>Pujols</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1002\">\r\n      <FirstName>Jim</FirstName>\r\n      <LastName>Edmunds</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1003\">\r\n      <FirstName>David</FirstName>\r\n      <LastName>Eckstein</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n</BaseballPlayers>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("select * from xmltest.playersDoc where manager.@managerid = '1004'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testBaseballPlayersDocContextCriteria() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleCase3225();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManagerCase3225(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<BaseballPlayers>\r\n   <Player PlayerID=\"1001\">\r\n      <FirstName>Albert</FirstName>\r\n      <LastName>Pujols</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1002\">\r\n      <FirstName>Jim</FirstName>\r\n      <LastName>Edmunds</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1003\">\r\n      <FirstName>David</FirstName>\r\n      <LastName>Eckstein</LastName>\r\n      <Manager ManagerID=\"1004\">\r\n         <FirstName>Tony</FirstName>\r\n         <LastName>LaRussa</LastName>\r\n         <Owner OwnerID=\"1009\">\r\n            <FirstName>Bill</FirstName>\r\n            <LastName>DeWitt</LastName>\r\n         </Owner>\r\n      </Manager>\r\n   </Player>\r\n   <Player PlayerID=\"1005\">\r\n      <FirstName>Derrek</FirstName>\r\n      <LastName>Lee</LastName>\r\n   </Player>\r\n   <Player PlayerID=\"1006\">\r\n      <FirstName>Corey</FirstName>\r\n      <LastName>Patterson</LastName>\r\n   </Player>\r\n   <Player PlayerID=\"1008\">\r\n      <FirstName>Carlos</FirstName>\r\n      <LastName>Zambrano</LastName>\r\n   </Player>\r\n</BaseballPlayers>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("select * from xmltest.playersDoc where context(manager, owner.@ownerid) = '1009'", expectedDoc, metadata, dataMgr);
    }

    @Test
    public void testProcedureAndXML() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        TestXMLProcessor.helpTestProcess("call xmltest.vsp1()", expectedDoc, metadata, dataMgr);
    }

    public void defer_testMinMaxOnSourceNode() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        FakeDataManager dataMgr = TestXMLProcessor.exampleDataManager(metadata);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n    <Catalog>\r\n        <Items>\r\n            <Item ItemID=\"001\">\r\n                <Name>Lamp</Name>\r\n                <Quantity>5</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"002\">\r\n                <Name>Screwdriver</Name>\r\n                <Quantity>100</Quantity>\r\n            </Item>\r\n            <Item ItemID=\"003\">\r\n                <Name>Goat</Name>\r\n                <Quantity>4</Quantity>\r\n            </Item>\r\n        </Items>\r\n    </Catalog>\r\n</Catalogs>\r\n\r\n";
        try {
            TestXMLProcessor.helpTestProcess("SELECT * FROM xmltest.docBounded", expectedDoc, metadata, dataMgr);
            Assert.fail((String)"should have failed the document restrictions.");
        }
        catch (TeiidProcessingException e) {
            // empty catch block
        }
    }
}

