/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.symbol.AbstractCaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.TestCaseExpression;

public class TestSearchedCaseExpression
extends TestCase {
    public TestSearchedCaseExpression(String name) {
        super(name);
    }

    public static List getWhenCriteria(int criteria) {
        ArrayList<CompareCriteria> list = new ArrayList<CompareCriteria>();
        ElementSymbol x = new ElementSymbol("x");
        for (int i = 0; i < criteria; ++i) {
            list.add(new CompareCriteria((Expression)x, 1, (Expression)new Constant((Object)new Integer(i))));
        }
        return list;
    }

    public static List getAlphaWhenCriteria(int criteria) {
        ArrayList<CompareCriteria> list = new ArrayList<CompareCriteria>();
        ElementSymbol x = new ElementSymbol("x");
        for (int i = 0; i < criteria; ++i) {
            list.add(new CompareCriteria((Expression)x, 1, (Expression)new Constant((Object)String.valueOf((char)(97 + i)))));
        }
        return list;
    }

    public static SearchedCaseExpression example(int whens) {
        SearchedCaseExpression caseExpr = new SearchedCaseExpression(TestSearchedCaseExpression.getWhenCriteria(whens), TestCaseExpression.getThenExpressions(whens));
        caseExpr.setElseExpression((Expression)new Constant((Object)new Integer(9999)));
        return caseExpr;
    }

    public static SearchedCaseExpression example2(int whens) {
        SearchedCaseExpression caseExpr = new SearchedCaseExpression(TestSearchedCaseExpression.getAlphaWhenCriteria(whens), TestCaseExpression.getThenExpressions(whens));
        caseExpr.setElseExpression((Expression)new Constant((Object)new Integer(9999)));
        return caseExpr;
    }

    public static void helpTestWhenCriteria(SearchedCaseExpression caseExpr, int expectedWhens) {
        TestSearchedCaseExpression.assertEquals((int)expectedWhens, (int)caseExpr.getWhenCount());
        ElementSymbol x = new ElementSymbol("x");
        for (int i = 0; i < expectedWhens; ++i) {
            TestSearchedCaseExpression.assertEquals((Object)new CompareCriteria((Expression)x, 1, (Expression)new Constant((Object)new Integer(i))), (Object)caseExpr.getWhenCriteria(i));
        }
    }

    public void testGetWhenCount() {
        TestSearchedCaseExpression.assertEquals((int)1, (int)TestSearchedCaseExpression.example(1).getWhenCount());
        TestSearchedCaseExpression.assertEquals((int)2, (int)TestSearchedCaseExpression.example(2).getWhenCount());
        TestSearchedCaseExpression.assertEquals((int)3, (int)TestSearchedCaseExpression.example(3).getWhenCount());
        TestSearchedCaseExpression.assertEquals((int)4, (int)TestSearchedCaseExpression.example(4).getWhenCount());
    }

    public void testGetWhen() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(3);
        TestSearchedCaseExpression.assertNotNull((Object)expr.getWhen());
        TestSearchedCaseExpression.assertEquals((int)3, (int)expr.getWhen().size());
        try {
            expr.getWhen().add(new Object());
            TestSearchedCaseExpression.fail((String)"Should not be modifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetThen() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(3);
        TestSearchedCaseExpression.assertNotNull((Object)expr.getThen());
        TestSearchedCaseExpression.assertEquals((int)3, (int)expr.getThen().size());
        try {
            expr.getThen().add(new Object());
            TestSearchedCaseExpression.fail((String)"Should not be modifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testClone() {
        CompareCriteria c1 = new CompareCriteria((Expression)new ElementSymbol("abc"), 1, (Expression)new Constant((Object)new Integer(20000)));
        CompareCriteria c2 = new CompareCriteria((Expression)new ElementSymbol("xyz"), 1, (Expression)new Constant((Object)new Integer(30000)));
        ArrayList<CompareCriteria> whens = new ArrayList<CompareCriteria>();
        whens.add(c1);
        whens.add(c2);
        Constant const1 = new Constant((Object)"a");
        Constant const2 = new Constant((Object)"b");
        ArrayList<Constant> thens = new ArrayList<Constant>();
        thens.add(const1);
        thens.add(const2);
        Constant elseExpression = new Constant((Object)"c");
        SearchedCaseExpression expr = new SearchedCaseExpression(whens, thens);
        expr.setElseExpression((Expression)elseExpression);
        expr.setType(DataTypeManager.DefaultDataClasses.STRING);
        SearchedCaseExpression clone = (SearchedCaseExpression)expr.clone();
        TestSearchedCaseExpression.assertTrue((expr != clone ? 1 : 0) != 0);
        TestSearchedCaseExpression.assertEquals((int)2, (int)clone.getWhenCount());
        TestCaseExpression.helpTestStrictEquivalence(c1, clone.getWhenCriteria(0));
        TestCaseExpression.helpTestStrictEquivalence(expr.getWhenCriteria(0), clone.getWhenCriteria(0));
        TestCaseExpression.helpTestStrictEquivalence(c2, clone.getWhenCriteria(1));
        TestCaseExpression.helpTestStrictEquivalence(expr.getWhenCriteria(1), clone.getWhenCriteria(1));
        TestCaseExpression.helpTestStrictEquivalence(const1, clone.getThenExpression(0));
        TestCaseExpression.helpTestStrictEquivalence(expr.getThenExpression(0), clone.getThenExpression(0));
        TestCaseExpression.helpTestStrictEquivalence(const2, clone.getThenExpression(1));
        TestCaseExpression.helpTestStrictEquivalence(expr.getThenExpression(1), clone.getThenExpression(1));
        TestCaseExpression.helpTestStrictEquivalence(expr.getElseExpression(), clone.getElseExpression());
        TestSearchedCaseExpression.assertEquals((Object)expr.getType(), (Object)clone.getType());
        TestSearchedCaseExpression.assertEquals((boolean)expr.isResolved(), (boolean)clone.isResolved());
    }

    public void testGetWhenCriteria() {
        TestSearchedCaseExpression.helpTestWhenCriteria(TestSearchedCaseExpression.example(4), 4);
    }

    public void testSetWhen() {
        SearchedCaseExpression caseExpr = TestSearchedCaseExpression.example(4);
        try {
            caseExpr.setWhen(null, null);
            TestSearchedCaseExpression.fail((String)"Setting WHEN and THEN to null should have failed.");
        }
        catch (IllegalArgumentException e) {
            TestSearchedCaseExpression.helpTestWhenCriteria(caseExpr, 4);
            TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)caseExpr, 4);
        }
        try {
            caseExpr.setWhen(TestSearchedCaseExpression.getWhenCriteria(2), null);
            TestSearchedCaseExpression.fail((String)"Setting THEN to null should have failed.");
        }
        catch (IllegalArgumentException e) {
            TestSearchedCaseExpression.helpTestWhenCriteria(caseExpr, 4);
            TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)caseExpr, 4);
        }
        try {
            caseExpr.setWhen(null, TestCaseExpression.getThenExpressions(2));
            TestSearchedCaseExpression.fail((String)"Setting WHEN to null should have failed.");
        }
        catch (IllegalArgumentException e) {
            TestSearchedCaseExpression.helpTestWhenCriteria(caseExpr, 4);
            TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)caseExpr, 4);
        }
        try {
            caseExpr.setWhen(TestSearchedCaseExpression.getWhenCriteria(0), TestCaseExpression.getThenExpressions(0));
            TestSearchedCaseExpression.fail((String)"Setting WHEN and THEN to empty lists should have failed.");
        }
        catch (IllegalArgumentException e) {
            TestSearchedCaseExpression.helpTestWhenCriteria(caseExpr, 4);
            TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)caseExpr, 4);
        }
        try {
            caseExpr.setWhen(TestCaseExpression.getWhenExpressions(3), TestCaseExpression.getThenExpressions(3));
            TestSearchedCaseExpression.fail((String)"Setting WHEN non Criteria types should have failed.");
        }
        catch (IllegalArgumentException e) {
            TestSearchedCaseExpression.helpTestWhenCriteria(caseExpr, 4);
            TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)caseExpr, 4);
        }
        caseExpr.setWhen(TestSearchedCaseExpression.getWhenCriteria(3), TestSearchedCaseExpression.getWhenCriteria(3));
        ArrayList<CompareCriteria> whens = new ArrayList<CompareCriteria>();
        whens.add(new CompareCriteria((Expression)new ElementSymbol("abc"), 1, (Expression)new Constant((Object)new Integer(20000))));
        whens.add(new CompareCriteria((Expression)new ElementSymbol("xyz"), 1, (Expression)new Constant((Object)new Integer(30000))));
        ArrayList<Constant> thens = new ArrayList<Constant>();
        thens.add(new Constant((Object)new Integer(20000)));
        thens.add(new Constant((Object)new Integer(30000)));
        caseExpr.setWhen(whens, thens);
        TestSearchedCaseExpression.assertEquals((int)2, (int)caseExpr.getWhenCount());
        TestSearchedCaseExpression.assertEquals((Object)new CompareCriteria((Expression)new ElementSymbol("abc"), 1, (Expression)new Constant((Object)new Integer(20000))), (Object)caseExpr.getWhenCriteria(0));
        TestSearchedCaseExpression.assertEquals((Object)new CompareCriteria((Expression)new ElementSymbol("xyz"), 1, (Expression)new Constant((Object)new Integer(30000))), (Object)caseExpr.getWhenCriteria(1));
        TestSearchedCaseExpression.assertEquals((Object)new Constant((Object)new Integer(20000)), (Object)caseExpr.getThenExpression(0));
        TestSearchedCaseExpression.assertEquals((Object)new Constant((Object)new Integer(30000)), (Object)caseExpr.getThenExpression(1));
    }

    public void testIsResolved() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(3);
        TestSearchedCaseExpression.assertFalse((boolean)expr.isResolved());
        CompareCriteria crit = (CompareCriteria)expr.getWhenCriteria(0);
        ElementSymbol x = (ElementSymbol)crit.getLeftExpression();
        x.setType(String.class);
        x.setMetadataID((Object)"metadataID");
        expr.setType(Integer.class);
        TestSearchedCaseExpression.assertTrue((boolean)expr.isResolved());
    }

    public void testGetThenExpression() {
        TestCaseExpression.helpTestThenExpressions((AbstractCaseExpression)TestSearchedCaseExpression.example(3), 3);
    }

    public void testGetElseExpression() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(3);
        TestSearchedCaseExpression.assertEquals((Object)new Constant((Object)new Integer(9999)), (Object)expr.getElseExpression());
    }

    public void testSetElseExpression() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(3);
        expr.setElseExpression((Expression)new Constant((Object)new Integer(1000)));
        TestSearchedCaseExpression.assertEquals((Object)new Constant((Object)new Integer(1000)), (Object)expr.getElseExpression());
        expr.setElseExpression(null);
        TestSearchedCaseExpression.assertNull((Object)expr.getElseExpression());
    }

    public void testGetType() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(4);
        TestSearchedCaseExpression.assertNull((Object)expr.getType());
        expr.setType(Integer.class);
        TestSearchedCaseExpression.assertEquals(Integer.class, (Object)expr.getType());
    }

    public void testSetType() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(4);
        expr.setType(DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.BIG_DECIMAL, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.BIG_INTEGER);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.BIG_INTEGER, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.BLOB);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.BLOB, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.BOOLEAN, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.BYTE);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.BYTE, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.CHAR);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.CHAR, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.CLOB);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.CLOB, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.DATE);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.DATE, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.DOUBLE);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.DOUBLE, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.FLOAT);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.FLOAT, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.LONG);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.LONG, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.NULL);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.NULL, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.OBJECT);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.OBJECT, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.SHORT);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.SHORT, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.STRING);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.TIME);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.TIME, (Object)expr.getType());
        expr.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
        TestSearchedCaseExpression.assertEquals((Object)DataTypeManager.DefaultDataClasses.TIMESTAMP, (Object)expr.getType());
        expr.setType(null);
        TestSearchedCaseExpression.assertNull((Object)expr.getType());
    }

    public void testEquals() {
        SearchedCaseExpression sc1 = TestSearchedCaseExpression.example(3);
        TestSearchedCaseExpression.assertTrue((boolean)sc1.equals((Object)sc1));
        TestSearchedCaseExpression.assertTrue((boolean)sc1.equals(sc1.clone()));
        TestSearchedCaseExpression.assertTrue((boolean)sc1.clone().equals(sc1));
        TestSearchedCaseExpression.assertTrue((boolean)sc1.equals((Object)TestSearchedCaseExpression.example(3)));
        SearchedCaseExpression sc2 = TestSearchedCaseExpression.example(4);
        TestSearchedCaseExpression.assertFalse((boolean)sc1.equals((Object)sc2));
        TestSearchedCaseExpression.assertFalse((boolean)sc2.equals((Object)sc1));
        SearchedCaseExpression sc3 = TestSearchedCaseExpression.example(3);
        sc3.setElseExpression((Expression)new ElementSymbol("y"));
        TestSearchedCaseExpression.assertFalse((boolean)sc1.equals((Object)sc3));
        TestSearchedCaseExpression.assertFalse((boolean)sc3.equals((Object)sc1));
    }
}

