/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core;

import junit.framework.TestCase;
import org.teiid.core.TeiidException;

public class TestMetaMatrixException
extends TestCase {
    public TestMetaMatrixException(String name) {
        super(name);
    }

    public void testFailMetaMatrixExceptionWithNullMessage() {
        Throwable e = null;
        try {
            new TeiidException((String)null);
            TestMetaMatrixException.fail((String)"Should not get here");
        }
        catch (Throwable ex) {
            e = ex;
        }
        TestMetaMatrixException.assertNotNull((Object)e);
    }

    public void testMetaMatrixExceptionWithNullThrowable() {
        TeiidException err = new TeiidException((Throwable)null);
        TestMetaMatrixException.assertNull((Object)err.getChild());
        TestMetaMatrixException.assertNull((Object)err.getCode());
        TestMetaMatrixException.assertNull((Object)err.getMessage());
    }

    public void testMetaMatrixExceptionWithMessage() {
        TeiidException err = new TeiidException("Test");
        TestMetaMatrixException.assertNull((Object)err.getChild());
        TestMetaMatrixException.assertNull((Object)err.getCode());
        TestMetaMatrixException.assertEquals((String)"Test", (String)err.getMessage());
    }

    public void testMetaMatrixExceptionWithCodeAndMessage() {
        TeiidException err = new TeiidException("Code", "Test");
        TestMetaMatrixException.assertNull((Object)err.getChild());
        TestMetaMatrixException.assertEquals((String)"Code", (String)err.getCode());
        TestMetaMatrixException.assertEquals((String)"Error Code:Code Message:Test", (String)err.getMessage());
    }

    public void testMetaMatrixExceptionWithExceptionAndMessage() {
        TeiidException child = new TeiidException("propertyValuePhrase", "Child");
        TeiidException err = new TeiidException((Throwable)child, "Test");
        TestMetaMatrixException.assertSame((Object)((Object)child), (Object)err.getChild());
        TestMetaMatrixException.assertEquals((String)"propertyValuePhrase", (String)err.getCode());
        TestMetaMatrixException.assertEquals((String)"Error Code:propertyValuePhrase Message:Test", (String)err.getMessage());
    }

    public void testMetaMatrixExceptionWithExceptionAndCodeAndMessage() {
        TeiidException child = new TeiidException("propertyValuePhrase", "Child");
        TeiidException err = new TeiidException((Throwable)child, "Code", "Test");
        TestMetaMatrixException.assertSame((Object)((Object)child), (Object)err.getChild());
        TestMetaMatrixException.assertEquals((String)"Code", (String)err.getCode());
        TestMetaMatrixException.assertEquals((String)"Error Code:Code Message:Test", (String)err.getMessage());
    }
}

