/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.teiid.TeiidExecutionFactory;

public class TestDymamicImportedMetaData {
    private MetadataFactory getMetadata(Properties importProperties, Connection conn) throws TranslatorException {
        MetadataFactory mf = this.createMetadataFactory("test", importProperties);
        TeiidExecutionFactory tef = new TeiidExecutionFactory();
        tef.getMetadata(mf, conn);
        return mf;
    }

    private MetadataFactory createMetadataFactory(String schema, Properties importProperties) {
        VDBRepository vdbRepository = new VDBRepository();
        vdbRepository.setSystemStore(VDBMetadataFactory.getSystem());
        return new MetadataFactory(schema, vdbRepository.getBuiltinDatatypes(), importProperties);
    }

    @Test
    public void testProcImport() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB("vdb", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
        ConnectionImpl conn = server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importProcedures", Boolean.TRUE.toString());
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Procedure p = (Procedure)((Schema)mf.getMetadataStore().getSchemas().get("TEST")).getProcedures().get("VDB.SYS.GETXMLSCHEMAS");
        Assert.assertEquals((long)1L, (long)p.getResultSet().getColumns().size());
    }

    @Test
    public void testDuplicatException() throws Exception {
        FakeServer server = new FakeServer();
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        MetadataFactory mf1 = this.createMetadataFactory("y", new Properties());
        Table dup = mf.addTable("dup");
        Table dup1 = mf1.addTable("dup");
        mf.addColumn("x", "string", (ColumnSet)dup);
        mf1.addColumn("x", "string", (ColumnSet)dup1);
        MetadataStore ms = mf.getMetadataStore();
        ms.addSchema((Schema)mf1.getMetadataStore().getSchemas().values().iterator().next());
        server.deployVDB("test", ms, new LinkedHashMap<String, TransformationMetadata.Resource>());
        ConnectionImpl conn = server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        this.getMetadata(importProperties, (Connection)conn);
        Assert.assertNotNull(((Schema)mf.getMetadataStore().getSchemas().get("X")).getTables().get("DUP"));
        importProperties.setProperty("importer.useFullSchemaName", Boolean.FALSE.toString());
        try {
            this.getMetadata(importProperties, (Connection)conn);
            Assert.fail();
        }
        catch (TranslatorException e) {
            // empty catch block
        }
    }
}

