/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.handler.timeout.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.TransformationMetadata;

public class TestLocalConnections {
    static ReentrantLock lock = new ReentrantLock();
    static Condition waiting = lock.newCondition();
    static Condition wait = lock.newCondition();
    static FakeServer server = new FakeServer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int blocking() throws InterruptedException {
        lock.lock();
        try {
            waiting.signal();
            if (!wait.await(2L, TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
        }
        finally {
            lock.unlock();
        }
        return 1;
    }

    @BeforeClass
    public static void oneTimeSetup() {
        server.setUseCallingThread(true);
        MetadataStore ms = new MetadataStore();
        Schema s = new Schema();
        s.setName("test");
        FunctionMethod function = new FunctionMethod("foo", null, "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, TestLocalConnections.class.getName(), "blocking", new FunctionParameter[0], new FunctionParameter("result", "integer"), true, FunctionMethod.Determinism.NONDETERMINISTIC);
        s.addFunction(function);
        ms.addSchema(s);
        server.deployVDB("test", ms, new LinkedHashMap<String, TransformationMetadata.Resource>());
    }

    @AfterClass
    public static void oneTimeTearDown() {
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentExection() throws Throwable {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ConnectionImpl c = server.createConnection("jdbc:teiid:test");
                    Statement s = c.createStatement();
                    s.execute("select foo()");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        SimpleUncaughtExceptionHandler handler = new SimpleUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
        t.start();
        lock.lock();
        try {
            waiting.await();
        }
        finally {
            lock.unlock();
        }
        ConnectionImpl c = server.createConnection("jdbc:teiid:test");
        Statement s = c.createStatement();
        s.execute("select * from tables");
        lock.lock();
        try {
            wait.signal();
        }
        finally {
            lock.unlock();
        }
        t.join(2000L);
        if (t.isAlive()) {
            Assert.fail();
        }
        if (handler.t != null) {
            throw handler.t;
        }
    }

    private final class SimpleUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        Throwable t;

        private SimpleUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread arg0, Throwable arg1) {
            this.t = arg1;
        }
    }
}

