/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.postgresql.Driver;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionProfile;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TestMMDatabaseMetaData;
import org.teiid.transport.ODBCSocketListener;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;

public class TestODBCSocketTransport {
    static InetSocketAddress addr;
    static ODBCSocketListener odbcTransport;
    Connection conn;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        SocketConfiguration config = new SocketConfiguration();
        config.setSSLConfiguration(new SSLConfiguration());
        addr = new InetSocketAddress(0);
        config.setBindAddress(addr.getHostName());
        config.setPortNumber(0);
        odbcTransport = new ODBCSocketListener(config, (StorageManager)BufferManagerFactory.getStandaloneBufferManager(), 0, 100000);
        FakeServer server = new FakeServer();
        server.setUseCallingThread(false);
        server.deployVDB("parts", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        TeiidDriver driver = new TeiidDriver();
        driver.setEmbeddedProfile((ConnectionProfile)server);
        odbcTransport.setDriver(driver);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        if (odbcTransport != null) {
            odbcTransport.stop();
        }
    }

    @Before
    public void setUp() throws Exception {
        Driver d = new Driver();
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        this.conn = d.connect("jdbc:postgresql://" + addr.getHostName() + ":" + odbcTransport.getPort() + "/parts", p);
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test
    public void testSelect() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        TestMMDatabaseMetaData.compareResultSet(s.getResultSet());
    }

    @Test
    public void testBlob() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select to_bytes('abc', 'UTF-16')"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        byte[] bytes = rs.getBytes(1);
        Assert.assertEquals((Object)"abc", (Object)new String(bytes, Charset.forName("UTF-16")));
    }

    @Test
    public void testClob() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select cast('abc' as clob)"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String clob = rs.getString(1);
        Assert.assertEquals((Object)"abc", (Object)clob);
    }

    @Test
    public void testTransactionCycle() throws Exception {
        this.conn.setAutoCommit(false);
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        this.conn.setAutoCommit(true);
    }

    @Test
    public void testPk() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = E'pg_attribute' AND n.nspname = E'pg_catalog'");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testPkPrepared() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = E'pg_attribute' AND n.nspname = E'pg_catalog'");
        ResultSet rs = stmt.executeQuery();
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testPreparedError() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select cast(? as integer)");
        stmt.setString(1, "a");
        try {
            stmt.executeQuery();
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Error converting"));
        }
    }

    @Test
    public void testPreparedError1() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select");
        try {
            stmt.executeQuery();
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Parsing error"));
        }
    }

    @Test
    public void testEscapedLiteral() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select E'\\n\\thello pg'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"\n\thello pg", (Object)rs.getString(1));
    }

    @Test
    public void testPgProc() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select * from pg_proc");
        rs.next();
        Assert.assertEquals((Object)"oid", (Object)rs.getArray("proargtypes").getBaseTypeName());
    }

    @Test
    public void testPgProcedure() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select has_function_privilege(100, 'foo')");
        rs.next();
    }
}

