/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.util.ResultsFuture;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.StatementImpl;

public class TestStatement {
    @Test
    public void testBatchExecution() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        ResultsFuture results = new ResultsFuture();
        Mockito.stub((Object)dqp.executeRequest(Mockito.anyLong(), (RequestMessage)Mockito.anyObject())).toReturn((Object)results);
        ResultsMessage rm = new ResultsMessage();
        rm.setResults(new List[]{Arrays.asList(1), Arrays.asList(2)});
        rm.setUpdateResult(true);
        results.getResultsReceiver().receiveResults((Object)rm);
        Mockito.stub((Object)conn.getDQP()).toReturn((Object)dqp);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        statement.addBatch("delete from table");
        statement.addBatch("delete from table1");
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 2}, statement.executeBatch()));
    }

    @Test
    public void testSetStatement() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertFalse((boolean)statement.execute("set foo bar"));
        Assert.assertEquals((Object)"bar", (Object)p.get("foo"));
    }

    @Test
    public void testPropertiesOverride() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        p.setProperty("ansiQuotedIdentifiers", Boolean.TRUE.toString());
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)statement.getExecutionProperty("ansiQuotedIdentifiers"));
        statement.setExecutionProperty("ansiQuotedIdentifiers", Boolean.FALSE.toString());
        Assert.assertEquals((Object)Boolean.FALSE.toString(), (Object)statement.getExecutionProperty("ansiQuotedIdentifiers"));
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)p.getProperty("ansiQuotedIdentifiers"));
    }

    @Test
    public void testTransactionStatements() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertFalse((boolean)statement.execute("start transaction"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setAutoCommit(false);
        Assert.assertFalse((boolean)statement.execute("commit"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setAutoCommit(true);
        Assert.assertFalse((boolean)statement.execute("start transaction"));
        Assert.assertFalse((boolean)statement.execute("rollback"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).rollback(false);
    }

    @Test
    public void testTransactionStatementsAsynch() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.stub((Object)conn.submitSetAutoCommitTrue(Mockito.anyBoolean())).toReturn((Object)ResultsFuture.NULL_FUTURE);
        Properties p = new Properties();
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        statement.submitExecute("start transaction");
        ((ConnectionImpl)Mockito.verify((Object)conn)).setAutoCommit(false);
        statement.submitExecute("commit");
        ((ConnectionImpl)Mockito.verify((Object)conn)).submitSetAutoCommitTrue(true);
        statement.submitExecute("start transaction");
        statement.submitExecute("rollback");
        ((ConnectionImpl)Mockito.verify((Object)conn)).submitSetAutoCommitTrue(false);
    }

    @Test
    public void testAsynchTimeout() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        statement.setQueryTimeoutMS(1);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        Mockito.stub((Object)statement.getDQP()).toReturn((Object)dqp);
        ResultsFuture future = new ResultsFuture();
        Mockito.stub((Object)dqp.executeRequest(Mockito.anyLong(), (RequestMessage)Mockito.anyObject())).toReturn((Object)future);
        statement.submitExecute("select 'hello world'");
        Thread.sleep(100L);
        ((DQP)Mockito.verify((Object)dqp)).cancelRequest(0L);
    }
}

