/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.cache.DefaultCache;

public class TestDefaultCache {
    @Test
    public void testExpiration() throws InterruptedException {
        DefaultCache cache = new DefaultCache("foo", 2, 70L);
        cache.put((Object)1, (Object)1);
        Thread.sleep(100L);
        Assert.assertNull((Object)cache.get((Object)1));
        cache.put((Object)2, (Object)2);
        Thread.sleep(50L);
        cache.put((Object)3, (Object)3);
        Assert.assertNotNull((Object)cache.get((Object)2));
        Thread.sleep(50L);
        cache.put((Object)4, (Object)4);
        Assert.assertNotNull((Object)cache.get((Object)3));
    }

    @Test
    public void testExpirationAtMaxSize() throws Exception {
        DefaultCache cache = new DefaultCache("foo", 2, 70L);
        cache.put((Object)1, (Object)1);
        cache.put((Object)2, (Object)2);
        cache.put((Object)3, (Object)3);
        Assert.assertEquals((long)2L, (long)cache.getCacheMap().size());
        Assert.assertEquals((long)2L, (long)cache.getExpirationQueue().size());
        Thread.sleep(100L);
        cache.put((Object)4, (Object)4);
        cache.put((Object)5, (Object)5);
        cache.get((Object)4);
        cache.put((Object)6, (Object)6);
        Assert.assertEquals((long)2L, (long)cache.getCacheMap().size());
        Assert.assertEquals((long)2L, (long)cache.getExpirationQueue().size());
        Assert.assertNotNull((Object)cache.get((Object)4));
        Assert.assertNotNull((Object)cache.get((Object)6));
    }

    @Test
    public void testZeroSize() throws Exception {
        DefaultCache cache = new DefaultCache("foo", 0, 70L);
        cache.put((Object)1, (Object)1);
        Assert.assertEquals((long)0L, (long)cache.size());
    }
}

