/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.UnitTestUtil;

public class TestFileStorageManager {
    static Random r = new Random();

    public FileStorageManager getStorageManager(Integer maxFileSize, Integer openFiles, String dir) throws TeiidComponentException {
        FileStorageManager sm = new FileStorageManager();
        sm.setStorageDirectory(UnitTestUtil.getTestScratchPath() + (dir != null ? File.separator + dir : ""));
        if (maxFileSize != null) {
            sm.setMaxFileSizeDirect((long)maxFileSize.intValue());
        }
        if (openFiles != null) {
            sm.setMaxOpenFiles(openFiles.intValue());
        }
        sm.initialize();
        return sm;
    }

    @Test
    public void testWrite() throws Exception {
        FileStorageManager sm = this.getStorageManager(null, null, null);
        String tsID = "0";
        FileStore store = sm.createFileStore(tsID);
        this.writeBytes(store);
        Assert.assertEquals((long)2048L, (long)sm.getUsedBufferSpace());
        store.remove();
        Assert.assertEquals((long)0L, (long)sm.getUsedBufferSpace());
    }

    @Test
    public void testCreatesSpillFiles() throws Exception {
        FileStorageManager sm = this.getStorageManager(1024, null, null);
        String tsID = "0";
        FileStore store = sm.createFileStore(tsID);
        this.writeBytes(store);
        Map cache = sm.getFileCache();
        Assert.assertEquals((long)1L, (long)cache.size());
        this.writeBytes(store);
        Assert.assertEquals((long)2L, (long)cache.size());
        store.remove();
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    @Test(expected=TeiidComponentException.class)
    public void testMaxSpace() throws Exception {
        FileStorageManager sm = this.getStorageManager(null, null, null);
        sm.setMaxBufferSpace(1L);
        String tsID = "0";
        FileStore store = sm.createFileStore(tsID);
        this.writeBytes(store);
    }

    @Test
    public void testFlush() throws Exception {
        FileStorageManager sm = this.getStorageManager(null, null, null);
        FileStore store = sm.createFileStore("0");
        FileStore.FileStoreOutputStream fsos = store.createOutputStream(2);
        fsos.write(new byte[3]);
        fsos.write(1);
        fsos.flush();
        Assert.assertEquals((long)0L, (long)fsos.getCount());
    }

    private void writeBytes(FileStore store) throws TeiidComponentException {
        byte[] bytes = new byte[2048];
        r.nextBytes(bytes);
        long start = store.write(bytes, 0, bytes.length);
        byte[] bytesRead = new byte[2048];
        store.readFully(start, bytesRead, 0, bytesRead.length);
        Assert.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
    }

    @Test
    public void testWritingMultipleFiles() throws Exception {
        FileStorageManager sm = this.getStorageManager(1024, null, null);
        String tsID = "0";
        FileStore store = sm.createFileStore(tsID);
        String contentOrig = new String("some file content this will stored in same tmp file with another");
        OutputStream out = store.createOutputStream();
        out.write(contentOrig.getBytes(), 0, contentOrig.getBytes().length);
        out.close();
        out = store.createOutputStream();
        long start = store.getLength();
        byte[] bytesOrig = new byte[2048];
        r.nextBytes(bytesOrig);
        out.write(bytesOrig, 0, 2048);
        byte[] readContent = new byte[2048];
        InputStream in = store.createInputStream(0L, (long)contentOrig.getBytes().length);
        int c = in.read(readContent, 0, 3000);
        Assert.assertEquals((Object)contentOrig, (Object)new String(readContent, 0, c));
        c = in.read(readContent, 0, 3000);
        Assert.assertEquals((long)-1L, (long)c);
        in.close();
        in = store.createInputStream(start, 2048L);
        c = in.read(readContent, 0, 3000);
        Assert.assertTrue((boolean)Arrays.equals(bytesOrig, readContent));
        c = in.read(readContent, 0, 3000);
        Assert.assertEquals((long)-1L, (long)c);
        in.close();
    }
}

