/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import junit.framework.TestCase;
import org.teiid.dqp.internal.datamgr.TestGroupImpl;
import org.teiid.dqp.internal.datamgr.TstLanguageBridgeFactory;
import org.teiid.language.ColumnReference;
import org.teiid.language.NamedTable;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.FakeMetadataObject;

public class TestElementImpl
extends TestCase {
    public TestElementImpl(String name) {
        super(name);
    }

    public static ElementSymbol helpExample(String groupName, String elementName) {
        ElementSymbol symbol = new ElementSymbol(elementName);
        symbol.setType(String.class);
        symbol.setGroupSymbol(TestGroupImpl.helpExample(groupName));
        FakeMetadataObject obj = new FakeMetadataObject(groupName + "." + elementName, "Element");
        obj.putProperty("group", new FakeMetadataObject(groupName, "Group"));
        obj.putProperty("length", "3");
        symbol.setMetadataID((Object)obj);
        return symbol;
    }

    public static ElementSymbol helpIntExample(String groupName, String elementName) {
        ElementSymbol symbol = new ElementSymbol(elementName);
        symbol.setType(Integer.class);
        symbol.setGroupSymbol(TestGroupImpl.helpExample(groupName));
        FakeMetadataObject obj = new FakeMetadataObject(groupName + "." + elementName, "Element");
        obj.putProperty("group", new FakeMetadataObject(groupName, "Group"));
        obj.putProperty("length", "3");
        symbol.setMetadataID((Object)obj);
        return symbol;
    }

    public static ElementSymbol helpExample(String groupName, String elementName, Object metadataID) {
        ElementSymbol symbol = new ElementSymbol(elementName);
        symbol.setGroupSymbol(TestGroupImpl.helpExample(groupName));
        symbol.setType(Integer.class);
        symbol.setMetadataID(metadataID);
        return symbol;
    }

    public static ColumnReference example(String groupName, String elementName) throws Exception {
        return TstLanguageBridgeFactory.factory.translate(TestElementImpl.helpExample(groupName, elementName));
    }

    public static ColumnReference example(String groupName, String elementName, Object metadataID) throws Exception {
        return TstLanguageBridgeFactory.factory.translate(TestElementImpl.helpExample(groupName, elementName, metadataID));
    }

    public void testGetName() throws Exception {
        Object metadataID = TstLanguageBridgeFactory.metadata.getElementID("pm1.g1.e1");
        TestElementImpl.assertEquals((String)"pm1.g1.e1", (String)TestElementImpl.example("pm1.g1", "e1", metadataID).getName());
    }

    public void testGetGroup() throws Exception {
        Object metadataID = TstLanguageBridgeFactory.metadata.getElementID("pm1.g1.e1");
        TestElementImpl.assertNotNull((Object)TestElementImpl.example("pm1.g1", "e1", metadataID).getTable());
    }

    public void testGetType() throws Exception {
        Object metadataID = TstLanguageBridgeFactory.metadata.getElementID("pm1.g1.e2");
        TestElementImpl.assertTrue((boolean)TestElementImpl.example("pm1.g1", "e2", metadataID).getType().equals(Integer.class));
    }

    public void helpTestEquals(ColumnReference e1, ColumnReference e2, boolean equal) {
        boolean actual = e1.equals(e2);
        boolean actual2 = e2.equals(e1);
        TestElementImpl.assertEquals((String)"e1.equals(e2) != e2.equals(e1)", (boolean)actual, (boolean)actual2);
        TestElementImpl.assertEquals((String)"Did not get expected equal value", (boolean)equal, (boolean)actual);
    }

    public NamedTable createGroup(String context, String definition) {
        return new NamedTable(context, definition, null);
    }

    public ColumnReference createElement(NamedTable group, String name) {
        return new ColumnReference(group, name, null, String.class);
    }
}

