/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.teiid.dqp.internal.datamgr.TestElementImpl;
import org.teiid.dqp.internal.datamgr.TestGroupImpl;
import org.teiid.dqp.internal.datamgr.TestLiteralImpl;
import org.teiid.dqp.internal.datamgr.TestSearchedCaseExpressionImpl;
import org.teiid.dqp.internal.datamgr.TstLanguageBridgeFactory;
import org.teiid.language.ColumnReference;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SearchedCaseExpression;

public class TestInsertImpl
extends TestCase {
    public TestInsertImpl(String name) {
        super(name);
    }

    public static org.teiid.query.sql.lang.Insert helpExample(String groupName) {
        GroupSymbol group = TestGroupImpl.helpExample(groupName);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(TestElementImpl.helpExample(groupName, "e1"));
        elements.add(TestElementImpl.helpExample(groupName, "e2"));
        elements.add(TestElementImpl.helpExample(groupName, "e3"));
        elements.add(TestElementImpl.helpExample(groupName, "e4"));
        ArrayList<Constant> values = new ArrayList<Constant>();
        values.add(TestLiteralImpl.helpExample(1));
        values.add(TestLiteralImpl.helpExample(2));
        values.add(TestLiteralImpl.helpExample(3));
        values.add(TestLiteralImpl.helpExample(4));
        return new org.teiid.query.sql.lang.Insert(group, elements, values);
    }

    public static org.teiid.query.sql.lang.Insert helpExample2(String groupName) {
        GroupSymbol group = TestGroupImpl.helpExample(groupName);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(TestElementImpl.helpExample(groupName, "e1"));
        ArrayList<SearchedCaseExpression> values = new ArrayList<SearchedCaseExpression>();
        values.add(TestSearchedCaseExpressionImpl.helpExample());
        return new org.teiid.query.sql.lang.Insert(group, elements, values);
    }

    public static Insert example(String groupName) throws Exception {
        return TstLanguageBridgeFactory.factory.translate(TestInsertImpl.helpExample(groupName));
    }

    public static Insert example2(String groupName) throws Exception {
        return TstLanguageBridgeFactory.factory.translate(TestInsertImpl.helpExample2(groupName));
    }

    public void testGetGroup() throws Exception {
        TestInsertImpl.assertNotNull((Object)TestInsertImpl.example("a.b").getTable());
    }

    public void testGetElements() throws Exception {
        Insert insert = TestInsertImpl.example("a.b");
        TestInsertImpl.assertNotNull((Object)insert.getColumns());
        TestInsertImpl.assertEquals((int)4, (int)insert.getColumns().size());
        Iterator i = insert.getColumns().iterator();
        while (i.hasNext()) {
            TestInsertImpl.assertTrue((boolean)(i.next() instanceof ColumnReference));
        }
        String sInsertSQL = insert.toString();
        TestInsertImpl.assertTrue((sInsertSQL.substring(sInsertSQL.indexOf(40)).indexOf(46) == -1 ? 1 : 0) != 0);
    }

    public void testGetValues() throws Exception {
        Insert insert = TestInsertImpl.example("a.b");
        TestInsertImpl.assertNotNull((Object)insert.getValueSource());
        TestInsertImpl.assertEquals((int)4, (int)((ExpressionValueSource)insert.getValueSource()).getValues().size());
        Iterator i = ((ExpressionValueSource)insert.getValueSource()).getValues().iterator();
        while (i.hasNext()) {
            TestInsertImpl.assertTrue((boolean)(i.next() instanceof Expression));
        }
    }

    public void testExpressionsInInsert() throws Exception {
        Insert insert = TestInsertImpl.example2("a.b");
        TestInsertImpl.assertNotNull((Object)insert.getColumns());
        TestInsertImpl.assertEquals((int)1, (int)insert.getColumns().size());
        Iterator i = insert.getColumns().iterator();
        while (i.hasNext()) {
            TestInsertImpl.assertTrue((boolean)(i.next() instanceof ColumnReference));
        }
        TestInsertImpl.assertNotNull((Object)insert.getValueSource());
        TestInsertImpl.assertEquals((int)1, (int)((ExpressionValueSource)insert.getValueSource()).getValues().size());
        i = ((ExpressionValueSource)insert.getValueSource()).getValues().iterator();
        while (i.hasNext()) {
            TestInsertImpl.assertTrue((boolean)(i.next() instanceof Expression));
        }
    }
}

