/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.client.RequestMessage;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataRoleAuthorizationValidator;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.PreparedStatementRequest;
import org.teiid.dqp.internal.process.Request;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestRequest
extends TestCase {
    private static final TempTableStore TEMP_TABLE_STORE = new TempTableStore("1");
    private static final String QUERY = "SELECT * FROM pm1.g1";

    public TestRequest(String name) {
        super(name);
    }

    public void testValidateEntitlement() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Request request = new Request();
        Command command = QueryParser.getQueryParser().parseCommand(QUERY);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        RequestMessage message = new RequestMessage();
        DQPWorkContext workContext = FakeMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, FakeMetadataFactory.example1VDB());
        request.initialize(message, null, null, (TransactionService)new FakeTransactionService(), TEMP_TABLE_STORE, workContext, null);
        request.initMetadata();
        request.setAuthorizationValidator((AuthorizationValidator)new DataRoleAuthorizationValidator(true, true, true));
        request.validateAccess(command);
    }

    public void testProcessRequest() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        RequestMessage message = new RequestMessage(QUERY);
        DQPWorkContext workContext = FakeMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, FakeMetadataFactory.example1VDB());
        this.helpProcessMessage(message, null, workContext);
        message = new RequestMessage(QUERY);
        this.helpProcessMessage(message, null, workContext);
    }

    public void testCommandContext() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        RequestMessage message = new RequestMessage(QUERY);
        DQPWorkContext workContext = FakeMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, FakeMetadataFactory.example1VDB());
        Request request = this.helpProcessMessage(message, null, workContext);
        TestRequest.assertEquals((Object)"1", (Object)request.context.getEnvironmentProperties().get("sessionid"));
    }

    private Request helpProcessMessage(RequestMessage message, SessionAwareCache<PreparedPlan> cache, DQPWorkContext workContext) throws TeiidComponentException, TeiidProcessingException {
        Object request = null;
        request = cache != null ? new PreparedStatementRequest(cache) : new Request();
        ConnectorManagerRepository repo = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        workContext.getVDB().addAttchment(ConnectorManagerRepository.class, (Object)repo);
        Mockito.stub((Object)repo.getConnectorManager(Mockito.anyString())).toReturn((Object)new AutoGenDataService());
        request.initialize(message, (BufferManager)Mockito.mock(BufferManager.class), (ProcessorDataManager)new FakeDataManager(), (TransactionService)new FakeTransactionService(), TEMP_TABLE_STORE, workContext, null);
        request.setAuthorizationValidator((AuthorizationValidator)new DataRoleAuthorizationValidator(false, true, true));
        request.processRequest();
        return request;
    }

    public void testProcessRequestPreparedStatement() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        SessionAwareCache cache = new SessionAwareCache();
        RequestMessage message = new RequestMessage(QUERY);
        DQPWorkContext workContext = FakeMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, FakeMetadataFactory.example1VDB());
        message.setStatementType(RequestMessage.StatementType.PREPARED);
        message.setParameterValues(new ArrayList());
        this.helpProcessMessage(message, (SessionAwareCache<PreparedPlan>)cache, workContext);
        message = new RequestMessage(QUERY);
        message.setStatementType(RequestMessage.StatementType.PREPARED);
        message.setParameterValues(new ArrayList());
        this.helpProcessMessage(message, (SessionAwareCache<PreparedPlan>)cache, workContext);
    }
}

