/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.dqp.internal.process.AbstractWorkItem;

public class TestWorkItemState {
    @Test
    public void testInitialState() {
        TestWorkItem item = new TestWorkItem();
        item.assertMoreWorkState();
    }

    @Test
    public void testGotoIdleState() {
        TestWorkItem item = new TestWorkItem();
        item.run();
        item.assertIdleState();
    }

    @Test
    public void testGotoMoreWorkState() {
        TestWorkItem item = new TestWorkItem();
        item.run();
        item.moreWork();
        item.assertMoreWorkState();
    }

    @Test
    public void testGotoWorkingState() {
        TestWorkItem item = new TestWorkItem();
        item.run();
        item.moreWork();
        item.run();
    }

    @Test
    public void testResume() {
        TestWorkItem item = new TestWorkItem();
        item.run();
        Assert.assertFalse((boolean)item.resumed);
        item.moreWork();
        Assert.assertTrue((boolean)item.resumed);
    }

    @Test
    public void testResumeDuringWorking() {
        TestWorkItem item = new TestWorkItem(false, true);
        Assert.assertFalse((boolean)item.resumed);
        item.run();
        Assert.assertTrue((boolean)item.resumed);
    }

    @Test
    public void testRunAfterDone() {
        TestWorkItem item = new TestWorkItem(true, false);
        item.run();
        item.assertDoneState();
        try {
            item.run();
            Assert.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRunDuringIdle() {
        TestWorkItem item = new TestWorkItem();
        item.run();
        item.assertIdleState();
        try {
            item.run();
            Assert.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private class TestWorkItem
    extends AbstractWorkItem {
        private boolean isDone;
        private boolean callMoreWork;
        private boolean resumed;

        private TestWorkItem() {
            this(false, false);
        }

        private TestWorkItem(boolean done, boolean callMoreWork) {
            super(false);
            this.isDone = done;
            this.callMoreWork = callMoreWork;
        }

        protected boolean isDoneProcessing() {
            return this.isDone;
        }

        protected void process() {
            this.assertWorkingState();
            if (this.callMoreWork) {
                this.moreWork();
            }
        }

        protected void resumeProcessing() {
            this.resumed = true;
        }

        public String toString() {
            return "TestItem";
        }

        private void checkState(AbstractWorkItem.ThreadState expectedState) {
            Assert.assertEquals((Object)expectedState, (Object)this.getThreadState());
        }

        private void assertIdleState() {
            this.checkState(AbstractWorkItem.ThreadState.IDLE);
        }

        private void assertMoreWorkState() {
            this.checkState(AbstractWorkItem.ThreadState.MORE_WORK);
        }

        private void assertWorkingState() {
            this.checkState(AbstractWorkItem.ThreadState.WORKING);
        }

        private void assertDoneState() {
            this.checkState(AbstractWorkItem.ThreadState.DONE);
        }
    }
}

