/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestSortOptimization {
    @Test
    public void testSortDupCombination() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select distinct e1, e2 from pm1.g1 order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortDupCombination1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select e1, e2 from pm1.g1 union select e1, e2 from pm1.g2 order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1", "SELECT e1, e2 FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortDupCombination2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select x.*, y.* from (select distinct e1, e2 from pm1.g1) x, (select distinct e1, e2 from pm1.g2) y where x.e1 = y.e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1", "SELECT e1, e2 FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{0}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testGroupDupCombination() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select max(e1), e2 from (select distinct e1, e2 from pm1.g1) x group by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{0}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortGroupCombination() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select max(e1), e2 from pm1.g1 x group by e2 order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{0}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testProjectionRaisingWithLimit() {
        String sql = "select e1, (select e1 from pm2.g1 where e2 = x.e2) from pm1.g1 as x order by e1 limit 2";
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, true);
        Assert.assertTrue((boolean)(plan.getRootNode() instanceof ProjectNode));
    }

    @Test
    public void testProjectionRaisingWithLimit1() {
        String sql = "select (select e1 from pm2.g1 where e2 = x.e2) as z from pm1.g1 as x order by z limit 2";
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), new String[]{"SELECT pm1.g1.e2 FROM pm1.g1"}, true);
        Assert.assertTrue((boolean)(plan.getRootNode() instanceof LimitNode));
    }

    @Test
    public void testProjectionRaisingWithAccess() throws Exception {
        String sql = "select e1, (select e1 from pm2.g1 where e2 = x.e2) as z from pm1.g1 as x order by e1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testProjectionRaisingWithAccessAndLimit() throws Exception {
        String sql = "select e1, (select e1 from pm2.g1 where e2 = x.e2) as z from pm1.g1 as x order by e1 limit 1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testProjectionRaisingForUnrelatedWithLimit() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select (select e1 from pm2.g1 where e2 = x.e2) as z from pm1.g1 as x order by e1 limit 1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 ORDER BY pm1.g1.e1 LIMIT 1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testProjectionRaisingForUnrelated() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select e2 from pm1.g1 as x order by e1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1 ORDER BY pm1.g1.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testProjectionRaisingWithAlias() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select (select e1 from pm2.g1 where e2 = x.e2) as z, x.e1 as foo from pm1.g1 as x order by foo limit 1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0 LIMIT 1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }
}

