/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;

public class TestCapabilitiesUtil
extends TestCase {
    public TestCapabilitiesUtil(String name) {
        super(name);
    }

    public void helpTestSupportsSelfJoin(boolean supportsSelfJoin, boolean supportsGroupAlias, boolean expectedValue) throws QueryMetadataException, TeiidComponentException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, supportsSelfJoin);
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, supportsGroupAlias);
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        boolean actual = CapabilitiesUtil.supportsSelfJoins((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)expectedValue, (boolean)actual);
    }

    public void testSupportsSelfJoin1() throws Exception {
        this.helpTestSupportsSelfJoin(false, true, false);
    }

    public void testSupportsSelfJoin2() throws Exception {
        this.helpTestSupportsSelfJoin(true, false, false);
    }

    public void testSupportsSelfJoin3() throws Exception {
        this.helpTestSupportsSelfJoin(true, true, true);
    }

    public void testSupportsSelfJoin4() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        boolean actual = CapabilitiesUtil.supportsSelfJoins((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder());
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)false, (boolean)actual);
    }

    public void helpTestSupportsOuterJoin(boolean capsSupportsOuterJoin, boolean capsSupportsFullOuterJoin, JoinType joinType, boolean expectedValue) throws QueryMetadataException, TeiidComponentException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, capsSupportsOuterJoin);
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, capsSupportsFullOuterJoin);
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        boolean actual = CapabilitiesUtil.supportsJoin((Object)modelID, (JoinType)joinType, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)expectedValue, (boolean)actual);
    }

    public void testSupportsOuterJoinFail1() throws Exception {
        this.helpTestSupportsOuterJoin(false, false, JoinType.JOIN_RIGHT_OUTER, false);
    }

    public void testSupportsOuterJoinFail3() throws Exception {
        this.helpTestSupportsOuterJoin(true, false, JoinType.JOIN_FULL_OUTER, false);
    }

    public void testSupportsOuterJoin1() throws Exception {
        this.helpTestSupportsOuterJoin(true, false, JoinType.JOIN_RIGHT_OUTER, true);
    }

    public void testSupportsOuterJoin2() throws Exception {
        this.helpTestSupportsOuterJoin(true, true, JoinType.JOIN_FULL_OUTER, true);
    }

    public void helpTestSupportsAggregates(boolean capsSupportsAggregates, boolean supportsFunctionInGroupBy, List groupCols) throws QueryMetadataException, TeiidComponentException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, capsSupportsAggregates);
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FUNCTIONS_IN_GROUP_BY, supportsFunctionInGroupBy);
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        boolean actual = CapabilitiesUtil.supportsAggregates((List)groupCols, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)capsSupportsAggregates, (boolean)actual);
    }

    public void testSupportsAggregates1() throws Exception {
        this.helpTestSupportsAggregates(true, true, null);
    }

    public void testSupportsFunctionInGroupBy() throws Exception {
        Function f = new Function("concat", new Expression[]{new Constant((Object)"a"), new Constant((Object)"b")});
        ExpressionSymbol expr = new ExpressionSymbol("e", (Expression)f);
        ArrayList<ExpressionSymbol> cols = new ArrayList<ExpressionSymbol>();
        cols.add(expr);
        this.helpTestSupportsAggregates(false, false, cols);
    }

    public void helpTestSupportsAggregateFunction(SourceCapabilities caps, AggregateSymbol aggregate, boolean expectedValue) throws QueryMetadataException, TeiidComponentException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        finder.addCapabilities("pm1", caps);
        boolean actual = CapabilitiesUtil.supportsAggregateFunction((Object)modelID, (AggregateSymbol)aggregate, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)expectedValue, (boolean)actual);
    }

    public void testSupportsAggregate1() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, false);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "COUNT", false, null);
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, false);
    }

    public void testSupportsAggregate2() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, false);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "COUNT", false, null);
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, false);
    }

    public void testSupportsAggregate3() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, true);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "COUNT", false, null);
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, true);
    }

    public void testSupportsAggregate4() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, true);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "COUNT", false, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, false);
    }

    public void testSupportsAggregate5() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, false);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "COUNT", false, null);
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, false);
    }

    public void testSupportsAggregate6() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, false);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "COUNT", false, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, true);
    }

    public void testSupportsAggregate7() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, false);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "SUM", false, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, false);
    }

    public void testSupportsAggregate8() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "SUM", false, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, true);
    }

    public void testSupportsAggregate9() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, false);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "AVG", false, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, false);
    }

    public void testSupportsAggregate10() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, true);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "AVG", false, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, true);
    }

    public void testSupportsAggregate11() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MIN, false);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "MIN", false, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, false);
    }

    public void testSupportsAggregate12() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MIN, true);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "MIN", false, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, true);
    }

    public void testSupportsAggregate13() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, false);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "MAX", false, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, false);
    }

    public void testSupportsAggregate14() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "MAX", false, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, true);
    }

    public void testSupportsAggregate15() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_DISTINCT, false);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "MAX", true, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, false);
    }

    public void testSupportsAggregate16() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_DISTINCT, true);
        AggregateSymbol aggregate = new AggregateSymbol("expr", "MAX", true, (Expression)new ElementSymbol("x"));
        this.helpTestSupportsAggregateFunction((SourceCapabilities)caps, aggregate, true);
    }

    public void helpTestSupportsScalar(SourceCapabilities caps, Function function, boolean expectedValue) throws QueryMetadataException, TeiidComponentException, QueryResolverException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        finder.addCapabilities("pm1", caps);
        ResolverVisitor.resolveLanguageObject((LanguageObject)function, (QueryMetadataInterface)metadata);
        boolean actual = CapabilitiesUtil.supportsScalarFunction((Object)modelID, (Function)function, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)expectedValue, (boolean)actual);
    }

    public void testSupportsScalar1() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        Function func = new Function("+", new Expression[]{new Constant((Object)1), new Constant((Object)2)});
        this.helpTestSupportsScalar((SourceCapabilities)caps, func, false);
    }

    public void testSupportsScalar3() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setFunctionSupport("now", false);
        Function func = new Function("NOW", new Expression[0]);
        this.helpTestSupportsScalar((SourceCapabilities)caps, func, false);
    }

    public void testSupportsScalar4() throws Exception {
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setFunctionSupport("now", true);
        Function func = new Function("NOW", new Expression[0]);
        this.helpTestSupportsScalar((SourceCapabilities)caps, func, true);
    }

    public void testSupportsDistinct1() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, true);
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        TestCapabilitiesUtil.assertTrue((boolean)CapabilitiesUtil.supportsSelectDistinct((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder));
    }

    public void testSupportsDistinct2() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, false);
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        boolean actual = CapabilitiesUtil.supportsSelectDistinct((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)false, (boolean)actual);
    }

    public void testSupportsOrderBy1() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        boolean actual = CapabilitiesUtil.supportsOrderBy((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)true, (boolean)actual);
    }

    public void testSupportsOrderBy2() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        boolean actual = CapabilitiesUtil.supportsOrderBy((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)false, (boolean)actual);
    }

    public void helpTestSupportsUnion(boolean supports) throws QueryMetadataException, TeiidComponentException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, supports);
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        boolean actual = CapabilitiesUtil.supportsSetOp((Object)modelID, (SetQuery.Operation)SetQuery.Operation.UNION, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)supports, (boolean)actual);
    }

    public void testSupportsUnionTrue() throws Exception {
        this.helpTestSupportsUnion(true);
    }

    public void testSupportsUnionFalse() throws Exception {
        this.helpTestSupportsUnion(false);
    }

    public void helpTestSupportsLiterals(boolean supports) throws QueryMetadataException, TeiidComponentException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, supports);
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        boolean actual = CapabilitiesUtil.supportsSelectExpression((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)supports, (boolean)actual);
    }

    public void testSupportsLiteralsTrue() throws Exception {
        this.helpTestSupportsLiterals(true);
    }

    public void testSupportsLiteralsFalse() throws Exception {
        this.helpTestSupportsLiterals(false);
    }

    public void helpTtestSupportsCaseExpression(boolean supports, boolean searched) throws QueryMetadataException, TeiidComponentException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        if (searched) {
            sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, supports);
        } else {
            sourceCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_CASE, supports);
        }
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        boolean actual = false;
        actual = searched ? CapabilitiesUtil.supportsSearchedCaseExpression((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder) : CapabilitiesUtil.supportsCaseExpression((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestCapabilitiesUtil.assertEquals((String)"Got wrong answer for supports", (boolean)supports, (boolean)actual);
    }

    public void testSupportsCaseTrue() throws Exception {
        this.helpTtestSupportsCaseExpression(true, false);
    }

    public void testSupportsCaseFalse() throws Exception {
        this.helpTtestSupportsCaseExpression(false, false);
    }

    public void testSupportsSearchedCaseTrue() throws Exception {
        this.helpTtestSupportsCaseExpression(true, true);
    }

    public void testSupportsSearchedCaseFalse() throws Exception {
        this.helpTtestSupportsCaseExpression(false, true);
    }

    private FakeCapabilitiesFinder getFinder(SourceCapabilities.Capability property, boolean supported) {
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities sourceCaps = new BasicSourceCapabilities();
        sourceCaps.setCapabilitySupport(property, supported);
        finder.addCapabilities("pm1", (SourceCapabilities)sourceCaps);
        return finder;
    }

    public void testSupportRowLimit() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = this.getFinder(SourceCapabilities.Capability.ROW_LIMIT, false);
        TestCapabilitiesUtil.assertEquals((boolean)false, (boolean)CapabilitiesUtil.supportsRowLimit((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder));
        finder = this.getFinder(SourceCapabilities.Capability.ROW_LIMIT, true);
        TestCapabilitiesUtil.assertEquals((boolean)true, (boolean)CapabilitiesUtil.supportsRowLimit((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder));
    }

    public void testSupportRowOffset() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject modelID = metadata.getStore().findObject("pm1", "Model");
        FakeCapabilitiesFinder finder = this.getFinder(SourceCapabilities.Capability.ROW_OFFSET, false);
        TestCapabilitiesUtil.assertEquals((boolean)false, (boolean)CapabilitiesUtil.supportsRowOffset((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder));
        finder = this.getFinder(SourceCapabilities.Capability.ROW_OFFSET, true);
        TestCapabilitiesUtil.assertEquals((boolean)true, (boolean)CapabilitiesUtil.supportsRowOffset((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder));
    }
}

