/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestRuleAccessPatternValidation {
    private static final FakeMetadataFacade METADATA = FakeMetadataFactory.example1Cached();
    private static final boolean DEBUG = false;
    private static CapabilitiesFinder FINDER = new DefaultCapabilitiesFinder((SourceCapabilities)TestOptimizer.getTypicalCapabilities());

    private void helpTestAccessPatternValidation(String command) throws Exception {
        PlanNode node = this.helpPlan(command);
    }

    private PlanNode helpPlan(String command) throws Exception {
        Command query = QueryParser.getQueryParser().parseCommand(command);
        QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)METADATA);
        RelationalPlanner p = new RelationalPlanner();
        p.initialize(query, null, (QueryMetadataInterface)METADATA, FINDER, null, new CommandContext());
        PlanNode planNode = p.generatePlan(query);
        RelationalPlanner planner = new RelationalPlanner();
        RuleStack rules = planner.buildRules();
        PlanNode testPlan = TestRuleAccessPatternValidation.helpExecuteRules(rules, planNode, (QueryMetadataInterface)METADATA, false);
        return testPlan;
    }

    private static PlanNode helpExecuteRules(RuleStack rules, PlanNode plan, QueryMetadataInterface metadata, boolean debug) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        CommandContext context = new CommandContext();
        while (!rules.isEmpty()) {
            if (debug) {
                System.out.println("\n============================================================================");
            }
            OptimizerRule rule = rules.pop();
            if (debug) {
                System.out.println("EXECUTING " + rule);
            }
            plan = rule.execute(plan, metadata, FINDER, rules, new AnalysisRecord(false, debug), context);
            if (!debug) continue;
            System.out.println("\nAFTER: \n" + plan);
        }
        return plan;
    }

    @Test
    public void testInsertWithAccessPattern_Case3966() throws Exception {
        this.helpTestAccessPatternValidation("insert into pm4.g1 (e1, e2, e3, e4) values('test', 1, convert('true', boolean) , convert('12', double) )");
    }

    @Test
    public void testDeleteWithAccessPattern_Case3966() throws Exception {
        this.helpTestAccessPatternValidation("delete from pm4.g1 where e1 = 'test' and e2 = 1");
    }

    @Test
    public void testDeleteWithAccessPattern_Case3966_2() throws Exception {
        try {
            this.helpTestAccessPatternValidation("delete from pm4.g1");
            Assert.fail((String)"Expected QueryPlannerException, but did not get one");
        }
        catch (QueryPlannerException err) {
            String msg = err.getMessage();
            String expected = "Group has an access pattern which has not been met: group(s) [pm4.g1]; access pattern(s) [Access Pattern: Unsatisfied [pm4.g1.e1] History [[pm4.g1.e1]]]";
            Assert.assertEquals((String)"Did not fail with expected QueryPlannerException", (Object)"Group has an access pattern which has not been met: group(s) [pm4.g1]; access pattern(s) [Access Pattern: Unsatisfied [pm4.g1.e1] History [[pm4.g1.e1]]]", (Object)msg);
        }
    }

    @Test
    public void testUpdateWithAccessPattern_Case3966() throws Exception {
        this.helpTestAccessPatternValidation("update pm4.g1 set e1 = 'test1' where e1 = 'test' and e2 = 1");
    }

    @Test
    public void testUpdateWithAccessPattern_Case3966_2() throws Exception {
        try {
            this.helpTestAccessPatternValidation("update pm4.g1 set e1 = 'test'");
            Assert.fail((String)"Expected QueryPlannerException, but did not get one");
        }
        catch (QueryPlannerException err) {
            String msg = err.getMessage();
            String expected = "Group has an access pattern which has not been met: group(s) [pm4.g1]; access pattern(s) [Access Pattern: Unsatisfied [pm4.g1.e1] History [[pm4.g1.e1]]]";
            Assert.assertEquals((String)"Did not fail with expected QueryPlannerException", (Object)"Group has an access pattern which has not been met: group(s) [pm4.g1]; access pattern(s) [Access Pattern: Unsatisfied [pm4.g1.e1] History [[pm4.g1.e1]]]", (Object)msg);
        }
    }

    @Test
    public void testInsertWithAccessPattern_Case3966_VL() throws Exception {
        this.helpTestAccessPatternValidation("insert into vm1.g37 (e1, e2, e3, e4) values('test', 1, convert('true', boolean) , convert('12', double) )");
    }

    @Test
    public void testDeleteWithAccessPattern_Case3966_VL() throws Exception {
        this.helpTestAccessPatternValidation("delete from vm1.g37 where e1 = 'test' and e2 = 1");
    }
}

