/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestAggregatePushdown;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestAggregateProcessing {
    static void sampleDataBQT3(FakeDataManager dataMgr) throws Exception {
        int j;
        int i;
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        List[] tuples = new List[20];
        for (i = 0; i < tuples.length; ++i) {
            tuples[i] = new ArrayList(17);
            tuples[i].add(new Integer(i));
            tuples[i].add("" + i);
            tuples[i].add(new Integer(i + 1));
            for (j = 0; j < 14; ++j) {
                tuples[i].add(null);
            }
        }
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt1.smalla", tuples);
        tuples = new List[20];
        for (i = 0; i < tuples.length; ++i) {
            tuples[i] = new ArrayList(17);
            tuples[i].add(new Integer(i));
            for (j = 0; j < 16; ++j) {
                tuples[i].add(null);
            }
        }
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt2.mediumb", tuples);
    }

    private void sampleDataBQT_defect9842(FakeDataManager dataMgr) throws Exception {
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        List[] tuples = new List[5];
        for (int i = 0; i < tuples.length; ++i) {
            int k = i + 10;
            tuples[i] = new ArrayList(17);
            if (i < 2) {
                tuples[i].add(new Integer(1));
            } else {
                tuples[i].add(new Integer(2));
            }
            tuples[i].add("" + k);
            tuples[i].add(new Integer(k + 1));
            tuples[i].add("" + (k + 1));
            tuples[i].add(new Float(0.5));
            for (int j = 0; j < 8; ++j) {
                tuples[i].add(null);
            }
            tuples[i].add(new Short((short)k));
            tuples[i].add(null);
            tuples[i].add(new BigDecimal("" + k));
            tuples[i].add(null);
        }
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt1.smalla", tuples);
    }

    @Test
    public void testAggregateOnBQT() throws Exception {
        String sql = "SELECT IntKey, SUM(IntNum) FROM BQT1.SmallA GROUP BY IntKey, IntNum HAVING IntNum > 10 ORDER BY IntKey";
        List[] expected = new List[]{Arrays.asList(new Integer(10), new Long(11L)), Arrays.asList(new Integer(11), new Long(12L)), Arrays.asList(new Integer(12), new Long(13L)), Arrays.asList(new Integer(13), new Long(14L)), Arrays.asList(new Integer(14), new Long(15L)), Arrays.asList(new Integer(15), new Long(16L)), Arrays.asList(new Integer(16), new Long(17L)), Arrays.asList(new Integer(17), new Long(18L)), Arrays.asList(new Integer(18), new Long(19L)), Arrays.asList(new Integer(19), new Long(20L))};
        FakeDataManager dataManager = new FakeDataManager();
        TestAggregateProcessing.sampleDataBQT3(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAggregateOnBQT2() throws Exception {
        String sql = "SELECT IntNum, IsNotNull FROM (SELECT IntNum, LongNum, COUNT(IntNum) AS IsNotNull FROM BQT1.SmallA GROUP BY IntNum, LongNum HAVING LongNum IS NULL ) AS x ORDER BY IntNum, IsNotNull";
        List[] expected = new List[]{Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(3), new Integer(1)), Arrays.asList(new Integer(4), new Integer(1)), Arrays.asList(new Integer(5), new Integer(1)), Arrays.asList(new Integer(6), new Integer(1)), Arrays.asList(new Integer(7), new Integer(1)), Arrays.asList(new Integer(8), new Integer(1)), Arrays.asList(new Integer(9), new Integer(1)), Arrays.asList(new Integer(10), new Integer(1)), Arrays.asList(new Integer(11), new Integer(1)), Arrays.asList(new Integer(12), new Integer(1)), Arrays.asList(new Integer(13), new Integer(1)), Arrays.asList(new Integer(14), new Integer(1)), Arrays.asList(new Integer(15), new Integer(1)), Arrays.asList(new Integer(16), new Integer(1)), Arrays.asList(new Integer(17), new Integer(1)), Arrays.asList(new Integer(18), new Integer(1)), Arrays.asList(new Integer(19), new Integer(1)), Arrays.asList(new Integer(20), new Integer(1))};
        FakeDataManager dataManager = new FakeDataManager();
        TestAggregateProcessing.sampleDataBQT3(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAggregateOnBQT_defect9842() throws Exception {
        String sql = "SELECT IntKey, SUM((BigDecimalValue)*(ShortValue)-(BigDecimalValue)*(ShortValue)*(FloatNum)) AS MySum FROM BQT1.SmallA GROUP BY IntKey ORDER BY IntKey";
        List[] expected = new List[]{Arrays.asList(new Integer(1), new BigDecimal("110.5000000")), Arrays.asList(new Integer(2), new BigDecimal("254.5000000"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT_defect9842(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase186260() {
        String sql = "SELECT COUNT(DISTINCT pm1.g2.e1), COUNT(DISTINCT pm1.g3.e1) FROM pm1.g2, pm1.g3";
        List[] expected = new List[]{Arrays.asList(new Integer(3), new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAggregatePushdown() {
        Command command = TestProcessor.helpParse("select e1, count(e2), max(e2) from (select e1, e2, e3 from pm1.g1 union all select e1, e2, e3 from pm1.g2 union all select e1, e2, e3 from pm2.g1) z group by e1");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        capFinder.addCapabilities("pm1", (SourceCapabilities)TestAggregatePushdown.getAggregateCapabilities());
        capFinder.addCapabilities("pm2", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT v_0.c_0, COUNT(v_0.c_1), MAX(v_0.c_1) FROM (SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0) AS v_0 GROUP BY v_0.c_0", new List[]{Arrays.asList("a", 2, 1)});
        dataManager.addData("SELECT v_0.c_0, COUNT(v_0.c_1), MAX(v_0.c_1) FROM (SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g2 AS g_0) AS v_0 GROUP BY v_0.c_0", new List[]{Arrays.asList("a", 3, 2)});
        dataManager.addData("SELECT g_0.e1, g_0.e2 FROM pm2.g1 AS g_0", new List[]{Arrays.asList("a", 3), Arrays.asList("xyz", 4), Arrays.asList(null, 5)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList(null, 1, 5), Arrays.asList("a", 6, 3), Arrays.asList("xyz", 1, 4)};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testUnionAggregatePushdown() {
        Command command = TestProcessor.helpParse("select count(*), max(e3) from (select e1, e2, e3 from pm1.g1 union all (select convert(e2, string) as a, e2, e3 from pm2.g2 order by a limit 10)) x group by e1, e2");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        capFinder.addCapabilities("pm1", (SourceCapabilities)TestAggregatePushdown.getAggregateCapabilities());
        BasicSourceCapabilities bac = TestAggregatePushdown.getAggregateCapabilities();
        bac.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm2", (SourceCapabilities)bac);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT v_0.c_1, v_0.c_0, COUNT(*), MAX(v_0.c_2) FROM (SELECT g_0.e2 AS c_0, g_0.e1 AS c_1, g_0.e3 AS c_2 FROM pm1.g1 AS g_0) AS v_0 GROUP BY v_0.c_0, v_0.c_1", new List[]{Arrays.asList("2", 2, 2, Boolean.FALSE), Arrays.asList("1", 1, 3, Boolean.TRUE)});
        dataManager.addData("SELECT v_0.c_1, v_0.c_0, COUNT(*), MAX(v_0.c_2) FROM (SELECT g_0.e2 AS c_0, convert(g_0.e2, string) AS c_1, g_0.e3 AS c_2 FROM pm2.g2 AS g_0 ORDER BY c_1 LIMIT 10) AS v_0 GROUP BY v_0.c_0, v_0.c_1", new List[]{Arrays.asList("1", 1, 4, Boolean.FALSE)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList(7, Boolean.TRUE), Arrays.asList(2, Boolean.FALSE)};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testPushDownOverUnionMixed1() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestAggregatePushdown.getAggregateCapabilities();
        caps.setFunctionSupport("power", true);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm1", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select max(e2), count(*), stddev_pop(e2), var_samp(e2) from (select e1, e2 from pm1.g1 union all select e1, e2 from pm2.g2) z"), (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e2 FROM pm1.g1 AS g_0", new List[]{Arrays.asList(1), Arrays.asList(2)});
        dataManager.addData("SELECT MAX(v_0.c_0), COUNT(*), COUNT(v_0.c_0), SUM(power(v_0.c_0, 2)), SUM(v_0.c_0) FROM (SELECT g_0.e2 AS c_0 FROM pm2.g2 AS g_0) AS v_0 HAVING COUNT(*) > 0", new List[]{Arrays.asList(5, 6, 4, BigInteger.valueOf(50L), 10L)});
        List[] expected = new List[]{Arrays.asList(5, 8, 2.1147629234082532, 5.366666666666666)};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBooleanAgg() {
        String sql = "select every(e3), any(e3) from pm1.g1";
        List[] expected = new List[]{Arrays.asList(Boolean.FALSE, Boolean.TRUE)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStatsFunctions() {
        String sql = "select stddev_pop(e2), var_samp(e2) from pm1.g1";
        List[] expected = new List[]{Arrays.asList(1.0671873729054748, 1.3666666666666667)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStatsFunctions1() {
        String sql = "select stddev_samp(e2), var_pop(e2) from (select 2 e2) x";
        List[] expected = new List[]{Arrays.asList(null, 0.0)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }
}

