/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.tempdata.TempTableDataManager;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestTempTables {
    private TempMetadataAdapter metadata;
    private TempTableDataManager dataManager;
    private TempTableStore tempStore;

    private ProcessorPlan execute(String sql, List[] expectedResults) throws Exception {
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)this.metadata);
        this.execute(plan, expectedResults);
        return plan;
    }

    private void execute(ProcessorPlan processorPlan, List[] expectedResults) throws Exception {
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setMetadata((QueryMetadataInterface)this.metadata);
        cc.setTempTableStore(this.tempStore);
        TestProcessor.doProcess(processorPlan, (ProcessorDataManager)this.dataManager, expectedResults, cc);
        Assert.assertTrue((FunctionMethod.Determinism.SESSION_DETERMINISTIC.compareTo((Enum)cc.getDeterminismLevel()) <= 0 ? 1 : 0) != 0);
    }

    @Before
    public void setUp() {
        this.tempStore = new TempTableStore("1");
        this.metadata = new TempMetadataAdapter((QueryMetadataInterface)FakeMetadataFactory.example1Cached(), this.tempStore.getMetadataStore());
        this.metadata.setSession(true);
        FakeDataManager fdm = new FakeDataManager();
        TestProcessor.sampleData1(fdm);
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        SessionAwareCache cache = new SessionAwareCache();
        cache.setBufferManager(bm);
        Executor executor = new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
        this.dataManager = new TempTableDataManager((ProcessorDataManager)fdm, bm, executor, cache, null, null);
    }

    @Test
    public void testInsertWithQueryExpression() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("update x set e1 = e2 where e2 > 1", new List[]{Arrays.asList(2)});
    }

    @Test
    public void testOutofOrderInsert() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("select e1, e2 from x", new List[]{Arrays.asList("one", 1)});
    }

    @Test
    public void testUpdate() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("select e1, e2 into x from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("update x set e1 = e2 where e2 > 1", new List[]{Arrays.asList(2)});
        this.execute("select e1 from x where e2 > 0 order by e1", new List[]{Arrays.asList(new String[]{null}), Arrays.asList("2"), Arrays.asList("3"), Arrays.asList("c"), Arrays.asList("one")});
    }

    @Test
    public void testDelete() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("select e1, e2 into x from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("delete from x where ascii(e1) > e2", new List[]{Arrays.asList(5)});
        this.execute("select e1 from x order by e1", new List[]{Arrays.asList(new String[]{null})});
    }

    @Test
    public void testDelete1() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("select e1, e2 into x from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("delete from x", new List[]{Arrays.asList(6)});
        this.execute("select e1 from x order by e1", new List[0]);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testDuplicatePrimaryKey() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
    }

    @Test
    public void testAtomicUpdate() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'one')", new List[]{Arrays.asList(1)});
        try {
            this.execute("update x set e2 = 3", new List[]{Arrays.asList(1)});
        }
        catch (TeiidProcessingException teiidProcessingException) {
            // empty catch block
        }
        this.execute("select count(*) from x", new List[]{Arrays.asList(2)});
    }

    @Test
    public void testAtomicDelete() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'one')", new List[]{Arrays.asList(1)});
        try {
            this.execute("delete from x where 1/(e2 - 2) <> 4", new List[]{Arrays.asList(1)});
        }
        catch (TeiidProcessingException teiidProcessingException) {
            // empty catch block
        }
        this.execute("select count(*) from x", new List[]{Arrays.asList(2)});
    }

    @Test
    public void testPrimaryKeyMetadata() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        Collection c = this.metadata.getUniqueKeysInGroup(this.metadata.getGroupID("x"));
        Assert.assertEquals((long)1L, (long)c.size());
        Assert.assertEquals((long)1L, (long)this.metadata.getElementIDsInKey(c.iterator().next()).size());
    }

    @Test
    public void testProjection() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e2 = 1", new List[]{Arrays.asList("one", 1)});
        this.execute("select e2, e1 from x where e2 = 1", new List[]{Arrays.asList(1, "one")});
    }

    @Test
    public void testOrderByWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'one')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'one')", new List[]{Arrays.asList(1)});
        this.execute("select * from x as y order by e2 desc", new List[]{Arrays.asList("one", 3), Arrays.asList("one", 2)});
    }

    @Test
    public void testOrderByWithoutIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("select * from x order by e1", new List[]{Arrays.asList("a", 3), Arrays.asList("b", 2)});
    }

    @Test
    public void testCompareEqualsWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e2 = 3", new List[]{Arrays.asList("a", 3)});
    }

    @Test
    public void testLikeWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e1 like 'z%'", new List[0]);
    }

    @Test
    public void testIsNullWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, null)", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e1 is null", new List[]{Arrays.asList(null, 3)});
    }

    @Test
    public void testInWithIndex() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'c')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (0, 'd')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (-1, 'e')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e1 in ('a', 'c', 'e', 'f', 'g')", new List[]{Arrays.asList("a", 3), Arrays.asList("c", 1), Arrays.asList("e", -1)});
    }

    @Test
    public void testInWithIndexUpdate() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, e3 string, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'c')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (0, 'd')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1, e3) values (-1, 'e', 'e')", new List[]{Arrays.asList(1)});
        this.execute("update x set e2 = 5 where e1 in ('a', 'c')", new List[]{Arrays.asList(2)});
        this.execute("select * from x where e1 in ('b', e3)", new List[]{Arrays.asList("b", 2, null), Arrays.asList("e", -1, "e")});
    }

    @Test
    public void testCompositeKeyCompareEquals() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1, e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'a')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'c')", new List[]{Arrays.asList(1)});
        this.execute("select * from x where e1 = 'b' and e2 = 2", new List[]{Arrays.asList("b", 2)});
    }

    @Test
    public void testCompositeKeyPartial() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e1 = 'b'", new List[]{Arrays.asList("b", 2), Arrays.asList("b", 3)});
    }

    @Test
    public void testCompositeKeyPartial1() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e1 < 'c'", new List[]{Arrays.asList("a", 1), Arrays.asList("b", 2), Arrays.asList("b", 3)});
    }

    @Test
    public void testCompositeKeyPartial2() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e2 = 1", new List[]{Arrays.asList("a", 1), Arrays.asList("c", 1)});
    }

    @Test
    public void testCompositeKeyPartial3() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e1 >= 'b'", new List[]{Arrays.asList("b", 2), Arrays.asList("b", 3), Arrays.asList("c", 1)});
    }

    @Test
    public void testCompositeKeyPartial4() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e1 >= 'b' order by e1 desc, e2 desc", new List[]{Arrays.asList("c", 1), Arrays.asList("b", 3), Arrays.asList("b", 2)});
    }

    @Test
    public void testCompositeKeyPartial5() throws Exception {
        this.sampleTable();
        this.execute("select * from x where e1 in ('a', 'b')", new List[]{Arrays.asList("a", 1), Arrays.asList("b", 2), Arrays.asList("b", 3)});
    }

    @Test
    public void testCompositeKeyPartial6() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1, e2))", new List[]{Arrays.asList(0)});
        this.execute("select * from x where e1 in ('a', 'b') order by e1 desc", new List[0]);
    }

    @Test
    public void testCountStar() throws Exception {
        this.sampleTable();
        this.execute("select count(*) a from x", new List[]{Arrays.asList(4)});
        this.execute("select count(*) a from x where e2 = 1 order by a", new List[]{Arrays.asList(2)});
    }

    @Test
    public void testAutoIncrement() throws Exception {
        this.execute("create local temporary table x (e1 serial, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2) values (1)", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2) values (3)", new List[]{Arrays.asList(1)});
        this.execute("select * from x", new List[]{Arrays.asList(1, 1), Arrays.asList(2, 3)});
    }

    @Test(expected=TeiidProcessingException.class)
    public void testNotNull() throws Exception {
        this.execute("create local temporary table x (e1 serial, e2 integer not null, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e1, e2) values ((select null), 1)", new List[]{Arrays.asList(1)});
    }

    @Test(expected=TeiidProcessingException.class)
    public void testNotNull1() throws Exception {
        this.execute("create local temporary table x (e1 serial, e2 integer not null, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2) values ((select null))", new List[]{Arrays.asList(1)});
    }

    @Test
    public void testSessionResolving() throws Exception {
        this.execute("create local temporary table temp_table (column1 integer)", new List[]{Arrays.asList(0)});
        this.execute("exec pm1.vsp60()", new List[]{Arrays.asList("First"), Arrays.asList("Second"), Arrays.asList("Third")});
    }

    @Test
    public void testCompositeKeyJoinUsesKeyOrder() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1, e2))", new List[]{Arrays.asList(0)});
        this.execute("create local temporary table x1 (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        TestOptimizer.helpPlan("select * from x, x1 where x.e2 = x1.e2 and x.e1 = x1.e1", (QueryMetadataInterface)this.metadata, new String[]{"SELECT x1.e2, x1.e1 FROM x1 ORDER BY x1.e1, x1.e2", "SELECT x.e2, x.e1 FROM x ORDER BY x.e1, x.e2"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testUnneededMergePredicate() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1))", new List[]{Arrays.asList(0)});
        this.execute("create local temporary table x1 (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        TestOptimizer.helpPlan("select x.e1 from x, x1 where x.e2 = x1.e2 and x.e1 = x1.e1", (QueryMetadataInterface)this.metadata, new String[]{"SELECT x.e2, x.e1 FROM x ORDER BY x.e1", "SELECT x1.e2, x1.e1 FROM x1 ORDER BY x1.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    private void sampleTable() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer, primary key (e1, e2))", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (3, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (2, 'b')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'c')", new List[]{Arrays.asList(1)});
        this.execute("insert into x (e2, e1) values (1, 'a')", new List[]{Arrays.asList(1)});
    }
}

