/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.core.TeiidComponentException;

public class NodeTestUtil {
    static BufferManager getTestBufferManager(long bytesAvailable, int procBatchSize, int connectorBatchSize) {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setProcessorBatchSize(procBatchSize);
        bufferManager.setConnectorBatchSize(connectorBatchSize);
        bufferManager.setMaxProcessingBatchColumns((int)((double)(bytesAvailable / (long)procBatchSize) / 0.0625 / 1024.0));
        bufferManager.setMaxReserveBatchColumns((int)((double)(bytesAvailable / (long)procBatchSize) / 0.0625 / 1024.0));
        return NodeTestUtil.createBufferManager(bufferManager);
    }

    static BufferManager getTestBufferManager(long bytesAvailable, int procBatchSize) {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setProcessorBatchSize(procBatchSize);
        bufferManager.setMaxProcessingBatchColumns((int)((double)(bytesAvailable / (long)procBatchSize) / 0.0625 / 1024.0));
        bufferManager.setMaxReserveBatchColumns((int)((double)(bytesAvailable / (long)procBatchSize) / 0.0625 / 1024.0));
        return NodeTestUtil.createBufferManager(bufferManager);
    }

    static BufferManager createBufferManager(BufferManagerImpl bufferManager) {
        try {
            bufferManager.initialize();
        }
        catch (TeiidComponentException e) {
            throw new RuntimeException(e);
        }
        bufferManager.setStorageManager(NodeTestUtil.createFakeDatabaseStorageManager());
        return bufferManager;
    }

    private static StorageManager createFakeDatabaseStorageManager() {
        return new MemoryStorageManager();
    }
}

