/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.EnhancedSortMergeJoinStrategy;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.JoinStrategy;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.NestedLoopJoinStrategy;
import org.teiid.query.processor.relational.NodeTestUtil;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestJoinNode {
    private static final int NO_CRITERIA = 0;
    private static final int EQUAL_CRITERIA = 1;
    private static final int FUNCTION_CRITERIA = 2;
    private int criteriaType = 1;
    protected JoinType joinType;
    protected List[] leftTuples;
    protected List[] rightTuples;
    protected List[] expected;
    private List[] expectedReversed;
    protected JoinNode join;
    protected JoinStrategy joinStrategy;
    private RelationalNode leftNode;
    private RelationalNode rightNode;
    private FakeDataManager dataMgr;

    @Before
    public void setup() {
        this.leftTuples = this.createTuples1();
        this.rightTuples = this.createTuples2();
    }

    protected List[] createTuples1() {
        return new List[]{Arrays.asList(new Integer(5)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(4)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(4)), Arrays.asList(new Integer(10)), Arrays.asList(new Integer(11)), Arrays.asList(new Integer(11))};
    }

    private List[] createTuples2() {
        return new List[]{Arrays.asList(new Integer(1)), Arrays.asList(new Integer(4)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(4)), Arrays.asList(new Object[]{null}), Arrays.asList(new Integer(7)), Arrays.asList(new Integer(7)), Arrays.asList(new Integer(6))};
    }

    private List[] createTuples3() {
        return new List[]{Arrays.asList(new Object[]{null}), Arrays.asList(new Object[]{null}), Arrays.asList(new Integer(10)), Arrays.asList(new Integer(10)), Arrays.asList(new Integer(9)), Arrays.asList(new Integer(9)), Arrays.asList(new Integer(9)), Arrays.asList(new Object[]{null}), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(5)), Arrays.asList(new Integer(15))};
    }

    private List[] createTuples4() {
        return new List[]{Arrays.asList(new Integer(1)), Arrays.asList(new Integer(4)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(4)), Arrays.asList(new Object[]{null}), Arrays.asList(new Integer(7)), Arrays.asList(new Integer(9)), Arrays.asList(new Integer(5)), Arrays.asList(new Integer(6)), Arrays.asList(new Integer(10)), Arrays.asList(new Object[]{null}), Arrays.asList(new Object[]{null})};
    }

    private List[] createTuples(int startingValue, int count) {
        return this.createTuples(startingValue, count, false);
    }

    private List[] createTuples(int startingValue, int count, boolean addNullAsSecondColumn) {
        ArrayList<List<Object>> lists = new ArrayList<List<Object>>();
        for (int i = 0; i < count; ++i) {
            Object[] tuple = addNullAsSecondColumn ? new Object[]{new Integer(startingValue + i), null} : new Object[]{new Integer(startingValue + i)};
            lists.add(Arrays.asList(tuple));
        }
        return lists.toArray(new List[0]);
    }

    private List[] createResults(int startingValue, int count) {
        return this.createTuples(startingValue, count, true);
    }

    protected void helpCreateJoin() {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es2 = new ElementSymbol("e2");
        es2.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ArrayList<ElementSymbol> leftElements = new ArrayList<ElementSymbol>();
        leftElements.add(es1);
        this.leftNode = new FakeRelationalNode(1, this.leftTuples);
        this.leftNode.setElements(leftElements);
        ArrayList<ElementSymbol> rightElements = new ArrayList<ElementSymbol>();
        rightElements.add(es2);
        this.rightNode = new FakeRelationalNode(2, this.rightTuples);
        this.rightNode.setElements(rightElements);
        ArrayList<ElementSymbol> joinElements = new ArrayList<ElementSymbol>();
        joinElements.add(es1);
        joinElements.add(es2);
        this.join = new JoinNode(3);
        this.joinStrategy = new NestedLoopJoinStrategy();
        this.join.setJoinStrategy(this.joinStrategy);
        this.join.setElements(joinElements);
        this.join.setJoinType(this.joinType);
        switch (this.criteriaType) {
            case 0: {
                break;
            }
            case 1: {
                this.join.setJoinExpressions(Arrays.asList(es1), Arrays.asList(es2));
                this.joinStrategy = new MergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT, false);
                this.join.setJoinStrategy(this.joinStrategy);
                break;
            }
            case 2: {
                Function func = new Function("lookup", new Expression[]{new Constant((Object)"pm1.g1"), new Constant((Object)"e2"), new Constant((Object)"e1"), es1});
                FunctionDescriptor desc = FakeMetadataFactory.SFM.getSystemFunctionLibrary().findFunction("lookup", new Class[]{String.class, String.class, String.class, Integer.class});
                func.setFunctionDescriptor(desc);
                func.setType(DataTypeManager.DefaultDataClasses.INTEGER);
                CompareCriteria joinCriteria = new CompareCriteria((Expression)es2, 1, (Expression)func);
                this.join.setJoinCriteria((Criteria)joinCriteria);
            }
        }
    }

    public void helpTestJoin() throws TeiidComponentException, TeiidProcessingException {
        for (int batchSize : new int[]{1, 10, this.leftTuples.length, 100}) {
            this.helpCreateJoin();
            if (batchSize == 0) continue;
            this.helpTestJoinDirect(this.expected, batchSize, 100000);
            List[] temp = this.leftTuples;
            this.leftTuples = this.rightTuples;
            this.rightTuples = temp;
            this.helpCreateJoin();
            this.helpTestJoinDirect(this.expectedReversed, batchSize, 100000);
            temp = this.leftTuples;
            this.leftTuples = this.rightTuples;
            this.rightTuples = temp;
        }
    }

    public void helpTestJoinDirect(List[] expectedResults, int batchSize, int processingBytes) throws TeiidComponentException, TeiidProcessingException {
        BufferManager mgr = NodeTestUtil.getTestBufferManager(processingBytes, batchSize);
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        this.join.addChild(this.leftNode);
        this.join.addChild(this.rightNode);
        this.leftNode.initialize(context, mgr, (ProcessorDataManager)this.dataMgr);
        this.rightNode.initialize(context, mgr, (ProcessorDataManager)this.dataMgr);
        this.join.initialize(context, mgr, (ProcessorDataManager)this.dataMgr);
        this.join.open();
        int currentRow = 1;
        while (true) {
            try {
                TupleBatch batch;
                do {
                    batch = this.join.nextBatch();
                    while (currentRow <= batch.getEndRow()) {
                        List tuple = batch.getTuple(currentRow);
                        Assert.assertEquals((String)("Rows don't match at " + currentRow), (Object)expectedResults[currentRow - 1], (Object)tuple);
                        ++currentRow;
                    }
                } while (!batch.getTerminationFlag());
            }
            catch (BlockedException e) {
                continue;
            }
            break;
        }
        Assert.assertEquals((long)expectedResults.length, (long)(currentRow - 1));
        this.join.close();
    }

    @Test
    public void testNoRows() throws Exception {
        this.leftTuples = new List[0];
        this.rightTuples = new List[0];
        this.joinType = JoinType.JOIN_INNER;
        this.expected = new List[0];
        this.expectedReversed = new List[0];
        this.helpTestJoin();
    }

    @Test
    public void testInnerJoin() throws Exception {
        this.joinType = JoinType.JOIN_INNER;
        this.expected = new List[]{Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(4))};
        this.expectedReversed = this.expected;
        this.helpTestJoin();
    }

    @Test
    public void testLeftOuterJoin() throws Exception {
        this.joinType = JoinType.JOIN_LEFT_OUTER;
        this.expected = new List[]{Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(3), null), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(5), null), Arrays.asList(new Integer(10), null), Arrays.asList(new Integer(11), null), Arrays.asList(new Integer(11), null)};
        this.expectedReversed = new List[]{Arrays.asList(null, null), Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(6), null), Arrays.asList(new Integer(7), null), Arrays.asList(new Integer(7), null)};
        this.helpTestJoin();
    }

    @Test
    public void testLeftOuterJoinWithSwap() throws Exception {
        int outerSize = 11;
        this.leftTuples = this.createTuples(1, outerSize);
        this.rightTuples = this.createTuples(201, outerSize + 1);
        this.joinType = JoinType.JOIN_LEFT_OUTER;
        this.expected = this.createResults(1, outerSize);
        this.expectedReversed = this.createResults(201, outerSize + 1);
        this.helpTestJoin();
    }

    @Test
    public void testCrossJoin() throws Exception {
        this.joinType = JoinType.JOIN_CROSS;
        this.criteriaType = 0;
        this.expected = new List[]{Arrays.asList(new Integer(5), new Integer(1)), Arrays.asList(new Integer(5), new Integer(4)), Arrays.asList(new Integer(5), new Integer(2)), Arrays.asList(new Integer(5), new Integer(2)), Arrays.asList(new Integer(5), new Integer(4)), Arrays.asList(new Integer(5), null), Arrays.asList(new Integer(5), new Integer(7)), Arrays.asList(new Integer(5), new Integer(7)), Arrays.asList(new Integer(5), new Integer(6)), Arrays.asList(new Integer(3), new Integer(1)), Arrays.asList(new Integer(3), new Integer(4)), Arrays.asList(new Integer(3), new Integer(2)), Arrays.asList(new Integer(3), new Integer(2)), Arrays.asList(new Integer(3), new Integer(4)), Arrays.asList(new Integer(3), null), Arrays.asList(new Integer(3), new Integer(7)), Arrays.asList(new Integer(3), new Integer(7)), Arrays.asList(new Integer(3), new Integer(6)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(2), new Integer(4)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(2), new Integer(4)), Arrays.asList(new Integer(2), null), Arrays.asList(new Integer(2), new Integer(7)), Arrays.asList(new Integer(2), new Integer(7)), Arrays.asList(new Integer(2), new Integer(6)), Arrays.asList(new Integer(4), new Integer(1)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(2)), Arrays.asList(new Integer(4), new Integer(2)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), null), Arrays.asList(new Integer(4), new Integer(7)), Arrays.asList(new Integer(4), new Integer(7)), Arrays.asList(new Integer(4), new Integer(6)), Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(1), new Integer(4)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(1), new Integer(4)), Arrays.asList(new Integer(1), null), Arrays.asList(new Integer(1), new Integer(7)), Arrays.asList(new Integer(1), new Integer(7)), Arrays.asList(new Integer(1), new Integer(6)), Arrays.asList(new Integer(4), new Integer(1)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(2)), Arrays.asList(new Integer(4), new Integer(2)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), null), Arrays.asList(new Integer(4), new Integer(7)), Arrays.asList(new Integer(4), new Integer(7)), Arrays.asList(new Integer(4), new Integer(6)), Arrays.asList(new Integer(10), new Integer(1)), Arrays.asList(new Integer(10), new Integer(4)), Arrays.asList(new Integer(10), new Integer(2)), Arrays.asList(new Integer(10), new Integer(2)), Arrays.asList(new Integer(10), new Integer(4)), Arrays.asList(new Integer(10), null), Arrays.asList(new Integer(10), new Integer(7)), Arrays.asList(new Integer(10), new Integer(7)), Arrays.asList(new Integer(10), new Integer(6)), Arrays.asList(new Integer(11), new Integer(1)), Arrays.asList(new Integer(11), new Integer(4)), Arrays.asList(new Integer(11), new Integer(2)), Arrays.asList(new Integer(11), new Integer(2)), Arrays.asList(new Integer(11), new Integer(4)), Arrays.asList(new Integer(11), null), Arrays.asList(new Integer(11), new Integer(7)), Arrays.asList(new Integer(11), new Integer(7)), Arrays.asList(new Integer(11), new Integer(6)), Arrays.asList(new Integer(11), new Integer(1)), Arrays.asList(new Integer(11), new Integer(4)), Arrays.asList(new Integer(11), new Integer(2)), Arrays.asList(new Integer(11), new Integer(2)), Arrays.asList(new Integer(11), new Integer(4)), Arrays.asList(new Integer(11), null), Arrays.asList(new Integer(11), new Integer(7)), Arrays.asList(new Integer(11), new Integer(7)), Arrays.asList(new Integer(11), new Integer(6))};
        this.expectedReversed = new List[]{Arrays.asList(new Integer(1), new Integer(5)), Arrays.asList(new Integer(1), new Integer(3)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(1), new Integer(4)), Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(1), new Integer(4)), Arrays.asList(new Integer(1), new Integer(10)), Arrays.asList(new Integer(1), new Integer(11)), Arrays.asList(new Integer(1), new Integer(11)), Arrays.asList(new Integer(4), new Integer(5)), Arrays.asList(new Integer(4), new Integer(3)), Arrays.asList(new Integer(4), new Integer(2)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(1)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(10)), Arrays.asList(new Integer(4), new Integer(11)), Arrays.asList(new Integer(4), new Integer(11)), Arrays.asList(new Integer(2), new Integer(5)), Arrays.asList(new Integer(2), new Integer(3)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(2), new Integer(4)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(2), new Integer(4)), Arrays.asList(new Integer(2), new Integer(10)), Arrays.asList(new Integer(2), new Integer(11)), Arrays.asList(new Integer(2), new Integer(11)), Arrays.asList(new Integer(2), new Integer(5)), Arrays.asList(new Integer(2), new Integer(3)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(2), new Integer(4)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(2), new Integer(4)), Arrays.asList(new Integer(2), new Integer(10)), Arrays.asList(new Integer(2), new Integer(11)), Arrays.asList(new Integer(2), new Integer(11)), Arrays.asList(new Integer(4), new Integer(5)), Arrays.asList(new Integer(4), new Integer(3)), Arrays.asList(new Integer(4), new Integer(2)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(1)), Arrays.asList(new Integer(4), new Integer(4)), Arrays.asList(new Integer(4), new Integer(10)), Arrays.asList(new Integer(4), new Integer(11)), Arrays.asList(new Integer(4), new Integer(11)), Arrays.asList(null, new Integer(5)), Arrays.asList(null, new Integer(3)), Arrays.asList(null, new Integer(2)), Arrays.asList(null, new Integer(4)), Arrays.asList(null, new Integer(1)), Arrays.asList(null, new Integer(4)), Arrays.asList(null, new Integer(10)), Arrays.asList(null, new Integer(11)), Arrays.asList(null, new Integer(11)), Arrays.asList(new Integer(7), new Integer(5)), Arrays.asList(new Integer(7), new Integer(3)), Arrays.asList(new Integer(7), new Integer(2)), Arrays.asList(new Integer(7), new Integer(4)), Arrays.asList(new Integer(7), new Integer(1)), Arrays.asList(new Integer(7), new Integer(4)), Arrays.asList(new Integer(7), new Integer(10)), Arrays.asList(new Integer(7), new Integer(11)), Arrays.asList(new Integer(7), new Integer(11)), Arrays.asList(new Integer(7), new Integer(5)), Arrays.asList(new Integer(7), new Integer(3)), Arrays.asList(new Integer(7), new Integer(2)), Arrays.asList(new Integer(7), new Integer(4)), Arrays.asList(new Integer(7), new Integer(1)), Arrays.asList(new Integer(7), new Integer(4)), Arrays.asList(new Integer(7), new Integer(10)), Arrays.asList(new Integer(7), new Integer(11)), Arrays.asList(new Integer(7), new Integer(11)), Arrays.asList(new Integer(6), new Integer(5)), Arrays.asList(new Integer(6), new Integer(3)), Arrays.asList(new Integer(6), new Integer(2)), Arrays.asList(new Integer(6), new Integer(4)), Arrays.asList(new Integer(6), new Integer(1)), Arrays.asList(new Integer(6), new Integer(4)), Arrays.asList(new Integer(6), new Integer(10)), Arrays.asList(new Integer(6), new Integer(11)), Arrays.asList(new Integer(6), new Integer(11))};
        this.helpTestJoin();
    }

    @Test
    public void testInnerJoinWithLookupFunction() throws Exception {
        this.criteriaType = 2;
        this.joinType = JoinType.JOIN_INNER;
        this.expected = new List[]{Arrays.asList(new Integer(5), new Integer(6)), Arrays.asList(new Integer(3), new Integer(4)), Arrays.asList(new Integer(3), new Integer(4)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(10), new Integer(7)), Arrays.asList(new Integer(10), new Integer(7))};
        this.expectedReversed = new List[]{Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(4), new Integer(5)), Arrays.asList(new Integer(2), new Integer(3)), Arrays.asList(new Integer(2), new Integer(3)), Arrays.asList(new Integer(4), new Integer(5))};
        this.dataMgr = new FakeDataManager();
        this.dataMgr.setThrowBlocked(true);
        HashMap<Integer, Integer> valueMap = new HashMap<Integer, Integer>();
        valueMap.put(new Integer(1), new Integer(2));
        valueMap.put(new Integer(2), new Integer(3));
        valueMap.put(new Integer(3), new Integer(4));
        valueMap.put(new Integer(4), new Integer(5));
        valueMap.put(new Integer(5), new Integer(6));
        valueMap.put(new Integer(10), new Integer(7));
        valueMap.put(new Integer(11), new Integer(8));
        this.dataMgr.defineCodeTable("pm1.g1", "e1", "e2", valueMap);
        this.helpTestJoin();
    }

    @Test
    public void testFullOuterJoin() throws Exception {
        this.joinType = JoinType.JOIN_FULL_OUTER;
        this.leftTuples = this.createTuples3();
        this.rightTuples = this.createTuples4();
        this.expected = new List[]{Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(3), null), Arrays.asList(null, new Integer(4)), Arrays.asList(null, new Integer(4)), Arrays.asList(new Integer(5), new Integer(5)), Arrays.asList(null, new Integer(6)), Arrays.asList(null, new Integer(7)), Arrays.asList(new Integer(9), new Integer(9)), Arrays.asList(new Integer(9), new Integer(9)), Arrays.asList(new Integer(9), new Integer(9)), Arrays.asList(new Integer(10), new Integer(10)), Arrays.asList(new Integer(10), new Integer(10)), Arrays.asList(new Integer(15), null)};
        this.expectedReversed = new List[]{Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(null, 3), Arrays.asList(4, null), Arrays.asList(4, null), Arrays.asList(new Integer(5), new Integer(5)), Arrays.asList(6, null), Arrays.asList(7, null), Arrays.asList(new Integer(9), new Integer(9)), Arrays.asList(new Integer(9), new Integer(9)), Arrays.asList(new Integer(9), new Integer(9)), Arrays.asList(new Integer(10), new Integer(10)), Arrays.asList(new Integer(10), new Integer(10)), Arrays.asList(null, 15)};
        this.helpTestJoin();
    }

    @Test
    public void testMergeJoinOptimization() throws Exception {
        this.helpTestEnhancedSortMergeJoin(99);
    }

    private void helpTestEnhancedSortMergeJoin(int batchSize) throws TeiidComponentException, TeiidProcessingException {
        this.joinType = JoinType.JOIN_INNER;
        int rows = 100;
        List[] data = new List[rows];
        for (int i = 0; i < rows; ++i) {
            data[i] = new ArrayList();
            Integer value = new Integer(i * 17 % 47);
            data[i].add(value);
        }
        this.leftTuples = data;
        this.rightTuples = this.createTuples2();
        this.expected = new List[]{Arrays.asList(4, 4), Arrays.asList(4, 4), Arrays.asList(7, 7), Arrays.asList(7, 7), Arrays.asList(2, 2), Arrays.asList(2, 2), Arrays.asList(6, 6), Arrays.asList(1, 1), Arrays.asList(4, 4), Arrays.asList(4, 4), Arrays.asList(7, 7), Arrays.asList(7, 7), Arrays.asList(2, 2), Arrays.asList(2, 2), Arrays.asList(6, 6), Arrays.asList(1, 1), Arrays.asList(4, 4), Arrays.asList(4, 4)};
        this.helpCreateJoin();
        this.joinStrategy = new EnhancedSortMergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT);
        this.join.setJoinStrategy(this.joinStrategy);
        this.helpTestJoinDirect(this.expected, batchSize, 1);
    }

    @Test
    public void testMergeJoinOptimizationMultiBatch() throws Exception {
        this.helpTestEnhancedSortMergeJoin(10);
    }

    @Test
    public void testMergeJoinOptimizationNoRows() throws Exception {
        this.joinType = JoinType.JOIN_INNER;
        this.leftTuples = this.createTuples1();
        this.rightTuples = new List[0];
        this.expected = new List[0];
        this.helpCreateJoin();
        this.joinStrategy = new EnhancedSortMergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT);
        this.join.setJoinStrategy(this.joinStrategy);
        this.helpTestJoinDirect(this.expected, 100, 1);
    }

    @Test
    public void testMergeJoinOptimizationWithDistinct() throws Exception {
        this.joinType = JoinType.JOIN_INNER;
        int rows = 50;
        List[] data = new List[rows];
        for (int i = 0; i < rows; ++i) {
            data[i] = new ArrayList();
            Integer value = new Integer(i * 17 % 47);
            data[i].add(value);
        }
        this.leftTuples = data;
        this.rightTuples = new List[]{Arrays.asList(4), Arrays.asList(7), Arrays.asList(2), Arrays.asList(6), Arrays.asList(1), Arrays.asList(8)};
        this.expected = new List[]{Arrays.asList(4, 4), Arrays.asList(8, 8), Arrays.asList(7, 7), Arrays.asList(2, 2), Arrays.asList(6, 6), Arrays.asList(1, 1)};
        this.helpCreateJoin();
        this.joinStrategy = new EnhancedSortMergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT);
        this.join.setJoinStrategy(this.joinStrategy);
        this.helpTestJoinDirect(this.expected, 40, 1);
    }

    @Test
    public void testMergeJoinOptimizationWithDistinctAlreadySorted() throws Exception {
        this.joinType = JoinType.JOIN_INNER;
        int rows = 50;
        List[] data = new List[rows];
        for (int i = 0; i < rows; ++i) {
            data[i] = new ArrayList();
            Integer value = new Integer(i * 17 % 47);
            data[i].add(value);
        }
        this.leftTuples = data;
        this.rightTuples = new List[]{Arrays.asList(1), Arrays.asList(2), Arrays.asList(4), Arrays.asList(6), Arrays.asList(7), Arrays.asList(8)};
        this.expected = new List[]{Arrays.asList(4, 4), Arrays.asList(8, 8), Arrays.asList(7, 7), Arrays.asList(2, 2), Arrays.asList(6, 6), Arrays.asList(1, 1)};
        this.helpCreateJoin();
        this.joinStrategy = new EnhancedSortMergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.ALREADY_SORTED);
        this.join.setJoinStrategy(this.joinStrategy);
        this.helpTestJoinDirect(this.expected, 40, 1);
    }

    @Test
    public void testRepeatedMerge() throws Exception {
        this.helpTestRepeatedMerge(false);
    }

    @Test
    public void testRepeatedMergeWithDistinct() throws Exception {
        this.helpTestRepeatedMerge(true);
    }

    public void helpTestRepeatedMerge(boolean indexDistinct) throws Exception {
        int i;
        this.joinType = JoinType.JOIN_INNER;
        int rows = 69;
        List[] data = new List[rows];
        for (i = 0; i < rows; ++i) {
            data[i] = Arrays.asList(i * 17 % 91);
        }
        if (indexDistinct) {
            data[2] = Arrays.asList(0);
        }
        data[6] = Arrays.asList(new Integer[]{null});
        this.rightTuples = data;
        this.leftTuples = new List[17];
        for (i = 0; i < this.leftTuples.length; ++i) {
            this.leftTuples[i] = Arrays.asList(i);
        }
        if (!indexDistinct) {
            this.leftTuples[1] = Arrays.asList(0);
        }
        this.leftTuples[11] = Arrays.asList(new Integer[]{null});
        this.expected = new List[]{Arrays.asList(13, 13), Arrays.asList(2, 2), Arrays.asList(8, 8), Arrays.asList(14, 14), Arrays.asList(3, 3), Arrays.asList(9, 9), Arrays.asList(15, 15), Arrays.asList(4, 4), Arrays.asList(10, 10), Arrays.asList(16, 16), Arrays.asList(5, 5), Arrays.asList(0, 0), Arrays.asList(0, 0)};
        this.helpCreateJoin();
        EnhancedSortMergeJoinStrategy psj = new EnhancedSortMergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT);
        psj.setPreferMemCutoff(1);
        this.joinStrategy = psj;
        this.join.setJoinStrategy(this.joinStrategy);
        this.helpTestJoinDirect(this.expected, 4, 1000);
    }
}

