/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.events.EventDistributor;
import org.teiid.metadata.MetadataRepository;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.NodeTestUtil;
import org.teiid.query.processor.relational.ProjectIntoNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.util.CommandContext;

public class TestProjectIntoNode {
    private static final int NUM_ROWS = 1000;

    private void helpTestNextBatch(int tupleBatchSize, ProjectIntoNode.Mode mode) throws Exception {
        ProjectIntoNode node = new ProjectIntoNode(2);
        FakeDataTupleSource tupleSource = new FakeDataTupleSource(1000);
        FakeRelationalNode child = new FakeRelationalNode(1, tupleSource, tupleBatchSize);
        node.addChild((RelationalNode)child);
        node.setIntoGroup(new GroupSymbol("myGroup"));
        ElementSymbol elementSymbol_1 = new ElementSymbol("myGroup.myElement1");
        ElementSymbol elementSymbol_2 = new ElementSymbol("myGroup.myElement2");
        elementSymbol_1.setType(Integer.class);
        elementSymbol_2.setType(String.class);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(elementSymbol_1);
        elements.add(elementSymbol_2);
        node.setIntoElements(elements);
        node.setMode(mode);
        node.setModelName("myModel");
        CommandContext context = new CommandContext();
        context.setProcessorID((Object)"processorID");
        BufferManager bm = NodeTestUtil.getTestBufferManager(tupleBatchSize, tupleBatchSize);
        FakePDM dataManager = new FakePDM(tupleBatchSize);
        child.initialize(context, bm, dataManager);
        node.initialize(context, bm, (ProcessorDataManager)dataManager);
        node.open();
        TupleBatch batch = null;
        while (true) {
            try {
                batch = node.nextBatch();
            }
            catch (BlockedException e) {
                continue;
            }
            break;
        }
        Assert.assertNotNull((Object)batch);
        List[] tuples = batch.getAllTuples();
        Assert.assertEquals((long)1L, (long)tuples.length);
        Object[] columns = tuples[0].toArray();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)1L, (long)columns.length);
        Assert.assertEquals((Object)new Integer(1000), (Object)columns[0]);
    }

    @Test
    public void testNextBatch() throws Exception {
        this.helpTestNextBatch(100, ProjectIntoNode.Mode.BATCH);
    }

    @Test
    public void testNextBatch_BulkInsert() throws Exception {
        this.helpTestNextBatch(100, ProjectIntoNode.Mode.BULK);
    }

    @Test
    public void testNextBatch_NoBatching() throws Exception {
        this.helpTestNextBatch(100, ProjectIntoNode.Mode.SINGLE);
    }

    @Test
    public void testNextBatch_Size20Batches() throws Exception {
        this.helpTestNextBatch(20, ProjectIntoNode.Mode.BATCH);
    }

    @Test
    public void testNextBatch_Iterator() throws Exception {
        this.helpTestNextBatch(100, ProjectIntoNode.Mode.ITERATOR);
    }

    public static List<List<Object>> getBulkRows(Insert insert, List<ElementSymbol> elements) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        int bulkRowCount = 1;
        if (insert.isBulk()) {
            Constant c = (Constant)insert.getValues().get(0);
            bulkRowCount = ((List)c.getValue()).size();
        }
        ArrayList<List<Object>> tuples = new ArrayList<List<Object>>(bulkRowCount);
        for (int row = 0; row < bulkRowCount; ++row) {
            ArrayList<Object> currentRow = new ArrayList<Object>(insert.getValues().size());
            for (ElementSymbol symbol : elements) {
                int index = insert.getVariables().indexOf(symbol);
                Object value = null;
                if (index != -1) {
                    if (insert.isBulk()) {
                        Constant multiValue = (Constant)insert.getValues().get(index);
                        value = ((List)multiValue.getValue()).get(row);
                    } else {
                        Expression expr = (Expression)insert.getValues().get(index);
                        value = Evaluator.evaluate((Expression)expr);
                    }
                }
                currentRow.add(value);
            }
            tuples.add(currentRow);
        }
        return tuples;
    }

    private static final class FakeDataTupleSource
    implements TupleSource {
        private int currentRow = 0;
        private boolean block = true;
        private int rows;

        private FakeDataTupleSource(int rows) {
            this.rows = rows;
        }

        public void closeSource() {
        }

        public List getSchema() {
            return null;
        }

        public List nextTuple() throws TeiidComponentException {
            if (this.currentRow % 100 == 0 && this.block) {
                this.block = false;
                throw BlockedException.INSTANCE;
            }
            return ++this.currentRow > this.rows ? null : Arrays.asList(new Integer(this.currentRow), Integer.toString(this.currentRow));
        }
    }

    private static final class FakePDM
    implements ProcessorDataManager {
        private int expectedBatchSize;
        private int callCount = 0;

        private FakePDM(int expectedBatchSize) {
            this.expectedBatchSize = expectedBatchSize;
        }

        public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException {
            return null;
        }

        public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID, int limit) throws TeiidComponentException, TeiidProcessingException {
            List<List<Object>> batch;
            ++this.callCount;
            int batchSize = 1;
            if (command instanceof Insert) {
                Insert insert = (Insert)command;
                if (insert.isBulk()) {
                    batch = TestProjectIntoNode.getBulkRows(insert, insert.getVariables());
                    batchSize = batch.size();
                    Assert.assertEquals((String)("Unexpected batch on call " + this.callCount), (long)this.expectedBatchSize, (long)batchSize);
                    for (int i = 0; i < batchSize; ++i) {
                        this.ensureValue2(batch.get(i), 2, (this.callCount - 1) * batchSize + i + 1);
                    }
                } else if (insert.getTupleSource() != null) {
                    TupleSource ts = insert.getTupleSource();
                    List tuple = null;
                    int i = 0;
                    while ((tuple = ts.nextTuple()) != null) {
                        this.ensureValue2(tuple, 2, ++i);
                    }
                    batchSize = i;
                } else {
                    this.ensureValue(insert, 2, this.callCount);
                }
            } else if (command instanceof BatchedUpdateCommand) {
                BatchedUpdateCommand bu = (BatchedUpdateCommand)command;
                batch = bu.getUpdateCommands();
                batchSize = batch.size();
                Assert.assertEquals((String)("Unexpected batch on call " + this.callCount), (long)this.expectedBatchSize, (long)batchSize);
            } else {
                Assert.fail((String)"Unexpected command type");
            }
            List<Object> counts = Arrays.asList(new Integer(batchSize));
            FakeTupleSource fakeTupleSource = new FakeTupleSource(null, new List[]{counts});
            return fakeTupleSource;
        }

        private void ensureValue(Insert command, int size, int value) {
            Assert.assertNotNull((Object)command.getValues());
            Assert.assertEquals((long)size, (long)command.getValues().size());
            Assert.assertEquals((Object)new Integer(value), (Object)((Constant)command.getValues().get(0)).getValue());
        }

        private void ensureValue2(List row, int size, int value) {
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((long)size, (long)row.size());
            Object val = row.get(0);
            Assert.assertEquals((Object)new Integer(value), val);
        }

        public EventDistributor getEventDistributor() {
            return null;
        }

        public MetadataRepository getMetadataRepository() {
            return null;
        }
    }
}

