/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestAlterResolving {
    @Test
    public void testAlterView() {
        AlterView alterView = (AlterView)TestResolver.helpResolve("alter view SmallA_2589 as select 2", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Assert.assertNotNull((Object)alterView.getTarget().getMetadataID());
    }

    @Test
    public void testAlterProcedure() {
        AlterProcedure alterProc = (AlterProcedure)TestResolver.helpResolve("alter procedure MMSP5 as begin select param1; end", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Assert.assertNotNull((Object)alterProc.getTarget().getMetadataID());
        Query q = (Query)((CreateUpdateProcedureCommand)alterProc.getDefinition()).getResultsCommand();
        Assert.assertTrue((boolean)((ElementSymbol)q.getSelect().getSymbol(0)).isExternalReference());
    }

    @Test
    public void testAlterTriggerInsert() {
        AlterTrigger alterTrigger = (AlterTrigger)TestResolver.helpResolve("alter trigger on SmallA_2589 instead of insert as for each row select new.intkey;", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Assert.assertNotNull((Object)alterTrigger.getTarget().getMetadataID());
    }

    @Test
    public void testAlterTriggerInsert_Invalid() {
        TestResolver.helpResolveException("alter trigger on SmallA_2589 instead of insert as for each row select old.intkey;", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testAlterView_Invalid() {
        TestResolver.helpResolveException("alter view bqt1.SmallA as select 2", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }
}

