/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import junit.framework.TestCase;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestXMLResolver
extends TestCase {
    public Command helpResolve(String sql) {
        Command cmd = TestResolver.helpResolve(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        ResolverUtil.fullyQualifyElements((Command)cmd);
        return cmd;
    }

    public void helpResolveException(String sql) {
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    public void helpResolveException(String sql, String expectedMessage) {
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), expectedMessage);
    }

    public void testXMLCriteriaShortElement() {
        CompareCriteria expected = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc1");
        ElementSymbol es = new ElementSymbol("root.node1", null, gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where node1 = 'yyz'");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    public void testXMLCriteriaLongElement1() {
        CompareCriteria expected = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc1");
        ElementSymbol es = new ElementSymbol("root.node1", null, gs);
        es.setGroupSymbol(gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where root.node1 = 'yyz'");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    public void testXMLCriteriaLongElement2() {
        CompareCriteria expected1 = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc4");
        ElementSymbol es1 = new ElementSymbol("root.node1", null, gs);
        expected1.setLeftExpression((Expression)es1);
        expected1.setOperator(1);
        expected1.setRightExpression((Expression)new Constant((Object)"xyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc4 where root.node1 = 'xyz'");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected1, (Object)actual);
    }

    public void testXMLCriteriaLongElement3() {
        GroupSymbol gs = new GroupSymbol("xmltest.doc4");
        CompareCriteria expected2 = new CompareCriteria();
        ElementSymbol es2 = new ElementSymbol("root.node1.@node2", null, gs);
        es2.setGroupSymbol(gs);
        expected2.setLeftExpression((Expression)es2);
        expected2.setOperator(1);
        expected2.setRightExpression((Expression)new Constant((Object)"xyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc4 where root.node1.@node2 = 'xyz'");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected2, (Object)actual);
    }

    public void testXMLCriteriaLongElement4() {
        GroupSymbol gs = new GroupSymbol("xmltest.doc4");
        CompareCriteria expected3 = new CompareCriteria();
        ElementSymbol es3 = new ElementSymbol("root.node3", null, gs);
        expected3.setLeftExpression((Expression)es3);
        expected3.setOperator(1);
        expected3.setRightExpression((Expression)new Constant((Object)"xyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc4 where root.node3 = 'xyz'");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected3, (Object)actual);
    }

    public void testXMLCriteriaLongElement5() {
        this.helpResolve("select * from xmltest.doc4 where root.node1 = 'yyz'");
    }

    public void testXMLCriteriaLongElement6() {
        this.helpResolve("select * from xmltest.doc4 where root.node1.@node2 = 'yyz'");
    }

    public void testXMLCriteriaLongElement7() {
        this.helpResolve("select * from xmltest.doc4 where root.node3 = 'yyz'");
    }

    public void testXMLCriteriaLongElement8() {
        this.helpResolve("select * from xmltest.doc4 where node3 = 'yyz'");
    }

    public void testXMLCriteriaLongElementFail1() {
        this.helpResolveException("select * from xmltest.doc4 where node3.node1.node2 = 'xyz'");
    }

    public void testXMLCriteriaLongElementFail2() {
        this.helpResolveException("select * from xmltest.doc4 where root.node1.node2.node3 = 'xyz'");
    }

    public void testXMLCriteriaLongElementFail3() {
        this.helpResolveException("select * from xmltest.doc4 where root.node1.node3 = 'xyz'");
    }

    public void testXMLCriteriaLongElementFail4() {
        this.helpResolveException("select * from xmltest.doc4 where node2.node1.node2 = 'xyz'");
    }

    public void testXMLCriteriaTempElement1() {
        this.helpResolve("select * from xmltest.doc4 where tm1.g1.e1 = 'x'");
    }

    public void testXMLCriteriaTempElement2() {
        this.helpResolve("select * from xmltest.doc4 where root.node1.@node2 = 'yyz' and tm1.g1.e2 = 'y'");
    }

    public void testXMLCriteriaTempElement3() {
        this.helpResolve("select * from xmltest.doc4 where tm1.g1.e1 = 'x' and tm1.g1.e2 = 'y'");
    }

    public void testXMLCriteriaTempElementFail1() {
        this.helpResolveException("select * from xmltest.doc4 where tm1.g2.e1 = 'xyz'");
    }

    public void testXMLCriteriaTempElementFail2() {
        this.helpResolveException("select * from xmltest.doc4 where root.node1.node2.node3 = 'xyz' and e1 = 'x'");
    }

    public void testXMLCriteriaTempElementFail3() {
        this.helpResolveException("select * from xmltest.doc4 where e3 = 'xyz' and tm1.g2.e4='m'");
    }

    public void testXMLAmbiguousName1() {
        this.helpResolve("select * from xmltest.doc4 where root.node1 is null");
    }

    public void testXMLAmbiguousName2() {
        this.helpResolve("select * from xmltest.doc4 where tm1.g1.node1 = 'yyz'");
    }

    public void testXMLAmbiguousName3() {
        this.helpResolveException("select * from xmltest.doc4 where node1 = 'yyz'");
    }

    public void testXMLCriteriaLongElementInAnonymous() {
        CompareCriteria expected = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc2");
        ElementSymbol es = new ElementSymbol("root.node1.node3", null, gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc2 where root.node1.node3 = 'yyz'");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    public void testXMLAmbiguousShortName() {
        CompareCriteria expected = new CompareCriteria();
        ElementSymbol es = new ElementSymbol("node2");
        GroupSymbol gs = new GroupSymbol("doc3");
        es.setGroupSymbol(gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        this.helpResolveException("select * from xmltest.doc3 where node2 = 'yyz'");
    }

    public void testXMLAttributeInCriteria() {
        this.helpResolve("select * from xmltest.doc4 where root.node1.@node2 = 'x'");
    }

    public void testXMLAttributeInCriteria2() {
        this.helpResolve("select * from xmltest.doc4 where root.node1.node2 = 'x'");
    }

    public void testXMLAttributeInCriteria3() {
        this.helpResolve("select * from xmltest.doc4 where node2 = 'x'");
    }

    public void testXMLAttributeElementAmbiguity1() {
        this.helpResolve("select * from xmltest.doc4 where root.node3.node4 = 'x'");
    }

    public void testXMLAttributeElementAmbiguity2() {
        this.helpResolve("select * from xmltest.doc4 where root.node3.@node4 = 'x'");
    }

    public void testXMLAttributeElementAmbiguity3() {
        this.helpResolve("select * from xmltest.doc4 where root.node3.node4 = 'x' and root.node3.@node4='y'");
    }

    public void testXMLAttributeElementAmbiguity4() {
        this.helpResolve("select * from xmltest.doc4 where root.node6 = 'x'");
    }

    public void testXMLAttributeElementAmbiguity5() {
        this.helpResolve("select * from xmltest.doc4 where root.@node6 = 'x'");
    }

    public void testXMLAttributeFullPath() {
        this.helpResolve("select * from xmltest.doc4 where xmltest.doc4.root.@node6 = 'x'");
    }

    public void testXMLCriteriaLongElementWithGroup1() {
        this.helpResolve("select * from xmltest.doc4 where xmltest.doc4.root.node1 = 'yyz'");
    }

    public void testXMLCriteriaLongElementWithGroup2() {
        this.helpResolve("select * from xmltest.doc4 where xmltest.doc4.root.node1.@node2 = 'yyz'");
    }

    public void testXMLCriteriaLongElementWithGroup3() {
        this.helpResolve("select * from xmltest.doc4 where xmltest.doc4.root.node3 = 'yyz'");
    }

    public void testXMLSelect() {
        this.helpResolve("select root.node3.@node4 from xmltest.doc4");
    }

    public void testXMLSelect2() {
        this.helpResolve("select root.node3.node4 from xmltest.doc4");
    }

    public void testXMLSelect3() {
        this.helpResolve("select root.@node6 from xmltest.doc4");
    }

    public void testXMLSelect4() {
        this.helpResolve("select root.node6 from xmltest.doc4");
    }

    public void testXMLSelect5() {
        this.helpResolve("select node2 from xmltest.doc4");
    }

    public void testDEFECT_19771() {
        this.helpResolveException("select node2 AS NODE2 from xmltest.doc4");
    }

    public void testContext() {
        GroupSymbol gs1 = new GroupSymbol("xmltest.doc1");
        ElementSymbol es1 = new ElementSymbol("root.node1.node2.node3", null, gs1);
        ElementSymbol es2 = new ElementSymbol("root.node1", null, gs1);
        Expression[] exprs = new Expression[]{es1, es2};
        Function context = new Function("context", exprs);
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)context);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where context(node3, node1) = 'yyz'");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    public void testRowLimit() {
        GroupSymbol gs1 = new GroupSymbol("xmltest.doc1");
        ElementSymbol es1 = new ElementSymbol("root.node1.node2.node3", null, gs1);
        es1.setGroupSymbol(gs1);
        Expression[] exprs = new Expression[]{es1};
        Function context = new Function("rowlimit", exprs);
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)context);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)new Integer(2)));
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where rowlimit(node3) = 2");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    public void testRowLimitException() {
        GroupSymbol gs1 = new GroupSymbol("xmltest.doc1");
        ElementSymbol es1 = new ElementSymbol("root.node1.node2.node3", null, gs1);
        Expression[] exprs = new Expression[]{es1};
        Function context = new Function("rowlimitexception", exprs);
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)context);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)new Integer(2)));
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where rowlimitexception(node3) = 2");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    public void testXMLQueryFail1() {
        this.helpResolveException("SELECT DISTINCT * FROM vm1.doc1");
    }

    public void testXMLQueryFail2() {
        this.helpResolveException("SELECT a2 FROM vm1.doc1");
    }

    public void testXMLQueryFail3() {
        this.helpResolveException("SELECT * FROM vm1.doc1, vm1.doc2");
    }

    public void testXMLWithOrderBy1() {
        this.helpResolveException("select * from xmltest.doc4 order by node1");
    }

    public void testConversionInXML() {
        GroupSymbol gs1 = new GroupSymbol("xmltest.doc1");
        ElementSymbol es1 = new ElementSymbol("root.node1", null, gs1);
        Function convert = new Function("convert", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)"string")});
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)es1);
        expected.setOperator(1);
        expected.setRightExpression((Expression)convert);
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where node1 = convert(5, string)");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
        Function actualRightExpr = (Function)((CompareCriteria)actual).getRightExpression();
        TestXMLResolver.assertNotNull((String)"Failed to resolve function", (Object)actualRightExpr.getFunctionDescriptor());
    }

    public void testXMLWithSelect1() throws Exception {
        CompareCriteria expected = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc1");
        ElementSymbol es = new ElementSymbol("root.node1", null, gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)TestResolver.helpResolve(QueryParser.getQueryParser().parseCommand("select \"xml\" from xmltest.doc1 where node1 = 'yyz'"), (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    public void testXMLWithSelect1a() {
        this.helpResolveException("select 'a' from xmltest.doc1 where node1 = 'yyz'", "Expressions cannot be selected by XML Queries");
    }

    public void testXMLWithSelect2() {
        CompareCriteria expected = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc1");
        ElementSymbol es = new ElementSymbol("root.node1", null, gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)this.helpResolve("select xmltest.doc1.xml from xmltest.doc1 where node1 = 'yyz'");
        Criteria actual = query.getCriteria();
        TestXMLResolver.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }
}

