/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.util;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestElementSymbolOptimizer {
    public Command helpResolve(String sql, QueryMetadataInterface metadata) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helpTestOptimize(String sql, QueryMetadataInterface metadata, String expected) throws QueryMetadataException, TeiidComponentException, QueryParserException, QueryResolverException {
        try {
            ResolverVisitor.setFindShortName((boolean)true);
            Command command = this.helpResolve(sql, metadata);
            String actual = command.toString();
            Assert.assertEquals((String)"Expected different optimized string", (Object)expected, (Object)actual);
        }
        finally {
            ResolverVisitor.setFindShortName((boolean)false);
        }
    }

    @Test
    public void testOptimize1() throws Exception {
        this.helpTestOptimize("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1, e2 FROM pm1.g1");
    }

    @Test
    public void testOptimize2() throws Exception {
        this.helpTestOptimize("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1, pm1.g2", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1, pm1.g2");
    }

    @Test
    public void testOptimize3() throws Exception {
        this.helpTestOptimize("UPDATE pm1.g1 SET pm1.g1.e1 = 'e' WHERE pm1.g1.e2 = 3", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "UPDATE pm1.g1 SET e1 = 'e' WHERE e2 = 3");
    }

    @Test
    public void testOptimize4() throws Exception {
        this.helpTestOptimize("INSERT INTO pm1.g1 (pm1.g1.e1, pm1.g1.e2) VALUES ('e', 3)", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "INSERT INTO pm1.g1 (e1, e2) VALUES ('e', 3)");
    }

    @Test
    public void testOptimize5() throws Exception {
        this.helpTestOptimize("DELETE FROM pm1.g1 WHERE pm1.g1.e2 = 3", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "DELETE FROM pm1.g1 WHERE e2 = 3");
    }

    @Test
    public void testOptimize6() throws Exception {
        this.helpTestOptimize("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1 WHERE e2 > (SELECT AVG(pm1.g2.e2) FROM pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1)", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1, e2 FROM pm1.g1 WHERE e2 > (SELECT AVG(e2) FROM pm1.g2 WHERE pm1.g1.e1 = e1)");
    }

    @Test
    public void testOptimize7() throws Exception {
        this.helpTestOptimize("SELECT 'text' AS zz, pm1.g1.e2 FROM pm1.g1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT 'text' AS zz, e2 FROM pm1.g1");
    }

    @Test
    public void testOptimize8() throws Exception {
        this.helpTestOptimize("SELECT 1, 'xyz'", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT 1, 'xyz'");
    }

    public void helpTestFullyQualify(String sql, QueryMetadataInterface metadata, String expected) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Command command = this.helpResolve(sql, metadata);
        ResolverUtil.fullyQualifyElements((Command)command);
        String actual = command.toString();
        Assert.assertEquals((String)"Expected different fully qualified string", (Object)expected, (Object)actual);
    }

    @Test
    public void testFullyQualify1() throws Exception {
        this.helpTestFullyQualify("SELECT e1, e2 FROM pm1.g1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1");
    }

    @Test
    public void testXMLQuery() throws Exception {
        this.helpTestOptimize("SELECT root.node1.node2.node3 FROM xmltest.doc1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT root.node1.node2.node3 FROM xmltest.doc1");
    }

    @Test
    public void testVirtualStoredProcedure() throws Exception {
        this.helpTestOptimize("EXEC pm1.vsp7(5)", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "EXEC pm1.vsp7(5)");
    }

    @Test
    public void testStoredQuerySubquery() throws Exception {
        this.helpTestOptimize("select x.e1 from (EXEC pm1.sq1()) as x", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1 FROM (EXEC pm1.sq1()) AS x");
    }

    @Test
    public void testStoredQuerySubquery2() throws Exception {
        this.helpTestOptimize("select x.e1 from (EXEC pm1.sq1()) as x WHERE x.e2 = 3", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1 FROM (EXEC pm1.sq1()) AS x WHERE e2 = 3");
    }

    @Test
    public void testOptimizeOrderBy() throws Exception {
        this.helpTestOptimize("SELECT pm1.g1.e1 FROM pm1.g1 order by pm1.g1.e1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1 FROM pm1.g1 ORDER BY e1");
    }

    @Test
    public void testOptimizeOrderBy1() throws Exception {
        this.helpTestFullyQualify("SELECT e1 FROM pm1.g1 order by e1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT pm1.g1.e1 FROM pm1.g1 ORDER BY e1");
    }

    @Test
    public void testOptimizeOrderByWithoutGroup() throws Exception {
        this.helpTestOptimize("SELECT pm1.g1.e1, count(*) as x FROM pm1.g1 order by x", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "SELECT e1, COUNT(*) AS x FROM pm1.g1 ORDER BY x");
    }
}

