/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorReport;

public class TestValidator {
    public static FakeMetadataFacade exampleMetadata() {
        FakeMetadataObject modelObj = FakeMetadataFactory.createPhysicalModel("test");
        FakeMetadataObject vModelObj2 = FakeMetadataFactory.createVirtualModel("vTest");
        FakeMetadataObject groupObj = FakeMetadataFactory.createPhysicalGroup("test.group", modelObj);
        FakeMetadataObject elemObj0 = FakeMetadataFactory.createElement("test.group.e0", groupObj, "integer", 0);
        elemObj0.putProperty("supNull", Boolean.FALSE);
        FakeMetadataObject elemObj1 = FakeMetadataFactory.createElement("test.group.e1", groupObj, "string", 1);
        elemObj1.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject elemObj2 = FakeMetadataFactory.createElement("test.group.e2", groupObj, "string", 2);
        elemObj2.putProperty("supCompare", Boolean.FALSE);
        FakeMetadataObject elemObj3 = FakeMetadataFactory.createElement("test.group.e3", groupObj, "string", 3);
        elemObj3.putProperty("supLike", Boolean.FALSE);
        FakeMetadataObject group2Obj = FakeMetadataFactory.createPhysicalGroup("test.group2", modelObj);
        FakeMetadataObject elemObj2_0 = FakeMetadataFactory.createElement("test.group2.e0", group2Obj, "integer", 0);
        elemObj2_0.putProperty("supUpdate", Boolean.FALSE);
        FakeMetadataObject elemObj2_1 = FakeMetadataFactory.createElement("test.group2.e1", group2Obj, "string", 1);
        FakeMetadataObject elemObj2_2 = FakeMetadataFactory.createElement("test.group2.e2", group2Obj, "string", 2);
        elemObj2_2.putProperty("supUpdate", Boolean.FALSE);
        FakeMetadataObject group3Obj = FakeMetadataFactory.createPhysicalGroup("test.group3", modelObj);
        group3Obj.putProperty("supUpdate", Boolean.FALSE);
        FakeMetadataObject elemObj3_0 = FakeMetadataFactory.createElement("test.group3.e0", group3Obj, "integer", 0);
        FakeMetadataObject elemObj3_1 = FakeMetadataFactory.createElement("test.group3.e1", group3Obj, "string", 1);
        FakeMetadataObject elemObj3_2 = FakeMetadataFactory.createElement("test.group3.e2", group3Obj, "string", 2);
        QueryNode vNode = new QueryNode("SELECT * FROM test.group WHERE e2 = 'x'");
        FakeMetadataObject vGroup = FakeMetadataFactory.createVirtualGroup("vTest.vGroup", vModelObj2, vNode);
        List<FakeMetadataObject> vGroupE = FakeMetadataFactory.createElements(vGroup, new String[]{"e0", "e1", "e2", "e3"}, new String[]{"integer", "string", "string", "string"});
        QueryNode vNode2 = new QueryNode("SELECT * FROM test.group");
        FakeMetadataObject vGroup2 = FakeMetadataFactory.createVirtualGroup("vTest.vMap", vModelObj2, vNode2);
        List<FakeMetadataObject> vGroupE2 = FakeMetadataFactory.createElements(vGroup2, new String[]{"e0", "e1", "e2", "e3"}, new String[]{"integer", "string", "string", "string"});
        vGroupE2.get(0).putProperty("supNull", Boolean.FALSE);
        vGroupE2.get(1).putProperty("supSelect", Boolean.FALSE);
        vGroupE2.get(2).putProperty("supCompare", Boolean.FALSE);
        vGroupE2.get(3).putProperty("supLike", Boolean.FALSE);
        MappingDocument doc = new MappingDocument(false);
        MappingElement complexRoot = doc.addChildElement(new MappingElement("a0"));
        MappingElement sourceNode = complexRoot.addChildElement(new MappingElement("a1"));
        sourceNode.setSource("test.group");
        sourceNode.addChildElement(new MappingElement("a2", "test.group.e1"));
        sourceNode.addChildElement(new MappingElement("b2", "test.group.e2"));
        sourceNode.addChildElement(new MappingElement("c2", "test.group.e3"));
        FakeMetadataObject docModel = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject doc1 = FakeMetadataFactory.createVirtualGroup("vm1.doc1", docModel, doc);
        List<FakeMetadataObject> docE1 = FakeMetadataFactory.createElements(doc1, new String[]{"a0", "a0.a1", "a0.a1.a2", "a0.a1.b2", "a0.a1.c2"}, new String[]{"string", "string", "string", "string", "string"});
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(modelObj);
        store.addObject(groupObj);
        store.addObject(elemObj0);
        store.addObject(elemObj1);
        store.addObject(elemObj2);
        store.addObject(elemObj3);
        store.addObject(vGroup);
        store.addObjects(vGroupE);
        store.addObject(vGroup2);
        store.addObjects(vGroupE2);
        store.addObject(docModel);
        store.addObject(group2Obj);
        store.addObject(elemObj2_0);
        store.addObject(elemObj2_1);
        store.addObject(elemObj2_2);
        store.addObject(group3Obj);
        store.addObject(elemObj3_0);
        store.addObject(elemObj3_1);
        store.addObject(elemObj3_2);
        store.addObject(doc1);
        store.addObjects(docE1);
        return new FakeMetadataFacade(store);
    }

    public FakeMetadataFacade exampleMetadata1() {
        FakeMetadataObject modelObj = FakeMetadataFactory.createPhysicalModel("test");
        FakeMetadataObject groupObj = FakeMetadataFactory.createPhysicalGroup("test.group", modelObj);
        FakeMetadataObject elemObj0 = FakeMetadataFactory.createElement("test.group.e0", groupObj, "integer", 0);
        FakeMetadataObject elemObj1 = FakeMetadataFactory.createElement("test.group.e1", groupObj, "string", 1);
        FakeMetadataObject elemObj2 = FakeMetadataFactory.createElement("test.group.e2", groupObj, "string", 2);
        FakeMetadataObject elemObj3 = FakeMetadataFactory.createElement("test.group.e3", groupObj, "string", 3);
        elemObj0.putProperty("supNull", Boolean.FALSE);
        elemObj0.putProperty("supDefaultvalue", Boolean.FALSE);
        elemObj1.putProperty("supNull", Boolean.TRUE);
        elemObj1.putProperty("supDefaultvalue", Boolean.TRUE);
        elemObj2.putProperty("supNull", Boolean.TRUE);
        elemObj2.putProperty("supDefaultvalue", Boolean.FALSE);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(modelObj);
        store.addObject(groupObj);
        store.addObject(elemObj0);
        store.addObject(elemObj1);
        store.addObject(elemObj2);
        store.addObject(elemObj3);
        return new FakeMetadataFacade(store);
    }

    public static FakeMetadataFacade exampleMetadata2() {
        FakeMetadataObject modelObj = FakeMetadataFactory.createPhysicalModel("test");
        FakeMetadataObject groupObj = FakeMetadataFactory.createPhysicalGroup("test.group", modelObj);
        List<FakeMetadataObject> elements = FakeMetadataFactory.createElements(groupObj, new String[]{"e0", "e1", "e2", "e3", "e4", "e5"}, new String[]{"integer", "string", "object", "blob", "clob", "xml"});
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(modelObj);
        store.addObject(groupObj);
        store.addObjects(elements);
        return new FakeMetadataFacade(store);
    }

    public static FakeMetadataFacade exampleMetadata3() {
        FakeMetadataObject modelObj = FakeMetadataFactory.createPhysicalModel("test");
        FakeMetadataObject groupObj = FakeMetadataFactory.createPhysicalGroup("test.group", modelObj);
        FakeMetadataObject elemObj0 = FakeMetadataFactory.createElement("test.group.e0", groupObj, "integer", 0);
        FakeMetadataObject elemObj1 = FakeMetadataFactory.createElement("test.group.e1", groupObj, "string", 1);
        elemObj1.putProperty("supNull", Boolean.FALSE);
        elemObj1.putProperty("supDefaultvalue", Boolean.FALSE);
        elemObj1.putProperty("supAutoIncrement", Boolean.TRUE);
        elemObj1.putProperty("nameInSource", "e1:SEQUENCE=MYSEQUENCE.nextVal");
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(modelObj);
        store.addObject(groupObj);
        store.addObject(elemObj0);
        store.addObject(elemObj1);
        return new FakeMetadataFacade(store);
    }

    public static FakeMetadataFacade exampleMetadata4() {
        FakeMetadataObject modelObj = FakeMetadataFactory.createPhysicalModel("test");
        FakeMetadataObject groupObj = FakeMetadataFactory.createPhysicalGroup("test.group", modelObj);
        FakeMetadataObject elemObj0 = FakeMetadataFactory.createElement("test.group.e0", groupObj, "integer", 0);
        FakeMetadataObject elemObj1 = FakeMetadataFactory.createElement("test.group.e1", groupObj, "string", 1);
        FakeMetadataObject elemObj2 = FakeMetadataFactory.createElement("test.group.e2", groupObj, "string", 2);
        FakeMetadataObject vModelObj = FakeMetadataFactory.createVirtualModel("vTest");
        QueryNode vNode = new QueryNode("SELECT * FROM test.group");
        FakeMetadataObject vGroupObj = FakeMetadataFactory.createVirtualGroup("vTest.vGroup", vModelObj, vNode);
        FakeMetadataObject vElemObj0 = FakeMetadataFactory.createElement("vTest.vGroup.e0", vGroupObj, "integer", 0);
        FakeMetadataObject vElemObj1 = FakeMetadataFactory.createElement("vTest.vGroup.e1", vGroupObj, "string", 1);
        FakeMetadataObject vElemObj2 = FakeMetadataFactory.createElement("vTest.vGroup.e2", vGroupObj, "string", 2);
        ArrayList<FakeMetadataObject> elements = new ArrayList<FakeMetadataObject>(1);
        elements.add(vElemObj0);
        elements.add(vElemObj1);
        FakeMetadataObject vGroupAp1 = FakeMetadataFactory.createAccessPattern("vTest.vGroup.ap1", vGroupObj, elements);
        QueryNode vNode2 = new QueryNode("SELECT * FROM vTest.vGroup");
        FakeMetadataObject vGroupObj2 = FakeMetadataFactory.createVirtualGroup("vTest.vGroup2", vModelObj, vNode2);
        FakeMetadataObject vElemObj20 = FakeMetadataFactory.createElement("vTest.vGroup2.e0", vGroupObj2, "integer", 0);
        FakeMetadataObject vElemObj21 = FakeMetadataFactory.createElement("vTest.vGroup2.e1", vGroupObj2, "string", 1);
        FakeMetadataObject vElemObj22 = FakeMetadataFactory.createElement("vTest.vGroup2.e2", vGroupObj2, "string", 2);
        elements = new ArrayList(1);
        elements.add(vElemObj20);
        elements.add(vElemObj21);
        FakeMetadataObject vGroup2Ap1 = FakeMetadataFactory.createAccessPattern("vTest.vGroup2.ap1", vGroupObj2, elements);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(modelObj);
        store.addObject(groupObj);
        store.addObject(elemObj0);
        store.addObject(elemObj1);
        store.addObject(elemObj2);
        store.addObject(vModelObj);
        store.addObject(vGroupObj);
        store.addObject(vElemObj0);
        store.addObject(vElemObj1);
        store.addObject(vElemObj2);
        store.addObject(vGroupAp1);
        store.addObject(vGroupObj2);
        store.addObject(vElemObj20);
        store.addObject(vElemObj21);
        store.addObject(vElemObj22);
        store.addObject(vGroup2Ap1);
        return new FakeMetadataFacade(store);
    }

    static Command helpResolve(String sql, QueryMetadataInterface metadata) {
        Command command = null;
        try {
            command = QueryParser.getQueryParser().parseCommand(sql);
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        return command;
    }

    static Command helpResolve(String sql, GroupSymbol container, int type, QueryMetadataInterface metadata) {
        Command command = null;
        try {
            command = QueryParser.getQueryParser().parseCommand(sql);
            QueryResolver.resolveCommand((Command)command, (GroupSymbol)container, (int)type, (QueryMetadataInterface)metadata);
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        return command;
    }

    static ValidatorReport helpValidate(String sql, String[] expectedStringArray, QueryMetadataInterface metadata) {
        Command command = TestValidator.helpResolve(sql, metadata);
        return TestValidator.helpRunValidator(command, expectedStringArray, metadata);
    }

    public static ValidatorReport helpRunValidator(Command command, String[] expectedStringArray, QueryMetadataInterface metadata) {
        try {
            ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
            TestValidator.examineReport(command, expectedStringArray, report);
            return report;
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private static void examineReport(Object command, String[] expectedStringArray, ValidatorReport report) {
        ArrayList actualObjs = new ArrayList();
        report.collectInvalidObjects(actualObjs);
        HashSet<String> expectedStrings = new HashSet<String>(Arrays.asList(expectedStringArray));
        HashSet<String> actualStrings = new HashSet<String>();
        for (LanguageObject obj : actualObjs) {
            actualStrings.add(SQLStringVisitor.getSQLString((LanguageObject)obj));
        }
        if (expectedStrings.size() == 0 && actualStrings.size() > 0) {
            Assert.fail((String)("Expected no failures but got some: " + report.getFailureMessage()));
        } else if (actualStrings.size() == 0 && expectedStrings.size() > 0) {
            Assert.fail((String)("Expected some failures but got none for sql = " + command));
        } else {
            Assert.assertEquals((String)"Expected and actual sets of strings are not the same: ", expectedStrings, actualStrings);
        }
    }

    private void helpValidateProcedure(String procedure, String userUpdateStr, String procedureType) {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc(procedureType, procedure);
        try {
            this.validateProcedure(userUpdateStr, (QueryMetadataInterface)metadata);
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private void validateProcedure(String userUpdateStr, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException, QueryValidatorException {
        ProcedureContainer command = (ProcedureContainer)TestValidator.helpResolve(userUpdateStr, metadata);
        Command proc = QueryResolver.expandCommand((ProcedureContainer)command, (QueryMetadataInterface)metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        ValidatorReport report = Validator.validate((LanguageObject)proc, (QueryMetadataInterface)metadata);
        if (report.hasItems()) {
            throw new QueryValidatorException(report.getFailureMessage());
        }
        report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        if (report.hasItems()) {
            throw new QueryValidatorException(report.getFailureMessage());
        }
    }

    private void helpFailProcedure(String procedure, String userUpdateStr, String procedureType) {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc(procedureType, procedure);
        try {
            this.validateProcedure(userUpdateStr, (QueryMetadataInterface)metadata);
            Assert.fail((String)("Expected failures for " + procedure));
        }
        catch (QueryValidatorException e) {
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testSelectStarWhereNoElementsAreNotSelectable() {
        TestValidator.helpValidate("SELECT * FROM pm1.g5", new String[]{"SELECT * FROM pm1.g5"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateSelect1() {
        TestValidator.helpValidate("SELECT e1, e2 FROM test.group", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateSelect2() {
        TestValidator.helpValidate("SELECT e2 FROM test.group", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompare1() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap WHERE e2 = 'a'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompare4() {
        TestValidator.helpValidate("SELECT e3 FROM vTest.vMap WHERE e3 LIKE 'a'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompare6() {
        TestValidator.helpValidate("SELECT e0 FROM vTest.vMap WHERE e0 BETWEEN 1000 AND 2000", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompareInHaving2() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap GROUP BY e2 HAVING e2 IS NULL", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompareInHaving3() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap GROUP BY e2 HAVING e2 IN ('a')", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompareInHaving4() {
        TestValidator.helpValidate("SELECT e3 FROM vTest.vMap GROUP BY e3 HAVING e3 LIKE 'a'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompareInHaving5() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap GROUP BY e2 HAVING e2 BETWEEN 1000 AND 2000", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidAggregate1() {
        TestValidator.helpValidate("SELECT SUM(e3) FROM test.group GROUP BY e2", new String[]{"SUM(e3)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidAggregate2() {
        TestValidator.helpValidate("SELECT e3 FROM test.group GROUP BY e2", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidAggregate3() {
        TestValidator.helpValidate("SELECT SUM(e2) FROM test.group GROUP BY e2", new String[]{"SUM(e2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidAggregate4() {
        TestValidator.helpValidate("SELECT AVG(e2) FROM test.group GROUP BY e2", new String[]{"AVG(e2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidAggregate5() {
        TestValidator.helpValidate("SELECT e1 || 'x' frOM pm1.g1 GROUP BY e2 + 1", new String[]{"e1"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidAggregate6() {
        TestValidator.helpValidate("SELECT e2 + 1 frOM pm1.g1 GROUP BY e2 + 1 HAVING e1 || 'x' > 0", new String[]{"e1"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidAggregate7() {
        TestValidator.helpValidate("SELECT StringKey, SUM(length(StringKey || 'x')) + 1 AS x FROM BQT1.SmallA GROUP BY StringKey || 'x' HAVING space(MAX(length((StringKey || 'x') || 'y'))) = '   '", new String[]{"StringKey"}, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testInvalidAggregate8() {
        TestValidator.helpValidate("SELECT max(ObjectValue) FROM BQT1.SmallA GROUP BY StringKey", new String[]{"MAX(ObjectValue)"}, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testInvalidAggregate9() {
        TestValidator.helpValidate("SELECT count(distinct ObjectValue) FROM BQT1.SmallA GROUP BY StringKey", new String[]{"COUNT(DISTINCT ObjectValue)"}, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testInvalidAggregateIssue190644() {
        TestValidator.helpValidate("SELECT e3 + 1 from pm1.g1 GROUP BY e2 + 1 HAVING e2 + 1 = 5", new String[]{"e3"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidAggregate1() {
        TestValidator.helpValidate("SELECT (e2 + 1) * 2 frOM pm1.g1 GROUP BY e2 + 1", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidAggregate2() {
        TestValidator.helpValidate("SELECT e2 + 1 frOM pm1.g1 GROUP BY e2 + 1", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidAggregate3() {
        TestValidator.helpValidate("SELECT sum (IntKey), case when IntKey>=5000 then '5000 +' else '0-999' end FROM BQT1.SmallA GROUP BY case when IntKey>=5000 then '5000 +' else '0-999' end", new String[0], (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testInvalidHaving1() {
        TestValidator.helpValidate("SELECT e3 FROM test.group HAVING e3 > 0", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidHaving2() {
        TestValidator.helpValidate("SELECT e3 FROM test.group HAVING concat(e3,'a') > 0", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testNestedAggregateInHaving() {
        TestValidator.helpValidate("SELECT e0 FROM test.group GROUP BY e0 HAVING SUM(COUNT(e0)) > 0", new String[]{"COUNT(e0)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testNestedAggregateInSelect() {
        TestValidator.helpValidate("SELECT SUM(COUNT(e0)) FROM test.group GROUP BY e0", new String[]{"COUNT(e0)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCaseInGroupBy() {
        TestValidator.helpValidate("SELECT SUM(e2) FROM pm1.g1 GROUP BY CASE e2 WHEN 0 THEN 1 ELSE 2 END", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateFunctionInGroupBy() {
        TestValidator.helpValidate("SELECT SUM(e2) FROM pm1.g1 GROUP BY (e2 + 1)", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidScalarSubqueryInGroupBy() {
        TestValidator.helpValidate("SELECT COUNT(*) FROM pm1.g1 GROUP BY (SELECT 1)", new String[]{"(SELECT 1)"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidConstantInGroupBy() {
        TestValidator.helpValidate("SELECT COUNT(*) FROM pm1.g1 GROUP BY 1", new String[]{"1"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidReferenceInGroupBy() {
        TestValidator.helpValidate("SELECT COUNT(*) FROM pm1.g1 GROUP BY ?", new String[]{"?"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateObjectType1() {
        TestValidator.helpValidate("SELECT DISTINCT * FROM test.group", new String[]{"test.\"group\".e2", "test.\"group\".e3", "test.\"group\".e4", "test.\"group\".e5"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateObjectType2() {
        TestValidator.helpValidate("SELECT * FROM test.group ORDER BY e1, e2", new String[]{"e2"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateObjectType3() {
        TestValidator.helpValidate("SELECT e2 AS x FROM test.group ORDER BY x", new String[]{"x"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNonComparableType() {
        TestValidator.helpValidate("SELECT e3 FROM test.group ORDER BY e3", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNonComparableType1() {
        TestValidator.helpValidate("SELECT e3 FROM test.group union SELECT e3 FROM test.group", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNonComparableType2() {
        TestValidator.helpValidate("SELECT e3 FROM test.group GROUP BY e3", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNonComparableType3() {
        TestValidator.helpValidate("SELECT e3 FROM test.group intersect SELECT e3 FROM test.group", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNonComparableType4() {
        TestValidator.helpValidate("SELECT e3 FROM test.group except SELECT e3 FROM test.group", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateIntersectAll() {
        TestValidator.helpValidate("SELECT e3 FROM pm1.g1 intersect all SELECT e3 FROM pm1.g1", new String[]{"SELECT e3 FROM pm1.g1 INTERSECT ALL SELECT e3 FROM pm1.g1"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateSetSelectInto() {
        TestValidator.helpValidate("SELECT e3 into #temp FROM pm1.g1 intersect all SELECT e3 FROM pm1.g1", new String[]{"SELECT e3 INTO #temp FROM pm1.g1 INTERSECT ALL SELECT e3 FROM pm1.g1"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInsert1() {
        TestValidator.helpValidate("INSERT INTO test.group (e0) VALUES (null)", new String[]{"e0"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInsert4() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadata1();
        Command command = QueryParser.getQueryParser().parseCommand("INSERT INTO test.group (e0) VALUES (2)");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[0], (QueryMetadataInterface)metadata);
    }

    @Test
    public void testInsert5() throws Exception {
        FakeMetadataFacade metadata = this.exampleMetadata1();
        Command command = QueryParser.getQueryParser().parseCommand("INSERT INTO test.group (e1, e2) VALUES ('x', 'y')");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{"test.\"group\".e0"}, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testValidateInsertElements1() throws Exception {
        FakeMetadataFacade metadata = TestValidator.exampleMetadata();
        Command command = QueryParser.getQueryParser().parseCommand("INSERT INTO test.group2 (e0, e1, e2) VALUES (5, 'x', 'y')");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{"e2", "e0"}, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testValidateInsertElements2() throws Exception {
        FakeMetadataFacade metadata = TestValidator.exampleMetadata();
        Command command = QueryParser.getQueryParser().parseCommand("INSERT INTO test.group2 (e1) VALUES ('y')");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[0], (QueryMetadataInterface)metadata);
    }

    @Test
    public void testValidateInsertElements3_autoIncNotRequired() throws Exception {
        TestValidator.helpValidate("INSERT INTO test.group (e0) VALUES (1)", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata3());
    }

    @Test
    public void testUpdate1() {
        TestValidator.helpValidate("UPDATE test.group SET e0=null", new String[]{"e0"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testUpdate2() {
        TestValidator.helpValidate("UPDATE test.group SET e0=1, e0=2", new String[]{"e0"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateUpdateElements1() throws Exception {
        FakeMetadataFacade metadata = TestValidator.exampleMetadata();
        Command command = QueryParser.getQueryParser().parseCommand("UPDATE test.group2 SET e0 = 5, e1 = 'x', e2 = 'y'");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{"e2", "e0"}, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testValidateUpdateElements2() throws Exception {
        FakeMetadataFacade metadata = TestValidator.exampleMetadata();
        Command command = QueryParser.getQueryParser().parseCommand("UPDATE test.group2 SET e1 = 'x'");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[0], (QueryMetadataInterface)metadata);
    }

    @Test
    public void testXMLQuery1() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQuery2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where a2='x'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQuery3() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 order by a2", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQuery6() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 UNION SELECT * FROM vm1.doc1", new String[]{"\"xml\"", "SELECT * FROM vm1.doc1 UNION SELECT * FROM vm1.doc1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryWithLimit() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 limit 1", new String[]{"SELECT * FROM vm1.doc1 LIMIT 1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = RowLimit(a2)", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit1() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimit(a2)=-1", new String[]{"RowLimit(a2) = -1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimit(a2)='x'", new String[]{"RowLimit(a2) = 'x'"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitNested() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimit(a2)=a2", new String[]{"RowLimit(a2) = a2"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitNested2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where convert(RowLimit(a2), string)=a2", new String[]{"convert(RowLimit(a2), string) = a2"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit3a() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimit(a2) = convert(a2, integer)", new String[]{"RowLimit(a2) = convert(a2, integer)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit3b() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where convert(a2, integer) = RowLimit(a2)", new String[]{"convert(a2, integer) = RowLimit(a2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit('x') = 3", new String[]{"rowlimit('x')"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(concat(a2, 'x')) = 3", new String[]{"rowlimit(concat(a2, 'x'))"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitConjunct() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 OR a2 = 'x'", new String[]{"(rowlimit(a2) = 3) OR (a2 = 'x')"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitCompound() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 AND a2 = 'x'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitCompound2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 AND concat(a2, 'y') = 'xy'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitCompound3() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 AND (concat(a2, 'y') = 'xy' OR concat(a2, 'y') = 'zy')", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitCompound4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 AND rowlimit(c2) = 4", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitCompound5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 AND rowlimit(a2) = 4", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where not(rowlimit(a2) = 3)", new String[]{"NOT (rowlimit(a2) = 3)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) IN (3)", new String[]{"rowlimit(a2) IN (3)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria3() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) LIKE 'x'", new String[]{"rowlimit(a2) LIKE 'x'"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) IS NULL", new String[]{"rowlimit(a2) IS NULL"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) IN (SELECT e0 FROM vTest.vMap)", new String[]{"rowlimit(a2) IN (SELECT e0 FROM vTest.vMap)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria6() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = CASE WHEN rowlimit(a2) = 2 THEN 2 END", new String[]{"2 = CASE WHEN rowlimit(a2) = 2 THEN 2 END"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria6a() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = CASE rowlimit(a2) WHEN 2 THEN 2 END", new String[]{"2 = CASE rowlimit(a2) WHEN 2 THEN 2 END"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria7() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) BETWEEN 2 AND 3", new String[]{"rowlimit(a2) BETWEEN 2 AND 3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria8() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = ANY (SELECT e0 FROM vTest.vMap)", new String[]{"rowlimit(a2) = ANY (SELECT e0 FROM vTest.vMap)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testNonXMLQueryRowLimit() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap WHERE rowlimit(e1) = 2", new String[]{"rowlimit(e1)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = RowLimitException(a2)", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException1() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimitException(a2)=-1", new String[]{"RowLimitException(a2) = -1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimitException(a2)='x'", new String[]{"RowLimitException(a2) = 'x'"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionNested() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimitException(a2)=a2", new String[]{"RowLimitException(a2) = a2"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionNested2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where convert(RowLimitException(a2), string)=a2", new String[]{"convert(RowLimitException(a2), string) = a2"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException3a() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimitException(a2) = convert(a2, integer)", new String[]{"RowLimitException(a2) = convert(a2, integer)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException3b() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where convert(a2, integer) = RowLimitException(a2)", new String[]{"convert(a2, integer) = RowLimitException(a2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception('x') = 3", new String[]{"rowlimitexception('x')"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(concat(a2, 'x')) = 3", new String[]{"rowlimitexception(concat(a2, 'x'))"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionConjunct() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 OR a2 = 'x'", new String[]{"(rowlimitexception(a2) = 3) OR (a2 = 'x')"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionCompound() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 AND a2 = 'x'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionCompound2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 AND concat(a2, 'y') = 'xy'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionCompound3() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 AND (concat(a2, 'y') = 'xy' OR concat(a2, 'y') = 'zy')", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionCompound4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 AND rowlimitexception(c2) = 4", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionCompound5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 AND rowlimitexception(a2) = 4", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where not(rowlimitexception(a2) = 3)", new String[]{"NOT (rowlimitexception(a2) = 3)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) IN (3)", new String[]{"rowlimitexception(a2) IN (3)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria3() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) LIKE 'x'", new String[]{"rowlimitexception(a2) LIKE 'x'"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) IS NULL", new String[]{"rowlimitexception(a2) IS NULL"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) IN (SELECT e0 FROM vTest.vMap)", new String[]{"rowlimitexception(a2) IN (SELECT e0 FROM vTest.vMap)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria6() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = CASE WHEN rowlimitexception(a2) = 2 THEN 2 END", new String[]{"2 = CASE WHEN rowlimitexception(a2) = 2 THEN 2 END"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria6a() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = CASE rowlimitexception(a2) WHEN 2 THEN 2 END", new String[]{"2 = CASE rowlimitexception(a2) WHEN 2 THEN 2 END"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria7() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) BETWEEN 2 AND 3", new String[]{"rowlimitexception(a2) BETWEEN 2 AND 3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria8() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = ANY (SELECT e0 FROM vTest.vMap)", new String[]{"rowlimitexception(a2) = ANY (SELECT e0 FROM vTest.vMap)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testNonXMLQueryRowLimitException() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap WHERE rowlimitexception(e1) = 2", new String[]{"rowlimitexception(e1)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testNonXMLQueryContextOperator() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap WHERE context(e1, e1) = 2", new String[]{"context(e1, e1)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateSubquery1() {
        TestValidator.helpValidate("SELECT e2 FROM (SELECT e2 FROM vTest.vMap WHERE e2 = 'a') AS x", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateSubquery2() {
        TestValidator.helpValidate("SELECT e2 FROM (SELECT e3 FROM vTest.vMap) AS x, vTest.vMap WHERE e2 = 'a'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateSubquery3() {
        TestValidator.helpValidate("SELECT * FROM pm1.g1, (EXEC pm1.sq1( )) AS alias", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateUnionWithSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 union all SELECT e3 FROM test.group union all select * from (SELECT e1 FROM test.group) as subquery1", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateExistsSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE EXISTS (SELECT e2 FROM vTest.vMap WHERE e2 = 'a')", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateScalarSubquery() {
        TestValidator.helpValidate("SELECT e2, (SELECT e1 FROM vTest.vMap WHERE e2 = '3') FROM test.group2", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateAnyCompareSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 < ANY (SELECT e1 FROM test.group)", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateAllCompareSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 = ALL (SELECT e1 FROM test.group)", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateSomeCompareSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 <= SOME (SELECT e1 FROM test.group)", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompareSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 >= (SELECT e1 FROM test.group WHERE e1 = 1)", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateInClauseSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 IN (SELECT e1 FROM test.group)", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateExec1() {
        TestValidator.helpValidate("EXEC pm1.sq1()", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testCreateUpdateProcedure4() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpValidateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure5() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(HAS CRITERIA ON (vm1.g1.E1, vm1.g1.e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpValidateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure7() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e1 from pm1.g1 where Translate CRITERIA WITH (vm1.g1.e1 = 1, vm1.g1.e1 = 2);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpValidateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure8() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e1 from pm1.g1 where Translate CRITERIA WITH (vm1.g1.e1 = 1);\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure11() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2, pm1.g1.e1 from pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure12() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2, pm1.g1.e1 from pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure13() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(TRANSLATE CRITERIA ON (vm1.g1.e1) WITH (vm1.g1.e1 = 1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpValidateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure16() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "INSERT into pm1.g1 (pm1.g1.e1) values (INPUT.e1);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpValidateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure17() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1, pm1.g2 where TRANSLATE = CRITERIA ON (e1) WITH (e1 = 20, e2 = 30);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Ignore
    @Test
    public void testCreateUpdateProcedure18() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE = CRITERIA ON (e3);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where e3= 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Ignore
    @Test
    public void testCreateUpdateProcedure18a() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE = CRITERIA ON (e3);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y like '%a' and e3= 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure19() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g2.e2 from pm1.g2 where TRANSLATE = CRITERIA ON (x, y);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y= 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure20() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE = CRITERIA WITH (y = e2+1);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y= 1";
        this.helpValidateProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure25() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g2.e2 from pm1.g2 where TRANSLATE > CRITERIA ON (y);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y > 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure26() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE = CRITERIA WITH (e3 = e2+1);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where e3 > 1";
        this.helpValidateProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure27() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g2.e2 from pm1.g2 where TRANSLATE LIKE CRITERIA WITH (y = e2+1);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure31() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string MaxTran;\n";
        procedure = procedure + "MaxTran = SELECT MAX(e1) FROM pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure32() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string var;\n";
        procedure = procedure + "var = null;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testDefect13643() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "LOOP ON (SELECT * FROM pm1.g1) AS myCursor\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var1 = SELECT COUNT(*) FROM myCursor;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ROWS_UPDATED = 0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testValidHaving() {
        TestValidator.helpValidate("SELECT intnum FROM bqt1.smalla GROUP BY intnum HAVING SUM(floatnum) > 1", new String[0], (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testValidHaving2() {
        String sql = "SELECT intkey FROM bqt1.smalla WHERE intkey = 1 GROUP BY intkey HAVING intkey = 1";
        TestValidator.helpValidate(sql, new String[0], (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testVirtualProcedure() {
        TestValidator.helpValidate("EXEC pm1.vsp1()", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testSelectWithNoFrom() {
        TestValidator.helpValidate("SELECT 5", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testSelectIntoTempGroup() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3, e4 INTO #myTempTable FROM pm1.g2;\n";
        procedure = procedure + "ROWS_UPDATED = SELECT COUNT(*) FROM #myTempTable;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testInvalidSelectIntoTempGroup() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3, e4 INTO #myTempTable FROM pm1.g2;\n";
        procedure = procedure + "SELECT e1, e2, e3 INTO #myTempTable FROM pm1.g2;\n";
        procedure = procedure + "ROWS_UPDATED = SELECT COUNT(*) FROM #myTempTable;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testInvalidSelectIntoTempGroup1() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "create local temporary table #myTempTable (e1 integer);\n";
        procedure = procedure + "SELECT e1 INTO #myTempTable FROM pm1.g2;\n";
        procedure = procedure + "ROWS_UPDATED = SELECT COUNT(*) FROM #myTempTable;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testSelectIntoPhysicalGroup() {
        TestValidator.helpValidate("SELECT e1, e2, e3, e4 INTO pm1.g1 FROM pm1.g2", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3, e4 INTO pm1.g1 FROM pm1.g2;\n";
        procedure = procedure + "ROWS_UPDATED = 0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testSelectIntoPhysicalGroupNotUpdateable_Defect16857() {
        TestValidator.helpValidate("SELECT e0, e1, e2 INTO test.group3 FROM test.group2", new String[]{"test.group3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testSelectIntoElementsNotUpdateable() {
        TestValidator.helpValidate("SELECT e0, e1, e2 INTO test.group2 FROM test.group3", new String[]{"test.group2"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidSelectIntoTooManyElements() {
        TestValidator.helpValidate("SELECT e1, e2, e3, e4, 'val' INTO pm1.g1 FROM pm1.g2", new String[]{"SELECT e1, e2, e3, e4, 'val' INTO pm1.g1 FROM pm1.g2"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3, e4, 'val' INTO pm1.g1 FROM pm1.g2;\n";
        procedure = procedure + "ROWS_UPDATED = 0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testInvalidSelectIntoTooFewElements() {
        TestValidator.helpValidate("SELECT e1, e2, e3 INTO pm1.g1 FROM pm1.g2", new String[]{"SELECT e1, e2, e3 INTO pm1.g1 FROM pm1.g2"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3 INTO pm1.g1 FROM pm1.g2;\n";
        procedure = procedure + "ROWS_UPDATED = 0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testInvalidSelectIntoIncorrectTypes() {
        TestValidator.helpValidate("SELECT e1, convert(e2, string), e3, e4 INTO pm1.g1 FROM pm1.g2", new String[]{"SELECT e1, convert(e2, string), e3, e4 INTO pm1.g1 FROM pm1.g2"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, convert(e2, string), e3, e4 INTO pm1.g1 FROM pm1.g2;\n";
        procedure = procedure + "ROWS_UPDATED = 0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testSelectIntoWithStar() {
        TestValidator.helpResolve("SELECT * INTO pm1.g1 FROM pm1.g2", (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidSelectIntoWithStar() {
        TestValidator.helpValidate("SELECT * INTO pm1.g1 FROM pm1.g2, pm1.g1", new String[]{"SELECT * INTO pm1.g1 FROM pm1.g2, pm1.g1"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT * INTO pm1.g1 FROM pm1.g2, pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED = 0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testSelectIntoVirtualGroup() {
        TestValidator.helpValidate("SELECT e1, e2, e3, e4 INTO vm1.g1 FROM pm1.g2", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3, e4 INTO vm1.g1 FROM pm1.g2;\n";
        procedure = procedure + "ROWS_UPDATED = 0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testVirtualProcedure2() {
        TestValidator.helpValidate("EXEC pm1.vsp13()", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedure3() {
        TestValidator.helpValidate("EXEC pm1.vsp27()", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testNonEmbeddedSubcommand_defect11000() {
        TestValidator.helpValidate("SELECT e0 FROM vTest.vGroup", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateObjectInComparison() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE ObjectValue = 5";
        ValidatorReport report = TestValidator.helpValidate(sql, new String[]{"ObjectValue = 5"}, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
        Assert.assertEquals((Object)"Expressions of type OBJECT, CLOB, BLOB, or XML cannot be used in comparison: ObjectValue = 5.", (Object)report.toString());
    }

    @Test
    public void testValidateAssignmentWithFunctionOnParameter_InServer() throws Exception {
        String sql = "EXEC pm1.vsp36(5)";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Command command = new QueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)0L, (long)report.getItems().size());
    }

    @Test
    public void testDefect9917() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        String sql = "SELECT lookup('pm1.g1', 'e1a', 'e2', e2) AS x, lookup('pm1.g1', 'e4', 'e3', e3) AS y FROM pm1.g1";
        Command command = new QueryParser().parseCommand(sql);
        try {
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
            Assert.fail((String)"Did not get exception");
        }
        catch (QueryResolverException e) {
            // empty catch block
        }
        sql = "SELECT lookup('pm1.g1a', 'e1', 'e2', e2) AS x, lookup('pm1.g1', 'e4', 'e3', e3) AS y FROM pm1.g1";
        command = new QueryParser().parseCommand(sql);
        try {
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
            Assert.fail((String)"Did not get exception");
        }
        catch (QueryResolverException e) {
            // empty catch block
        }
    }

    @Test
    public void testLookupKeyElementComparable() throws Exception {
        FakeMetadataFacade metadata = TestValidator.exampleMetadata2();
        String sql = "SELECT lookup('test.group', 'e2', 'e3', convert(e2, blob)) AS x FROM test.group";
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((Object)"Expressions of type OBJECT, CLOB, BLOB, or XML cannot be used as LOOKUP key columns: test.\"group\".e3.", (Object)report.toString());
    }

    @Test
    public void testDefect12107() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        String sql = "SELECT SUM(DISTINCT lookup('pm1.g1', 'e2', 'e2', e2)) FROM pm1.g1";
        Command command = TestValidator.helpResolve(sql, (QueryMetadataInterface)metadata);
        sql = "SELECT SUM(DISTINCT lookup('pm1.g1', 'e3', 'e2', e2)) FROM pm1.g1";
        command = TestValidator.helpResolve(sql, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((Object)"The aggregate function SUM cannot be used with non-numeric expressions: SUM(DISTINCT lookup('pm1.g1', 'e3', 'e2', e2))", (Object)report.toString());
    }

    private ValidatorReport helpValidateInModeler(String procName, String procSql, QueryMetadataInterface metadata) throws Exception {
        Command command = new QueryParser().parseCommand(procSql);
        GroupSymbol group = new GroupSymbol(procName);
        QueryResolver.resolveCommand((Command)command, (GroupSymbol)group, (int)6, (QueryMetadataInterface)metadata);
        return Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testValidateDynamicCommandWithNonTempGroup_InModeler() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN execute string 'select ' || '1' as X integer into pm1.g3; END";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", sql, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)1L, (long)report.getItems().size());
        Assert.assertEquals((Object)"Wrong number of elements being SELECTed INTO the target table. Expected 4 elements, but was 1.", (Object)report.toString());
    }

    @Test
    public void testDynamicDupUsing() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN execute string 'select ' || '1' as X integer into #temp using id=1, id=2; END";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", sql, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)1L, (long)report.getItems().size());
        Assert.assertEquals((Object)"Elements cannot appear more than once in a SET or USING clause.  The following elements are duplicated: [DVARS.id]", (Object)report.toString());
    }

    @Test
    public void testValidateAssignmentWithFunctionOnParameter_InModeler() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x = pm1.vsp36.param1 * 2; SELECT x; END";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", sql, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)0L, (long)report.getItems().size());
    }

    @Test
    public void testDefect12533() {
        String sql = "SELECT BQT1.SmallA.DateValue, BQT2.SmallB.ObjectValue FROM BQT1.SmallA, BQT2.SmallB WHERE BQT1.SmallA.DateValue = BQT2.SmallB.DateValue AND BQT1.SmallA.ObjectValue = BQT2.SmallB.ObjectValue AND BQT1.SmallA.IntKey < 30 AND BQT2.SmallB.IntKey < 30 ORDER BY BQT1.SmallA.DateValue";
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        TestValidator.helpValidate(sql, new String[]{"BQT1.SmallA.ObjectValue = BQT2.SmallB.ObjectValue"}, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16772() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN IF (pm1.vsp42.param1 > 0) SELECT 1 AS x; ELSE SELECT 0 AS x; END";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp42", sql, (QueryMetadataInterface)metadata);
        Assert.assertEquals((String)"Expected report to have no validation failures", (Object)false, (Object)report.hasItems());
    }

    @Test
    public void testDefect14886() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN END";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Command command = new QueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)0L, (long)report.getItems().size());
    }

    @Test
    public void testDefect21389() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN SELECT * INTO #temptable FROM pm1.g1; INSERT INTO #temptable (e1) VALUES ('a'); END";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject e1 = metadata.getStore().findObject("pm1.g1.e1", "Element");
        e1.putProperty("supUpdate", Boolean.FALSE);
        Command command = new QueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)0L, (long)report.getItems().size());
    }

    @Test
    public void testMakeNotDep() {
        TestValidator.helpValidate("select group2.e1, group3.e2 from group2, group3 WHERE group2.e0 = group3.e0 OPTION MAKENOTDEP group2, group3", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidMakeNotDep() {
        TestValidator.helpValidate("select group2.e1, group3.e2 from group2, group3 WHERE group2.e0 = group3.e0 OPTION MAKEDEP group2 MAKENOTDEP group2, group3", new String[]{"OPTION MAKEDEP group2 MAKENOTDEP group2, group3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidLimit() {
        TestValidator.helpValidate("SELECT * FROM pm1.g1 LIMIT -5", new String[]{"LIMIT -5"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidLimit_Offset() {
        TestValidator.helpValidate("SELECT * FROM pm1.g1 LIMIT -1, 100", new String[]{"LIMIT -1, 100"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testCase4237() {
        FakeMetadataFacade metadata = this.helpCreateCase4237VirtualProcedureMetadata();
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN EXEC pm1.sp(vm1.sp.in1); END";
        Command command = TestValidator.helpResolve(sql, new GroupSymbol("vm1.sp"), 6, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[0], (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCase4237InlineView() {
        FakeMetadataFacade metadata = this.helpCreateCase4237VirtualProcedureMetadata();
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN SELECT * FROM (EXEC pm1.sp(vm1.sp.in1)) AS FOO; END";
        Command command = TestValidator.helpResolve(sql, new GroupSymbol("vm1.sp"), 6, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[0], (QueryMetadataInterface)metadata);
    }

    private FakeMetadataFacade helpCreateCase4237VirtualProcedureMetadata() {
        FakeMetadataObject physicalModel = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject resultSet = FakeMetadataFactory.createResultSet("pm1.rs", physicalModel, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject returnParam = FakeMetadataFactory.createParameter("ret", 1, 5, "object", resultSet);
        FakeMetadataObject inParam = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        FakeMetadataObject storedProcedure = FakeMetadataFactory.createStoredProcedure("pm1.sp", physicalModel, Arrays.asList(returnParam, inParam));
        FakeMetadataObject virtualModel = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject virtualResultSet = FakeMetadataFactory.createResultSet("vm1.rs", physicalModel, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject virtualReturnParam = FakeMetadataFactory.createParameter("ret", 1, 5, "object", virtualResultSet);
        FakeMetadataObject virtualInParam = FakeMetadataFactory.createParameter("in1", 2, 1, "string", null);
        QueryNode queryNode = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN EXEC pm1.sp(vm1.sp.in1); END");
        FakeMetadataObject virtualStoredProcedure = FakeMetadataFactory.createVirtualProcedure("vm1.sp", physicalModel, Arrays.asList(virtualReturnParam, virtualInParam), queryNode);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(physicalModel);
        store.addObject(resultSet);
        store.addObject(storedProcedure);
        store.addObject(virtualModel);
        store.addObject(virtualResultSet);
        store.addObject(virtualStoredProcedure);
        return new FakeMetadataFacade(store);
    }

    @Test
    public void testSelectIntoWithNull() {
        TestValidator.helpValidate("SELECT null, null, null, null INTO pm1.g1 FROM pm1.g2", new String[0], (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testCreateWithNonSortablePrimaryKey() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Command command = TestValidator.helpResolve("create local temporary table x (column1 string, column2 clob, primary key (column2))", (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{"column2"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testDropNonTemporary() {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Command command = TestValidator.helpResolve("drop table pm1.g1", (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{command.toString()}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testNestedContexts() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where context(a0, context(a0, a2))='x'", new String[]{"context(a0, context(a0, a2))"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidContextElement() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where context(1, a2)='x'", new String[]{"context(1, a2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInsertIntoVirtualWithQuery() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Command command = TestValidator.helpResolve("insert into vm1.g1 select 1, 2, true, 3", (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertTrue((boolean)report.getItems().isEmpty());
    }

    @Test
    public void testDynamicIntoDeclaredTemp() throws Exception {
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE  ").append("BEGIN\n").append("CREATE LOCAL TEMPORARY TABLE x (column1 string);").append("execute string 'SELECT e1 FROM pm1.g2' as e1 string INTO x;\n").append("select column1 from x;\n").append("END\n");
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", procedure.toString(), (QueryMetadataInterface)metadata);
        Assert.assertEquals((String)report.toString(), (long)0L, (long)report.getItems().size());
    }

    @Test
    public void testVariablesGroupSelect() {
        String procedure = "CREATE VIRTUAL PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer VARIABLES.var1 = 1;\n";
        procedure = procedure + "select * from variables;\n";
        procedure = procedure + "END\n";
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        Command command = TestValidator.helpResolve(procedure, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{"variables"}, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testClobEquals() {
        TestValidator.helpValidate("SELECT * FROM test.group where e4 = '1'", new String[]{"e4 = '1'"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testUpdateWithClob() {
        TestValidator.helpValidate("update test.group set e4 = ?", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testBlobLessThan() {
        TestValidator.helpValidate("SELECT * FROM test.group where e3 < ?", new String[]{"e3 < ?"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateCompare2() {
        TestValidator.helpValidate("SELECT e2 FROM test.group WHERE e4 IS NULL", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateCompare3() {
        TestValidator.helpValidate("SELECT e2 FROM test.group WHERE e4 IN ('a')", new String[]{"e4 IN ('a')"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateCompare5() {
        TestValidator.helpValidate("SELECT e2 FROM test.group WHERE e4 BETWEEN '1' AND '2'", new String[]{"e4 BETWEEN '1' AND '2'"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateCompareInHaving1() {
        TestValidator.helpValidate("SELECT e1 FROM test.group GROUP BY e1 HAVING convert(e1, clob) = 'a'", new String[]{"convert(e1, clob) = 'a'"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNoExpressionName() {
        TestValidator.helpValidate("SELECT xmlelement(name a, xmlattributes('1'))", new String[]{"XMLATTRIBUTES('1')"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNoExpressionName1() {
        TestValidator.helpValidate("SELECT xmlforest('1')", new String[]{"XMLFOREST('1')"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testXpathValueValid_defect15088() {
        String userSql = "SELECT xpathValue('<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>', 'a/b/c')";
        TestValidator.helpValidate(userSql, new String[0], (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testXpathValueInvalid_defect15088() throws Exception {
        String userSql = "SELECT xpathValue('<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>', '//*[local-name()=''bookName\"]')";
        TestValidator.helpValidate(userSql, new String[]{"xpathValue('<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>', '//*[local-name()=''bookName\"]')"}, (QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testTextTableNegativeWidth() {
        TestValidator.helpValidate("SELECT * from texttable(null columns x string width -1) as x", new String[]{"TEXTTABLE(null COLUMNS x string WIDTH -1) AS x"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testTextTableNoWidth() {
        TestValidator.helpValidate("SELECT * from texttable(null columns x string width 1, y integer) as x", new String[]{"TEXTTABLE(null COLUMNS x string WIDTH 1, y integer) AS x"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testTextTableInvalidDelimiter() {
        TestValidator.helpValidate("SELECT * from texttable(null columns x string width 1 DELIMITER 'z') as x", new String[]{"TEXTTABLE(null COLUMNS x string WIDTH 1 DELIMITER 'z') AS x"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testXMLNamespaces() {
        TestValidator.helpValidate("select xmlforest(xmlnamespaces(no default, default 'http://foo'), e1 as \"table\") from pm1.g1", new String[]{"XMLNAMESPACES(NO DEFAULT, DEFAULT 'http://foo')"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLNamespacesReserved() {
        TestValidator.helpValidate("select xmlforest(xmlnamespaces('http://foo' as xmlns), e1 as \"table\") from pm1.g1", new String[]{"XMLNAMESPACES('http://foo' AS xmlns)"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTablePassingMultipleContext() {
        TestValidator.helpValidate("select * from pm1.g1, xmltable('/' passing xmlparse(DOCUMENT '<a/>'), xmlparse(DOCUMENT '<b/>')) as x", new String[]{"XMLTABLE('/' PASSING XMLPARSE(DOCUMENT '<a/>'), XMLPARSE(DOCUMENT '<b/>')) AS x"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Ignore(value="this is actually handled by saxon and will show up during resolving")
    @Test
    public void testXMLTablePassingSameName() {
        TestValidator.helpValidate("select * from pm1.g1, xmltable('/' passing {x '<a/>'} as a, {x '<b/>'} as a) as x", new String[]{"xmltable('/' passing e1, e1 || 'x') as x"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTablePassingContextType() {
        TestValidator.helpValidate("select * from pm1.g1, xmltable('/' passing 2) as x", new String[]{"XMLTABLE('/' PASSING 2) AS x"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTableMultipleOrdinals() {
        TestValidator.helpValidate("select * from pm1.g1, xmltable('/' passing XMLPARSE(DOCUMENT '<a/>') columns x for ordinality, y for ordinality) as x", new String[]{"XMLTABLE('/' PASSING XMLPARSE(DOCUMENT '<a/>') COLUMNS x FOR ORDINALITY, y FOR ORDINALITY) AS x"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTableContextRequired() {
        TestValidator.helpValidate("select * from xmltable('/a/b' passing convert('<a/>', xml) as a columns x for ordinality, c integer path '.') as x", new String[]{"XMLTABLE('/a/b' PASSING convert('<a/>', xml) AS a COLUMNS x FOR ORDINALITY, c integer PATH '.') AS x"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLQueryPassingContextType() {
        TestValidator.helpValidate("select xmlquery('/' passing 2)", new String[]{"XMLQUERY('/' PASSING 2)"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testQueryString() {
        TestValidator.helpValidate("select querystring('/', '1')", new String[]{"QUERYSTRING('/', '1')"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testXmlNameValidation() throws Exception {
        TestValidator.helpValidate("select xmlelement(\":\")", new String[]{"XMLELEMENT(NAME \":\")"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testXmlParse() throws Exception {
        TestValidator.helpValidate("select xmlparse(content e2) from pm1.g1", new String[]{"XMLPARSE(CONTENT e2)"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testDecode() throws Exception {
        TestValidator.helpValidate("select to_bytes(e1, '?') from pm1.g1", new String[]{"to_bytes(e1, '?')"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateXMLAGG() {
        TestValidator.helpValidate("SELECT XMLAGG(e1) from pm1.g1", new String[]{"XMLAGG(e1)"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateBooleanAgg() {
        TestValidator.helpValidate("SELECT EVERY(e1) from pm1.g1", new String[]{"EVERY(e1)"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateStatAgg() {
        TestValidator.helpValidate("SELECT stddev_pop(distinct e2) from pm1.g1", new String[]{"STDDEV_POP(DISTINCT e2)"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateScalarSubqueryTooManyColumns() {
        TestValidator.helpValidate("SELECT e2, (SELECT e1, e2 FROM pm1.g1 WHERE e2 = '3') FROM pm1.g2", new String[]{"SELECT e1, e2 FROM pm1.g1 WHERE e2 = '3'"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidIntoSubquery() {
        TestValidator.helpValidate("SELECT e2, (SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3') FROM pm1.g2", new String[]{"SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3'"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidIntoSubquery1() {
        TestValidator.helpValidate("SELECT e2 FROM pm1.g2 WHERE EXISTS (SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3')", new String[]{"SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3'"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidIntoSubquery2() {
        TestValidator.helpValidate("SELECT * FROM (SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3') x", new String[]{"SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3'"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidIntoSubquery3() {
        TestValidator.helpValidate("SELECT e2 FROM pm1.g2 WHERE e2 in (SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3')", new String[]{"SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3'"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidIntoSubquery4() throws Exception {
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE\n").append("BEGIN\n").append("loop on (SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3') as x\n").append("BEGIN\nSELECT 1;\nEND\nSELECT 1\n;END\n");
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", procedure.toString(), (QueryMetadataInterface)metadata);
        TestValidator.examineReport(procedure, new String[]{"SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3'"}, report);
    }

    @Test
    public void testDisallowUpdateOnMultisourceElement() throws Exception {
        HashSet<String> models = new HashSet<String>();
        models.add("pm1");
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", "UPDATE PM1.G1 set SOURCE_NAME='blah'", (QueryMetadataInterface)new MultiSourceMetadataWrapper((QueryMetadataInterface)FakeMetadataFactory.example1(), models));
        Assert.assertEquals((String)report.toString(), (long)1L, (long)report.getItems().size());
    }

    @Test
    public void testDisallowProjectIntoMultiSource() throws Exception {
        HashSet<String> models = new HashSet<String>();
        models.add("pm1");
        TestValidator.helpValidate("insert into pm1.g1 select * from pm1.g1", new String[]{"pm1.g1"}, (QueryMetadataInterface)new MultiSourceMetadataWrapper((QueryMetadataInterface)FakeMetadataFactory.example1(), models));
    }

    @Test
    public void testTextAggEncoding() throws Exception {
        TestValidator.helpValidate("select textagg(for e1 encoding abc) from pm1.g1", new String[]{"TEXTAGG(FOR e1 ENCODING abc)"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testTextAggHeader() throws Exception {
        TestValidator.helpValidate("select textagg(for e1 || 1 HEADER) from pm1.g1", new String[]{"TEXTAGG(FOR (e1 || 1) HEADER)"}, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testMultiSourceProcValue() throws Exception {
        HashSet<String> models = new HashSet<String>();
        models.add("MultiModel");
        TestValidator.helpValidate("exec MultiModel.proc('a', (select 1))", new String[]{"MultiModel.proc.source_name"}, (QueryMetadataInterface)new MultiSourceMetadataWrapper((QueryMetadataInterface)FakeMetadataFactory.exampleMultiBinding(), models));
    }
}

