/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;

public class CancellationTimer {
    private static AtomicInteger id = new AtomicInteger();
    private TreeSet<CancelTask> cancelQueue = new TreeSet();
    private Thread thread;

    public CancellationTimer(String name) {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        CancellationTimer.this.doCancellations();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }, name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancellations() throws InterruptedException {
        CancelTask task = null;
        CancellationTimer cancellationTimer = this;
        synchronized (cancellationTimer) {
            if (this.cancelQueue.isEmpty()) {
                this.wait();
                return;
            }
            task = this.cancelQueue.first();
            long toWait = task.endTime - System.currentTimeMillis();
            if (toWait > 0L) {
                this.wait(toWait);
                return;
            }
            this.cancelQueue.pollFirst();
        }
        try {
            task.run();
        }
        catch (Throwable t) {
            Logger.getLogger(CancellationTimer.class).error((Object)"Unexpected exception running task", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CancelTask task) {
        CancellationTimer cancellationTimer = this;
        synchronized (cancellationTimer) {
            this.cancelQueue.add(task);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CancelTask task) {
        CancellationTimer cancellationTimer = this;
        synchronized (cancellationTimer) {
            this.cancelQueue.remove(task);
            this.notifyAll();
        }
    }

    static /* synthetic */ AtomicInteger access$000() {
        return id;
    }

    static abstract class CancelTask
    implements Runnable,
    Comparable<CancelTask> {
        long endTime;
        int seqId = CancellationTimer.access$000().get();

        public CancelTask(long delay) {
            this.endTime = System.currentTimeMillis() + delay;
        }

        @Override
        public int compareTo(CancelTask o) {
            this.endTime = o.endTime;
            int result = Long.signum(this.endTime);
            if (result == 0) {
                this.seqId = o.seqId;
                return this.seqId;
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CancelTask)) {
                return false;
            }
            return this.compareTo((CancelTask)obj) == 0;
        }
    }
}

