/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache;

import java.io.Serializable;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCache;
import org.teiid.core.TeiidRuntimeException;

public class DefaultCacheFactory
implements CacheFactory,
Serializable {
    private static final long serialVersionUID = -5541424157695857527L;
    private static CacheConfiguration DEFAULT = new CacheConfiguration(CacheConfiguration.Policy.LRU, 3600, 100, "default");
    DefaultCache cacheRoot;
    private volatile boolean destroyed = false;

    public DefaultCacheFactory() {
        this(DEFAULT);
    }

    public DefaultCacheFactory(CacheConfiguration config) {
        this.cacheRoot = new DefaultCache("Teiid", config.getMaxEntries(), config.getMaxAgeInSeconds() * 1000);
    }

    @Override
    public void destroy() {
        this.destroyed = true;
    }

    @Override
    public <K, V> Cache<K, V> get(String location, CacheConfiguration config) {
        if (!this.destroyed) {
            return this.cacheRoot.addChild(location);
        }
        throw new TeiidRuntimeException("Cache system has been shutdown");
    }

    @Override
    public boolean isReplicated() {
        return false;
    }
}

