/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.client.BatchSerializer;

public class TupleBatch
implements Externalizable {
    private static final long serialVersionUID = 6304443387337336957L;
    private int rowOffset;
    private List<List<?>> tuples;
    private boolean terminationFlag = false;
    private String[] preservedTypes;
    private transient String[] types;

    public TupleBatch() {
    }

    public TupleBatch(int beginRow, List<?>[] tuples) {
        this.rowOffset = beginRow;
        this.tuples = Arrays.asList(tuples);
    }

    public TupleBatch(int beginRow, List listOfTupleLists) {
        this.rowOffset = beginRow;
        this.tuples = new ArrayList(listOfTupleLists);
    }

    public int getBeginRow() {
        return this.rowOffset;
    }

    public int getEndRow() {
        return this.rowOffset + this.tuples.size() - 1;
    }

    public int getRowCount() {
        return this.tuples.size();
    }

    public List getTuple(int rowIndex) {
        return this.tuples.get(rowIndex - this.rowOffset);
    }

    public List<List<?>> getTuples() {
        return this.tuples;
    }

    public List[] getAllTuples() {
        return this.tuples.toArray(new List[this.tuples.size()]);
    }

    public boolean getTerminationFlag() {
        return this.terminationFlag;
    }

    public void setTerminationFlag(boolean terminationFlag) {
        this.terminationFlag = terminationFlag;
    }

    public void setDataTypes(String[] types) {
        this.types = types;
    }

    public boolean containsRow(int row) {
        return this.rowOffset <= row && this.getEndRow() >= row;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("TupleBatch; beginning row=");
        s.append(this.rowOffset);
        s.append(", number of rows=");
        s.append(this.tuples.size());
        s.append(", lastBatch=");
        s.append(this.terminationFlag);
        return s.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rowOffset = in.readInt();
        this.terminationFlag = in.readBoolean();
        this.preservedTypes = (String[])in.readObject();
        if (this.types == null) {
            this.types = this.preservedTypes;
        }
        this.tuples = new ArrayList();
        for (List tuple : BatchSerializer.readBatch((ObjectInput)in, (String[])this.types)) {
            this.tuples.add(tuple);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rowOffset);
        out.writeBoolean(this.terminationFlag);
        out.writeObject(this.preservedTypes);
        BatchSerializer.writeBatch((ObjectOutput)out, (String[])this.types, (List[])this.getAllTuples());
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public void preserveTypes() {
        this.preservedTypes = this.types;
    }
}

