/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.LobManager;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.sql.symbol.Expression;

public class BufferManagerImpl
implements BufferManager,
StorageManager {
    public static final double KB_PER_VALUE = 0.0625;
    private static final int IO_BUFFER_SIZE = 16384;
    private static final int COMPACTION_THRESHOLD = 0x2000000;
    private int connectorBatchSize = 1024;
    private int processorBatchSize = 512;
    private int maxProcessingBatches = 128;
    private int maxReserveBatchColumns = 16384;
    private int maxProcessingKB;
    private int maxReserveBatchKB;
    private volatile int reserveBatchKB;
    private int maxActivePlans = 20;
    private ReentrantLock lock = new ReentrantLock(true);
    private Condition batchesFreed = this.lock.newCondition();
    private volatile int activeBatchColumnCount = 0;
    private Map<String, TupleBufferInfo> activeBatches = new LinkedHashMap<String, TupleBufferInfo>();
    private Map<String, TupleReference> tupleBufferMap = new ConcurrentHashMap<String, TupleReference>();
    private ReferenceQueue<TupleBuffer> tupleBufferQueue = new ReferenceQueue();
    private StorageManager diskMgr;
    private AtomicLong tsId = new AtomicLong();
    private AtomicLong batchAdded = new AtomicLong();
    private AtomicLong readCount = new AtomicLong();
    private AtomicLong writeCount = new AtomicLong();
    private AtomicLong readAttempts = new AtomicLong();
    private AtomicLong referenceHit = new AtomicLong();

    public long getBatchesAdded() {
        return this.batchAdded.get();
    }

    public long getReadCount() {
        return this.readCount.get();
    }

    public long getWriteCount() {
        return this.writeCount.get();
    }

    public long getReadAttempts() {
        return this.readAttempts.get();
    }

    @Override
    public int getMaxProcessingKB() {
        return this.maxProcessingKB;
    }

    public void setMaxProcessingBatchColumns(int maxProcessingBatches) {
        this.maxProcessingBatches = maxProcessingBatches;
    }

    @Override
    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    @Override
    public int getConnectorBatchSize() {
        return this.connectorBatchSize;
    }

    public void setConnectorBatchSize(int connectorBatchSize) {
        this.connectorBatchSize = connectorBatchSize;
    }

    public void setProcessorBatchSize(int processorBatchSize) {
        this.processorBatchSize = processorBatchSize;
    }

    public void setStorageManager(StorageManager storageManager) {
        Assertion.isNotNull((Object)storageManager);
        Assertion.isNull((Object)this.diskMgr);
        this.diskMgr = storageManager;
    }

    public StorageManager getStorageManager() {
        return this.diskMgr;
    }

    @Override
    public TupleBuffer createTupleBuffer(List elements, String groupName, BufferManager.TupleSourceType tupleSourceType) {
        String newID = String.valueOf(this.tsId.getAndIncrement());
        int[] lobIndexes = LobManager.getLobIndexes(elements);
        BatchManagerImpl batchManager = new BatchManagerImpl(newID, elements.size(), lobIndexes);
        TupleBuffer tupleBuffer = new TupleBuffer(batchManager, newID, elements, lobIndexes, this.getProcessorBatchSize());
        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Creating TupleBuffer:", newID, "of type ", tupleSourceType});
        return tupleBuffer;
    }

    @Override
    public STree createSTree(List elements, String groupName, int keyLength) {
        String newID = String.valueOf(this.tsId.getAndIncrement());
        int[] lobIndexes = LobManager.getLobIndexes(elements);
        BatchManagerImpl bm = new BatchManagerImpl(newID, elements.size(), lobIndexes);
        BatchManagerImpl keyManager = new BatchManagerImpl(String.valueOf(this.tsId.getAndIncrement()), keyLength, null);
        int[] compareIndexes = new int[keyLength];
        for (int i = 1; i < compareIndexes.length; ++i) {
            compareIndexes[i] = i;
        }
        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Creating STree:", newID});
        return new STree(keyManager, bm, new ListNestedSortComparator(compareIndexes), this.getProcessorBatchSize(), keyLength, TupleBuffer.getTypeNames(elements));
    }

    @Override
    public FileStore createFileStore(String name) {
        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Creating FileStore:", name});
        return this.diskMgr.createFileStore(name);
    }

    @Override
    public void setMaxActivePlans(int maxActivePlans) {
        this.maxActivePlans = maxActivePlans;
    }

    @Override
    public void initialize() throws TeiidComponentException {
        int maxMemory = (int)Math.min(Runtime.getRuntime().maxMemory() / 1024L, Integer.MAX_VALUE);
        maxMemory -= 307200;
        if (this.maxReserveBatchColumns < 0) {
            this.maxReserveBatchKB = 0;
            int one_gig = 0x100000;
            if (maxMemory > one_gig) {
                this.maxReserveBatchKB += (int)Math.max(0.0, (double)(maxMemory - one_gig) * 0.75);
            }
            this.maxReserveBatchKB = (int)((double)this.maxReserveBatchKB + Math.max(0.0, (double)Math.min(one_gig, maxMemory) * 0.5));
        } else {
            this.maxReserveBatchKB = Math.max(0, (int)Math.min((double)this.maxReserveBatchColumns * 0.0625 * (double)this.processorBatchSize, 2.147483647E9));
        }
        this.reserveBatchKB = this.maxReserveBatchKB;
        this.maxProcessingKB = this.maxProcessingBatches < 0 ? Math.max((int)Math.min(8.0 * (double)this.processorBatchSize, 2.147483647E9), (int)(0.1 * (double)maxMemory) / this.maxActivePlans) : Math.max(0, (int)Math.min(Math.ceil((double)this.maxProcessingBatches * 0.0625 * (double)this.processorBatchSize), 2.147483647E9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseBuffers(int count) {
        if (count < 1) {
            return;
        }
        this.lock.lock();
        try {
            this.reserveBatchKB += count;
            this.batchesFreed.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reserveBuffers(int count, BufferManager.BufferReserveMode mode) {
        this.lock.lock();
        try {
            int waitCount;
            if (mode == BufferManager.BufferReserveMode.WAIT) {
                for (waitCount = Math.min(count, this.maxReserveBatchKB); waitCount > 0 && waitCount > this.reserveBatchKB; waitCount /= 2) {
                    try {
                        this.batchesFreed.await(100L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new TeiidRuntimeException((Throwable)e);
                    }
                }
            }
            if (this.reserveBatchKB >= count || mode == BufferManager.BufferReserveMode.FORCE) {
                this.reserveBatchKB -= count;
                waitCount = count;
                return waitCount;
            }
            int result = Math.max(0, this.reserveBatchKB);
            this.reserveBatchKB -= result;
            int n = result;
            return n;
        }
        finally {
            this.lock.unlock();
            this.persistBatchReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistBatchReferences() {
        if (this.activeBatchColumnCount == 0 || this.activeBatchColumnCount <= this.reserveBatchKB) {
            int memoryCount = this.activeBatchColumnCount + this.maxReserveBatchColumns - this.reserveBatchKB;
            if (DataTypeManager.isValueCacheEnabled()) {
                if (memoryCount < this.maxReserveBatchColumns / 8) {
                    DataTypeManager.setValueCacheEnabled((boolean)false);
                }
            } else if (memoryCount > this.maxReserveBatchColumns / 4) {
                DataTypeManager.setValueCacheEnabled((boolean)true);
            }
            return;
        }
        while (true) {
            ManagedBatchImpl mb = null;
            Map<String, TupleBufferInfo> map = this.activeBatches;
            synchronized (map) {
                if (this.activeBatchColumnCount == 0 || this.activeBatchColumnCount * 5 < this.reserveBatchKB * 4) {
                    break;
                }
                Iterator<TupleBufferInfo> iter = this.activeBatches.values().iterator();
                TupleBufferInfo tbi = iter.next();
                Map.Entry<Integer, ManagedBatchImpl> entry = null;
                if (tbi.lastUsed != null) {
                    entry = tbi.batches.floorEntry(tbi.lastUsed - 1);
                }
                if (entry == null) {
                    entry = tbi.batches.lastEntry();
                }
                tbi.removeBatch((Integer)entry.getKey());
                if (tbi.batches.isEmpty()) {
                    iter.remove();
                }
                mb = entry.getValue();
            }
            try {
                mb.persist();
            }
            catch (TeiidComponentException e) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object[])new Object[]{"Error persisting batch, attempts to read that batch later will result in an exception"});
            }
        }
    }

    @Override
    public int getSchemaSize(List<? extends Expression> elements) {
        int total = 0;
        boolean isValueCacheEnabled = DataTypeManager.isValueCacheEnabled();
        for (Expression expression : elements) {
            Class type = expression.getType();
            if (type == DataTypeManager.DefaultDataClasses.STRING) {
                total += isValueCacheEnabled ? 100 : 256;
                continue;
            }
            if (type == DataTypeManager.DefaultDataClasses.DATE || type == DataTypeManager.DefaultDataClasses.TIME || type == DataTypeManager.DefaultDataClasses.TIMESTAMP) {
                total += isValueCacheEnabled ? 20 : 28;
                continue;
            }
            if (type == DataTypeManager.DefaultDataClasses.LONG || type == DataTypeManager.DefaultDataClasses.DOUBLE) {
                total += isValueCacheEnabled ? 12 : 16;
                continue;
            }
            if (type == DataTypeManager.DefaultDataClasses.INTEGER || type == DataTypeManager.DefaultDataClasses.FLOAT) {
                total += isValueCacheEnabled ? 6 : 12;
                continue;
            }
            if (type == DataTypeManager.DefaultDataClasses.CHAR || type == DataTypeManager.DefaultDataClasses.SHORT) {
                total += isValueCacheEnabled ? 4 : 10;
                continue;
            }
            if (type == DataTypeManager.DefaultDataClasses.OBJECT) {
                total += 1024;
                continue;
            }
            if (type == DataTypeManager.DefaultDataClasses.NULL) continue;
            if (type == DataTypeManager.DefaultDataClasses.BYTE) {
                total += 2;
                continue;
            }
            if (type == DataTypeManager.DefaultDataClasses.BOOLEAN) {
                ++total;
                continue;
            }
            total += 512;
        }
        total += 8 * elements.size() + 36;
        return Math.max(1, (total *= this.processorBatchSize) / 1024);
    }

    public void setMaxReserveBatchColumns(int maxReserve) {
        this.maxReserveBatchColumns = maxReserve;
    }

    public void shutdown() {
    }

    @Override
    public void addTupleBuffer(TupleBuffer tb) {
        this.cleanDefunctTupleBuffers();
        this.tupleBufferMap.put(tb.getId(), new TupleReference(tb, this.tupleBufferQueue));
    }

    @Override
    public TupleBuffer getTupleBuffer(String id) {
        this.cleanDefunctTupleBuffers();
        Reference r = this.tupleBufferMap.get(id);
        if (r != null) {
            return (TupleBuffer)r.get();
        }
        return null;
    }

    private void cleanDefunctTupleBuffers() {
        Reference<TupleBuffer> r;
        while ((r = this.tupleBufferQueue.poll()) != null) {
            this.tupleBufferMap.remove(((TupleReference)r).id);
        }
    }

    static class TupleReference
    extends WeakReference<TupleBuffer> {
        String id;

        public TupleReference(TupleBuffer referent, ReferenceQueue<? super TupleBuffer> q) {
            super(referent, q);
            this.id = referent.getId();
        }
    }

    private final class ManagedBatchImpl
    implements BatchManager.ManagedBatch {
        private boolean persistent;
        private boolean softCache;
        private volatile TupleBatch activeBatch;
        private volatile Reference<TupleBatch> batchReference;
        private int beginRow;
        private BatchManagerImpl batchManager;
        private long id;
        private LobManager lobManager;

        public ManagedBatchImpl(TupleBatch batch, BatchManagerImpl manager, boolean softCache) {
            this.softCache = softCache;
            this.id = BufferManagerImpl.this.batchAdded.incrementAndGet();
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Add batch to BufferManager", this.id});
            this.activeBatch = batch;
            this.beginRow = batch.getBeginRow();
            this.batchManager = manager;
            if (this.batchManager.lobIndexes != null) {
                this.lobManager = new LobManager();
            }
        }

        @Override
        public void setPrefersMemory(boolean prefers) {
            this.softCache = prefers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToCache(boolean update) {
            Map map = BufferManagerImpl.this.activeBatches;
            synchronized (map) {
                TupleBatch batch = this.activeBatch;
                if (batch == null) {
                    return;
                }
                BufferManagerImpl.this.activeBatchColumnCount += this.batchManager.columnCount;
                TupleBufferInfo tbi = null;
                tbi = update ? (TupleBufferInfo)BufferManagerImpl.this.activeBatches.remove(this.batchManager.id) : (TupleBufferInfo)BufferManagerImpl.this.activeBatches.get(this.batchManager.id);
                if (tbi == null) {
                    tbi = new TupleBufferInfo();
                    update = true;
                }
                if (update) {
                    BufferManagerImpl.this.activeBatches.put(this.batchManager.id, tbi);
                }
                Assertion.isNull((Object)tbi.batches.put(this.beginRow, this));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public TupleBatch getBatch(boolean cache, String[] types) throws TeiidComponentException {
            long reads = BufferManagerImpl.this.readAttempts.incrementAndGet();
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.batchManager.id, "getting batch", reads, "reference hits", BufferManagerImpl.this.referenceHit.get()});
            Object object = BufferManagerImpl.this.activeBatches;
            synchronized (object) {
                TupleBufferInfo tbi = (TupleBufferInfo)BufferManagerImpl.this.activeBatches.remove(this.batchManager.id);
                if (tbi != null) {
                    boolean put = true;
                    if (!cache) {
                        tbi.removeBatch(this.beginRow);
                        if (tbi.batches.isEmpty()) {
                            put = false;
                        }
                    }
                    if (put) {
                        tbi.lastUsed = this.beginRow;
                        BufferManagerImpl.this.activeBatches.put(this.batchManager.id, tbi);
                    }
                }
            }
            BufferManagerImpl.this.persistBatchReferences();
            object = this;
            synchronized (object) {
                TupleBatch batch = this.activeBatch;
                if (batch != null) {
                    return batch;
                }
                Reference<TupleBatch> ref = this.batchReference;
                this.batchReference = null;
                if (ref != null && (batch = ref.get()) != null) {
                    if (cache) {
                        this.activeBatch = batch;
                        this.addToCache(true);
                    }
                    BufferManagerImpl.this.referenceHit.getAndIncrement();
                    return batch;
                }
                long count = BufferManagerImpl.this.readCount.incrementAndGet();
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.batchManager.id, this.id, "reading batch from disk, total reads:", count});
                try {
                    this.batchManager.compactionLock.readLock().lock();
                    long[] info = (long[])this.batchManager.physicalMapping.get(this.id);
                    ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(this.batchManager.store.createInputStream(info[0]), 16384));
                    batch = new TupleBatch();
                    batch.setDataTypes(types);
                    batch.readExternal(ois);
                    batch.setRowOffset(this.beginRow);
                    batch.setDataTypes(null);
                    if (this.lobManager != null) {
                        for (List<?> tuple : batch.getTuples()) {
                            this.lobManager.updateReferences(this.batchManager.lobIndexes, tuple);
                        }
                    }
                    if (cache) {
                        this.activeBatch = batch;
                        this.addToCache(true);
                    }
                    TupleBatch tupleBatch = batch;
                    return tupleBatch;
                }
                catch (IOException e) {
                    throw new TeiidComponentException((Throwable)e, QueryPlugin.Util.getString("FileStoreageManager.error_reading", new Object[]{this.batchManager.id}));
                }
                catch (ClassNotFoundException e) {
                    throw new TeiidComponentException((Throwable)e, QueryPlugin.Util.getString("FileStoreageManager.error_reading", new Object[]{this.batchManager.id}));
                }
                finally {
                    this.batchManager.compactionLock.readLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void persist() throws TeiidComponentException {
            block13: {
                boolean lockheld = false;
                try {
                    TupleBatch batch = this.activeBatch;
                    if (batch == null) break block13;
                    if (!this.persistent) {
                        long count = BufferManagerImpl.this.writeCount.incrementAndGet();
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.batchManager.id, this.id, "writing batch to disk, total writes: ", count});
                        long offset = 0L;
                        if (this.lobManager != null) {
                            for (List<?> tuple : batch.getTuples()) {
                                this.lobManager.updateReferences(this.batchManager.lobIndexes, tuple);
                            }
                        }
                        FileStore fileStore = this.batchManager.store;
                        synchronized (fileStore) {
                            offset = this.batchManager.getOffset();
                            BufferedOutputStream fsos = new BufferedOutputStream(this.batchManager.store.createOutputStream(), 16384);
                            ObjectOutputStream oos = new ObjectOutputStream(fsos);
                            batch.writeExternal(oos);
                            oos.close();
                            long size = this.batchManager.store.getLength() - offset;
                            long[] info = new long[]{offset, size};
                            this.batchManager.physicalMapping.put(this.id, info);
                        }
                        LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.batchManager.id, this.id, "batch written starting at:", offset});
                    }
                    this.batchReference = this.softCache ? new SoftReference<TupleBatch>(batch) : new WeakReference<TupleBatch>(batch);
                }
                catch (IOException e) {
                    throw new TeiidComponentException((Throwable)e);
                }
                catch (Throwable e) {
                    throw new TeiidComponentException(e);
                }
                finally {
                    this.persistent = true;
                    this.activeBatch = null;
                    if (lockheld) {
                        this.batchManager.compactionLock.writeLock().unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Map map = BufferManagerImpl.this.activeBatches;
            synchronized (map) {
                TupleBufferInfo tbi = (TupleBufferInfo)BufferManagerImpl.this.activeBatches.get(this.batchManager.id);
                if (tbi != null && tbi.removeBatch(this.beginRow) != null && tbi.batches.isEmpty()) {
                    BufferManagerImpl.this.activeBatches.remove(this.batchManager.id);
                }
            }
            long[] info = (long[])this.batchManager.physicalMapping.remove(this.id);
            if (info != null) {
                this.batchManager.unusedSpace.addAndGet(info[1]);
            }
            this.activeBatch = null;
            this.batchReference = null;
        }

        public String toString() {
            return "ManagedBatch " + this.batchManager.id + " " + this.activeBatch;
        }
    }

    private class TupleBufferInfo {
        TreeMap<Integer, ManagedBatchImpl> batches = new TreeMap();
        Integer lastUsed = null;

        private TupleBufferInfo() {
        }

        ManagedBatchImpl removeBatch(int row) {
            ManagedBatchImpl result = this.batches.remove(row);
            if (result != null) {
                BufferManagerImpl.this.activeBatchColumnCount -= result.batchManager.columnCount;
            }
            return result;
        }
    }

    private final class BatchManagerImpl
    implements BatchManager {
        private final String id;
        private final int columnCount;
        private volatile FileStore store;
        private Map<Long, long[]> physicalMapping = new ConcurrentHashMap<Long, long[]>();
        private ReadWriteLock compactionLock = new ReentrantReadWriteLock();
        private AtomicLong unusedSpace = new AtomicLong();
        private int[] lobIndexes;

        private BatchManagerImpl(String newID, int columnCount, int[] lobIndexes) {
            this.id = newID;
            this.columnCount = columnCount;
            this.store = BufferManagerImpl.this.createFileStore(this.id);
            this.store.setCleanupReference(this);
            this.lobIndexes = lobIndexes;
        }

        @Override
        public FileStore createStorage(String prefix) {
            return BufferManagerImpl.this.createFileStore(this.id + prefix);
        }

        @Override
        public BatchManager.ManagedBatch createManagedBatch(TupleBatch batch, boolean softCache) throws TeiidComponentException {
            ManagedBatchImpl mbi = new ManagedBatchImpl(batch, this, softCache);
            mbi.addToCache(false);
            BufferManagerImpl.this.persistBatchReferences();
            return mbi;
        }

        private boolean shouldCompact(long offset) {
            return offset > 0x2000000L && this.unusedSpace.get() * 4L > offset * 3L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getOffset() throws TeiidComponentException {
            long offset = this.store.getLength();
            if (!this.shouldCompact(offset)) {
                return offset;
            }
            try {
                this.compactionLock.writeLock().lock();
                offset = this.store.getLength();
                if (!this.shouldCompact(offset)) {
                    long l = offset;
                    return l;
                }
                FileStore newStore = BufferManagerImpl.this.createFileStore(this.id);
                newStore.setCleanupReference(this);
                byte[] buffer = new byte[16384];
                ArrayList<long[]> values = new ArrayList<long[]>(this.physicalMapping.values());
                Collections.sort(values, new Comparator<long[]>(){

                    @Override
                    public int compare(long[] o1, long[] o2) {
                        return Long.signum(o1[0] - o2[0]);
                    }
                });
                for (long[] info : values) {
                    int toWrite;
                    long oldOffset = info[0];
                    info[0] = newStore.getLength();
                    for (int size = (int)info[1]; size > 0; size -= toWrite) {
                        toWrite = Math.min(16384, size);
                        this.store.readFully(oldOffset, buffer, 0, toWrite);
                        newStore.write(buffer, 0, toWrite);
                    }
                }
                this.store.remove();
                this.store = newStore;
                long oldOffset = offset;
                offset = this.store.getLength();
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Compacted store", this.id, "pre-size", oldOffset, "post-size", offset});
                long l = offset;
                return l;
            }
            finally {
                this.compactionLock.writeLock().unlock();
            }
        }

        @Override
        public void remove() {
            this.store.remove();
        }
    }
}

