/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.logging.AuditMessage;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;

public class AuthorizationValidationVisitor
extends AbstractValidationVisitor {
    private HashMap<String, DataPolicy> allowedPolicies;
    private String userName;
    private boolean allowCreateTemporaryTablesDefault = true;
    private boolean allowFunctionCallsByDefault = true;

    public AuthorizationValidationVisitor(HashMap<String, DataPolicy> policies, String user) {
        this.allowedPolicies = policies;
        this.userName = user;
    }

    public void setAllowCreateTemporaryTablesDefault(boolean allowCreateTemporaryTablesDefault) {
        this.allowCreateTemporaryTablesDefault = allowCreateTemporaryTablesDefault;
    }

    public void setAllowFunctionCallsByDefault(boolean allowFunctionCallsDefault) {
        this.allowFunctionCallsByDefault = allowFunctionCallsDefault;
    }

    @Override
    public void visit(Create obj) {
        Set<String> resources = Collections.singleton(obj.getTable().getName());
        List<GroupSymbol> symbols = Arrays.asList(obj.getTable());
        this.validateTemp(resources, symbols, Context.CREATE);
    }

    @Override
    public void visit(AlterProcedure obj) {
        this.validateEntitlements(Arrays.asList(obj.getTarget()), DataPolicy.PermissionType.ALTER, Context.ALTER);
    }

    @Override
    public void visit(AlterTrigger obj) {
        this.validateEntitlements(Arrays.asList(obj.getTarget()), DataPolicy.PermissionType.ALTER, obj.isCreate() ? Context.CREATE : Context.ALTER);
    }

    @Override
    public void visit(AlterView obj) {
        this.validateEntitlements(Arrays.asList(obj.getTarget()), DataPolicy.PermissionType.ALTER, Context.ALTER);
    }

    private void validateTemp(Set<String> resources, Collection<GroupSymbol> symbols, Context context) {
        this.logRequest(resources, context);
        boolean allowed = false;
        for (DataPolicy p : this.allowedPolicies.values()) {
            DataPolicyMetadata policy = (DataPolicyMetadata)p;
            if (policy.isAllowCreateTemporaryTables() == null) {
                if (!this.allowCreateTemporaryTablesDefault) continue;
                allowed = true;
                break;
            }
            if (!policy.isAllowCreateTemporaryTables().booleanValue()) continue;
            allowed = true;
            break;
        }
        this.logResult(resources, context, allowed);
        if (!allowed) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.018.005.0095", new Object[]{this.userName, "CREATE_TEMPORARY_TABLES"}), symbols);
        }
    }

    private void logRequest(Set<String> resources, Context context) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
            AuditMessage msg = new AuditMessage(context.name(), "getInaccessibleResources-request", this.userName, resources.toArray(new String[resources.size()]));
            LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object[])new Object[]{msg});
        }
    }

    @Override
    public void visit(Drop obj) {
        Set<String> resources = Collections.singleton(obj.getTable().getName());
        List<GroupSymbol> symbols = Arrays.asList(obj.getTable());
        this.validateTemp(resources, symbols, Context.CREATE);
    }

    @Override
    public void visit(Delete obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Insert obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Query obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Update obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Function obj) {
        String schema;
        if ("lookup".equalsIgnoreCase(obj.getName())) {
            try {
                ResolverUtil.ResolvedLookup lookup = ResolverUtil.resolveLookup(obj, this.getMetadata());
                LinkedList<Symbol> symbols = new LinkedList<Symbol>();
                symbols.add(lookup.getGroup());
                symbols.add(lookup.getKeyElement());
                symbols.add(lookup.getReturnElement());
                this.validateEntitlements(symbols, DataPolicy.PermissionType.READ, Context.QUERY);
            }
            catch (TeiidComponentException e) {
                this.handleException((TeiidException)((Object)e), obj);
            }
            catch (TeiidProcessingException e) {
                this.handleException((TeiidException)((Object)e), obj);
            }
        } else if (!this.allowFunctionCallsByDefault && (schema = obj.getFunctionDescriptor().getSchema()) != null && !this.isSystemSchema(schema)) {
            HashMap<String, Function> map = new HashMap<String, Function>();
            map.put(schema + '.' + obj.getFunctionDescriptor().getName(), obj);
            this.validateEntitlements(DataPolicy.PermissionType.EXECUTE, Context.FUNCTION, map);
        }
    }

    protected void validateEntitlements(Insert obj) {
        this.validateEntitlements(obj.getVariables(), DataPolicy.PermissionType.CREATE, Context.INSERT);
    }

    protected void validateEntitlements(Update obj) {
        HashSet<ElementSymbol> elements = new HashSet<ElementSymbol>();
        ElementCollectorVisitor.getElements(obj.getChangeList().getClauseMap().values(), elements);
        if (obj.getCriteria() != null) {
            ElementCollectorVisitor.getElements((LanguageObject)obj.getCriteria(), elements);
        }
        this.validateEntitlements(elements, DataPolicy.PermissionType.READ, Context.UPDATE);
        this.validateEntitlements(obj.getChangeList().getClauseMap().keySet(), DataPolicy.PermissionType.UPDATE, Context.UPDATE);
    }

    protected void validateEntitlements(Delete obj) {
        if (obj.getCriteria() != null) {
            this.validateEntitlements(ElementCollectorVisitor.getElements((LanguageObject)obj.getCriteria(), true), DataPolicy.PermissionType.READ, Context.DELETE);
        }
        this.validateEntitlements(Arrays.asList(obj.getGroup()), DataPolicy.PermissionType.DELETE, Context.DELETE);
    }

    protected void validateEntitlements(Query obj) {
        Into intoObj = obj.getInto();
        if (intoObj != null) {
            GroupSymbol intoGroup = intoObj.getGroup();
            List<ElementSymbol> intoElements = null;
            try {
                intoElements = ResolverUtil.resolveElementsInGroup(intoGroup, this.getMetadata());
            }
            catch (QueryMetadataException err) {
                this.handleException((TeiidException)((Object)err), intoGroup);
            }
            catch (TeiidComponentException err) {
                this.handleException((TeiidException)((Object)err), intoGroup);
            }
            this.validateEntitlements(intoElements, DataPolicy.PermissionType.CREATE, Context.INSERT);
        }
        Collection<GroupSymbol> entitledObjects = GroupCollectorVisitor.getGroups((LanguageObject)obj, true);
        if (!this.isXMLCommand(obj)) {
            entitledObjects.addAll(ElementCollectorVisitor.getElements((LanguageObject)obj, true));
        }
        if (entitledObjects.size() == 0) {
            return;
        }
        this.validateEntitlements(entitledObjects, DataPolicy.PermissionType.READ, Context.QUERY);
    }

    protected void validateEntitlements(StoredProcedure obj) {
        this.validateEntitlements(Arrays.asList(obj.getGroup()), DataPolicy.PermissionType.EXECUTE, Context.STORED_PROCEDURE);
    }

    protected void validateEntitlements(Collection<? extends LanguageObject> symbols, DataPolicy.PermissionType actionCode, Context auditContext) {
        HashMap<String, LanguageObject> nameToSymbolMap = new HashMap<String, LanguageObject>();
        for (LanguageObject languageObject : symbols) {
            try {
                GroupSymbol group;
                String fullName = null;
                Object metadataID = null;
                if (languageObject instanceof ElementSymbol ? (metadataID = ((ElementSymbol)languageObject).getMetadataID()) instanceof MultiSourceElement || metadataID instanceof TempMetadataID : languageObject instanceof GroupSymbol && (metadataID = (group = (GroupSymbol)languageObject).getMetadataID()) instanceof TempMetadataID && !group.isProcedure()) continue;
                fullName = this.getMetadata().getFullName(metadataID);
                Object modelId = this.getMetadata().getModelID(metadataID);
                String modelName = this.getMetadata().getFullName(modelId);
                if (this.isSystemSchema(modelName)) continue;
                nameToSymbolMap.put(fullName, languageObject);
            }
            catch (QueryMetadataException e) {
                this.handleException((TeiidException)((Object)e));
            }
            catch (TeiidComponentException e) {
                this.handleException((TeiidException)((Object)e));
            }
        }
        this.validateEntitlements(actionCode, auditContext, nameToSymbolMap);
    }

    private boolean isSystemSchema(String modelName) {
        return "SYS".equalsIgnoreCase(modelName) || "pg_catalog".equalsIgnoreCase(modelName);
    }

    private void validateEntitlements(DataPolicy.PermissionType actionCode, Context auditContext, Map<String, ? extends LanguageObject> nameToSymbolMap) {
        if (nameToSymbolMap.isEmpty()) {
            return;
        }
        Set<String> inaccessibleResources = this.getInaccessibleResources(actionCode, nameToSymbolMap.keySet(), auditContext);
        if (inaccessibleResources.isEmpty()) {
            return;
        }
        ArrayList<LanguageObject> inaccessibleSymbols = new ArrayList<LanguageObject>(inaccessibleResources.size());
        for (String name : inaccessibleResources) {
            inaccessibleSymbols.add(nameToSymbolMap.get(name));
        }
        this.handleValidationError(QueryPlugin.Util.getString("ERR.018.005.0095", new Object[]{this.userName, actionCode}), inaccessibleSymbols);
    }

    public Set<String> getInaccessibleResources(DataPolicy.PermissionType action, Set<String> resources, Context context) {
        this.logRequest(resources, context);
        HashSet<String> results = new HashSet<String>(resources);
        for (DataPolicy p : this.allowedPolicies.values()) {
            DataPolicyMetadata policy = (DataPolicyMetadata)p;
            if (results.isEmpty()) break;
            Iterator<String> i = results.iterator();
            while (i.hasNext()) {
                if (!policy.allows(i.next(), action)) continue;
                i.remove();
            }
        }
        this.logResult(resources, context, results.isEmpty());
        return results;
    }

    private void logResult(Set<String> resources, Context context, boolean granted) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
            if (granted) {
                AuditMessage msg = new AuditMessage(context.name(), "getInaccessibleResources-granted all", this.userName, resources.toArray(new String[resources.size()]));
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object[])new Object[]{msg});
            } else {
                AuditMessage msg = new AuditMessage(context.name(), "getInaccessibleResources-denied", this.userName, resources.toArray(new String[resources.size()]));
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object[])new Object[]{msg});
            }
        }
    }

    public static enum Context {
        CREATE,
        DROP,
        QUERY,
        INSERT,
        UPDATE,
        DELETE,
        FUNCTION,
        ALTER,
        STORED_PROCEDURE;

    }
}

