/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.io.StringReader;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.parser.ParseException;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.SQLParser;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.query.parser.TokenMgrError;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class QueryParser {
    private static ThreadLocal<QueryParser> QUERY_PARSER = new ThreadLocal<QueryParser>(){

        @Override
        protected QueryParser initialValue() {
            return new QueryParser();
        }
    };
    private static final String LINE_MARKER = "line ";
    private static final String COL_MARKER = "column ";
    private static final String XQUERY_DECLARE = "declare";
    private static final String XML_OPEN_BRACKET = "<";
    private SQLParser parser;

    public static QueryParser getQueryParser() {
        return QUERY_PARSER.get();
    }

    private SQLParser getSqlParser(String sql) {
        String string = sql = sql != null ? sql : "";
        if (this.parser == null) {
            this.parser = new SQLParser(new StringReader(sql));
        } else {
            this.parser.ReInit(new StringReader(sql));
        }
        return this.parser;
    }

    public Command parseCommand(String sql) throws QueryParserException {
        return this.parseCommand(sql, new ParseInfo());
    }

    public Command parseUpdateProcedure(String sql) throws QueryParserException {
        try {
            Command result = this.getSqlParser(sql).updateProcedure(new ParseInfo());
            result.setCacheHint(SQLParserUtil.getQueryCacheOption(sql));
            return result;
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        catch (TokenMgrError tme) {
            throw this.handleTokenMgrError(tme);
        }
    }

    public Command parseCommand(String sql, ParseInfo parseInfo) throws QueryParserException {
        return this.parseCommand(sql, parseInfo, false);
    }

    public Command parseDesignerCommand(String sql) throws QueryParserException {
        return this.parseCommand(sql, new ParseInfo(), true);
    }

    public Command parseCommand(String sql, ParseInfo parseInfo, boolean designerCommands) throws QueryParserException {
        if (sql == null || sql.length() == 0) {
            throw new QueryParserException(QueryPlugin.Util.getString("QueryParser.emptysql"));
        }
        Command result = null;
        try {
            result = designerCommands ? this.getSqlParser(sql).designerCommand(parseInfo) : this.getSqlParser(sql).command(parseInfo);
            result.setCacheHint(SQLParserUtil.getQueryCacheOption(sql));
        }
        catch (ParseException pe) {
            if (sql.startsWith(XML_OPEN_BRACKET) || sql.startsWith(XQUERY_DECLARE)) {
                throw new QueryParserException(pe, QueryPlugin.Util.getString("QueryParser.xqueryCompilation", new Object[]{sql}));
            }
            throw this.convertParserException(pe);
        }
        catch (TokenMgrError tme) {
            if (sql.startsWith(XML_OPEN_BRACKET) || sql.startsWith(XQUERY_DECLARE)) {
                throw new QueryParserException(tme, QueryPlugin.Util.getString("QueryParser.xqueryCompilation", new Object[]{sql}));
            }
            throw this.handleTokenMgrError(tme);
        }
        return result;
    }

    public CacheHint parseCacheHint(String sql) throws QueryParserException {
        if (sql == null || sql.length() == 0) {
            throw new QueryParserException(QueryPlugin.Util.getString("QueryParser.emptysql"));
        }
        return SQLParserUtil.getQueryCacheOption(sql);
    }

    public Criteria parseCriteria(String sql) throws QueryParserException {
        if (sql == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("QueryParser.nullSqlCrit"));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Criteria result = null;
        try {
            result = this.getSqlParser(sql).criteria(dummyInfo);
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        catch (TokenMgrError tme) {
            throw this.handleTokenMgrError(tme);
        }
        return result;
    }

    private QueryParserException convertParserException(ParseException pe) {
        return new QueryParserException(QueryPlugin.Util.getString("QueryParser.parsingError", new Object[]{pe.getMessage()}));
    }

    public Expression parseExpression(String sql) throws QueryParserException {
        if (sql == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("QueryParser.nullSqlExpr"));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Expression result = null;
        try {
            result = this.getSqlParser(sql).expression(dummyInfo);
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        catch (TokenMgrError tme) {
            throw this.handleTokenMgrError(tme);
        }
        return result;
    }

    public SingleElementSymbol parseSelectExpression(String sql) throws QueryParserException {
        if (sql == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("QueryParser.nullSqlExpr"));
        }
        ParseInfo dummyInfo = new ParseInfo();
        SingleElementSymbol result = null;
        try {
            result = this.getSqlParser(sql).selectExpression(dummyInfo);
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        catch (TokenMgrError tme) {
            throw this.handleTokenMgrError(tme);
        }
        return result;
    }

    private QueryParserException handleTokenMgrError(TokenMgrError tme) {
        String msg = tme.getMessage();
        int index = msg.indexOf(LINE_MARKER);
        if (index > 0) {
            index += LINE_MARKER.length();
            int lastIndex = msg.indexOf(",", index);
            if ((index = msg.indexOf(COL_MARKER, lastIndex)) > 0) {
                lastIndex = msg.indexOf(".", index += COL_MARKER.length());
                return new QueryParserException(QueryPlugin.Util.getString("QueryParser.lexicalError", new Object[]{tme.getMessage()}));
            }
        }
        return new QueryParserException(QueryPlugin.Util.getString("QueryParser.parsingError", new Object[]{tme.getMessage()}));
    }
}

