/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.List;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.util.CommandContext;

public class QueryProcessor
implements BatchCollector.BatchProducer {
    private static ExpiredTimeSliceException EXPIRED_TIME_SLICE = new ExpiredTimeSliceException();
    private CommandContext context;
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private ProcessorPlan processPlan;
    private boolean initialized;
    private boolean open;
    private int reserved;
    private volatile boolean requestCanceled;
    private static final int DEFAULT_WAIT = 50;
    private boolean processorClosed;

    public QueryProcessor(ProcessorPlan plan, CommandContext context, BufferManager bufferMgr, ProcessorDataManager dataMgr) throws TeiidComponentException {
        this.context = context;
        this.dataMgr = dataMgr;
        this.processPlan = plan;
        this.bufferMgr = bufferMgr;
    }

    public CommandContext getContext() {
        return this.context;
    }

    public Object getProcessID() {
        return this.context.getProcessorID();
    }

    public ProcessorPlan getProcessorPlan() {
        return this.processPlan;
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidProcessingException, TeiidComponentException {
        while (true) {
            long wait = 50L;
            try {
                return this.nextBatchDirect();
            }
            catch (BlockedException e) {
                if (!this.context.isNonBlocking()) {
                    throw e;
                }
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException err) {
                    throw new TeiidComponentException((Throwable)err);
                }
            }
        }
    }

    private TupleBatch nextBatchDirect() throws BlockedException, TeiidProcessingException, TeiidComponentException {
        boolean done = false;
        TupleBatch result = null;
        try {
            this.init();
            long currentTime = System.currentTimeMillis();
            Assertion.assertTrue((!this.processorClosed ? 1 : 0) != 0);
            while (currentTime < this.context.getTimeSliceEnd() || this.context.isNonBlocking()) {
                if (this.requestCanceled) {
                    throw new TeiidProcessingException(QueryPlugin.Util.getString("QueryProcessor.request_cancelled", new Object[]{this.getProcessID()}));
                }
                if (currentTime > this.context.getTimeoutEnd()) {
                    throw new TeiidProcessingException("Query timed out");
                }
                result = this.processPlan.nextBatch();
                if (result.getTerminationFlag()) {
                    done = true;
                } else if (result.getRowCount() <= 0) continue;
                break;
            }
        }
        catch (BlockedException e) {
            throw e;
        }
        catch (TeiidException e) {
            this.closeProcessing();
            if (e instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)((Object)e);
            }
            if (e instanceof TeiidComponentException) {
                throw (TeiidComponentException)((Object)e);
            }
            throw new TeiidComponentException((Throwable)e);
        }
        if (done) {
            this.closeProcessing();
        }
        if (result == null) {
            throw EXPIRED_TIME_SLICE;
        }
        return result;
    }

    private void init() throws TeiidComponentException, TeiidProcessingException {
        if (!this.initialized) {
            this.reserved = this.bufferMgr.reserveBuffers(this.bufferMgr.getSchemaSize(this.getOutputElements()), BufferManager.BufferReserveMode.FORCE);
            this.processPlan.initialize(this.context, this.dataMgr, this.bufferMgr);
            this.initialized = true;
        }
        if (!this.open) {
            this.processPlan.open();
            this.open = true;
        }
    }

    public void closeProcessing() {
        if (this.processorClosed) {
            return;
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"QueryProcessor: closing processor"});
        }
        this.bufferMgr.releaseBuffers(this.reserved);
        this.reserved = 0;
        this.processorClosed = true;
        try {
            this.processPlan.close();
        }
        catch (TeiidComponentException e1) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)e1, (Object[])new Object[]{"Error closing processor"});
        }
    }

    @Override
    public List getOutputElements() {
        return this.processPlan.getOutputElements();
    }

    public List<Exception> getAndClearWarnings() {
        return this.processPlan.getAndClearWarnings();
    }

    public void requestCanceled() {
        this.requestCanceled = true;
    }

    public BatchCollector createBatchCollector() throws TeiidComponentException {
        return new BatchCollector(this, this.bufferMgr, this.context, false);
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.context.setNonBlocking(nonBlocking);
    }

    @Override
    public TupleBuffer getFinalBuffer() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        while (true) {
            long wait = 50L;
            try {
                this.init();
                return this.processPlan.getFinalBuffer();
            }
            catch (BlockedException e) {
                if (!this.context.isNonBlocking()) {
                    throw e;
                }
            }
            catch (TeiidComponentException e) {
                this.closeProcessing();
                throw e;
            }
            catch (TeiidProcessingException e) {
                this.closeProcessing();
                throw e;
            }
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException err) {
                throw new TeiidComponentException((Throwable)err);
            }
        }
    }

    @Override
    public boolean hasFinalBuffer() {
        return this.processPlan.hasFinalBuffer();
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    public static interface ProcessorFactory {
        public QueryProcessor createQueryProcessor(String var1, String var2, CommandContext var3, Object ... var4) throws TeiidProcessingException, TeiidComponentException;
    }

    public static class ExpiredTimeSliceException
    extends TeiidRuntimeException {
        private static final long serialVersionUID = 4585044674826578060L;
    }
}

