/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.util.CommandContext;

public class AccessNode
extends SubqueryAwareRelationalNode {
    private static final int MAX_CONCURRENT = 10;
    private Command command;
    private String modelName;
    private String connectorBindingId;
    private boolean shouldEvaluate = false;
    private ArrayList<TupleSource> tupleSources = new ArrayList();
    private boolean isUpdate = false;
    private boolean returnedRows = false;
    protected Command nextCommand;
    private int reserved;
    private int schemaSize;

    protected AccessNode() {
    }

    public AccessNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        this.schemaSize = this.getBufferManager().getSchemaSize(this.getOutputElements());
    }

    @Override
    public void reset() {
        super.reset();
        this.tupleSources.clear();
        this.isUpdate = false;
        this.returnedRows = false;
        this.nextCommand = null;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setModelName(String name) {
        this.modelName = name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setShouldEvaluateExpressions(boolean shouldEvaluate) {
        this.shouldEvaluate = shouldEvaluate;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        Command atomicCommand = this.command;
        boolean needProcessing = true;
        if (this.shouldEvaluate) {
            atomicCommand = this.initialCommand();
        }
        do {
            atomicCommand = this.nextCommand();
            if (this.shouldEvaluate) {
                needProcessing = this.prepareNextCommand(atomicCommand);
                this.nextCommand = null;
            } else {
                needProcessing = RelationalNodeUtil.shouldExecute(atomicCommand, true);
            }
            this.isUpdate = RelationalNodeUtil.isUpdate(atomicCommand);
            if (!needProcessing) continue;
            this.registerRequest(atomicCommand);
        } while (!this.processCommandsIndividually() && this.hasNextCommand() && this.tupleSources.size() < Math.min(10, this.getContext().getUserRequestSourceConcurrency()));
    }

    static void rewriteAndEvaluate(Command atomicCommand, Evaluator eval, CommandContext context, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
        try {
            QueryRewriter.evaluateAndRewrite(atomicCommand, eval, context, metadata);
        }
        catch (QueryValidatorException e) {
            throw new TeiidProcessingException((Throwable)((Object)e), QueryPlugin.Util.getString("AccessNode.rewrite_failed", new Object[]{atomicCommand}));
        }
    }

    protected Command initialCommand() throws TeiidProcessingException, TeiidComponentException {
        return this.nextCommand();
    }

    protected Command nextCommand() {
        if (this.nextCommand == null) {
            this.nextCommand = (Command)this.command.clone();
        }
        return this.nextCommand;
    }

    protected boolean prepareNextCommand(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        AccessNode.rewriteAndEvaluate(atomicCommand, this.getEvaluator(Collections.emptyMap()), this.getContext(), this.getContext().getMetadata());
        return RelationalNodeUtil.shouldExecute(atomicCommand, true);
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        while (!this.tupleSources.isEmpty() || this.hasNextCommand()) {
            if (this.tupleSources.isEmpty() && this.processCommandsIndividually()) {
                this.registerNext();
            }
            for (int i = 0; i < this.tupleSources.size(); ++i) {
                TupleSource tupleSource = this.tupleSources.get(i);
                try {
                    List<?> tuple = null;
                    while ((tuple = tupleSource.nextTuple()) != null) {
                        this.returnedRows = true;
                        this.addBatchRow(tuple);
                        if (!this.isBatchFull()) continue;
                        return this.pullBatch();
                    }
                    tupleSource.closeSource();
                    this.tupleSources.remove(i--);
                    if (this.reserved > 0) {
                        this.reserved -= this.schemaSize;
                        this.getBufferManager().releaseBuffers(this.schemaSize);
                    }
                    if (this.processCommandsIndividually()) continue;
                    this.registerNext();
                    continue;
                }
                catch (BlockedException e) {
                    if (!this.processCommandsIndividually()) continue;
                    throw e;
                }
            }
            if (this.processCommandsIndividually()) {
                if (!this.hasPendingRows()) continue;
                return this.pullBatch();
            }
            if (this.tupleSources.isEmpty()) continue;
            throw BlockedException.INSTANCE;
        }
        if (this.isUpdate && !this.returnedRows) {
            ArrayList<Integer> tuple = new ArrayList<Integer>(1);
            tuple.add(0);
            this.addBatchRow(tuple);
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    private void registerNext() throws TeiidComponentException, TeiidProcessingException {
        while (this.hasNextCommand()) {
            Command atomicCommand = this.nextCommand();
            if (this.prepareNextCommand(atomicCommand)) {
                this.nextCommand = null;
                this.registerRequest(atomicCommand);
                break;
            }
            this.nextCommand = null;
        }
    }

    private void registerRequest(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        LimitNode parent;
        int limit = -1;
        if (this.getParent() instanceof LimitNode && (parent = (LimitNode)this.getParent()).getLimit() > 0) {
            limit = parent.getLimit() + parent.getOffset();
        }
        this.tupleSources.add(this.getDataManager().registerRequest(this.getContext(), atomicCommand, this.modelName, this.connectorBindingId, this.getID(), limit));
        if (this.tupleSources.size() > 1) {
            this.reserved += this.getBufferManager().reserveBuffers(this.schemaSize, BufferManager.BufferReserveMode.FORCE);
        }
    }

    protected boolean processCommandsIndividually() {
        return false;
    }

    protected boolean hasNextCommand() {
        return false;
    }

    @Override
    public void closeDirect() {
        this.getBufferManager().releaseBuffers(this.reserved);
        this.reserved = 0;
        super.closeDirect();
        this.closeSources();
    }

    private void closeSources() {
        for (TupleSource ts : this.tupleSources) {
            ts.closeSource();
        }
        this.tupleSources.clear();
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.command);
    }

    @Override
    public Object clone() {
        AccessNode clonedNode = new AccessNode();
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(AccessNode source, AccessNode target) {
        super.copy(source, target);
        target.modelName = source.modelName;
        target.connectorBindingId = source.connectorBindingId;
        target.shouldEvaluate = source.shouldEvaluate;
        target.command = source.command;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Query", this.command.toString());
        props.addProperty("Model Name", this.modelName);
        return props;
    }

    public String getConnectorBindingId() {
        return this.connectorBindingId;
    }

    public void setConnectorBindingId(String connectorBindingId) {
        this.connectorBindingId = connectorBindingId;
    }
}

