/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.DependentValueSource;
import org.teiid.query.processor.relational.JoinStrategy;
import org.teiid.query.processor.relational.SourceState;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.util.CommandContext;

public class JoinNode
extends SubqueryAwareRelationalNode {
    static BatchAvailableException BATCH_AVILABLE = new BatchAvailableException();
    private State state = State.LOAD_LEFT;
    private JoinStrategy joinStrategy;
    private JoinType joinType;
    private String dependentValueSource;
    private List leftExpressions;
    private List rightExpressions;
    private boolean leftDistinct;
    private boolean rightDistinct;
    private Criteria joinCriteria;
    private Map combinedElementMap;
    private int[] projectionIndexes;

    public JoinNode(int nodeID) {
        super(nodeID);
    }

    public void setJoinType(JoinType type) {
        this.joinType = type;
    }

    public JoinStrategy getJoinStrategy() {
        return this.joinStrategy;
    }

    public void setJoinStrategy(JoinStrategy joinStrategy) {
        this.joinStrategy = joinStrategy;
    }

    public void setJoinExpressions(List leftExpressions, List rightExpressions) {
        this.leftExpressions = leftExpressions;
        this.rightExpressions = rightExpressions;
    }

    public boolean isLeftDistinct() {
        return this.leftDistinct;
    }

    public void setLeftDistinct(boolean leftDistinct) {
        this.leftDistinct = leftDistinct;
    }

    public boolean isRightDistinct() {
        return this.rightDistinct;
    }

    public void setRightDistinct(boolean rightDistinct) {
        this.rightDistinct = rightDistinct;
    }

    public void setJoinCriteria(Criteria joinCriteria) {
        this.joinCriteria = joinCriteria;
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.combinedElementMap == null) {
            ArrayList combinedElements = new ArrayList(this.getChildren()[0].getElements());
            combinedElements.addAll(this.getChildren()[1].getElements());
            this.combinedElementMap = JoinNode.createLookupMap(combinedElements);
            this.projectionIndexes = JoinNode.getProjectionIndexes(this.combinedElementMap, this.getElements());
        }
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        this.joinStrategy.initialize(this);
        this.joinStrategy.openLeft();
        if (!this.isDependent()) {
            this.joinStrategy.openRight();
        }
        this.state = State.LOAD_LEFT;
    }

    @Override
    public Object clone() {
        JoinNode clonedNode = new JoinNode(super.getID());
        super.copy(this, clonedNode);
        clonedNode.joinType = this.joinType;
        clonedNode.joinStrategy = this.joinStrategy.clone();
        clonedNode.joinCriteria = this.joinCriteria;
        clonedNode.leftExpressions = this.leftExpressions;
        clonedNode.rightExpressions = this.rightExpressions;
        clonedNode.dependentValueSource = this.dependentValueSource;
        clonedNode.rightDistinct = this.rightDistinct;
        clonedNode.leftDistinct = this.leftDistinct;
        return clonedNode;
    }

    @Override
    protected TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.state == State.LOAD_LEFT) {
            if (this.joinType != JoinType.JOIN_FULL_OUTER) {
                this.joinStrategy.leftSource.setImplicitBuffer(SourceState.ImplicitBuffer.NONE);
            }
            this.joinStrategy.loadLeft();
            if (this.isDependent()) {
                TupleBuffer buffer = this.joinStrategy.leftSource.getTupleBuffer();
                this.getContext().getVariableContext().setGlobalValue(this.dependentValueSource, new DependentValueSource(buffer));
            }
            this.state = State.LOAD_RIGHT;
        }
        if (this.state == State.LOAD_RIGHT) {
            this.joinStrategy.openRight();
            this.joinStrategy.loadRight();
            this.state = State.EXECUTE;
        }
        try {
            this.joinStrategy.process();
            this.terminateBatches();
        }
        catch (BatchAvailableException batchAvailableException) {
            // empty catch block
        }
        return this.pullBatch();
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        if (this.isDependent()) {
            props.addProperty("Dependent Join", Boolean.TRUE.toString());
        }
        props.addProperty("Join Strategy", this.joinStrategy.toString());
        props.addProperty("Join Type", this.joinType.toString());
        List<String> critList = this.getCriteriaList();
        props.addProperty("Join Criteria", critList);
        return props;
    }

    private List<String> getCriteriaList() {
        ArrayList<String> critList = new ArrayList<String>();
        if (this.leftExpressions != null) {
            for (int i = 0; i < this.leftExpressions.size(); ++i) {
                critList.add(this.leftExpressions.get(i).toString() + "=" + this.rightExpressions.get(i).toString());
            }
        }
        if (this.joinCriteria != null) {
            for (Criteria crit : Criteria.separateCriteriaByAnd(this.joinCriteria)) {
                critList.add(crit.toString());
            }
        }
        return critList;
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        str.append(this.getClassName());
        str.append("(");
        str.append(this.getID());
        str.append(") [");
        if (this.isDependent()) {
            str.append("Dependent] [");
        }
        str.append(this.joinStrategy.toString());
        str.append("] [");
        str.append(this.joinType.toString());
        str.append("]");
        if (this.getJoinType() != JoinType.JOIN_CROSS) {
            str.append(" criteria=").append(this.getCriteriaList());
        }
        str.append(" output=");
        str.append(this.getElements());
    }

    public boolean isDependent() {
        return this.dependentValueSource != null;
    }

    public void setDependentValueSource(String dependentValueSource) {
        this.dependentValueSource = dependentValueSource;
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        this.joinStrategy.close();
        if (this.getContext() != null && this.dependentValueSource != null) {
            this.getContext().getVariableContext().setGlobalValue(this.dependentValueSource, null);
        }
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    Map getCombinedElementMap() {
        return this.combinedElementMap;
    }

    public Criteria getJoinCriteria() {
        return this.joinCriteria;
    }

    boolean matchesCriteria(List outputTuple) throws BlockedException, TeiidComponentException, ExpressionEvaluationException {
        return this.joinCriteria == null || this.getEvaluator(this.combinedElementMap).evaluate(this.joinCriteria, outputTuple);
    }

    public List getLeftExpressions() {
        return this.leftExpressions;
    }

    public List getRightExpressions() {
        return this.rightExpressions;
    }

    @Override
    protected void addBatchRow(List row) {
        List projectTuple = JoinNode.projectTuple(this.projectionIndexes, row);
        super.addBatchRow(projectTuple);
        if (this.isBatchFull()) {
            throw BATCH_AVILABLE;
        }
    }

    private static enum State {
        LOAD_LEFT,
        LOAD_RIGHT,
        EXECUTE;

    }

    public static enum JoinStrategyType {
        MERGE,
        ENHANCED_SORT,
        NESTED_LOOP,
        NESTED_TABLE;

    }

    static class BatchAvailableException
    extends RuntimeException {
        BatchAvailableException() {
        }
    }
}

