/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class ExecResolver
extends ProcedureContainerResolver {
    private void findCommandMetadata(Command command, TempMetadataStore discoveredMetadata, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Expression expr;
        StoredProcedureInfo storedProcedureInfo;
        StoredProcedure storedProcedureCommand;
        block24: {
            storedProcedureCommand = (StoredProcedure)command;
            storedProcedureInfo = null;
            try {
                storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(storedProcedureCommand.getProcedureName());
            }
            catch (QueryMetadataException e) {
                String[] parts = storedProcedureCommand.getProcedureName().split("\\.", 2);
                if (parts.length > 1 && parts[0].equalsIgnoreCase(metadata.getVirtualDatabaseName())) {
                    try {
                        storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(parts[1]);
                        storedProcedureCommand.setProcedureName(parts[1]);
                    }
                    catch (QueryMetadataException e1) {
                        // empty catch block
                    }
                }
                if (storedProcedureInfo != null) break block24;
                throw e;
            }
        }
        storedProcedureCommand.setUpdateCount(storedProcedureInfo.getUpdateCount());
        storedProcedureCommand.setModelID(storedProcedureInfo.getModelID());
        storedProcedureCommand.setProcedureID(storedProcedureInfo.getProcedureID());
        storedProcedureCommand.setProcedureCallableName(storedProcedureInfo.getProcedureCallableName());
        List<SPParameter> oldParams = storedProcedureCommand.getParameters();
        boolean namedParameters = storedProcedureCommand.displayNamedParameters();
        if (oldParams.size() == 0 || oldParams.size() == 1 && storedProcedureCommand.isCalledWithReturn()) {
            storedProcedureCommand.setDisplayNamedParameters(true);
            namedParameters = true;
        }
        HashMap<Object, Expression> inputExpressions = new HashMap<Object, Expression>();
        int adjustIndex = 0;
        for (SPParameter param : oldParams) {
            if (param.getExpression() == null) {
                if (param.getParameterType() != 5) continue;
                --adjustIndex;
                continue;
            }
            if (namedParameters && param.getParameterType() != 4) {
                if (inputExpressions.put(param.getName().toUpperCase(), param.getExpression()) == null) continue;
                throw new QueryResolverException(QueryPlugin.Util.getString("ExecResolver.duplicate_named_params", new Object[]{param.getName().toUpperCase()}));
            }
            inputExpressions.put(param.getIndex() + adjustIndex, param.getExpression());
        }
        storedProcedureCommand.clearParameters();
        int origInputs = inputExpressions.size();
        List<SPParameter> metadataParams = storedProcedureInfo.getParameters();
        ArrayList<SPParameter> clonedMetadataParams = new ArrayList<SPParameter>(metadataParams.size());
        int inputParams = 0;
        int outParams = 0;
        boolean hasReturnValue = false;
        for (SPParameter metadataParameter : metadataParams) {
            if (metadataParameter.getParameterType() == 1 || metadataParameter.getParameterType() == 3) {
                ++inputParams;
            } else if (metadataParameter.getParameterType() == 2) {
                ++outParams;
            } else if (metadataParameter.getParameterType() == 4) {
                hasReturnValue = true;
            }
            SPParameter clonedParam = (SPParameter)metadataParameter.clone();
            clonedMetadataParams.add(clonedParam);
            storedProcedureCommand.setParameter(clonedParam);
        }
        if (storedProcedureCommand.isCalledWithReturn() && !hasReturnValue) {
            throw new QueryResolverException(QueryPlugin.Util.getString("ExecResolver.return_expected", new Object[]{storedProcedureCommand.getGroup()}));
        }
        if (!namedParameters && inputParams > inputExpressions.size()) {
            throw new QueryResolverException("ERR.015.008.0007", QueryPlugin.Util.getString("ERR.015.008.0007", new Object[]{inputParams, origInputs, storedProcedureCommand.getGroup()}));
        }
        int exprIndex = 1;
        HashSet<String> expected = new HashSet<String>();
        if (storedProcedureCommand.isCalledWithReturn() && hasReturnValue) {
            for (SPParameter param : clonedMetadataParams) {
                if (param.getParameterType() != 4) continue;
                expr = (Expression)inputExpressions.remove(exprIndex++);
                param.setExpression(expr);
            }
        }
        for (SPParameter param : clonedMetadataParams) {
            if (param.getParameterType() == 5 || param.getParameterType() == 4) continue;
            if (namedParameters) {
                String nameKey = param.getParameterSymbol().getShortCanonicalName();
                Expression expr2 = (Expression)inputExpressions.remove(nameKey);
                if (expr2 == null && param.getParameterType() != 2) {
                    expr2 = ResolverUtil.getDefault(param.getParameterSymbol(), metadata);
                    param.setUsingDefault(true);
                    expected.add(nameKey);
                }
                param.setExpression(expr2);
                continue;
            }
            if (param.getParameterType() == 2) continue;
            expr = (Expression)inputExpressions.remove(exprIndex++);
            param.setExpression(expr);
        }
        if (!inputExpressions.isEmpty()) {
            if (namedParameters) {
                throw new QueryResolverException(QueryPlugin.Util.getString("ExecResolver.invalid_named_params", new Object[]{inputExpressions.keySet(), expected}));
            }
            throw new QueryResolverException("ERR.015.008.0007", QueryPlugin.Util.getString("ERR.015.008.0007", new Object[]{inputParams, origInputs, storedProcedureCommand.getGroup().toString()}));
        }
        String procName = storedProcedureCommand.getProcedureName();
        List tempElements = storedProcedureCommand.getProjectedSymbols();
        boolean isVirtual = storedProcedureInfo.getQueryPlan() != null;
        discoveredMetadata.addTempGroup(procName, tempElements, isVirtual);
        GroupSymbol procGroup = new GroupSymbol(storedProcedureInfo.getProcedureCallableName());
        procGroup.setProcedure(true);
        TempMetadataID tid = discoveredMetadata.getTempGroupID(procName);
        tid.setOriginalMetadataID(storedProcedureCommand.getProcedureID());
        procGroup.setMetadataID(tid);
        storedProcedureCommand.setGroup(procGroup);
    }

    @Override
    public void resolveProceduralCommand(Command command, TempMetadataAdapter metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        this.findCommandMetadata(command, metadata.getMetadataStore(), metadata);
        StoredProcedure storedProcedureCommand = (StoredProcedure)command;
        GroupContext externalGroups = storedProcedureCommand.getExternalGroupContexts();
        for (SPParameter param : storedProcedureCommand.getParameters()) {
            Expression expr = param.getExpression();
            if (expr == null) continue;
            for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr)) {
                QueryResolver.setChildMetadata(container.getCommand(), command);
                QueryResolver.resolveCommand(container.getCommand(), metadata.getMetadata());
            }
            ResolverVisitor.resolveLanguageObject(expr, null, externalGroups, metadata);
            Class paramType = param.getClassType();
            ResolverUtil.setDesiredType(expr, paramType, storedProcedureCommand);
            Class exprType = expr.getType();
            if (paramType == null || exprType == null) {
                throw new QueryResolverException("ERR.015.008.0061", QueryPlugin.Util.getString("ERR.015.008.0061", new Object[]{storedProcedureCommand.getProcedureName(), param.getName()}));
            }
            String tgtType = DataTypeManager.getDataTypeName((Class)paramType);
            String srcType = DataTypeManager.getDataTypeName((Class)exprType);
            Expression result = null;
            if (param.getParameterType() == 4 || param.getParameterType() == 2) {
                if (ResolverUtil.canImplicitlyConvert(tgtType, srcType)) continue;
                throw new QueryResolverException(QueryPlugin.Util.getString("ExecResolver.out_type_mismatch", new Object[]{param.getParameterSymbol(), tgtType, srcType}));
            }
            try {
                result = ResolverUtil.convertExpression(expr, tgtType, metadata);
            }
            catch (QueryResolverException e) {
                throw new QueryResolverException((Throwable)((Object)e), QueryPlugin.Util.getString("ExecResolver.Param_convert_fail", new Object[]{srcType, tgtType}));
            }
            param.setExpression(result);
        }
    }

    @Override
    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryResolverException {
    }

    @Override
    protected String getPlan(QueryMetadataInterface metadata, GroupSymbol group) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        StoredProcedureInfo storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(group.getCanonicalName());
        QueryNode plan = storedProcedureInfo.getQueryPlan();
        if (plan.getQuery() == null) {
            throw new QueryResolverException("ERR.015.008.0009", QueryPlugin.Util.getString("ERR.015.008.0009", new Object[]{group, "Stored Procedure"}));
        }
        return plan.getQuery();
    }
}

