/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.Collection;
import java.util.Set;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;

public class AggregateValidationVisitor
extends AbstractValidationVisitor {
    private boolean validateBelow = true;
    private Set<Expression> groupExpressions;

    public AggregateValidationVisitor(Set<Expression> groupExpressions) {
        this.groupExpressions = groupExpressions;
    }

    @Override
    public void visit(AggregateSymbol obj) {
        AggregateSymbol.Type aggregateFunction;
        Collection<AggregateSymbol> nestedAggs;
        Expression aggExp = obj.getExpression();
        if (aggExp != null && (nestedAggs = AggregateSymbolCollectorVisitor.getAggregates(aggExp, true)).size() > 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0039", new Object[]{nestedAggs}), nestedAggs);
        }
        if (((aggregateFunction = obj.getAggregateFunction()) == AggregateSymbol.Type.SUM || aggregateFunction == AggregateSymbol.Type.AVG) && obj.getType() == null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0041", new Object[]{aggregateFunction, obj}), obj);
        } else if (obj.getType() != DataTypeManager.DefaultDataClasses.NULL) {
            if (aggregateFunction == AggregateSymbol.Type.XMLAGG && aggExp.getType() != DataTypeManager.DefaultDataClasses.XML) {
                this.handleValidationError(QueryPlugin.Util.getString("AggregateValidationVisitor.non_xml", new Object[]{aggregateFunction, obj}), obj);
            } else if (obj.isBoolean() && aggExp.getType() != DataTypeManager.DefaultDataClasses.BOOLEAN) {
                this.handleValidationError(QueryPlugin.Util.getString("AggregateValidationVisitor.non_boolean", new Object[]{aggregateFunction, obj}), obj);
            }
        }
        if ((obj.isDistinct() || aggregateFunction == AggregateSymbol.Type.MIN || aggregateFunction == AggregateSymbol.Type.MAX) && DataTypeManager.isNonComparable((String)DataTypeManager.getDataTypeName((Class)aggExp.getType()))) {
            this.handleValidationError(QueryPlugin.Util.getString("AggregateValidationVisitor.non_comparable", new Object[]{aggregateFunction, obj}), obj);
        }
        if (obj.isEnhancedNumeric()) {
            if (!Number.class.isAssignableFrom(aggExp.getType())) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0041", new Object[]{aggregateFunction, obj}), obj);
            }
            if (obj.isDistinct()) {
                this.handleValidationError(QueryPlugin.Util.getString("AggregateValidationVisitor.invalid_distinct", new Object[]{aggregateFunction, obj}), obj);
            }
        }
        this.validateBelow = false;
    }

    @Override
    public void visit(ElementSymbol obj) {
        this.validateExpression(obj);
    }

    @Override
    public void visit(ExpressionSymbol obj) {
        this.validateExpression(obj);
    }

    @Override
    public void visit(CaseExpression obj) {
        this.validateExpression(obj);
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        this.validateExpression(obj);
    }

    @Override
    public void visit(Function obj) {
        this.validateExpression(obj);
    }

    private void validateExpression(Expression symbol) {
        if (ElementCollectorVisitor.getElements((LanguageObject)symbol, false).isEmpty()) {
            this.validateBelow = false;
            return;
        }
        if (this.groupExpressions == null) {
            if (symbol instanceof ElementSymbol && !((ElementSymbol)symbol).isExternalReference()) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0037", new Object[]{symbol}), symbol);
            }
        } else if (!this.groupExpressions.contains(symbol)) {
            if (symbol instanceof ElementSymbol && !((ElementSymbol)symbol).isExternalReference()) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0038", new Object[]{symbol}), symbol);
            }
        } else {
            this.validateBelow = false;
        }
    }

    public static void validate(LanguageObject obj, final AggregateValidationVisitor visitor) {
        visitor.validateBelow = true;
        PreOrderNavigator nav = new PreOrderNavigator(visitor){
            private boolean validateBelow;

            @Override
            protected void visitNode(LanguageObject obj) {
                if (this.validateBelow) {
                    super.visitNode(obj);
                }
            }

            @Override
            protected void preVisitVisitor(LanguageObject obj) {
                super.preVisitVisitor(obj);
                this.validateBelow = visitor.validateBelow;
            }

            @Override
            protected void postVisitVisitor(LanguageObject obj) {
                this.validateBelow = true;
            }
        };
        obj.acceptVisitor(nav);
    }
}

