/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.XPathException;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.HasCriteria;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.TranslateCriteria;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;
import org.teiid.query.validator.AggregateValidationVisitor;
import org.teiid.query.validator.UpdateValidator;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.query.xquery.saxon.SaxonXQueryExpression;

public class ValidationVisitor
extends AbstractValidationVisitor {
    private boolean isXML = false;
    private CreateUpdateProcedureCommand updateProc;

    public void setUpdateProc(CreateUpdateProcedureCommand updateProc) {
        this.updateProc = updateProc;
    }

    @Override
    public void reset() {
        super.reset();
        this.isXML = false;
    }

    @Override
    public void visit(BatchedUpdateCommand obj) {
        List<Command> commands = obj.getUpdateCommands();
        Command command = null;
        int type = 0;
        for (int i = 0; i < commands.size(); ++i) {
            Into into;
            command = commands.get(i);
            type = command.getType();
            if (type != 2 && type != 3 && type != 4 && type != 1) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_batch_command"), command);
                continue;
            }
            if (type != 1 || (into = ((Query)command).getInto()) != null) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_batch_command"), command);
        }
    }

    @Override
    public void visit(Delete obj) {
        this.validateNoXMLUpdates(obj);
        GroupSymbol group = obj.getGroup();
        this.validateGroupSupportsUpdate(group);
    }

    @Override
    public void visit(GroupBy obj) {
        List groupBySymbols = obj.getSymbols();
        this.validateSortable(groupBySymbols);
        for (SingleElementSymbol symbol : groupBySymbols) {
            ExpressionSymbol exprSymbol;
            Expression expr;
            if (!(symbol instanceof ExpressionSymbol) || ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr = (exprSymbol = (ExpressionSymbol)symbol).getExpression()).isEmpty() && !(expr instanceof Constant) && !(expr instanceof Reference)) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.groupby_subquery", new Object[]{expr}), expr);
        }
    }

    @Override
    public void visit(GroupSymbol obj) {
        try {
            if (this.getMetadata().isScalarGroup(obj.getMetadataID())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_scalar_group_reference", new Object[]{obj}), obj);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((TeiidException)((Object)e));
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    @Override
    public void visit(Insert obj) {
        this.validateNoXMLUpdates(obj);
        this.validateGroupSupportsUpdate(obj.getGroup());
        this.validateInsert(obj);
        if (obj.getQueryExpression() != null) {
            this.validateMultisourceInsert(obj.getGroup());
        }
        if (obj.getUpdateInfo() != null && obj.getUpdateInfo().isInherentInsert()) {
            try {
                if (obj.getUpdateInfo().findInsertUpdateMapping(obj, false) == null) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.nonUpdatable", obj.getVariables()), obj);
                }
            }
            catch (QueryValidatorException e) {
                this.handleValidationError(e.getMessage(), obj);
            }
        }
    }

    @Override
    public void visit(OrderByItem obj) {
        this.validateSortable(obj.getSymbol());
    }

    @Override
    public void visit(Query obj) {
        this.validateHasProjectedSymbols(obj);
        if (this.isXMLCommand(obj)) {
            if (obj.getInto() != null) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0069"), obj);
            }
            this.isXML = true;
            this.validateXMLQuery(obj);
        } else {
            this.validateAggregates(obj);
            if (obj.getSelect() != null && obj.getFrom() == null && !ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(obj.getSelect()).isEmpty()) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0067"), obj);
            }
            if (obj.getInto() != null) {
                this.validateSelectInto(obj);
            }
        }
    }

    @Override
    public void visit(Select obj) {
        this.validateSelectElements(obj);
        if (obj.isDistinct()) {
            this.validateSortable(obj.getProjectedSymbols());
        }
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.validateSubquery(obj);
        if (ValidationVisitor.isNonComparable(obj.getExpression())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0027", new Object[]{obj}), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
        List<SingleElementSymbol> projSymbols = obj.getCommand().getProjectedSymbols();
        if (projSymbols.size() != 1) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0011"), obj);
        }
    }

    @Override
    public void visit(DependentSetCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(SetQuery obj) {
        this.validateHasProjectedSymbols(obj);
        this.validateSetQuery(obj);
    }

    @Override
    public void visit(Update obj) {
        this.validateNoXMLUpdates(obj);
        this.validateGroupSupportsUpdate(obj.getGroup());
        this.validateUpdate(obj);
    }

    @Override
    public void visit(Into obj) {
        GroupSymbol target = obj.getGroup();
        this.validateGroupSupportsUpdate(target);
        this.validateMultisourceInsert(obj.getGroup());
    }

    private void validateMultisourceInsert(GroupSymbol group) {
        try {
            if (this.getMetadata().isMultiSource(this.getMetadata().getModelID(group.getMetadataID()))) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.multisource_insert", new Object[]{group}), group);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((TeiidException)((Object)e));
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    @Override
    public void visit(Function obj) {
        block12: {
            block17: {
                block15: {
                    block16: {
                        block14: {
                            block13: {
                                if (!"lookup".equalsIgnoreCase(obj.getName())) break block13;
                                try {
                                    ResolverUtil.ResolvedLookup resolvedLookup = ResolverUtil.resolveLookup(obj, this.getMetadata());
                                    if (ValidationVisitor.isNonComparable(resolvedLookup.getKeyElement())) {
                                        this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_lookup_key", new Object[]{resolvedLookup.getKeyElement()}), resolvedLookup.getKeyElement());
                                    }
                                    break block12;
                                }
                                catch (TeiidComponentException e) {
                                    this.handleException((TeiidException)((Object)e), obj);
                                }
                                catch (TeiidProcessingException e) {
                                    this.handleException((TeiidException)((Object)e), obj);
                                }
                                break block12;
                            }
                            if (!obj.getFunctionDescriptor().getName().equalsIgnoreCase("context")) break block14;
                            if (!this.isXML) {
                                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.The_context_function_cannot_be_used_in_a_non-XML_command"), obj);
                            } else {
                                if (!(obj.getArg(0) instanceof ElementSymbol)) {
                                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.004.0036"), obj);
                                }
                                for (Function function : FunctionCollectorVisitor.getFunctions((LanguageObject)obj.getArg(1), false)) {
                                    if (!function.getFunctionDescriptor().getName().equalsIgnoreCase("context")) continue;
                                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Context_function_nested"), obj);
                                }
                            }
                            break block12;
                        }
                        if (!obj.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimit") && !obj.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimitexception")) break block15;
                        if (!this.isXML) break block16;
                        if (obj.getArg(0) instanceof ElementSymbol) break block12;
                        this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.2"), obj);
                        break block12;
                    }
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.The_rowlimit_function_cannot_be_used_in_a_non-XML_command"), obj);
                    break block12;
                }
                if (!obj.getFunctionDescriptor().getName().equalsIgnoreCase("xpathvalue")) break block17;
                if (!(obj.getArgs()[1] instanceof Constant)) break block12;
                Constant xpathConst = (Constant)obj.getArgs()[1];
                try {
                    XMLSystemFunctions.validateXpath((String)xpathConst.getValue());
                }
                catch (XPathException e) {
                    this.handleValidationError(QueryPlugin.Util.getString("QueryResolver.invalid_xpath", new Object[]{e.getMessage()}), obj);
                }
                break block12;
            }
            if (!obj.getFunctionDescriptor().getName().equalsIgnoreCase("to_bytes") && !obj.getFunctionDescriptor().getName().equalsIgnoreCase("to_chars")) break block12;
            try {
                FunctionMethods.getCharset((String)((Constant)obj.getArg(1)).getValue());
            }
            catch (IllegalArgumentException e) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_encoding", new Object[]{obj.getArg(1)}), obj);
            }
        }
    }

    @Override
    public void visit(AssignmentStatement obj) {
        ElementSymbol variable = obj.getVariable();
        this.validateAssignment(obj, variable);
    }

    @Override
    public void visit(CommandStatement obj) {
        if (obj.getCommand() instanceof StoredProcedure) {
            StoredProcedure proc = (StoredProcedure)obj.getCommand();
            for (SPParameter param : proc.getParameters()) {
                if (param.getParameterType() != 4 && param.getParameterType() != 2 || !(param.getExpression() instanceof ElementSymbol)) continue;
                this.validateAssignment(obj, (ElementSymbol)param.getExpression());
            }
        }
    }

    @Override
    public void visit(StoredProcedure obj) {
        for (SPParameter param : obj.getInputParameters()) {
            try {
                if (!(param.getExpression() instanceof Constant) && this.getMetadata().isMultiSourceElement(param.getMetadataID())) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.multisource_constant", new Object[]{param.getParameterSymbol()}), param.getParameterSymbol());
                    continue;
                }
                if (!EvaluatableVisitor.isFullyEvaluatable(param.getExpression(), true)) continue;
                try {
                    Object evaluatedValue = Evaluator.evaluate(param.getExpression());
                    if (evaluatedValue != null || this.getMetadata().elementSupports(param.getMetadataID(), 4)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0055", new Object[]{param.getParameterSymbol()}), param.getParameterSymbol());
                }
                catch (ExpressionEvaluationException e) {
                }
            }
            catch (TeiidComponentException e) {
                this.handleException((TeiidException)((Object)e));
            }
        }
    }

    private void validateAssignment(LanguageObject obj, ElementSymbol variable) {
        String groupName = variable.getGroupSymbol().getCanonicalName();
        if (groupName.equals("CHANGING") || groupName.equals("INPUTS")) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0012", new Object[]{"INPUTS", "CHANGING"}), obj);
        }
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.validateSubquery(obj);
        List<SingleElementSymbol> projSymbols = obj.getCommand().getProjectedSymbols();
        if (projSymbols.size() != 1) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.008.0032", new Object[]{obj.getCommand()}), obj.getCommand());
        }
    }

    @Override
    public void visit(CreateUpdateProcedureCommand obj) {
        if (!obj.isUpdateProcedure()) {
            if (GroupCollectorVisitor.getGroups((LanguageObject)obj, true).contains(obj.getVirtualGroup())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Procedure_has_group_self_reference"), obj);
            }
            return;
        }
        this.updateProc = obj;
        this.validateContainsRowsUpdatedVariable(obj);
    }

    @Override
    public void visit(DeclareStatement obj) {
        this.validateAssignment(obj, obj.getVariable());
    }

    @Override
    public void visit(HasCriteria obj) {
        if (this.updateProc == null || !this.updateProc.isUpdateProcedure()) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0019"), obj);
        }
    }

    @Override
    public void visit(TranslateCriteria obj) {
        if (this.updateProc == null || !this.updateProc.isUpdateProcedure()) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0019"), obj);
        }
        if (obj.hasTranslations()) {
            List selectElmnts = null;
            if (obj.getSelector().hasElements()) {
                selectElmnts = obj.getSelector().getElements();
            }
            for (CompareCriteria transCrit : obj.getTranslations()) {
                Collection<ElementSymbol> leftElmnts = ElementCollectorVisitor.getElements((LanguageObject)transCrit.getLeftExpression(), true);
                ElementSymbol leftExpr = leftElmnts.iterator().next();
                if (selectElmnts == null || selectElmnts.contains(leftExpr)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0021"), leftExpr);
            }
        }
        this.validateTranslateCriteria(obj);
    }

    @Override
    public void visit(CompoundCriteria obj) {
        if (this.isXML) {
            ArrayList<Function> rowLimitFunctions = new ArrayList<Function>();
            FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
            PreOrderNavigator.doVisit(obj, visitor);
            visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
            PreOrderNavigator.doVisit(obj, visitor);
            int functionCount = rowLimitFunctions.size();
            if (functionCount > 0) {
                Iterator<Criteria> conjunctIter = Criteria.separateCriteriaByAnd(obj).iterator();
                int i = 0;
                while (conjunctIter.hasNext() && i < functionCount) {
                    CompareCriteria crit;
                    Criteria conjunct = conjunctIter.next();
                    if (!(conjunct instanceof CompareCriteria) || (!rowLimitFunctions.contains((crit = (CompareCriteria)conjunct).getLeftExpression()) || rowLimitFunctions.contains(crit.getRightExpression())) && (!rowLimitFunctions.contains(crit.getRightExpression()) || rowLimitFunctions.contains(crit.getLeftExpression()))) continue;
                    ++i;
                }
                if (i < functionCount) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.3"), obj);
                }
            }
        }
    }

    protected void validateTranslateCriteria(TranslateCriteria obj) {
        if (this.currentCommand == null) {
            return;
        }
        Map symbolMap = this.updateProc.getSymbolMap();
        Command userCommand = this.updateProc.getUserCommand();
        if (userCommand == null) {
            return;
        }
        Criteria userCrit = null;
        int userCmdType = userCommand.getType();
        switch (userCmdType) {
            case 4: {
                userCrit = ((Delete)userCommand).getCriteria();
                break;
            }
            case 3: {
                userCrit = ((Update)userCommand).getCriteria();
                break;
            }
        }
        if (userCrit == null) {
            return;
        }
        Collection<ElementSymbol> transleElmnts = ElementCollectorVisitor.getElements((LanguageObject)obj, true);
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroups((LanguageObject)this.currentCommand, true);
        int selectType = obj.getSelector().getSelectorType();
        for (Criteria predCrit : Criteria.separateCriteriaByAnd(userCrit)) {
            CompareCriteria ccCrit;
            if (selectType != 0 && (predCrit instanceof CompareCriteria ? selectType != (ccCrit = (CompareCriteria)predCrit).getOperator() : (predCrit instanceof MatchCriteria ? selectType != 7 : (predCrit instanceof IsNullCriteria ? selectType != 9 : (predCrit instanceof SetCriteria ? selectType != 8 : predCrit instanceof BetweenCriteria && selectType != 10))))) continue;
            for (ElementSymbol criteriaElement : ElementCollectorVisitor.getElements((LanguageObject)predCrit, true)) {
                if (!transleElmnts.contains(criteriaElement)) continue;
                Expression mappedExpr = (Expression)symbolMap.get(criteriaElement);
                if (mappedExpr instanceof AggregateSymbol) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0022", new Object[]{criteriaElement}), criteriaElement);
                }
                if (groups.containsAll(GroupsUsedByElementsVisitor.getGroups(mappedExpr))) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0023", new Object[]{criteriaElement}), criteriaElement);
            }
        }
    }

    protected void validateSelectElements(Select obj) {
        if (this.isXML) {
            return;
        }
        Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)obj, true);
        Collection<ElementSymbol> cantSelect = this.validateElementsSupport(elements, 0);
        if (cantSelect != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0024", new Object[]{cantSelect}), cantSelect);
        }
    }

    protected void validateHasProjectedSymbols(Command obj) {
        if (obj.getProjectedSymbols().size() == 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0025"), obj);
        }
    }

    protected void validateSortable(List symbols) {
        for (SingleElementSymbol symbol : symbols) {
            this.validateSortable(symbol);
        }
    }

    private void validateSortable(SingleElementSymbol symbol) {
        if (ValidationVisitor.isNonComparable(symbol)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0026", new Object[]{symbol}), symbol);
        }
    }

    public static boolean isNonComparable(Expression symbol) {
        return DataTypeManager.isNonComparable((String)DataTypeManager.getDataTypeName((Class)symbol.getType()));
    }

    protected void validateNoXMLUpdates(Command obj) {
        if (this.isXMLCommand(obj)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0029"), obj);
        }
    }

    protected void validateNoXMLProcedures(Command obj) {
        if (this.isXMLCommand(obj)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0030"), obj);
        }
    }

    private void validateXMLQuery(Query obj) {
        if (obj.getGroupBy() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0031"), obj);
        }
        if (obj.getHaving() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0032"), obj);
        }
        if (obj.getLimit() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.limit_not_valid_for_xml"), obj);
        }
        if (obj.getOrderBy() != null) {
            OrderBy orderBy = obj.getOrderBy();
            for (OrderByItem item : orderBy.getOrderByItems()) {
                if (item.getSymbol() instanceof ElementSymbol) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.orderby_expression_xml"), obj);
            }
        }
    }

    protected void validateGroupSupportsUpdate(GroupSymbol groupSymbol) {
        try {
            if (!this.getMetadata().groupSupports(groupSymbol.getMetadataID(), 0)) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0033", new Object[]{SQLStringVisitor.getSQLString(groupSymbol)}), groupSymbol);
            }
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e), groupSymbol);
        }
    }

    protected void validateSetQuery(SetQuery query) {
        for (QueryCommand subQuery : query.getQueryCommands()) {
            if (this.isXMLCommand(subQuery)) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0034"), query);
            }
            if (!(subQuery instanceof Query) || ((Query)subQuery).getInto() == null) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.union_insert"), query);
        }
        if (!query.isAll() || query.getOperation() == SetQuery.Operation.EXCEPT || query.getOperation() == SetQuery.Operation.INTERSECT) {
            this.validateSortable(query.getProjectedSymbols());
        }
        if (query.isAll() && (query.getOperation() == SetQuery.Operation.EXCEPT || query.getOperation() == SetQuery.Operation.INTERSECT)) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.excpet_intersect_all"), query);
        }
    }

    private void validateAggregates(Query query) {
        Select select = query.getSelect();
        GroupBy groupBy = query.getGroupBy();
        Criteria having = query.getHaving();
        if (groupBy != null || having != null || !AggregateSymbolCollectorVisitor.getAggregates(select, false).isEmpty()) {
            HashSet<Expression> groupSymbols = null;
            if (groupBy != null) {
                groupSymbols = new HashSet<Expression>();
                for (SingleElementSymbol element : groupBy.getSymbols()) {
                    groupSymbols.add(SymbolMap.getExpression(element));
                }
            }
            AggregateValidationVisitor visitor = new AggregateValidationVisitor(groupSymbols);
            if (having != null) {
                AggregateValidationVisitor.validate(having, visitor);
            }
            List<SingleElementSymbol> projectedSymbols = select.getProjectedSymbols();
            for (SingleElementSymbol symbol : projectedSymbols) {
                AggregateValidationVisitor.validate(symbol, visitor);
            }
            ValidatorReport report = visitor.getReport();
            Collection items = report.getItems();
            super.getReport().addItems(items);
        }
    }

    protected void validateInsert(Insert obj) {
        List<ElementSymbol> vars = obj.getVariables();
        Iterator varIter = vars.iterator();
        List values = obj.getValues();
        Iterator valIter = values.iterator();
        GroupSymbol insertGroup = obj.getGroup();
        try {
            for (ElementSymbol insertElem : vars) {
                if (this.getMetadata().elementSupports(insertElem.getMetadataID(), 5)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0052", new Object[]{insertElem}), insertElem);
            }
            LinkedList<ElementSymbol> insertElmnts = new LinkedList<ElementSymbol>(ResolverUtil.resolveElementsInGroup(insertGroup, this.getMetadata()));
            insertElmnts.removeAll(vars);
            for (ElementSymbol nextElmnt : insertElmnts) {
                if (this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 7) || this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 4) || this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 8) || this.getMetadata().isMultiSourceElement(nextElmnt.getMetadataID())) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0053", new Object[]{insertGroup, nextElmnt}), nextElmnt);
            }
            while (valIter.hasNext() && varIter.hasNext()) {
                Expression nextValue = (Expression)valIter.next();
                ElementSymbol nextVar = (ElementSymbol)varIter.next();
                if (!(nextValue instanceof Constant) && this.getMetadata().isMultiSourceElement(nextVar.getMetadataID())) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.multisource_constant", new Object[]{nextVar}), nextVar);
                    continue;
                }
                if (!EvaluatableVisitor.isFullyEvaluatable(nextValue, true)) continue;
                try {
                    Object evaluatedValue = Evaluator.evaluate(nextValue);
                    if (evaluatedValue != null || this.getMetadata().elementSupports(nextVar.getMetadataID(), 4)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0055", new Object[]{nextVar}), nextVar);
                }
                catch (ExpressionEvaluationException e) {}
            }
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e), obj);
        }
    }

    protected void validateSetClauseList(SetClauseList list) {
        HashSet<ElementSymbol> dups = new HashSet<ElementSymbol>();
        HashSet<ElementSymbol> changeVars = new HashSet<ElementSymbol>();
        for (SetClause clause : list.getClauses()) {
            ElementSymbol elementID = clause.getSymbol();
            if (changeVars.add(elementID)) continue;
            dups.add(elementID);
        }
        if (!dups.isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0062", new Object[]{dups}), dups);
        }
    }

    protected void validateUpdate(Update update) {
        try {
            Set<ElementSymbol> updateCols;
            UpdateValidator.UpdateInfo info = update.getUpdateInfo();
            for (SetClause entry : update.getChangeList().getClauses()) {
                Expression value;
                ElementSymbol elementID = entry.getSymbol();
                if (!this.getMetadata().elementSupports(elementID.getMetadataID(), 5)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0059", new Object[]{elementID}), elementID);
                }
                Object metadataID = elementID.getMetadataID();
                if (this.getMetadata().isMultiSourceElement(metadataID)) {
                    this.handleValidationError(QueryPlugin.Util.getString("multi_source_update_not_allowed", new Object[]{elementID}), elementID);
                }
                if (EvaluatableVisitor.isFullyEvaluatable(value = entry.getValue(), true)) {
                    try {
                        value = new Constant(Evaluator.evaluate(value));
                    }
                    catch (ExpressionEvaluationException err) {
                        // empty catch block
                    }
                }
                if (value instanceof Constant) {
                    if (!((Constant)value).isNull() || this.getMetadata().elementSupports(elementID.getMetadataID(), 4)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0060", new Object[]{SQLStringVisitor.getSQLString(elementID)}), elementID);
                    continue;
                }
                if (info == null || info.getUpdateType() != UpdateValidator.UpdateType.UPDATE_PROCEDURE || !this.getMetadata().isVirtualGroup(update.getGroup().getMetadataID()) || EvaluatableVisitor.willBecomeConstant(value)) continue;
                Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)value, false);
                for (ElementSymbol element : elements) {
                    if (element.isExternalReference()) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0061", new Object[]{SQLStringVisitor.getSQLString(value)}), value);
                }
            }
            if (info != null && info.isInherentUpdate() && !info.hasValidUpdateMapping(updateCols = update.getChangeList().getClauseMap().keySet())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.nonUpdatable", new Object[]{updateCols}), update);
            }
        }
        catch (TeiidException e) {
            this.handleException(e, update);
        }
        this.validateSetClauseList(update.getChangeList());
    }

    protected void validateSelectInto(Query query) {
        List<SingleElementSymbol> symbols = query.getSelect().getProjectedSymbols();
        GroupSymbol intoGroup = query.getInto().getGroup();
        this.validateInto(query, symbols, intoGroup);
    }

    private void validateInto(LanguageObject query, List<SingleElementSymbol> symbols, GroupSymbol intoGroup) {
        try {
            List elementIDs = this.getMetadata().getElementIDsInGroupID(intoGroup.getMetadataID());
            if (symbols.size() != elementIDs.size()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_wrong_elements", new Object[]{new Integer(elementIDs.size()), new Integer(symbols.size())}), query);
                return;
            }
            for (int symbolNum = 0; symbolNum < symbols.size(); ++symbolNum) {
                String targetTypeName;
                Class symbolType;
                String symbolTypeName;
                SingleElementSymbol symbol = symbols.get(symbolNum);
                Object elementID = elementIDs.get(symbolNum);
                if (!this.getMetadata().elementSupports(elementID, 5)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.element_updates_not_allowed", new Object[]{this.getMetadata().getFullName(elementID)}), intoGroup);
                }
                if ((symbolTypeName = DataTypeManager.getDataTypeName((Class)(symbolType = symbol.getType()))).equals(targetTypeName = this.getMetadata().getElementType(elementID)) || DataTypeManager.isImplicitConversion((String)symbolTypeName, (String)targetTypeName)) continue;
                Object[] params = new Object[]{symbolTypeName, targetTypeName, new Integer(symbolNum + 1), query};
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_no_implicit_conversion", params), query);
            }
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e), query);
        }
    }

    protected void validateContainsRowsUpdatedVariable(CreateUpdateProcedureCommand obj) {
        final ArrayList assignVars = new ArrayList();
        LanguageVisitor visitor = new LanguageVisitor(){

            @Override
            public void visit(AssignmentStatement stmt) {
                assignVars.add(stmt.getVariable());
            }
        };
        PreOrderNavigator.doVisit(obj, visitor);
        boolean foundVar = false;
        for (ElementSymbol variable : assignVars) {
            if (!variable.getShortName().equalsIgnoreCase("ROWS_UPDATED")) continue;
            foundVar = true;
            break;
        }
        if (!foundVar) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0016", new Object[]{"ROWS_UPDATED"}), obj);
        }
    }

    private void validateRowLimitFunctionNotInInvalidCriteria(Criteria obj) {
        ArrayList<Function> rowLimitFunctions = new ArrayList<Function>();
        FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
        PreOrderNavigator.doVisit(obj, visitor);
        visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
        PreOrderNavigator.doVisit(obj, visitor);
        if (rowLimitFunctions.size() > 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.3"), obj);
        }
    }

    @Override
    public void visit(BetweenCriteria obj) {
        if (ValidationVisitor.isNonComparable(obj.getExpression())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0027", new Object[]{obj}), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(IsNullCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(MatchCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(NotCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(SetCriteria obj) {
        if (ValidationVisitor.isNonComparable(obj.getExpression())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0027", new Object[]{obj}), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        this.validateSubquery(obj);
        if (ValidationVisitor.isNonComparable(obj.getLeftExpression())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0027", new Object[]{obj}), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(Option obj) {
        List<String> dep = obj.getDependentGroups();
        List<String> notDep = obj.getNotDependentGroups();
        if (dep != null && !dep.isEmpty() && notDep != null && !notDep.isEmpty()) {
            String groupName2 = null;
            String notDepGroup2 = null;
            for (String groupName2 : dep) {
                for (String notDepGroup2 : notDep) {
                    if (!notDepGroup2.equalsIgnoreCase(groupName2)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.group_in_both_dep", new Object[]{groupName2}), obj);
                    return;
                }
            }
        }
    }

    @Override
    public void visit(DynamicCommand obj) {
        if (obj.getIntoGroup() != null) {
            this.validateInto(obj, obj.getAsColumns(), obj.getIntoGroup());
        }
        if (obj.getUsing() != null) {
            this.validateSetClauseList(obj.getUsing());
        }
    }

    @Override
    public void visit(Create obj) {
        if (!obj.getPrimaryKey().isEmpty()) {
            this.validateSortable(obj.getPrimaryKey());
        }
    }

    @Override
    public void visit(Drop drop) {
        if (!drop.getTable().isTempTable()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.drop_of_nontemptable", new Object[]{drop.getTable()}), drop);
        }
    }

    @Override
    public void visit(CompareCriteria obj) {
        if (ValidationVisitor.isNonComparable(obj.getLeftExpression())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0027", new Object[]{obj}), obj);
        }
        ArrayList<Function> rowLimitFunctions = new ArrayList<Function>();
        FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
        PreOrderNavigator.doVisit(obj, visitor);
        visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
        PreOrderNavigator.doVisit(obj, visitor);
        int functionCount = rowLimitFunctions.size();
        if (functionCount > 0) {
            Function rightExpr;
            Function leftExpr;
            Function function = null;
            Expression expr = null;
            if (obj.getLeftExpression() instanceof Function && ((leftExpr = (Function)obj.getLeftExpression()).getFunctionDescriptor().getName().equalsIgnoreCase("rowlimit") || leftExpr.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimitexception"))) {
                function = leftExpr;
                expr = obj.getRightExpression();
            }
            if (function == null && obj.getRightExpression() instanceof Function && ((rightExpr = (Function)obj.getRightExpression()).getFunctionDescriptor().getName().equalsIgnoreCase("rowlimit") || rightExpr.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimitexception"))) {
                function = rightExpr;
                expr = obj.getLeftExpression();
            }
            if (function == null) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.0"), obj);
            } else if (expr instanceof Constant) {
                Constant constant = (Constant)expr;
                if (constant.getValue() instanceof Integer) {
                    Integer integer = (Integer)constant.getValue();
                    if (integer < 0) {
                        this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), obj);
                    }
                } else {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), obj);
                }
            } else if (expr instanceof Reference) {
                ((Reference)expr).setConstraint(new PositiveIntegerConstraint("ValidationVisitor.1"));
            } else {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), obj);
            }
        }
    }

    @Override
    public void visit(Limit obj) {
        Expression offsetExpr = obj.getOffset();
        if (offsetExpr instanceof Constant) {
            Integer offset = (Integer)((Constant)offsetExpr).getValue();
            if (offset < 0) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badoffset2"), obj);
            }
        } else if (offsetExpr instanceof Reference) {
            ((Reference)offsetExpr).setConstraint(new PositiveIntegerConstraint("ValidationVisitor.badoffset2"));
        }
        Expression limitExpr = obj.getRowLimit();
        if (limitExpr instanceof Constant) {
            Integer limit = (Integer)((Constant)limitExpr).getValue();
            if (limit < 0) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badlimit2"), obj);
            }
        } else if (limitExpr instanceof Reference) {
            ((Reference)limitExpr).setConstraint(new PositiveIntegerConstraint("ValidationVisitor.badlimit2"));
        }
    }

    @Override
    public void visit(XMLForest obj) {
        this.validateDerivedColumnNames(obj, obj.getArgs());
        for (DerivedColumn dc : obj.getArgs()) {
            if (dc.getAlias() == null) continue;
            this.validateQName(obj, dc.getAlias());
            this.validateXMLContentTypes(dc.getExpression(), obj);
        }
    }

    @Override
    public void visit(AggregateSymbol obj) {
        if (obj.getAggregateFunction() != AggregateSymbol.Type.TEXTAGG) {
            return;
        }
        TextLine tl = (TextLine)obj.getExpression();
        if (tl.isIncludeHeader()) {
            this.validateDerivedColumnNames(obj, tl.getExpressions());
        }
        for (DerivedColumn dc : tl.getExpressions()) {
            this.validateXMLContentTypes(dc.getExpression(), obj);
        }
        this.validateTextOptions(obj, tl.getDelimiter(), tl.getQuote());
        if (tl.getEncoding() != null) {
            try {
                Charset.forName(tl.getEncoding());
            }
            catch (IllegalArgumentException e) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_encoding", new Object[]{tl.getEncoding()}), obj);
            }
        }
    }

    private String[] validateQName(LanguageObject obj, String name) {
        try {
            return Name11Checker.getInstance().getQNameParts((CharSequence)name);
        }
        catch (QNameException e) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_invalid_qname", new Object[]{name}), obj);
            return null;
        }
    }

    private void validateDerivedColumnNames(LanguageObject obj, List<DerivedColumn> cols) {
        for (DerivedColumn dc : cols) {
            if (dc.getAlias() != null || dc.getExpression() instanceof ElementSymbol) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.expression_requires_name"), obj);
        }
    }

    @Override
    public void visit(XMLAttributes obj) {
        this.validateDerivedColumnNames(obj, obj.getArgs());
        for (DerivedColumn dc : obj.getArgs()) {
            String[] parts;
            if (dc.getAlias() == null) continue;
            if ("xmlns".equals(dc.getAlias())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_attributes_reserved"), obj);
            }
            if ((parts = this.validateQName(obj, dc.getAlias())) == null || !"xmlns".equals(parts[0])) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_attributes_reserved", new Object[]{dc.getAlias()}), obj);
        }
    }

    @Override
    public void visit(XMLElement obj) {
        for (Expression expression : obj.getContent()) {
            this.validateXMLContentTypes(expression, obj);
        }
        this.validateQName(obj, obj.getName());
    }

    public void validateXMLContentTypes(Expression expression, LanguageObject parent) {
        if (expression.getType() == DataTypeManager.DefaultDataClasses.OBJECT || expression.getType() == DataTypeManager.DefaultDataClasses.BLOB) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_content_type", new Object[]{expression}), parent);
        }
    }

    @Override
    public void visit(QueryString obj) {
        this.validateDerivedColumnNames(obj, obj.getArgs());
    }

    @Override
    public void visit(XMLTable obj) {
        List<DerivedColumn> passing = obj.getPassing();
        this.validatePassing(obj, obj.getXQueryExpression(), passing);
        boolean hasOrdinal = false;
        for (XMLTable.XMLColumn xc : obj.getColumns()) {
            if (!xc.isOrdinal()) {
                if (xc.getDefaultExpression() == null || EvaluatableVisitor.isFullyEvaluatable(obj, false)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_default", new Object[]{xc.getDefaultExpression()}), obj);
                continue;
            }
            if (hasOrdinal) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.one_ordinal"), obj);
                break;
            }
            hasOrdinal = true;
        }
    }

    @Override
    public void visit(XMLQuery obj) {
        this.validatePassing(obj, obj.getXQueryExpression(), obj.getPassing());
    }

    private void validatePassing(LanguageObject obj, SaxonXQueryExpression xqe, List<DerivedColumn> passing) {
        boolean context = false;
        boolean hadError = false;
        HashSet<String> names = new HashSet<String>();
        for (DerivedColumn dc : passing) {
            if (dc.getAlias() == null) {
                Class type = dc.getExpression().getType();
                if (type != DataTypeManager.DefaultDataClasses.XML) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.context_item_type"), obj);
                }
                if (context && !hadError) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.passing_requires_name"), obj);
                    hadError = true;
                }
                context = true;
                continue;
            }
            this.validateXMLContentTypes(dc.getExpression(), obj);
            if (names.add(dc.getAlias().toUpperCase())) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.duplicate_passing", new Object[]{dc.getAlias()}), obj);
        }
        if (xqe.usesContextItem() && !context) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.context_required"), obj);
        }
    }

    @Override
    public void visit(XMLNamespaces obj) {
        boolean hasDefault = false;
        for (XMLNamespaces.NamespaceItem item : obj.getNamespaceItems()) {
            if (item.getPrefix() != null) {
                if (item.getPrefix().equals("xml") || item.getPrefix().equals("xmlns")) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_namespaces_reserved"), obj);
                }
                if (item.getUri().length() != 0) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_namespaces_null_uri"), obj);
                continue;
            }
            if (hasDefault) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_namespaces"), obj);
                break;
            }
            hasDefault = true;
        }
    }

    @Override
    public void visit(TextTable obj) {
        boolean widthSet = false;
        Character delimiter = null;
        Character quote = null;
        for (TextTable.TextColumn column : obj.getColumns()) {
            if (column.getWidth() != null) {
                widthSet = true;
                if (column.getWidth() >= 0) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_negative"), obj);
                continue;
            }
            if (!widthSet) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_invalid_width"), obj);
        }
        if (widthSet) {
            if (obj.getDelimiter() != null || obj.getHeader() != null || obj.getQuote() != null) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_width"), obj);
            }
        } else {
            if (obj.getHeader() != null && obj.getHeader() < 0) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_negative"), obj);
            }
            delimiter = obj.getDelimiter();
            quote = obj.getQuote();
            this.validateTextOptions(obj, delimiter, quote);
        }
        if (obj.getSkip() != null && obj.getSkip() < 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_negative"), obj);
        }
    }

    private void validateTextOptions(LanguageObject obj, Character delimiter, Character quote) {
        if (quote == null) {
            quote = Character.valueOf('\"');
        }
        if (delimiter == null) {
            delimiter = Character.valueOf(',');
        }
        if (EquivalenceUtil.areEqual((Object)quote, (Object)delimiter)) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_delimiter"), obj);
        }
        if (EquivalenceUtil.areEqual((Object)quote, (Object)Character.valueOf('\n')) || EquivalenceUtil.areEqual((Object)delimiter, (Object)Character.valueOf('\n'))) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_newline"), obj);
        }
    }

    @Override
    public void visit(XMLParse obj) {
        if (obj.getExpression().getType() != DataTypeManager.DefaultDataClasses.STRING && obj.getExpression().getType() != DataTypeManager.DefaultDataClasses.CLOB && obj.getExpression().getType() != DataTypeManager.DefaultDataClasses.BLOB) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xmlparse_type"), obj);
        }
    }

    @Override
    public void visit(ExistsCriteria obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(LoopStatement obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(WithQueryCommand obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(AlterView obj) {
        try {
            QueryResolver.validateProjectedSymbols(obj.getTarget(), this.getMetadata(), obj.getDefinition());
            Validator.validate(obj.getDefinition(), this.getMetadata(), this);
        }
        catch (QueryValidatorException e) {
            this.handleValidationError(e.getMessage(), (LanguageObject)obj.getDefinition());
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    @Override
    public void visit(AlterProcedure obj) {
        GroupSymbol gs = obj.getTarget();
        try {
            if (!gs.isProcedure() || !this.getMetadata().isVirtualModel(this.getMetadata().getModelID(gs.getMetadataID()))) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.not_a_procedure", new Object[]{gs}), gs);
                return;
            }
            Validator.validate(obj.getDefinition(), this.getMetadata(), this);
            StoredProcedureInfo info = this.getMetadata().getStoredProcedureInfoForProcedure(gs.getName());
            for (SPParameter param : info.getParameters()) {
                if (param.getParameterType() != 5) continue;
                QueryResolver.validateProjectedSymbols(gs, param.getResultSetColumns(), ((CreateUpdateProcedureCommand)obj.getDefinition()).getProjectedSymbols());
                break;
            }
        }
        catch (QueryValidatorException e) {
            this.handleValidationError(e.getMessage(), ((CreateUpdateProcedureCommand)obj.getDefinition()).getBlock());
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    @Override
    public void visit(AlterTrigger obj) {
        this.validateGroupSupportsUpdate(obj.getTarget());
        try {
            if (obj.getDefinition() != null) {
                Validator.validate(obj.getDefinition(), this.getMetadata(), this);
            }
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    private void validateSubquery(SubqueryContainer<?> subQuery) {
        if (subQuery.getCommand() instanceof Query && ((Query)subQuery.getCommand()).getInto() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.subquery_insert"), (LanguageObject)subQuery.getCommand());
        }
    }

    private final class PositiveIntegerConstraint
    implements Reference.Constraint {
        private String msgKey;

        public PositiveIntegerConstraint(String msgKey) {
            this.msgKey = msgKey;
        }

        @Override
        public void validate(Object value) throws QueryValidatorException {
            if ((Integer)value < 0) {
                throw new QueryValidatorException(QueryPlugin.Util.getString(this.msgKey));
            }
        }
    }
}

