/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import javax.sql.rowset.serial.SerialBlob;
import junit.framework.TestCase;
import org.teiid.core.types.BlobType;
import org.teiid.core.util.UnitTestUtil;

public class TestBlobValue
extends TestCase {
    public void testBlobValue() throws Exception {
        String testString = "this is test blob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        TestBlobValue.assertEquals((String)testString, (String)new String(bv.getBytes(1L, (int)bv.length())));
    }

    public void testBlobValuePersistence() throws Exception {
        String testString = "this is test clob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        String key = bv.getReferenceStreamId();
        File saved = new File(UnitTestUtil.getTestScratchPath() + "/blobassaved.bin");
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(saved));
        out.writeObject(bv);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(saved));
        BlobType read = (BlobType)in.readObject();
        TestBlobValue.assertEquals((String)key, (String)read.getReferenceStreamId());
        TestBlobValue.assertNull((Object)read.getReference());
        saved.delete();
    }
}

