/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.teiid.core.util.TimestampWithTimezone;

public class TestTimestampWithTimezone
extends TestCase {
    public TestTimestampWithTimezone(String name) {
        super(name);
    }

    public void setUp() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("America/Chicago"));
    }

    public void tearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }

    public void helpTestSame(String startts, int startnanos, String starttz, String endtz) {
        try {
            Timestamp start = this.getTimestamp(startts, startnanos, starttz);
            Timestamp end = this.getTimestamp(startts, startnanos, endtz);
            TestTimestampWithTimezone.assertFalse((String)"Initial timestamps should be different UTC times", (start.getTime() == end.getTime() ? 1 : 0) != 0);
            TestTimestampWithTimezone.assertEquals((long)TimestampWithTimezone.createTimestamp((Date)start, (TimeZone)TimeZone.getTimeZone(starttz), (Calendar)Calendar.getInstance()).getTime(), (long)TimestampWithTimezone.createTimestamp((Date)end, (TimeZone)TimeZone.getTimeZone(endtz), (Calendar)Calendar.getInstance()).getTime());
        }
        catch (ParseException e) {
            TestTimestampWithTimezone.fail((String)e.toString());
        }
    }

    public void helpTestChange(String ts, String endtz, String expected) {
        Timestamp start = Timestamp.valueOf(ts);
        Calendar target = Calendar.getInstance(TimeZone.getTimeZone(endtz));
        TestTimestampWithTimezone.assertEquals((String)expected, (String)TimestampWithTimezone.createTimestamp((Date)start, (TimeZone)TimeZone.getTimeZone("America/Chicago"), (Calendar)target).toString());
    }

    private Timestamp getTimestamp(String startts, int startnanos, String starttz) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone(starttz));
        Timestamp ts = new Timestamp(df.parse(startts).getTime());
        ts.setNanos(startnanos);
        return ts;
    }

    public void testDST() {
        this.helpTestSame("2005-10-30 02:39:10", 1, "America/Chicago", "GMT-05:00");
        this.helpTestSame("2005-10-30 01:39:10", 1, "America/Chicago", "GMT");
        this.helpTestSame("2005-04-03 02:39:10", 1, "GMT", "America/Chicago");
        this.helpTestChange("2005-10-30 02:39:10.1", "GMT", "2005-10-29 21:39:10.1");
        this.helpTestChange("2005-10-30 10:39:10.1", "GMT", "2005-10-30 04:39:10.1");
    }

    public void testTimezone() {
        this.helpTestSame("2004-06-29 15:39:10", 1, "GMT-06:00", "GMT-05:00");
    }

    public void testTimezone2() {
        this.helpTestSame("2004-06-29 15:39:10", 1, "GMT-08:00", "GMT-06:00");
    }

    public void testTimezone3() {
        this.helpTestSame("2004-08-31 18:25:54", 1, "Europe/London", "GMT");
    }

    public void testTimezoneOverMidnight() {
        this.helpTestSame("2004-06-30 23:39:10", 1, "America/Los_Angeles", "America/Chicago");
    }

    public void testCase2852() {
        this.helpTestSame("2005-05-17 22:35:33", 508659, "GMT", "America/New_York");
    }

    public void testCreateDate() {
        Timestamp t = Timestamp.valueOf("2004-06-30 23:39:10.1201");
        java.sql.Date date = TimestampWithTimezone.createDate((Date)t);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        TestTimestampWithTimezone.assertEquals((int)cal.get(11), (int)0);
        TestTimestampWithTimezone.assertEquals((int)cal.get(12), (int)0);
        TestTimestampWithTimezone.assertEquals((int)cal.get(13), (int)0);
        TestTimestampWithTimezone.assertEquals((int)cal.get(14), (int)0);
        TestTimestampWithTimezone.assertEquals((int)cal.get(1), (int)2004);
        TestTimestampWithTimezone.assertEquals((int)cal.get(2), (int)5);
        TestTimestampWithTimezone.assertEquals((int)cal.get(5), (int)30);
    }

    public void testCreateTime() {
        Timestamp t = Timestamp.valueOf("2004-06-30 23:39:10.1201");
        Time date = TimestampWithTimezone.createTime((Date)t);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        TestTimestampWithTimezone.assertEquals((int)cal.get(11), (int)23);
        TestTimestampWithTimezone.assertEquals((int)cal.get(12), (int)39);
        TestTimestampWithTimezone.assertEquals((int)cal.get(13), (int)10);
        TestTimestampWithTimezone.assertEquals((int)cal.get(14), (int)0);
        TestTimestampWithTimezone.assertEquals((int)cal.get(1), (int)1970);
        TestTimestampWithTimezone.assertEquals((int)cal.get(2), (int)0);
        TestTimestampWithTimezone.assertEquals((int)cal.get(5), (int)1);
    }

    public void testDateToDateConversion() {
        java.sql.Date t = java.sql.Date.valueOf("2004-06-30");
        java.sql.Date converted = TimestampWithTimezone.createDate((Date)t, (TimeZone)TimeZone.getTimeZone("America/Chicago"), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("US/Central")));
        TestTimestampWithTimezone.assertEquals((long)t.getTime(), (long)converted.getTime());
    }

    public void testDateToDateConversion1() {
        java.sql.Date t = java.sql.Date.valueOf("2004-06-30");
        java.sql.Date converted = TimestampWithTimezone.createDate((Date)t, (TimeZone)TimeZone.getTimeZone("America/Chicago"), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        Calendar cal = Calendar.getInstance();
        cal.setTime(converted);
        TestTimestampWithTimezone.assertEquals((int)0, (int)cal.get(14));
    }
}

