/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache;

import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;

@ManagementObject(componentType=@ManagementComponent(type="teiid", subtype="dqp"), properties=ManagementProperties.EXPLICIT)
public class CacheConfiguration {
    private Policy policy;
    private int maxage = -1;
    private int maxEntries = 512;
    private boolean enabled = true;
    private String name;
    private String location;
    private int maxStaleness = 0;

    public CacheConfiguration() {
    }

    public CacheConfiguration(Policy policy, int maxAgeInSeconds, int maxNodes, String location) {
        this.policy = policy;
        this.maxage = maxAgeInSeconds;
        this.maxEntries = maxNodes;
        this.location = location;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    @ManagementProperty(description="The maximum age of an entry in seconds. -1 indicates no max.")
    public int getMaxAgeInSeconds() {
        return this.maxage;
    }

    public void setMaxAgeInSeconds(int maxage) {
        this.maxage = maxage;
    }

    @ManagementProperty(description="The maximum staleness in seconds of an entry based upon modifications. -1 indicates no max.")
    public int getMaxStaleness() {
        return this.maxStaleness;
    }

    public void setMaxStaleness(int maxStaleDataModification) {
        this.maxStaleness = maxStaleDataModification;
    }

    @ManagementProperty(description="The maximum number of cache entries. -1 indicates no limit. (default 1024)")
    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(int entries) {
        this.maxEntries = entries;
    }

    public void setType(String type) {
        this.policy = Policy.valueOf(type);
    }

    @ManagementProperty(description="Name of the configuration", readOnly=true)
    @ManagementObjectID(type="cache")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManagementProperty(description="location prefix in cache", readOnly=true)
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static enum Policy {
        LRU,
        EXPIRATION;

    }
}

